<?php
/*-------- لید خبر ---------*/
function get_meta($value) {
	global $post;
	$field = get_post_meta($post->ID, $value, true);
	if( !empty($field) ) {
		return is_array($field) ? stripslashes_deep($field) : stripslashes(wp_kses_decode_entities($field));
	} else {
		return false;
	}
}
function qaleb_add_meta_box() {
	add_meta_box(
		'post-info',
		'لید خبر را وارد نمایید',
		'qaleb_meta_box',
		'post',
		'advanced',
		'high'
	);
}
add_action('add_meta_boxes', 'qaleb_add_meta_box');
function qaleb_meta_box($post) {
	wp_nonce_field('meta_box_action', 'meta_box_nonce');
?>
	<p>
        <textarea name="lead" id="lead" style="height: 90px; width: 94%;"><?php echo get_meta('lead'); ?></textarea>
	</p>
<?php
}
function save_meta_box($post_id) {
	if( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) return;
	if( !isset($_POST['meta_box_nonce']) || ! wp_verify_nonce($_POST['meta_box_nonce'], 'meta_box_action') ) return;
	if( !current_user_can('edit_post', $post_id) ) return;
	if( isset($_POST['lead']) )
		update_post_meta($post_id, 'lead', esc_attr($_POST['lead']));
}
add_action('save_post', 'save_meta_box');
/*-------- لید خبر ---------*/


function prfx7_custom_meta() {
    add_meta_box( 'prfx7_meta', __( 'گزارشگر ', 'prfx7-textdomain' ), 'prfx7_meta_callback', 'media', 'side', 'high' );
}
add_action( 'add_meta_boxes', 'prfx7_custom_meta' );


function prfx7_meta_callback( $post ) {
    wp_nonce_field( basename( __FILE__ ), 'prfx7_nonce' );
    $prfx7_stored_meta = get_post_meta( $post->ID );
    ?>

<p>
  <input type="text" name="meta-text-7" id="meta-text" value="<?php if ( isset ( $prfx7_stored_meta['meta-text-7'] ) ) echo $prfx7_stored_meta['meta-text-7'][0]; ?>" />
</p>
<?php
}
function prfx7_meta_save( $post_id ) {
 
    // Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
    $is_valid_nonce = ( isset( $_POST[ 'prfx7_nonce' ] ) && wp_verify_nonce( $_POST[ 'prfx7_nonce' ], basename( __FILE__ ) ) ) ? 'true' : 'false';
 
    // Exits script depending on save status
    if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
        return;
    }
 
    // Checks for input and sanitizes/saves if needed
    if( isset( $_POST[ 'meta-text-7' ] ) ) {
        update_post_meta( $post_id, 'meta-text-7', sanitize_text_field( $_POST[ 'meta-text-7' ] ) );
    }
 
}
add_action( 'save_post', 'prfx7_meta_save' );




function prfx6_custom_meta() {
    add_meta_box( 'prfx6_meta', __( 'عکاس', 'prfx6-textdomain' ), 'prfx6_meta_callback', 'gallery', 'side', 'high' );
}
add_action( 'add_meta_boxes', 'prfx6_custom_meta' );


function prfx6_meta_callback( $post ) {
    wp_nonce_field( basename( __FILE__ ), 'prfx6_nonce' );
    $prfx6_stored_meta = get_post_meta( $post->ID );
    ?>

<p>
  <input type="text" name="meta-text-6" id="meta-text" value="<?php if ( isset ( $prfx6_stored_meta['meta-text-6'] ) ) echo $prfx6_stored_meta['meta-text-6'][0]; ?>" />
</p>
<?php
}
function prfx6_meta_save( $post_id ) {
 
    // Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
    $is_valid_nonce = ( isset( $_POST[ 'prfx6_nonce' ] ) && wp_verify_nonce( $_POST[ 'prfx6_nonce' ], basename( __FILE__ ) ) ) ? 'true' : 'false';
 
    // Exits script depending on save status
    if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
        return;
    }
 
    // Checks for input and sanitizes/saves if needed
    if( isset( $_POST[ 'meta-text-6' ] ) ) {
        update_post_meta( $post_id, 'meta-text-6', sanitize_text_field( $_POST[ 'meta-text-6' ] ) );
    }
 
}
add_action( 'save_post', 'prfx6_meta_save' );




function prfx11_custom_meta() {
    add_meta_box( 'prfx11_meta', __( 'چکیده گالری', 'prfx11-textdomain' ), 'prfx11_meta_callback', 'gallery', 'side', 'high' );
}
add_action( 'add_meta_boxes', 'prfx11_custom_meta' );


function prfx11_meta_callback( $post ) {
    wp_nonce_field( basename( __FILE__ ), 'prfx11_nonce' );
    $prfx11_stored_meta = get_post_meta( $post->ID );
    ?>

<p>
  <input type="text" name="meta-text-11" id="meta-text" value="<?php if ( isset ( $prfx11_stored_meta['meta-text-11'] ) ) echo $prfx11_stored_meta['meta-text-11'][0]; ?>" />
</p>
<?php
}
function prfx11_meta_save( $post_id ) {
 
    // Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
    $is_valid_nonce = ( isset( $_POST[ 'prfx11_nonce' ] ) && wp_verify_nonce( $_POST[ 'prfx11_nonce' ], basename( __FILE__ ) ) ) ? 'true' : 'false';
 
    // Exits script depending on save status
    if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
        return;
    }
 
    // Checks for input and sanitizes/saves if needed
    if( isset( $_POST[ 'meta-text-11' ] ) ) {
        update_post_meta( $post_id, 'meta-text-11', sanitize_text_field( $_POST[ 'meta-text-11' ] ) );
    }
 
}
add_action( 'save_post', 'prfx11_meta_save' );






function prfx2_custom_meta() {
    add_meta_box( 'prfx2_meta', __( 'رو تیتر خبر', 'prfx2-textdomain' ), 'prfx2_meta_callback', 'post', 'side', 'high' );
}
add_action( 'add_meta_boxes', 'prfx2_custom_meta' );


function prfx2_meta_callback( $post ) {
    wp_nonce_field( basename( __FILE__ ), 'prfx2_nonce' );
    $prfx2_stored_meta = get_post_meta( $post->ID );
    ?>

<p>
  <input type="text" name="meta-text-1" id="meta-text" value="<?php if ( isset ( $prfx2_stored_meta['meta-text-1'] ) ) echo $prfx2_stored_meta['meta-text-1'][0]; ?>" />
</p>
<?php
}
function prfx2_meta_save( $post_id ) {
 
    // Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
    $is_valid_nonce = ( isset( $_POST[ 'prfx2_nonce' ] ) && wp_verify_nonce( $_POST[ 'prfx2_nonce' ], basename( __FILE__ ) ) ) ? 'true' : 'false';
 
    // Exits script depending on save status
    if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
        return;
    }
 
    // Checks for input and sanitizes/saves if needed
    if( isset( $_POST[ 'meta-text-1' ] ) ) {
        update_post_meta( $post_id, 'meta-text-1', sanitize_text_field( $_POST[ 'meta-text-1' ] ) );
    }
 
}
add_action( 'save_post', 'prfx2_meta_save' );

  

  
  
 function prfx3_custom_meta() {
    add_meta_box( 'prfx3_meta', __( 'نام نویسنده', 'prfx3-textdomain' ), 'prfx3_meta_callback', 'post', 'side', 'high' );
}
add_action( 'add_meta_boxes', 'prfx3_custom_meta' );


function prfx3_meta_callback( $post ) {
    wp_nonce_field( basename( __FILE__ ), 'prfx3_nonce' );
    $prfx3_stored_meta = get_post_meta( $post->ID );
    ?>

<p>
  <input type="text" name="meta-text-3" id="meta-text" value="<?php if ( isset ( $prfx3_stored_meta['meta-text-3'] ) ) echo $prfx3_stored_meta['meta-text-3'][0]; ?>" />
</p>
<?php
}
function prfx3_meta_save( $post_id ) {
 
    // Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
    $is_valid_nonce = ( isset( $_POST[ 'prfx3_nonce' ] ) && wp_verify_nonce( $_POST[ 'prfx3_nonce' ], basename( __FILE__ ) ) ) ? 'true' : 'false';
 
    // Exits script depending on save status
    if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
        return;
    }
 
    // Checks for input and sanitizes/saves if needed
    if( isset( $_POST[ 'meta-text-3' ] ) ) {
        update_post_meta( $post_id, 'meta-text-3', sanitize_text_field( $_POST[ 'meta-text-3' ] ) );
    }
 
}
add_action( 'save_post', 'prfx3_meta_save' );
 
  
/**
 * Saves the custom meta input
 */
function file_meta_save( $post_id ) {
 
    // Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
    $is_valid_nonce = ( isset( $_POST[ 'file_nonce' ] ) && wp_verify_nonce( $_POST[ 'file_nonce' ], basename( __FILE__ ) ) ) ? 'true' : 'false';
 
    // Exits script depending on save status
    if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
        return;
    }
 
    // Checks for input and sanitizes/saves if needed
    if( isset( $_POST[ 'meta-text-file' ] ) ) {
        update_post_meta( $post_id, 'meta-text-file', sanitize_text_field( $_POST[ 'meta-text-file' ] ) );
    }
 
}
add_action( 'save_post', 'file_meta_save' );






function prfx4_custom_meta() {
    add_meta_box( 'prfx4_meta', __( 'منبع خبر', 'prfx4-textdomain' ), 'prfx4_meta_callback', 'post', 'side', 'high' );
}
add_action( 'add_meta_boxes', 'prfx4_custom_meta' );


function prfx4_meta_callback( $post ) {
    wp_nonce_field( basename( __FILE__ ), 'prfx4_nonce' );
    $prfx4_stored_meta = get_post_meta( $post->ID );
    ?>

<p>
  <input type="text" name="meta-text-4" id="meta-text" value="<?php if ( isset ( $prfx4_stored_meta['meta-text-4'] ) ) echo $prfx4_stored_meta['meta-text-4'][0]; ?>" />
</p>
<?php
}
function prfx4_meta_save( $post_id ) {
 
    // Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
    $is_valid_nonce = ( isset( $_POST[ 'prfx4_nonce' ] ) && wp_verify_nonce( $_POST[ 'prfx4_nonce' ], basename( __FILE__ ) ) ) ? 'true' : 'false';
 
    // Exits script depending on save status
    if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
        return;
    }
 
    // Checks for input and sanitizes/saves if needed
    if( isset( $_POST[ 'meta-text-4' ] ) ) {
        update_post_meta( $post_id, 'meta-text-4', sanitize_text_field( $_POST[ 'meta-text-4' ] ) );
    }
 
}
add_action( 'save_post', 'prfx4_meta_save' );






function video_custom_meta()
{
    add_meta_box('video_meta', __('بارگذاری فیلم ها', 'video-textdomain'), 'video_meta_callback', 'media', 'normal', 'high');
}

add_action('add_meta_boxes', 'video_custom_meta');


function video_meta_callback($post)
{
    wp_nonce_field(basename(__FILE__), 'video_nonce');
    $video_stored_meta = get_post_meta($post->ID);
    ?>
<style>
    #video_tb_qaleb tr td{
		padding-bottom:10px;
	}
</style>
<table width="100%" id="video_tb_qaleb">
  <?php   
    
    // jQuery
wp_enqueue_script('jquery');
// This will enqueue the Media Uploader script
wp_enqueue_media();
?>


  <tr>
    <td><label style="color:#ea074f" for="href-link-player">بارگذاری فیلم جهت نمایش در پلیر</label>
  </tr>
  <tr>
    <td><input id="href-link-player" type="text" name="href-link-player" value="<?php if (isset ($video_stored_meta['href-link-player'])){echo $video_stored_meta['href-link-player'][0];}?>" />
      <button type="button" class="button-secondary add-video-qaleb" qalebdata="player" > افزودن</button></td>
  </tr>

    <tr>
    <td><label for="href-link-1080">بارگذاری فیلم با کیفیت 1080</label>
     (فرمت مناسب mp4)
  </tr>
  <tr>
    <td><input id="href-link-1080" type="text" name="href-link-1080" value="<?php if (isset ($video_stored_meta['href-link-1080'])){echo $video_stored_meta['href-link-1080'][0];}?>" />
      <button type="button" class="button-secondary add-video-qaleb" qalebdata="1080" > افزودن</button></td>
  </tr>
  
  
  <tr>
    <td><label for="href-link-720">بارگذاری فیلم با کیفیت 720</label>
     (فرمت مناسب mp4)
  </tr>
  <tr>
    <td><input id="href-link-720" type="text" name="href-link-720" value="<?php if (isset ($video_stored_meta['href-link-720'])){echo $video_stored_meta['href-link-720'][0];}?>" />
      <button type="button" class="button-secondary add-video-qaleb" qalebdata="720" > افزودن</button></td>
  </tr>
  <tr>
    <td><label for="href-link-720">بارگذاری فیلم با کیفیت 480</label>
     (فرمت مناسب mp4)</td>
  </tr>
  <tr>
    <td><input id="href-link-480" type="text" name="href-link-480" value="<?php if (isset ($video_stored_meta['href-link-480'])){echo $video_stored_meta['href-link-480'][0];}?>" />
      <button type="button" class="button-secondary add-video-qaleb" qalebdata="480" > افزودن</button></td>
  </tr>
  <tr>
    <td><label for="href-link-720">بارگذاری فیلم با کیفیت 360</label>
     (فرمت مناسب mp4)</td>
  </tr>
  <tr>
    <td><input id="href-link-360" type="text" name="href-link-360" value="<?php if (isset ($video_stored_meta['href-link-360'])){echo $video_stored_meta['href-link-360'][0];}?>" />
      <button type="button" class="button-secondary add-video-qaleb" qalebdata="360" > افزودن</button></td>
  </tr>
  <tr>
    <td><label for="href-link-720">بارگذاری فیلم با کیفیت 240</label>
     (فرمت مناسب mp4)</td>
  </tr>
  <tr>
    <td><input id="href-link-240" type="text" name="href-link-240" value="<?php if (isset ($video_stored_meta['href-link-240'])){echo $video_stored_meta['href-link-240'][0];}?>" />
      <button type="button" class="button-secondary add-video-qaleb" qalebdata="240" > افزودن</button></td>
  </tr>
  <script type="text/javascript">
jQuery(document).ready(function($){
    $('.add-video-qaleb').click(function(e) {
		var kf = "#href-link-"+$(this).attr("qalebdata");
        e.preventDefault();
        var image = wp.media({ 
            title: 'انتخاب فیلم',
            // mutiple: true if you want to upload multiple files at once
            multiple: false,
        }).open()
        .on('select', function(e){
            // This will return the selected image from the Media Uploader, the result is an object
            var uploaded_image = image.state().get('selection').first();
            // We convert uploaded_image to a JSON object to make accessing it easier
            // Output to the console uploaded_image
            console.log(uploaded_image);
            var image_url = uploaded_image.toJSON().url;
            // Let's assign the url value to the input field
            $(kf).val(image_url);
        });
    });
});
</script>

</table>
<?php
}

/**
 * Saves the custom meta input
 */
function video_meta_save($post_id)
{

    // Checks save status
    $is_autosave = wp_is_post_autosave($post_id);
    $is_revision = wp_is_post_revision($post_id);
    $is_valid_nonce = (isset($_POST['video_nonce']) && wp_verify_nonce($_POST['video_nonce'], basename(__FILE__))) ? 'true' : 'false';

    // Exits script depending on save status
    if ($is_autosave || $is_revision || !$is_valid_nonce) {
        return;
    }

    // Checks for input and sanitizes/saves if needed
	
    if (isset($_POST['href-link-player'])) {
        update_post_meta($post_id, 'href-link-player', sanitize_text_field($_POST['href-link-player']));
    }	
	
	if (isset($_POST['href-link-1080'])) {
        update_post_meta($post_id, 'href-link-1080', sanitize_text_field($_POST['href-link-1080']));
    }
	
    if (isset($_POST['href-link-720'])) {
        update_post_meta($post_id, 'href-link-720', sanitize_text_field($_POST['href-link-720']));
    }
	 if (isset($_POST['href-link-480'])) {
        update_post_meta($post_id, 'href-link-480', sanitize_text_field($_POST['href-link-480']));
    }
	 if (isset($_POST['href-link-360'])) {
        update_post_meta($post_id, 'href-link-360', sanitize_text_field($_POST['href-link-360']));
    }
	 if (isset($_POST['href-link-240'])) {
        update_post_meta($post_id, 'href-link-240', sanitize_text_field($_POST['href-link-240']));
    }


}

add_action('save_post', 'video_meta_save');

