<?php
class theme_wg_news_all_post extends WP_Widget {
	
	function __construct() {
		parent::__construct( false, 'News - نوشته، فیلم و عکس' );
	}
	
	function widget( $args, $instance ) {
		extract($args, EXTR_SKIP);
		echo $before_widget;
		echo $before_title;
		//Display title as stored in this instance of the widget
		echo esc_html($instance['news_title']); 
		echo $after_title;
		print_theme_wg_news_all_post($instance);
		echo $after_widget;
	}
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['news_title'] = $new_instance['news_title'];
		$instance['select_news'] = $new_instance['select_news'];
		$instance['news_cat'] = $new_instance['news_cat'];
		$instance['news_count'] = $new_instance['news_count'];
		return $instance;
	}

	function form( $instance ) {
		$defaults = array(
			'news_title' => 'جديدترين ها',
			'news_count' => '8',
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
		?>
		<br />
			<table>
				<tbody>
					<tr>
						<td><label for="<?php echo $this->get_field_id('news_title'); ?>"> عنوان ابزارک </label></td>
						<td><input type="text" id="<?php echo $this->get_field_id( 'news_title' ); ?>" name="<?php echo $this->get_field_name( 'news_title' ); ?>" value="<?php echo $instance['news_title']; ?>" /></td>
					</tr>
					
					<tr>
						<td><label for="<?php echo $this->get_field_id('select_news'); ?>"> نوع نمايش </label></td>
						<td>
							<select class="select-type" id="<?php echo $this->get_field_id('select_news'); ?>" name="<?php echo $this->get_field_name('select_news'); ?>" type="text">
								<option value="1">جديدترين</option>
								<option value="2">نمايش به صورت تصادفي</option>
							</select>
						</td>
					</tr>
					
                    
					<tr>
						<td><label for="<?php echo $this->get_field_id('news_count'); ?>"> تعداد اخبار</label></td>
						<td><input type="text" id="<?php echo $this->get_field_id( 'news_count' ); ?>" name="<?php echo $this->get_field_name( 'news_count' ); ?>" value="<?php echo $instance['news_count']; ?>" /></td>
					</tr>
				</tbody>
			</table>
		<?php
		
		echo '<script>';
		echo 'document.getElementById("'. $this->get_field_id( 'select_news' ) .'").value = "' . $instance['select_news'] . '";';
		echo 'document.getElementById("'. $this->get_field_id( 'news_title' ) .'").value = "' . $instance['news_title'] . '";';
		echo 'document.getElementById("'. $this->get_field_id( 'news_count' ) .'").value = "' . $instance['news_count'] . '";';
		echo '
			jQuery(function($) {
				$("#'. $this->get_field_id('select_news'). '").change(function(){
					if($("#'. $this->get_field_id('select_news'). '").val() == "3") {
						$(".select-cat").show(); 
					} else {
						$(".select-cat").hide(); 
					} 
				});
			});
		</script>';
	}
	
}
function theme_wg_news_all_post_register() {
	register_widget( 'theme_wg_news_all_post' );
}
add_action( 'widgets_init', 'theme_wg_news_all_post_register' );

function print_theme_wg_news_all_post($options) { ?>
            <div class="all-post">
			<ul>
				<?php
					if($options['select_news']==1){
						$big_query = new WP_Query(array(
						'post_status' =>'publish',
						'post_type' => array('post','media','gallery'),
						'posts_per_page' => $options['news_count']));
						
					} elseif ($options['select_news']==2) {
						
						$big_query = new WP_Query(array(
						'post_status' =>'publish',
						'post_type' => array('post','media','gallery'),
						'orderby' => 'rand',
						'posts_per_page' => $options['news_count']));
						
					}
					if($big_query->have_posts()) : while($big_query->have_posts()) : $big_query->the_post();
					?>
<li class="<?php if(get_post_type() == "media"){ ?>media-all <?php }else if(get_post_type() == "gallery"){ ?> gallery-all <?php } ?>"> 
<?php if(get_post_type() == "media"){ ?> <i class="fa fa-youtube-play"></i> <?php }else if(get_post_type() == "gallery"){ ?> 
<i class="fa fa-picture-o"></i>
<?php } ?>
<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
					<?php endwhile; endif; wp_reset_query(); ?>
                    </ul>
                    </div>
                    
<?php
}
?>