<?php
add_action( 'widgets_init', 'tie_slider_widget' );
function tie_slider_widget() {
	register_widget( 'tie_slider' );
}
class tie_slider extends WP_Widget {

	public function __construct(){
		$widget_ops = array( 'classname' => 'tie-slider' ,'description' => 'جهت استفاده در سایدبار چپ' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'tie-slider-widget' );
		parent::__construct( 'tie-slider-widget',' '. __( 'News - اسلایدر کوچک ' , 'wp'), $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );

		$no_of_posts = $instance['no_of_posts'];
		$cats_id = $instance['cats_id'];
		$custom_slider = $instance['custom_slider'];

		$argss= array('posts_per_page'=> $no_of_posts , 'category__in' => $cats_id);
		$featured_query = new WP_Query( $argss );
	?>
	<?php if( empty($custom_slider) ):
	if( $featured_query->have_posts() ) : ?>
	
	
<div class="slider-box">	
	<div class="flexslider" id="<?php echo $args['widget_id']; ?>">
		<ul class="slides img-f">
		<?php while ( $featured_query->have_posts() ) : $featured_query->the_post()?>
			<li>
<?php if(has_post_thumbnail()){?>
<a href="<?php the_permalink(); ?>"><?php $ata = get_the_title(); if ( has_post_thumbnail()) the_post_thumbnail('post_author_5', array('title' => esc_attr( $post->post_title ) , 'alt' => $ata ) ); ?></a>
<?php }else{ ?>
<img src="<?php bloginfo("template_url"); ?>/img/none.png">
<?php } ?>
<div class="slider-caption">
<h2> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> </h2>
<p><?php if(get_meta('lead') != false) : echo get_meta('lead'); else : the_excerpt(); endif; ?></p>
</div>
			</li>
		<?php endwhile;?>
		</ul>
	</div></div><div class="lin-20"></div>
	<?php endif; ?>
	<?php else :
		$custom_slider_args = array( 'post_type' => 'tie_slider', 'p' => $custom_slider ) ;
		$custom_slider_query = new WP_Query( $custom_slider_args );
	?><div class="slider-box">	
	<div class="flexslider" id="<?php echo $args['widget_id']; ?>">
		<ul class="slides">
		<?php while ( $custom_slider_query->have_posts() ) : $custom_slider_query->the_post();
			$custom = get_post_custom($post->ID);
			$slider = unserialize( $custom["custom_slider"][0] );
			$number = count($slider);
				
			if( $slider ){
			foreach( $slider as $slide ): ?>	
			<li>
				<?php if( !empty( $slide['link'] ) ):?><a href="<?php  echo stripslashes( $slide['link'] )  ?>"><?php endif; ?>
				<img src="<?php echo tie_slider_img_src( $slide['id'] , 'tie-large' ) ?>" alt="" />
				<?php if( !empty( $slide['link'] ) ):?></a><?php endif; ?>
				<?php if( !empty( $slide['title'] ) || !empty( $slide['caption'] ) ) :?>
				<div class="slider-caption">
					<?php if( !empty( $slide['title'] ) ):?><h2><?php if( !empty( $slide['link'] ) ):?><a href="<?php  echo stripslashes( $slide['link'] )  ?>"><?php endif; ?><?php  echo stripslashes( $slide['title'] )  ?><?php if( !empty( $slide['link'] ) ):?></a><?php endif; ?></h2><?php endif; ?>
					<?php if( !empty( $slide['caption'] ) ):?><p><?php echo stripslashes($slide['caption']) ; ?></p><?php endif; ?>
				</div>
				<?php endif; ?>
			</li>
			<?php endforeach; 
			}?>
		<?php endwhile;?>
		</ul>
	</div></div>
	<?php endif; ?>

	<div class="clear"></div>
	
	<script>
	jQuery(document).ready(function() {
	  jQuery('#<?php echo $args['widget_id']; ?>').flexslider({
		animation: "fade",
		slideshowSpeed: 7000,
		animationSpeed: 600,
		randomize: false,
		pauseOnHover: true,
		prevText: "",
		nextText: "",
		controlNav: false
	  });
	});
	</script>
	<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['cat_posts_title'] = strip_tags( $new_instance['cat_posts_title'] );
		$instance['no_of_posts'] = strip_tags( $new_instance['no_of_posts'] );
		$instance['custom_slider'] =  $new_instance['custom_slider'] ;
		
		$instance['cats_id'] = implode(',' , $new_instance['cats_id']  );

		return $instance;
	}

	function form( $instance ) {
		$defaults = array( 'no_of_posts' => '5' , 'cats_id' => '1' );
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$categories_obj = get_categories();
		$categories = array();

		foreach ($categories_obj as $pn_cat) {
			$categories[$pn_cat->cat_ID] = $pn_cat->cat_name;
		}
		
		$sliders = array();
		$custom_slider = new WP_Query( array( 'post_type' => 'tie_slider', 'posts_per_page' => -1 ) );
		while ( $custom_slider->have_posts() ) {
			$custom_slider->the_post();
			$sliders[get_the_ID()] = get_the_title();
		}
		?>

		<p><em style="color:#0085ba;"><?php echo 'از این اسلایدر به صورت نامحدود استفاده نمایید'; ?></em></p>
		<p>
			<label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>">تعداد : </label>
			<input id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo $instance['no_of_posts']; ?>" type="text" size="3" />
		</p>
		<p>
			<?php $cats_id = explode ( ',' , $instance['cats_id'] ) ; ?>
			<label for="<?php echo $this->get_field_id( 'cats_id' ); ?>">دسته : </label>
			<select multiple="multiple" id="<?php echo $this->get_field_id( 'cats_id' ); ?>[]" name="<?php echo $this->get_field_name( 'cats_id' ); ?>[]">
				<?php foreach ($categories as $key => $option) { ?>
				<option value="<?php echo $key ?>" <?php if ( in_array( $key , $cats_id ) ) { echo ' selected="selected"' ; } ?>><?php echo $option; ?></option>
				<?php } ?>
			</select>
		</p>
		<?php $slider = $instance['custom_slider'] ; ?>

	<?php
	}
}
?>