/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-08-10 09:26:39 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_ewwwio_images` (
  `id` int(14) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` bigint(20) unsigned DEFAULT NULL,
  `gallery` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resize` varchar(75) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `converted` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `results` varchar(75) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `backup` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `level` int(5) unsigned DEFAULT NULL,
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `updates` int(5) unsigned DEFAULT NULL,
  `updated` timestamp NOT NULL DEFAULT '1971-01-01 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `trace` blob,
  UNIQUE KEY `id` (`id`),
  KEY `path_image_size` (`path`(191),`image_size`),
  KEY `attachment_info` (`gallery`(3),`attachment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=21915 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1377 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=378 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_smush_dir_images` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `path_hash` char(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


 /* SQL Chunk Header Index 1 */ 

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES 
("60","32","_wp_trash_meta_time","1628573858"),
("59","32","_wp_trash_meta_status","0");


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES 
("1","1","یک نویسنده‌ی دیدگاه در وردپرس","wapuu@wordpress.example","https://wordpress.org/","","2018-03-29 19:12:26","2018-03-29 15:42:26","سلام, این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com\">Gravatar</a> گرفته می‌شود.","0","1","","comment","0","0"),
("22","153","فرزین","oscriptco@gmail.com","","31.59.203.51","2018-09-27 15:37:30","2018-09-27 12:07:30","لورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.","0","1","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36","comment","0","0"),
("5","1","آفتاب","maerefat.67@gmail.com","","89.38.195.178","2018-04-07 22:24:28","2018-04-07 17:54:28","سلام\nروز خوبی داشته باشید","0","1","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:59.0) Gecko/20100101 Firefox/59.0","comment","1","1"),
("32","66","asd","sadadasdas2112@gmail.com","http://as","5.202.97.72","2020-10-17 19:27:26","2020-10-17 15:57:26","asd","0","trash","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:81.0) Gecko/20100101 Firefox/81.0","comment","0","0");


/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES 
("4","islamic","ad29af231c09f06f2122180902191419","100","2018-09-02 14:44:27","islamic","O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-09-02 19:14:19\";s:7:\"Version\";s:6:\"1.2.42\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.40\";s:10:\"VersionPHP\";s:6:\"5.6.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:4;s:4:\"Name\";s:7:\"islamic\";s:4:\"Hash\";s:32:\"ad29af231c09f06f2122180902191419\";s:8:\"NameHash\";s:40:\"islamic_ad29af231c09f06f2122180902191419\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:53:\"/home/demoqale/islamic.demo-qaleb.ir/wp-snapshots/tmp\";s:8:\"StoreURL\";s:42:\"http://islamic.demo-qaleb.ir/wp-snapshots/\";s:8:\"ScanFile\";s:50:\"islamic_ad29af231c09f06f2122180902191419_scan.json\";s:7:\"Runtime\";s:10:\"21.34 sec.\";s:7:\"ExeSize\";s:8:\"472.46KB\";s:7:\"ZipSize\";s:7:\"44.86MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:7:\"islamic\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:52:\"islamic_ad29af231c09f06f2122180902191419_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:36:\"/home/demoqale/islamic.demo-qaleb.ir\";s:4:\"Size\";i:47038474;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:45:\"/home/demoqale/islamic.demo-qaleb.ir/wp-admin\";i:1;s:55:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/uploads\";i:2;s:57:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/languages\";i:3;s:55:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/plugins\";i:4;s:54:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/themes\";i:5;s:48:\"/home/demoqale/islamic.demo-qaleb.ir/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";s:54:\"islamic_ad29af231c09f06f2122180902191419_installer.php\";s:4:\"Size\";i:483794;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:16:\"aXNsYW1pYzEzNjc=\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1041347;s:4:\"File\";s:53:\"islamic_ad29af231c09f06f2122180902191419_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:107:\"/home/demoqale/islamic.demo-qaleb.ir/wp-snapshots/tmp/islamic_ad29af231c09f06f2122180902191419_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");


/* INSERT TABLE DATA: wp_duplicator_pro_entities */
INSERT INTO `wp_duplicator_pro_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"uninstall_tables\": true,\n    \"crypt\": true,\n    \"wpfront_integrate\": false,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_phpdump_qrylimit\": 500,\n    \"package_php_chunking\": null,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 6,\n    \"homepath_as_abspath\": false,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 18,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"http\",\n    \"custom_ajax_url\": \"http:\\/\\/islamic.demo-qaleb.ir\\/wp-admin\\/admin-ajax.php\",\n    \"server_kick_off_sslverify\": true,\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"manual_mode_storage_ids\": [\n        \"-2\"\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": 1628586503,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": true,\n    \"lkp\": \"\",\n    \"license_limit\": -1,\n    \"last_edd_api_response\": null,\n    \"last_edd_api_timestamp\": 0,\n    \"last_system_check_timestamp\": 1628586514,\n    \"initial_activation_timestamp\": 1628586514,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"trace_profiler_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"profile_idea\": false,\n    \"profile_beta\": false,\n    \"dupHidePackagesGiftFeatures\": true,\n    \"type\": \"DUP_PRO_Global_Entity\",\n    \"notices\": {\n        \"dupArchiveSwitch\": true\n    }\n}"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"basic_auth_password\": null,\n    \"lkp\": \"\",\n    \"type\": \"DUP_PRO_Secure_Global_Entity\"\n}"),
("3","DUP_PRO_System_Global_Entity","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1628587597,\n    \"type\": \"DUP_PRO_System_Global_Entity\"\n}"),
("4","DUP_PRO_Package_Template_Entity","{\"name\":\"Default\",\"notes\":\"The default template.\",\"filter_sites\":[],\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":[],\"installer_opts_secure_on\":null,\"installer_opts_secure_pass\":null,\"installer_opts_skip_scan\":null,\"installer_opts_db_host\":null,\"installer_opts_db_name\":null,\"installer_opts_db_user\":null,\"installer_opts_cpnl_enable\":false,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":true,\"is_manual\":false,\"type\":\"DUP_PRO_Package_Template_Entity\"}"),
("5","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"database_filter_on\": 0,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"type\": \"DUP_PRO_Package_Template_Entity\"\n}");


/* INSERT TABLE DATA: wp_duplicator_pro_packages */
INSERT INTO `wp_duplicator_pro_packages` VALUES 
("1","20210810_d8acd985d987d988d8b1db8cd8a7d8","538e5b723e2ac0f51400_20210810092618","21","2021-08-10 13:56:26","islamic","{\n    \"Created\": \"2021-08-10 09:26:18\",\n    \"Version\": \"3.8.8.1\",\n    \"VersionWP\": \"5.8\",\n    \"VersionDB\": \"5.7.32\",\n    \"VersionPHP\": \"7.4.11\",\n    \"VersionOS\": \"Linux\",\n    \"ID\": 1,\n    \"Name\": \"20210810_d8acd985d987d988d8b1db8cd8a7d8\",\n    \"Hash\": \"538e5b723e2ac0f51400_20210810092618\",\n    \"NameHash\": \"20210810_d8acd985d987d988d8b1db8cd8a7d8_538e5b723e2ac0f51400_20210810092618\",\n    \"Type\": 0,\n    \"Notes\": \"\",\n    \"StorePath\": \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"http:\\/\\/islamic.demo-qaleb.ir\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20210810_d8acd985d987d988d8b1db8cd8a7d8_538e5b723e2ac0f51400_20210810092618_scan.json\",\n    \"timer_start\": 1628587598.31494,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"\\u067e\\u06cc\\u0634 \\u0641\\u0631\\u0636\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/.opcache\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/.tmb\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/cache\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/old-cache\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/updraft\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/wfcache\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/.htaccess\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"File\": \"20210810_d8acd985d987d988d8b1db8cd8a7d8_538e5b723e2ac0f51400_20210810092618_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\",\n        \"Size\": 110643469,\n        \"Dirs\": null,\n        \"DirCount\": 588,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 5491,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"Unreadable\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Unreadable\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20210810_d8acd985d987d988d8b1db8cd8a7d8_538e5b723e2ac0f51400_20210810092618_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\",\n                \"latin1_swedish_ci\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"demoqale_islam\",\n            \"tablesBaseCount\": 17,\n            \"tablesFinalCount\": 17,\n            \"tablesRowCount\": 1942,\n            \"tablesSizeOnDisk\": 1263578,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"rows\": \"2\",\n                    \"size\": 11696\n                },\n                \"wp_comments\": {\n                    \"rows\": \"4\",\n                    \"size\": 12516\n                },\n                \"wp_duplicator_packages\": {\n                    \"rows\": \"1\",\n                    \"size\": 10888\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"rows\": \"5\",\n                    \"size\": 9784\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"rows\": \"0\",\n                    \"size\": 1024\n                },\n                \"wp_ewwwio_images\": {\n                    \"rows\": \"0\",\n                    \"size\": 4096\n                },\n                \"wp_links\": {\n                    \"rows\": \"0\",\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"rows\": \"311\",\n                    \"size\": 165244\n                },\n                \"wp_postmeta\": {\n                    \"rows\": \"899\",\n                    \"size\": 352820\n                },\n                \"wp_posts\": {\n                    \"rows\": \"254\",\n                    \"size\": 617416\n                },\n                \"wp_smush_dir_images\": {\n                    \"rows\": \"0\",\n                    \"size\": 1024\n                },\n                \"wp_term_relationships\": {\n                    \"rows\": \"290\",\n                    \"size\": 22642\n                },\n                \"wp_term_taxonomy\": {\n                    \"rows\": \"59\",\n                    \"size\": 8740\n                },\n                \"wp_termmeta\": {\n                    \"rows\": \"0\",\n                    \"size\": 4096\n                },\n                \"wp_terms\": {\n                    \"rows\": \"59\",\n                    \"size\": 16992\n                },\n                \"wp_usermeta\": {\n                    \"rows\": \"57\",\n                    \"size\": 15132\n                },\n                \"wp_users\": {\n                    \"rows\": \"1\",\n                    \"size\": 8444\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"version\": \"5.7.32\",\n            \"versionComment\": \"MySQL Community Server - (GPL)\",\n            \"tableWiseRowCounts\": {\n                \"wp_commentmeta\": \"2\",\n                \"wp_comments\": \"4\",\n                \"wp_duplicator_packages\": \"1\",\n                \"wp_duplicator_pro_entities\": \"5\",\n                \"wp_duplicator_pro_packages\": \"1\"\n            }\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": null,\n        \"File\": \"20210810_d8acd985d987d988d8b1db8cd8a7d8_538e5b723e2ac0f51400_20210810092618_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/backups-dup-pro\\/tmp\\/20210810_d8acd985d987d988d8b1db8cd8a7d8_538e5b723e2ac0f51400_20210810092618_database.sql\",\n        \"sameNameTableExists\": false,\n        \"indexProcessedSchemaSize\": [\n            0,\n            11696,\n            24212,\n            35100,\n            44884\n        ],\n        \"intFieldsStruct\": {\n            \"wp_commentmeta\": {\n                \"meta_id\": \"NULL\",\n                \"comment_id\": \"0\"\n            },\n            \"wp_comments\": {\n                \"comment_ID\": \"NULL\",\n                \"comment_post_ID\": \"0\",\n                \"comment_karma\": \"0\",\n                \"comment_parent\": \"0\",\n                \"user_id\": \"0\"\n            },\n            \"wp_duplicator_packages\": {\n                \"id\": \"NULL\",\n                \"status\": \"NULL\"\n            },\n            \"wp_duplicator_pro_entities\": {\n                \"id\": \"NULL\"\n            }\n        }\n    },\n    \"Status\": \"20.7\",\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1628587599,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"custom_data\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tableIndex\": 0,\n        \"tableOffset\": 0,\n        \"totalRowOffset\": 0,\n        \"chunkIndex\": null,\n        \"validationStage1\": false,\n        \"bulkOffset\": 0,\n        \"bulkSizeOffset\": 0,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"tablesToProcess\": [\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_packages\",\n            \"wp_duplicator_pro_entities\",\n            \"wp_duplicator_pro_packages\",\n            \"wp_ewwwio_images\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_smush_dir_images\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_usermeta\",\n            \"wp_users\"\n        ],\n        \"startTime\": 1628587598.39972,\n        \"fileOffset\": 12362,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"totalSchemaSize\": 1282274,\n        \"tablesSchemaSizes\": {\n            \"wp_commentmeta\": 11696,\n            \"wp_comments\": 12516,\n            \"wp_duplicator_packages\": 10888,\n            \"wp_duplicator_pro_entities\": 9784,\n            \"wp_duplicator_pro_packages\": 14320,\n            \"wp_ewwwio_images\": 4096,\n            \"wp_links\": 1024,\n            \"wp_options\": 170644,\n            \"wp_postmeta\": 352820,\n            \"wp_posts\": 617416,\n            \"wp_smush_dir_images\": 1024,\n            \"wp_term_relationships\": 22642,\n            \"wp_term_taxonomy\": 8740,\n            \"wp_termmeta\": 4096,\n            \"wp_terms\": 16992,\n            \"wp_usermeta\": 15132,\n            \"wp_users\": 8444\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5\n}");


/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES 
("1","siteurl","http://islamic.demo-qaleb.ir","yes"),
("2","home","http://islamic.demo-qaleb.ir","yes"),
("3","blogname","جمهوری اسلامی","yes"),
("4","blogdescription","کاری از کلکسیون طراحی","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","maerefat.67@gmail.com","yes"),
("7","start_of_week","6","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","0","yes"),
("22","posts_per_page","15","yes"),
("23","date_format","F j, Y","yes"),
("24","time_format","g:i a","yes"),
("25","links_updated_date_format","F j, Y g:i a","yes"),
("26","comment_moderation","0","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("29","rewrite_rules","a:182:{s:10:\"gallery/?$\";s:27:\"index.php?post_type=gallery\";s:40:\"gallery/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=gallery&feed=$matches[1]\";s:35:\"gallery/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=gallery&feed=$matches[1]\";s:27:\"gallery/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=gallery&paged=$matches[1]\";s:8:\"media/?$\";s:25:\"index.php?post_type=media\";s:38:\"media/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=media&feed=$matches[1]\";s:33:\"media/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=media&feed=$matches[1]\";s:25:\"media/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=media&paged=$matches[1]\";s:12:\"newspaper/?$\";s:29:\"index.php?post_type=newspaper\";s:42:\"newspaper/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=newspaper&feed=$matches[1]\";s:37:\"newspaper/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=newspaper&feed=$matches[1]\";s:29:\"newspaper/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=newspaper&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:53:\"gallery-tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?gallery-tags=$matches[1]&feed=$matches[2]\";s:48:\"gallery-tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?gallery-tags=$matches[1]&feed=$matches[2]\";s:29:\"gallery-tags/([^/]+)/embed/?$\";s:45:\"index.php?gallery-tags=$matches[1]&embed=true\";s:41:\"gallery-tags/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?gallery-tags=$matches[1]&paged=$matches[2]\";s:23:\"gallery-tags/([^/]+)/?$\";s:34:\"index.php?gallery-tags=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:57:\"gallery_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?gallery_category=$matches[1]&feed=$matches[2]\";s:52:\"gallery_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?gallery_category=$matches[1]&feed=$matches[2]\";s:33:\"gallery_category/([^/]+)/embed/?$\";s:49:\"index.php?gallery_category=$matches[1]&embed=true\";s:45:\"gallery_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?gallery_category=$matches[1]&paged=$matches[2]\";s:27:\"gallery_category/([^/]+)/?$\";s:38:\"index.php?gallery_category=$matches[1]\";s:35:\"gallery/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"gallery/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"gallery/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"gallery/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"gallery/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"gallery/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"gallery/([^/]+)/embed/?$\";s:40:\"index.php?gallery=$matches[1]&embed=true\";s:28:\"gallery/([^/]+)/trackback/?$\";s:34:\"index.php?gallery=$matches[1]&tb=1\";s:48:\"gallery/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?gallery=$matches[1]&feed=$matches[2]\";s:43:\"gallery/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?gallery=$matches[1]&feed=$matches[2]\";s:36:\"gallery/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?gallery=$matches[1]&paged=$matches[2]\";s:43:\"gallery/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?gallery=$matches[1]&cpage=$matches[2]\";s:32:\"gallery/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?gallery=$matches[1]&page=$matches[2]\";s:24:\"gallery/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"gallery/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"gallery/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"gallery/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"gallery/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"gallery/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"media_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?media_category=$matches[1]&feed=$matches[2]\";s:50:\"media_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?media_category=$matches[1]&feed=$matches[2]\";s:31:\"media_category/([^/]+)/embed/?$\";s:47:\"index.php?media_category=$matches[1]&embed=true\";s:43:\"media_category/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?media_category=$matches[1]&paged=$matches[2]\";s:25:\"media_category/([^/]+)/?$\";s:36:\"index.php?media_category=$matches[1]\";s:33:\"media/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"media/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"media/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"media/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"media/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"media/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"media/([^/]+)/embed/?$\";s:38:\"index.php?media=$matches[1]&embed=true\";s:26:\"media/([^/]+)/trackback/?$\";s:32:\"index.php?media=$matches[1]&tb=1\";s:46:\"media/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?media=$matches[1]&feed=$matches[2]\";s:41:\"media/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?media=$matches[1]&feed=$matches[2]\";s:34:\"media/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?media=$matches[1]&paged=$matches[2]\";s:41:\"media/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?media=$matches[1]&cpage=$matches[2]\";s:30:\"media/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?media=$matches[1]&page=$matches[2]\";s:22:\"media/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"media/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"media/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"media/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"media/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"media/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"newspaper_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?newspaper_category=$matches[1]&feed=$matches[2]\";s:54:\"newspaper_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?newspaper_category=$matches[1]&feed=$matches[2]\";s:35:\"newspaper_category/([^/]+)/embed/?$\";s:51:\"index.php?newspaper_category=$matches[1]&embed=true\";s:47:\"newspaper_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?newspaper_category=$matches[1]&paged=$matches[2]\";s:29:\"newspaper_category/([^/]+)/?$\";s:40:\"index.php?newspaper_category=$matches[1]\";s:37:\"newspaper/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"newspaper/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"newspaper/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"newspaper/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"newspaper/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"newspaper/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"newspaper/([^/]+)/embed/?$\";s:42:\"index.php?newspaper=$matches[1]&embed=true\";s:30:\"newspaper/([^/]+)/trackback/?$\";s:36:\"index.php?newspaper=$matches[1]&tb=1\";s:50:\"newspaper/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?newspaper=$matches[1]&feed=$matches[2]\";s:45:\"newspaper/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?newspaper=$matches[1]&feed=$matches[2]\";s:38:\"newspaper/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?newspaper=$matches[1]&paged=$matches[2]\";s:45:\"newspaper/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?newspaper=$matches[1]&cpage=$matches[2]\";s:34:\"newspaper/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?newspaper=$matches[1]&page=$matches[2]\";s:26:\"newspaper/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"newspaper/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"newspaper/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"newspaper/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"newspaper/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"newspaper/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("1540","widget_last_post_author_3","a:5:{i:2;a:4:{s:12:\"widget_title\";s:29:\"جدیدترین مقالات\";s:8:\"post_num\";s:1:\"2\";s:8:\"post_cat\";s:0:\"\";s:11:\"limit_title\";s:0:\"\";}i:3;a:4:{s:12:\"widget_title\";s:29:\"جدیدترین مقالات\";s:8:\"post_num\";s:1:\"5\";s:8:\"post_cat\";s:0:\"\";s:11:\"limit_title\";s:0:\"\";}i:4;a:4:{s:12:\"widget_title\";s:29:\"جدیدترین مقالات\";s:8:\"post_num\";s:1:\"3\";s:8:\"post_cat\";s:0:\"\";s:11:\"limit_title\";s:0:\"\";}i:5;a:4:{s:12:\"widget_title\";s:29:\"جدیدترین مقالات\";s:8:\"post_num\";s:1:\"3\";s:8:\"post_cat\";s:1:\"9\";s:11:\"limit_title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("1541","widget_last_post_author_4","a:2:{i:2;a:4:{s:12:\"widget_title\";s:21:\"آخرین اخبار\";s:8:\"post_num\";s:2:\"10\";s:8:\"post_cat\";s:1:\"2\";s:11:\"limit_title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("1542","widget_last_post_author_5","a:5:{i:2;a:4:{s:12:\"widget_title\";s:14:\"برگزیده\";s:8:\"post_num\";s:1:\"1\";s:8:\"post_cat\";s:1:\"8\";s:11:\"limit_title\";s:0:\"\";}i:3;a:4:{s:12:\"widget_title\";s:12:\"سرتیتر\";s:8:\"post_num\";s:1:\"1\";s:8:\"post_cat\";s:1:\"4\";s:11:\"limit_title\";s:0:\"\";}i:5;a:4:{s:12:\"widget_title\";s:25:\"انتخاب سردبیر\";s:8:\"post_num\";s:1:\"1\";s:8:\"post_cat\";s:1:\"8\";s:11:\"limit_title\";s:0:\"\";}i:6;a:4:{s:12:\"widget_title\";s:39:\"تـحـلـیـل اقـتـصـادی\";s:8:\"post_num\";s:1:\"1\";s:8:\"post_cat\";s:1:\"5\";s:11:\"limit_title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("1543","widget_last_post_titr","a:4:{i:2;a:4:{s:12:\"widget_title\";s:13:\"سر تیتر\";s:8:\"post_num\";s:1:\"5\";s:8:\"post_cat\";s:1:\"6\";s:11:\"limit_title\";s:0:\"\";}i:3;a:4:{s:12:\"widget_title\";s:8:\"ویژه\";s:8:\"post_num\";s:1:\"3\";s:8:\"post_cat\";s:2:\"17\";s:11:\"limit_title\";s:0:\"\";}i:4;a:4:{s:12:\"widget_title\";s:12:\"سردبیر\";s:8:\"post_num\";s:1:\"9\";s:8:\"post_cat\";s:0:\"\";s:11:\"limit_title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("1544","widget_last_post_time","a:4:{i:2;a:4:{s:12:\"widget_title\";s:19:\"تایم زمانی\";s:8:\"post_num\";s:1:\"3\";s:8:\"post_cat\";s:1:\"2\";s:11:\"limit_title\";s:0:\"\";}i:3;a:4:{s:12:\"widget_title\";s:17:\"زمان بندی\";s:8:\"post_num\";s:1:\"4\";s:8:\"post_cat\";s:1:\"4\";s:11:\"limit_title\";s:0:\"\";}i:4;a:4:{s:12:\"widget_title\";s:29:\"جدیدترین مقالات\";s:8:\"post_num\";s:1:\"3\";s:8:\"post_cat\";s:0:\"\";s:11:\"limit_title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("1545","widget_last_post_newspaper","a:2:{i:2;a:4:{s:12:\"widget_title\";s:24:\"گیشه روز نامه\";s:8:\"post_num\";s:0:\"\";s:8:\"post_cat\";s:0:\"\";s:11:\"limit_title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("21860","widget_block","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("21858","duplicator_pro_license_key","Activation BY MR-Code","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:6:{i:0;s:14:\"azan/index.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:35:\"classic-widgets/classic-widgets.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:29:\"duplicator/duplicator-pro.php\";i:5;s:23:\"wp-jalali/wp-jalali.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","http://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","a:5:{i:0;s:79:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh/header.php\";i:2;s:79:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh/footer.php\";i:3;s:78:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh/style.css\";i:4;s:86:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh.2.5/css/print.css\";i:5;s:82:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh.2.5/style.css\";}","no"),
("40","template","News-Nashrieh","yes"),
("41","stylesheet","News-Nashrieh","yes"),
("21871","finished_updating_comment_type","1","yes"),
("44","comment_registration","0","yes"),
("45","html_type","text/html","yes"),
("46","use_trackback","0","yes"),
("47","default_role","subscriber","yes"),
("48","db_version","49752","yes"),
("49","uploads_use_yearmonth_folders","1","yes"),
("50","upload_path","","yes"),
("51","blog_public","0","yes"),
("52","default_link_category","2","yes"),
("53","show_on_front","posts","yes"),
("54","tag_base","","yes"),
("55","show_avatars","1","yes"),
("56","avatar_rating","G","yes"),
("57","upload_url_path","","yes"),
("58","thumbnail_size_w","100","yes"),
("59","thumbnail_size_h","70","yes"),
("60","thumbnail_crop","1","yes"),
("61","medium_size_w","300","yes"),
("62","medium_size_h","250","yes"),
("63","avatar_default","mystery","yes"),
("64","large_size_w","800","yes"),
("65","large_size_h","600","yes"),
("66","image_default_link_type","","yes"),
("67","image_default_size","","yes"),
("68","image_default_align","","yes"),
("69","close_comments_for_old_posts","0","yes"),
("70","close_comments_days_old","14","yes"),
("71","thread_comments","1","yes"),
("72","thread_comments_depth","5","yes"),
("73","page_comments","0","yes"),
("74","comments_per_page","50","yes"),
("75","default_comments_page","newest","yes"),
("76","comment_order","asc","yes"),
("77","sticky_posts","a:0:{}","yes"),
("78","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:10:\"فهرست\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("79","widget_text","a:5:{i:2;a:4:{s:5:\"title\";s:21:\"درباره سایت\";s:4:\"text\";s:319:\"عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:127:\"<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/04/ads.png\" alt=\"\" width=\"100%\" height=\"90\" /> </a>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:127:\"<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/04/ads.png\" alt=\"\" width=\"100%\" height=\"90\" /> </a>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:5;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}","yes"),
("80","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("81","uninstall_plugins","a:1:{s:27:\"autoptimize/autoptimize.php\";s:21:\"autoptimize_uninstall\";}","no"),
("82","timezone_string","Asia/Tehran","yes"),
("83","page_for_posts","0","yes"),
("84","page_on_front","0","yes"),
("85","default_post_format","0","yes"),
("86","link_manager_enabled","0","yes"),
("87","finished_splitting_shared_terms","1","yes"),
("88","site_icon","0","yes"),
("89","medium_large_size_w","768","yes"),
("90","medium_large_size_h","0","yes"),
("91","initial_db_version","38590","yes"),
("92","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes"),
("93","fresh_site","0","yes"),
("94","WPLANG","fa_IR","yes"),
("95","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("96","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("97","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("98","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("99","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("100","sidebars_widgets","a:11:{s:19:\"wp_inactive_widgets\";a:25:{i:0;s:18:\"last_post_author-2\";i:1;s:18:\"last_post_author-3\";i:2;s:18:\"last_post_author-4\";i:3;s:18:\"last_post_author-5\";i:4;s:20:\"last_post_author_2-2\";i:5;s:20:\"last_post_author_2-3\";i:6;s:20:\"last_post_author_3-2\";i:7;s:20:\"last_post_author_3-4\";i:8;s:20:\"last_post_author_5-2\";i:9;s:20:\"last_post_author_5-3\";i:10;s:13:\"widget_tabs-2\";i:11;s:16:\"last_post_time-2\";i:12;s:16:\"last_post_time-3\";i:13;s:19:\"tie-slider-widget-2\";i:14;s:24:\"theme_wg_news_all_post-2\";i:15;s:24:\"theme_wg_news_all_post-3\";i:16;s:24:\"theme_wg_news_all_post-4\";i:17;s:21:\"last_post_newspaper-2\";i:18;s:13:\"widget_azan-2\";i:19;s:13:\"widget_azan-3\";i:20;s:6:\"text-4\";i:21;s:6:\"text-3\";i:22;s:13:\"widget_azan-4\";i:23;s:6:\"text-2\";i:24;s:11:\"tag_cloud-2\";}s:4:\"logo\";a:2:{i:0;s:20:\"last_post_author_5-5\";i:1;s:20:\"last_post_author_2-6\";}s:5:\"right\";a:7:{i:0;s:20:\"last_post_author_5-6\";i:1;s:18:\"last_post_author-6\";i:2;s:20:\"last_post_author_2-7\";i:3;s:20:\"last_post_author_3-5\";i:4;s:16:\"last_post_time-4\";i:5;s:13:\"widget_azan-5\";i:6;s:12:\"categories-2\";}s:5:\"middl\";a:5:{i:0;s:16:\"last_post_titr-2\";i:1;s:16:\"last_post_list-2\";i:2;s:16:\"last_post_list-3\";i:3;s:16:\"last_post_titr-3\";i:4;s:20:\"last_post_author_4-2\";}s:4:\"left\";a:1:{i:0;s:6:\"text-5\";}s:10:\"page-right\";a:2:{i:0;s:19:\"tie-slider-widget-3\";i:1;s:20:\"last_post_author_3-3\";}s:9:\"page-left\";a:3:{i:0;s:16:\"last_post_titr-4\";i:1;s:13:\"widget_tabs-3\";i:2;s:24:\"theme_wg_news_all_post-5\";}s:12:\"footer-right\";a:1:{i:0;s:16:\"last_post_list-6\";}s:12:\"footer-middl\";a:1:{i:0;s:16:\"last_post_list-5\";}s:11:\"footer-left\";a:1:{i:0;s:16:\"last_post_list-4\";}s:13:\"array_version\";i:3;}","yes"),
("353","menu_icons_install","1522394001","yes"),
("152","theme_mods_twentyseventeen","a:3:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1523267150;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:6:\"text-4\";i:1;s:6:\"text-3\";i:2;s:13:\"widget_azan-2\";}s:9:\"sidebar-1\";a:1:{i:0;s:13:\"widget_azan-3\";}s:9:\"sidebar-2\";a:2:{i:0;s:6:\"text-2\";i:1;s:11:\"tag_cloud-2\";}s:9:\"sidebar-3\";a:0:{}}}s:18:\"nav_menu_locations\";a:1:{s:3:\"top\";i:11;}s:18:\"custom_css_post_id\";i:-1;}","yes"),
("153","current_theme","نشریه","yes"),
("154","theme_mods_Aftab-News-2","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:11:\"primary-nav\";i:11;s:9:\"top-nav-1\";i:44;s:9:\"top-nav-2\";i:49;s:10:\"footer-nav\";i:49;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1524222312;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:23:\"posts-listtime-widget-3\";i:1;s:20:\"posts-box-2-widget-5\";i:2;s:13:\"widget_azan-2\";i:3;s:13:\"widget_azan-3\";}s:5:\"middl\";a:10:{i:0;s:20:\"posts-box-1-widget-2\";i:1;s:20:\"posts_box_5-widget-2\";i:2;s:26:\"posts-main-number-widget-2\";i:3;s:20:\"posts-box-2-widget-2\";i:4;s:19:\"posts-main-widget-2\";i:5;s:6:\"text-4\";i:6;s:20:\"posts-box-4-widget-2\";i:7;s:21:\"posts_slider-widget-2\";i:8;s:6:\"text-3\";i:9;s:17:\"tabe-big-widget-2\";}s:4:\"left\";a:8:{i:0;s:19:\"tie-slider-widget-2\";i:1;s:18:\"last_post_author-2\";i:2;s:11:\"last_post-2\";i:3;s:25:\"posts-box-author-widget-2\";i:4;s:23:\"posts-listtime-widget-2\";i:5;s:13:\"widget_tabs-2\";i:6;s:24:\"theme_wg_news_all_post-2\";i:7;s:20:\"posts-box-3-widget-2\";}s:9:\"left-page\";a:6:{i:0;s:11:\"last_post-3\";i:1;s:11:\"last_post-4\";i:2;s:11:\"last_post-5\";i:3;s:11:\"last_post-7\";i:4;s:11:\"last_post-6\";i:5;s:24:\"theme_wg_news_all_post-3\";}s:5:\"media\";a:1:{i:0;s:21:\"posts-box-13-widget-2\";}s:3:\"ads\";a:1:{i:0;s:15:\"banner_widget-2\";}s:8:\"footer-1\";a:1:{i:0;s:23:\"posts-listtime-widget-4\";}s:8:\"footer-2\";a:1:{i:0;s:18:\"last_post_author-3\";}s:8:\"footer-3\";a:2:{i:0;s:6:\"text-2\";i:1;s:11:\"tag_cloud-2\";}}}}","yes"),
("155","theme_switched","","yes"),
("10141","category_children","a:1:{i:1;a:5:{i:0;i:4;i:1;i:5;i:2;i:6;i:3;i:7;i:4;i:8;}}","yes"),
("101","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("102","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("103","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("104","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("105","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("106","widget_tag_cloud","a:2:{i:2;a:3:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}","yes"),
("107","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("108","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("109","cron","a:13:{i:1628588836;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1628593607;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"e287ef120dcd45b3be4a4896ee74b8b6\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:375;}}}}i:1628593983;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"e180de93d77317f6708a530cdb4598dd\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:376;}}}}i:1628600456;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1628610146;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1628610153;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1628612714;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1628629773;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1628663011;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1628664573;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1628672972;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1628672973;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes"),
("694","_is_widget_active_","1","yes"),
("291","ewww_image_optimizer_background_optimization","1","yes"),
("292","ewww_image_optimizer_bulk_attachments","","no"),
("293","ewww_image_optimizer_flag_attachments","","no"),
("294","ewww_image_optimizer_ngg_attachments","","no"),
("295","ewww_image_optimizer_disable_pngout","1","no"),
("296","ewww_image_optimizer_optipng_level","2","no"),
("297","ewww_image_optimizer_pngout_level","2","no"),
("298","ewww_image_optimizer_jpegtran_copy","1","no"),
("299","ewww_image_optimizer_jpg_level","10","no"),
("300","ewww_image_optimizer_png_level","10","no"),
("301","ewww_image_optimizer_gif_level","10","no"),
("302","ewww_image_optimizer_pdf_level","0","no"),
("303","exactdn_all_the_things","1","no"),
("304","ewww_image_optimizer_version","411.0","yes"),
("307","ewww_image_optimizer_tracking_notice","1","yes"),
("308","ewww_image_optimizer_backup_files","","no"),
("309","ewww_image_optimizer_cloud_key","","yes"),
("310","ewww_image_optimizer_jpg_quality","","yes"),
("311","ewww_image_optimizer_aux_paths","","yes"),
("312","ewww_image_optimizer_exclude_paths","","yes"),
("313","ewww_image_optimizer_allow_tracking","","yes"),
("314","ewww_image_optimizer_maxmediawidth","0","yes"),
("315","ewww_image_optimizer_maxmediaheight","0","yes"),
("316","ewww_image_optimizer_maxotherwidth","0","yes"),
("317","ewww_image_optimizer_maxotherheight","0","yes"),
("318","ewww_image_optimizer_disable_resizes","","yes"),
("319","ewww_image_optimizer_disable_resizes_opt","","yes"),
("320","ewww_image_optimizer_jpg_background","","yes"),
("321","ewww_image_optimizer_webp_paths","","yes"),
("1510","duplicator_version_plugin","1.2.42","yes"),
("11210","su_option_supported_blocks","a:3:{i:0;s:14:\"core/paragraph\";i:1;s:14:\"core/shortcode\";i:2;s:13:\"core/freeform\";}","no"),
("11211","su_option_generator_access","manage_options","no"),
("11212","su_option_enable_shortcodes_in","a:1:{i:0;s:20:\"category_description\";}","no"),
("11213","su_option_hide_deprecated","on","no"),
("11214","widget_shortcodes-ultimate","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("11215","su_option_version","5.5.0","no"),
("11216","su_option_dismissed_notices","a:1:{s:4:\"rate\";i:1570276648;}","yes"),
("21831","_transient_timeout_feed_mod_1e2ffee29b94cfb5d3816e721235f11e","1628617054","no"),
("21832","_transient_feed_mod_1e2ffee29b94cfb5d3816e721235f11e","1628573854","no"),
("21833","_transient_timeout_dash_v2_ccb55a4e4b351a220e50ef4117d7dc27","1628617055","no"),
("21834","_transient_dash_v2_ccb55a4e4b351a220e50ef4117d7dc27","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://wp-persian.com/1398/09/10/wp-persian-53/\'>وردپرس فارسی ۵٫۳ نگارش استاد «علیدوست فلاحتی»</a></li></ul></div><div class=\"rss-widget\"><p><strong>خطای RSS:</strong> WP HTTP Error: نشانی معتبر نیست.</p></div>","no"),
("21830","_transient_feed_1e2ffee29b94cfb5d3816e721235f11e","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://wp-persian.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"سایت رسمی پروژه وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 01 Dec 2019 14:08:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fa-IR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.9-alpha-51470\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"وردپرس فارسی ۵٫۳ نگارش استاد «علیدوست فلاحتی»\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://wp-persian.com/1398/09/10/wp-persian-53/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 01 Dec 2019 14:08:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=489\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:593:\"وردپرس فارسی ۵٫۳ منتشر شد.این نگارش از وردپرس فارسی با افتخار مزیّن به نام استاد گرانقدر موسیقی ایران، «علیدوست فلاحتی» است. می‌توانید نگارش جدید وردپرس فارسی را از این بخش دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید.توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط به وردپرس [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:824:\"\r\n<p>وردپرس فارسی ۵٫۳ منتشر شد.<br>این نگارش از وردپرس فارسی با افتخار مزیّن به نام استاد گرانقدر موسیقی ایران، «<a href=\"https://fa.wikipedia.org/wiki/%D8%B9%D9%84%DB%8C%D8%AF%D9%88%D8%B3%D8%AA_%D9%81%D9%84%D8%A7%D8%AD%D8%AA%DB%8C\">علیدوست فلاحتی</a>» است.</p>\r\n\r\n\r\n\r\n<p>می‌توانید نگارش جدید وردپرس فارسی را از <a href=\"http://wp-persian.com/download/\">این بخش</a> دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید.<br><em>توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط به وردپرس فارسی (fa_IR) باشد.</em></p>\r\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۵٫۲٫۱\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1398/03/12/wp-persian-521/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 02 Jun 2019 16:39:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=487\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"وردپرس فارسی ۵٫۲٫۱ منتشر شد.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"<p>وردپرس فارسی ۵٫۲٫۱ منتشر شد.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"وردپرس فارسی ۵٫۲ نگارش استاد «حسن اسکندری»\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://wp-persian.com/1398/02/18/wp-persian-52/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 May 2019 05:30:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=484\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:587:\"وردپرس فارسی ۵٫۲ منتشر شد.این نگارش از وردپرس فارسی با افتخار مزیّن به نام استاد گرانقدر موسیقی ایران، «حسن اسکندری» است. می‌توانید نگارش جدید وردپرس فارسی را از این بخش دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید.توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط به وردپرس [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:831:\"\r\n<p>وردپرس فارسی ۵٫۲ منتشر شد.<br>این نگارش از وردپرس فارسی با افتخار مزیّن به نام استاد گرانقدر موسیقی ایران، «<a href=\"https://fa.wikipedia.org/wiki/%D8%B9%D8%A7%D8%B4%DB%8C%D9%82_%D8%AD%D8%B3%D9%86_%D8%A7%D8%B3%DA%A9%D9%86%D8%AF%D8%B1%DB%8C\">حسن اسکندری</a>» است.</p>\r\n\r\n\r\n\r\n<p>می‌توانید نگارش جدید وردپرس فارسی را از <a href=\"http://wp-persian.com/download/\">این بخش</a> دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید.<br><em>توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط به وردپرس فارسی (fa_IR) باشد.</em></p>\r\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"وردپرس فارسی ۵٫۱ نگارش استاد «ملک‌محمد مسعودی»\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://wp-persian.com/1397/12/16/wp-persian-51/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 07 Mar 2019 13:07:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=480\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:596:\"وردپرس فارسی ۵٫۱ منتشر شد.این نگارش از وردپرس فارسی با افتخار مزیّن به نام استاد گرانقدر موسیقی ایران، «ملک‌محمد مسعودی» است. می‌توانید نگارش جدید وردپرس فارسی را از این بخش دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید.توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط به وردپرس [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:836:\"\r\n<p>وردپرس فارسی ۵٫۱ منتشر شد.<br>این نگارش از وردپرس فارسی با افتخار مزیّن به نام استاد گرانقدر موسیقی ایران، «<a href=\"https://fa.wikipedia.org/wiki/%D9%85%D9%84%DA%A9%E2%80%8C%D9%85%D8%AD%D9%85%D8%AF_%D9%85%D8%B3%D8%B9%D9%88%D8%AF%DB%8C\">ملک‌محمد مسعودی</a>» است.</p>\r\n\r\n\r\n\r\n<p>می‌توانید نگارش جدید وردپرس فارسی را از <a href=\"http://wp-persian.com/download/\">این بخش</a> دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید.<br><em>توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط به وردپرس فارسی (fa_IR) باشد.</em></p>\r\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"وردپرس فارسی ۵٫۰٫۳ نگارش استاد «قنبر راستگو»\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1397/11/10/wp-persian-503/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 29 Jan 2019 20:32:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"عمومی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=473\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:591:\"وردپرس فارسی ۵٫۰٫۳ منتشر شد.این نگارش از وردپرس فارسی با افتخار مزیّن به نام استاد گرانقدر موسیقی ایران، «قنبر راستگو» است. می‌توانید نگارش جدید وردپرس فارسی را از این بخش دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید.توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط به وردپرس [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:764:\"\r\n<p>وردپرس فارسی ۵٫۰٫۳ منتشر شد.<br>این نگارش از وردپرس فارسی با افتخار مزیّن به نام استاد گرانقدر موسیقی ایران، «<a href=\"https://fa.wikipedia.org/wiki/قنبر_راستگو\">قنبر راستگو</a>» است.</p>\r\n\r\n\r\n\r\n<p>می‌توانید نگارش جدید وردپرس فارسی را از <a href=\"http://wp-persian.com/download/\">این بخش</a> دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید.<br><em>توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط به وردپرس فارسی (fa_IR) باشد.</em></p>\r\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۹٫۸\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1397/05/18/wp-persian-498/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Aug 2018 16:01:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=470\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"وردپرس فارسی ۴٫۹٫۸ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"<p>وردپرس فارسی ۴٫۹٫۸ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۹٫۱\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1396/10/24/wp-persian-491/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 14 Jan 2018 15:24:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=466\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:199:\"وردپرس فارسی ۴٫۹٫۱ منتشر شد. ترجمه این نگارش بدون نظارت مستقیم گروه وردپرس فارسی و توسط کاربران انجام شده است.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:214:\"<p>وردپرس فارسی ۴٫۹٫۱ منتشر شد.</p>\n<p>ترجمه این نگارش بدون نظارت مستقیم گروه وردپرس فارسی و توسط کاربران انجام شده است.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۸٫۲\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1396/07/14/wp-persian-482/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Oct 2017 08:29:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=464\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"وردپرس فارسی ۴٫۸٫۲ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"<p>وردپرس فارسی ۴٫۸٫۲ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۸٫۱\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1396/06/09/wp-persian-481/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 31 Aug 2017 09:55:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=461\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"وردپرس فارسی ۴٫۸٫۱ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"<p>وردپرس فارسی ۴٫۸٫۱ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"وردپرس فارسی ۴٫۸ نگارش استاد «آی‌محمد یوسفی»\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://wp-persian.com/1396/03/19/wp-persian-48/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Jun 2017 16:13:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=458\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:576:\"وردپرس فارسی ۴٫۸ منتشر شد. این نگارش از وردپرس فارسی با افتخار مزیّن به نام استاد گرانقدر موسیقی ایران، «آی‌محمد یوسفی» است. می‌توانید نگارش جدید وردپرس فارسی را از این بخش دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید. توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:816:\"<p>وردپرس فارسی ۴٫۸ منتشر شد.<br />\nاین نگارش از وردپرس فارسی با افتخار مزیّن به نام استاد گرانقدر موسیقی ایران، «<a href=\"https://fa.wikipedia.org/wiki/%D8%A2%DB%8C%E2%80%8C%D9%85%D8%AD%D9%85%D8%AF_%DB%8C%D9%88%D8%B3%D9%81%DB%8C\">آی‌محمد یوسفی</a>» است.</p>\n<p>می‌توانید نگارش جدید وردپرس فارسی را از <a href=\"http://wp-persian.com/download/\">این بخش</a> دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید.<br />\n<em>توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط به وردپرس فارسی (fa_IR) باشد.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:27:\"http://wp-persian.com/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:10:{s:4:\"date\";s:29:\"Tue, 10 Aug 2021 05:37:33 GMT\";s:6:\"server\";s:6:\"Apache\";s:4:\"link\";s:58:\"<http://wp-persian.com/wp-json/>; rel=\"https://api.w.org/\"\";s:7:\"upgrade\";s:6:\"h2,h2c\";s:13:\"last-modified\";s:29:\"Sun, 01 Dec 2019 14:09:23 GMT\";s:4:\"etag\";s:37:\"\"3c390fd8a0d4c32da60c1109e3b358f2-br\"\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:2:\"br\";s:14:\"content-length\";s:4:\"1703\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";}}s:5:\"build\";s:14:\"20180831101039\";}","no"),
("21829","_transient_timeout_feed_1e2ffee29b94cfb5d3816e721235f11e","1628617054","no"),
("21828","_site_transient_community-events-a35c28d8b018a6a53b96ddaac48ee926","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:10:\"86.57.96.0\";}s:6:\"events\";a:2:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:66:\"Watch Party + Discussion group: Content Creation with Block Editor\";s:3:\"url\";s:68:\"https://www.meetup.com/learn-wordpress-discussions/events/279774777/\";s:6:\"meetup\";s:27:\"Learn WordPress Discussions\";s:10:\"meetup_url\";s:51:\"https://www.meetup.com/learn-wordpress-discussions/\";s:4:\"date\";s:19:\"2021-08-11 19:00:00\";s:8:\"end_date\";s:19:\"2021-08-11 20:00:00\";s:20:\"start_unix_timestamp\";i:1628733600;s:18:\"end_unix_timestamp\";i:1628737200;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:37.779998779297003;s:9:\"longitude\";d:-122.41999816895;}}i:1;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:54:\"WordCamp Florianópolis, Santa Catarina &#8211; Brazil\";s:3:\"url\";s:34:\"https://floripa.wordcamp.org/2021/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2021-08-11 19:30:00\";s:8:\"end_date\";s:19:\"2021-08-12 00:00:00\";s:20:\"start_unix_timestamp\";i:1628721000;s:18:\"end_unix_timestamp\";i:1628737200;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"BR\";s:8:\"latitude\";d:-27.595319799999999;s:9:\"longitude\";d:-48.554292699999998;}}}}","no"),
("21827","_site_transient_timeout_community-events-a35c28d8b018a6a53b96ddaac48ee926","1628617053","no"),
("21825","_site_transient_timeout_browser_5dd84b6147bbb17b430079be84dacdc3","1629178651","no"),
("21826","_site_transient_browser_5dd84b6147bbb17b430079be84dacdc3","a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"90.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no"),
("21857","duplicator_pro_plugin_version","3.8.8.1","yes"),
("21856","duplicator_pro_reset_user_settings_required","0","yes"),
("131","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:21:\"maerefat.67@gmail.com\";s:7:\"version\";s:6:\"4.9.18\";s:9:\"timestamp\";i:1620890302;}","no"),
("158","widget_tabe-big-widget","a:2:{i:2;a:12:{s:5:\"catid\";s:1:\"6\";s:6:\"catid2\";s:1:\"5\";s:6:\"catid3\";s:1:\"8\";s:6:\"catid4\";s:1:\"4\";s:11:\"excludepost\";s:0:\"\";s:12:\"excludepost2\";s:0:\"\";s:12:\"excludepost3\";s:0:\"\";s:12:\"excludepost4\";s:0:\"\";s:12:\"title_word_1\";s:0:\"\";s:12:\"title_word_2\";s:0:\"\";s:12:\"title_word_3\";s:0:\"\";s:12:\"title_word_4\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("156","widget_links","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("157","widget_posts-box-13-widget","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("159","widget_widget_tabs","a:3:{i:2;a:2:{s:11:\"posts_order\";s:7:\"popular\";s:12:\"posts_number\";s:1:\"4\";}i:3;a:2:{s:11:\"posts_order\";s:0:\"\";s:12:\"posts_number\";s:1:\"3\";}s:12:\"_multiwidget\";i:1;}","yes"),
("160","widget_posts-main-widget","a:2:{i:2;a:6:{s:5:\"title\";s:21:\"دنیای سیاست\";s:8:\"category\";s:1:\"4\";s:13:\"category_link\";s:74:\"http://islamic.demo-qaleb.ir/category/news/%d8%b3%db%8c%d8%a7%d8%b3%db%8c/\";s:15:\"category_target\";s:2:\"on\";s:6:\"number\";i:2;s:9:\"icon_code\";s:46:\"<i class=\"fa fa-gavel\" aria-hidden=\"true\"></i>\";}s:12:\"_multiwidget\";i:1;}","yes"),
("161","widget_posts-main-number-widget","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("162","widget_last_post","a:7:{i:2;a:4:{s:12:\"widget_title\";s:12:\"فرهنگی\";s:8:\"post_num\";s:1:\"2\";s:8:\"post_cat\";s:1:\"8\";s:11:\"limit_title\";s:0:\"\";}i:3;a:4:{s:12:\"widget_title\";s:13:\":: ایران\";s:8:\"post_num\";s:1:\"4\";s:8:\"post_cat\";s:1:\"2\";s:11:\"limit_title\";s:0:\"\";}i:4;a:4:{s:12:\"widget_title\";s:20:\":: بین الملل\";s:8:\"post_num\";s:1:\"4\";s:8:\"post_cat\";s:1:\"3\";s:11:\"limit_title\";s:0:\"\";}i:5;a:4:{s:12:\"widget_title\";s:13:\":: سیاسی\";s:8:\"post_num\";s:1:\"4\";s:8:\"post_cat\";s:1:\"4\";s:11:\"limit_title\";s:0:\"\";}i:6;a:4:{s:12:\"widget_title\";s:13:\":: ورزشی\";s:8:\"post_num\";s:1:\"4\";s:8:\"post_cat\";s:1:\"7\";s:11:\"limit_title\";s:0:\"\";}i:7;a:4:{s:12:\"widget_title\";s:17:\":: اجتماعی\";s:8:\"post_num\";s:1:\"4\";s:8:\"post_cat\";s:1:\"6\";s:11:\"limit_title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("163","widget_theme_wg_news_all_post","a:5:{i:2;a:4:{s:10:\"news_title\";s:21:\"جديدترين ها\";s:11:\"select_news\";s:1:\"1\";s:8:\"news_cat\";N;s:10:\"news_count\";s:1:\"8\";}i:3;a:4:{s:10:\"news_title\";s:21:\"جديدترين ها\";s:11:\"select_news\";s:1:\"1\";s:8:\"news_cat\";N;s:10:\"news_count\";s:2:\"15\";}i:4;a:4:{s:10:\"news_title\";s:21:\"جديدترين ها\";s:11:\"select_news\";s:1:\"1\";s:8:\"news_cat\";N;s:10:\"news_count\";s:1:\"8\";}i:5;a:4:{s:10:\"news_title\";s:21:\"جديدترين ها\";s:11:\"select_news\";s:1:\"1\";s:8:\"news_cat\";N;s:10:\"news_count\";s:2:\"15\";}s:12:\"_multiwidget\";i:1;}","yes"),
("164","widget_last_post_list","a:6:{i:2;a:4:{s:12:\"widget_title\";s:17:\"بین الملل\";s:8:\"post_num\";s:1:\"4\";s:8:\"post_cat\";s:1:\"3\";s:11:\"limit_title\";s:0:\"\";}i:3;a:4:{s:12:\"widget_title\";s:10:\"ایران\";s:8:\"post_num\";s:1:\"5\";s:8:\"post_cat\";s:1:\"2\";s:11:\"limit_title\";s:0:\"\";}i:4;a:4:{s:12:\"widget_title\";s:10:\"سیاسی\";s:8:\"post_num\";s:1:\"5\";s:8:\"post_cat\";s:1:\"4\";s:11:\"limit_title\";s:0:\"\";}i:5;a:4:{s:12:\"widget_title\";s:14:\"اقتصادی\";s:8:\"post_num\";s:1:\"5\";s:8:\"post_cat\";s:1:\"5\";s:11:\"limit_title\";s:0:\"\";}i:6;a:4:{s:12:\"widget_title\";s:29:\"جدیدترین مقالات\";s:8:\"post_num\";s:1:\"5\";s:8:\"post_cat\";s:0:\"\";s:11:\"limit_title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("165","widget_last_post_author","a:6:{i:2;a:4:{s:12:\"widget_title\";s:29:\"جدیدترین مقالات\";s:8:\"post_num\";s:1:\"2\";s:8:\"post_cat\";s:1:\"9\";s:11:\"limit_title\";s:0:\"\";}i:3;a:4:{s:12:\"widget_title\";s:27:\"جدیدترین اخبار\";s:8:\"post_num\";s:1:\"3\";s:8:\"post_cat\";s:1:\"2\";s:11:\"limit_title\";s:0:\"\";}i:4;a:4:{s:12:\"widget_title\";s:15:\"در حاشیه\";s:8:\"post_num\";s:1:\"3\";s:8:\"post_cat\";s:1:\"3\";s:11:\"limit_title\";s:0:\"\";}i:5;a:4:{s:12:\"widget_title\";s:18:\"نویسندگان\";s:8:\"post_num\";s:1:\"3\";s:8:\"post_cat\";s:1:\"9\";s:11:\"limit_title\";s:0:\"\";}i:6;a:4:{s:12:\"widget_title\";s:23:\"فـرهـنـگ روز\";s:8:\"post_num\";s:1:\"3\";s:8:\"post_cat\";s:1:\"8\";s:11:\"limit_title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("166","widget_posts-box-author-widget","a:2:{i:2;a:5:{s:5:\"title\";s:18:\"یادداشتها\";s:8:\"category\";s:1:\"9\";s:13:\"category_link\";s:81:\"http://islamic.demo-qaleb.ir/category/%db%8c%d8%a7%d8%af%d8%af%d8%a7%d8%b4%d8%aa/\";s:15:\"category_target\";s:0:\"\";s:9:\"icon_code\";s:45:\"<i class=\"fa fa-book\" aria-hidden=\"true\"></i>\";}s:12:\"_multiwidget\";i:1;}","yes"),
("167","widget_posts-listtime-widget","a:4:{i:2;a:3:{s:5:\"title\";s:13:\"ویژه ها\";s:8:\"category\";s:2:\"17\";s:6:\"number\";i:7;}i:3;a:3:{s:5:\"title\";s:12:\"تاریخی\";s:8:\"category\";s:1:\"1\";s:6:\"number\";i:4;}i:4;a:3:{s:5:\"title\";s:21:\"آخرین مطالب\";s:8:\"category\";s:1:\"1\";s:6:\"number\";i:4;}s:12:\"_multiwidget\";i:1;}","yes"),
("168","widget_banner_widget","a:4:{i:2;a:14:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:3;s:10:\"ad_1_image\";s:63:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/ads.png\";s:9:\"ad_1_link\";s:29:\"http://islamic.demo-qaleb.ir/\";s:10:\"ad_2_image\";s:63:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/ads.png\";s:9:\"ad_2_link\";s:0:\"\";s:10:\"ad_3_image\";s:63:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/ads.png\";s:9:\"ad_3_link\";s:0:\"\";s:10:\"ad_4_image\";s:63:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/ads.png\";s:9:\"ad_4_link\";s:0:\"\";s:10:\"ad_5_image\";s:63:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/ads.png\";s:9:\"ad_5_link\";s:0:\"\";s:10:\"ad_6_image\";s:63:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/ads.png\";s:9:\"ad_6_link\";s:0:\"\";}i:3;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:1;s:10:\"ad_1_image\";s:65:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/04/ads-1.png\";s:9:\"ad_1_link\";s:0:\"\";}i:4;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:1;s:10:\"ad_1_image\";s:65:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/04/ads-1.png\";s:9:\"ad_1_link\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("169","widget_tie-slider-widget","a:3:{i:2;a:4:{s:15:\"cat_posts_title\";s:0:\"\";s:11:\"no_of_posts\";s:1:\"3\";s:13:\"custom_slider\";N;s:7:\"cats_id\";s:2:\"17\";}i:3;a:4:{s:15:\"cat_posts_title\";s:0:\"\";s:11:\"no_of_posts\";s:1:\"3\";s:13:\"custom_slider\";N;s:7:\"cats_id\";s:2:\"30\";}s:12:\"_multiwidget\";i:1;}","yes"),
("170","widget_posts_slider-widget","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:1:\"4\";s:6:\"number\";i:3;}s:12:\"_multiwidget\";i:1;}","yes"),
("171","widget_posts-box-1-widget","a:2:{i:2;a:6:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:1:\"1\";s:13:\"category_link\";s:0:\"\";s:15:\"category_target\";s:2:\"on\";s:6:\"number\";i:3;s:9:\"icon_code\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("172","widget_posts-box-2-widget","a:3:{i:2;a:5:{s:5:\"title\";s:10:\"ایران\";s:8:\"category\";s:1:\"2\";s:13:\"category_link\";s:69:\"http://islamic.demo-qaleb.ir/category/%d8%a7%db%8c%d8%b1%d8%a7%d9%86/\";s:15:\"category_target\";s:2:\"on\";s:9:\"icon_code\";s:46:\"<i class=\"fa fa-globe\" aria-hidden=\"true\"></i>\";}i:5;a:5:{s:5:\"title\";s:15:\"استان ها\";s:8:\"category\";s:2:\"10\";s:13:\"category_link\";s:0:\"\";s:15:\"category_target\";s:0:\"\";s:9:\"icon_code\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("173","widget_posts-box-3-widget","a:2:{i:2;a:5:{s:5:\"title\";s:18:\"کاریکاتور\";s:8:\"category\";s:2:\"30\";s:13:\"category_link\";s:93:\"http://islamic.demo-qaleb.ir/category/%da%a9%d8%a7%d8%b1%db%8c%da%a9%d8%a7%d8%aa%d9%88%d8%b1/\";s:15:\"category_target\";s:2:\"on\";s:9:\"icon_code\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("174","widget_posts-box-4-widget","a:2:{i:2;a:6:{s:5:\"title\";s:26:\"روی میز سردبیر\";s:8:\"category\";s:1:\"6\";s:13:\"category_link\";s:86:\"http://islamic.demo-qaleb.ir/category/news/%d8%a7%d8%ac%d8%aa%d9%85%d8%a7%d8%b9%db%8c/\";s:15:\"category_target\";s:2:\"on\";s:6:\"number\";i:3;s:9:\"icon_code\";s:52:\"<i class=\"fa fa-institution\" aria-hidden=\"true\"></i>\";}s:12:\"_multiwidget\";i:1;}","yes"),
("175","widget_posts_box_5-widget","a:2:{i:2;a:6:{s:5:\"title\";s:15:\"خبر ویژه\";s:8:\"category\";s:1:\"1\";s:13:\"category_link\";s:36:\"http://islamic.demo-qaleb.ir/?cat=17\";s:15:\"category_target\";s:0:\"\";s:6:\"number\";i:3;s:9:\"icon_code\";s:51:\"<i class=\"fa fa-quote-left\" aria-hidden=\"true\"></i>\";}s:12:\"_multiwidget\";i:1;}","yes"),
("176","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes"),
("733","theme_mods_Aftab-News-3.3","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:11:\"primary-nav\";i:11;s:9:\"top-nav-1\";i:44;s:9:\"top-nav-2\";i:49;s:10:\"footer-nav\";i:49;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1535710463;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:23:\"posts-listtime-widget-3\";i:1;s:20:\"posts-box-2-widget-5\";i:2;s:13:\"widget_azan-2\";i:3;s:13:\"widget_azan-3\";}s:5:\"middl\";a:10:{i:0;s:20:\"posts-box-1-widget-2\";i:1;s:20:\"posts_box_5-widget-2\";i:2;s:26:\"posts-main-number-widget-2\";i:3;s:20:\"posts-box-2-widget-2\";i:4;s:19:\"posts-main-widget-2\";i:5;s:6:\"text-4\";i:6;s:20:\"posts-box-4-widget-2\";i:7;s:21:\"posts_slider-widget-2\";i:8;s:6:\"text-3\";i:9;s:17:\"tabe-big-widget-2\";}s:4:\"left\";a:9:{i:0;s:19:\"tie-slider-widget-2\";i:1;s:18:\"last_post_author-2\";i:2;s:11:\"last_post-2\";i:3;s:15:\"banner_widget-3\";i:4;s:25:\"posts-box-author-widget-2\";i:5;s:23:\"posts-listtime-widget-2\";i:6;s:13:\"widget_tabs-2\";i:7;s:24:\"theme_wg_news_all_post-2\";i:8;s:20:\"posts-box-3-widget-2\";}s:9:\"left-page\";a:8:{i:0;s:15:\"banner_widget-4\";i:1;s:13:\"widget_azan-4\";i:2;s:11:\"last_post-3\";i:3;s:11:\"last_post-4\";i:4;s:11:\"last_post-5\";i:5;s:11:\"last_post-7\";i:6;s:11:\"last_post-6\";i:7;s:24:\"theme_wg_news_all_post-3\";}s:5:\"media\";a:1:{i:0;s:21:\"posts-box-13-widget-2\";}s:3:\"ads\";a:1:{i:0;s:15:\"banner_widget-2\";}s:8:\"footer-1\";a:1:{i:0;s:23:\"posts-listtime-widget-4\";}s:8:\"footer-2\";a:1:{i:0;s:18:\"last_post_author-3\";}s:8:\"footer-3\";a:2:{i:0;s:6:\"text-2\";i:1;s:11:\"tag_cloud-2\";}}}}","yes"),
("1512","duplicator_exe_safe_mode","0","yes"),
("1561","duplicator_package_active","O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-09-02 19:14:19\";s:7:\"Version\";s:6:\"1.2.42\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.40\";s:10:\"VersionPHP\";s:6:\"5.6.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:7:\"islamic\";s:4:\"Hash\";s:32:\"ad29af231c09f06f2122180902191419\";s:8:\"NameHash\";s:40:\"islamic_ad29af231c09f06f2122180902191419\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:53:\"/home/demoqale/islamic.demo-qaleb.ir/wp-snapshots/tmp\";s:8:\"StoreURL\";s:42:\"http://islamic.demo-qaleb.ir/wp-snapshots/\";s:8:\"ScanFile\";s:50:\"islamic_ad29af231c09f06f2122180902191419_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:36:\"/home/demoqale/islamic.demo-qaleb.ir\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-09-02 19:14:19\";s:7:\"Version\";s:6:\"1.2.42\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.40\";s:10:\"VersionPHP\";s:6:\"5.6.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:7:\"islamic\";s:4:\"Hash\";s:32:\"ad29af231c09f06f2122180902191419\";s:8:\"NameHash\";s:40:\"islamic_ad29af231c09f06f2122180902191419\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:53:\"/home/demoqale/islamic.demo-qaleb.ir/wp-snapshots/tmp\";s:8:\"StoreURL\";s:42:\"http://islamic.demo-qaleb.ir/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:16:\"aXNsYW1pYzEzNjc=\";s:10:\"\0*\0Package\";r:58;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:58;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:45:\"/home/demoqale/islamic.demo-qaleb.ir/wp-admin\";i:1;s:55:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/uploads\";i:2;s:57:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/languages\";i:3;s:55:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/plugins\";i:4;s:54:\"/home/demoqale/islamic.demo-qaleb.ir/wp-content/themes\";i:5;s:48:\"/home/demoqale/islamic.demo-qaleb.ir/wp-includes\";}}s:9:\"Installer\";r:80;s:8:\"Database\";r:90;}","yes"),
("1520","duplicator_settings","a:10:{s:7:\"version\";s:6:\"1.2.42\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}","yes"),
("1573","newspaper_category_children","a:0:{}","yes"),
("21907","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/fa_IR/wordpress-5.8.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/fa_IR/wordpress-5.8.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"5.8\";s:7:\"version\";s:3:\"5.8\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.6\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1628587493;s:15:\"version_checked\";s:3:\"5.8\";s:12:\"translations\";a:0:{}}","no"),
("21910","wpcf7","a:2:{s:7:\"version\";s:5:\"5.4.2\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1628587503;s:7:\"version\";s:5:\"5.4.2\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}","yes"),
("21909","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1628587501;s:7:\"checked\";a:2:{s:15:\"News-Nashrieh-o\";s:5:\"3.5.0\";s:13:\"News-Nashrieh\";s:3:\"5.0\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}","no"),
("1523","duplicator_ui_view_state","a:6:{s:28:\"dup-settings-diag-opts-panel\";s:1:\"1\";s:19:\"dup-pack-build-try2\";s:1:\"1\";s:19:\"dup-pack-build-try3\";s:1:\"1\";s:19:\"dup-pack-build-try1\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"1\";s:22:\"dup-pack-storage-panel\";s:1:\"1\";}","yes"),
("1622","wp-smush-last_settings","a:12:{s:11:\"networkwide\";i:0;s:4:\"auto\";i:1;s:5:\"lossy\";i:0;s:8:\"original\";i:0;s:10:\"strip_exif\";i:0;s:6:\"resize\";i:0;s:6:\"backup\";i:0;s:10:\"png_to_jpg\";i:0;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"detection\";i:0;s:9:\"gutenberg\";i:0;}","no"),
("1623","wdev-frash","a:3:{s:7:\"plugins\";a:1:{s:23:\"wp-smushit/wp-smush.php\";i:1535870368;}s:5:\"queue\";a:2:{s:32:\"7de3619981caadc55f30a002bfb299f6\";a:3:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:5:\"email\";s:7:\"show_at\";i:1535870368;}s:32:\"fc50097023d0d34c5a66f6cddcf77694\";a:3:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:4:\"rate\";s:7:\"show_at\";i:1536475168;}}s:4:\"done\";a:0:{}}","no"),
("1624","wp-smush-skip-redirect","1","no"),
("1625","smush_option","a:1:{s:7:\"version\";s:5:\"2.8.1\";}","yes"),
("1626","wp-smush-install-type","existing","no"),
("1627","wp-smush-version","2.8.1","no"),
("1628","smush_global_stats","a:9:{s:11:\"size_before\";i:0;s:10:\"size_after\";i:0;s:7:\"percent\";d:0;s:5:\"human\";s:6:\"0٫0 B\";s:5:\"bytes\";i:0;s:12:\"total_images\";i:0;s:12:\"resize_count\";i:0;s:14:\"resize_savings\";i:0;s:18:\"conversion_savings\";i:0;}","no"),
("1631","dir_smush_stats","a:2:{s:9:\"dir_smush\";a:2:{s:5:\"total\";s:1:\"0\";s:9:\"optimised\";i:0;}s:14:\"combined_stats\";a:0:{}}","no"),
("1632","wp-smush-resize_sizes","a:2:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;}","no"),
("1633","skip-smush-setup","1","no"),
("1634","wp-smush-hide_smush_welcome","1","no"),
("1635","wp-smush-networkwide","0","no"),
("1636","wp-smush-auto","1","no"),
("1637","wp-smush-lossy","0","no"),
("1638","wp-smush-strip_exif","0","no"),
("1639","wp-smush-resize","0","no"),
("1640","wp-smush-detection","0","no"),
("1641","wp-smush-original","0","no"),
("1642","wp-smush-backup","0","no"),
("1643","wp-smush-png_to_jpg","0","no"),
("1644","wp-smush-image_sizes","a:24:{i:0;s:9:\"thumbnail\";i:1;s:6:\"medium\";i:2;s:5:\"large\";i:3;s:9:\"list-item\";i:4;s:9:\"list-blog\";i:5;s:8:\"blok-one\";i:6;s:8:\"blok-tow\";i:7;s:8:\"top-post\";i:8;s:11:\"spical-post\";i:9;s:10:\"flexslider\";i:10;s:10:\"scroll-box\";i:11;s:12:\"single-thumb\";i:12;s:13:\"post_author_1\";i:13;s:13:\"post_author_2\";i:14;s:13:\"post_author_3\";i:15;s:13:\"post_author_4\";i:16;s:13:\"post_author_5\";i:17;s:14:\"post_newspaper\";i:18;s:13:\"videoItem-big\";i:19;s:9:\"videoItem\";i:20;s:9:\"mediaItem\";i:21;s:14:\"gallery-slider\";i:22;s:11:\"img-gallery\";i:23;s:12:\"medium_large\";}","no"),
("1653","autoptimize_version","2.3.0","yes"),
("1657","autoptimize_html","","yes"),
("1658","autoptimize_html_keepcomments","","yes"),
("1659","autoptimize_js","on","yes"),
("1660","autoptimize_js_exclude","seal.js, js/jquery/jquery.js","yes"),
("1661","autoptimize_js_trycatch","","yes"),
("1662","autoptimize_js_justhead","","yes"),
("1663","autoptimize_js_forcehead","","yes"),
("1664","autoptimize_js_include_inline","","yes"),
("1665","autoptimize_css","on","yes"),
("1666","autoptimize_css_exclude","wp-content/cache/, wp-content/uploads/, admin-bar.min.css, dashicons.min.css","yes"),
("1667","autoptimize_css_justhead","","yes"),
("1668","autoptimize_css_datauris","","yes"),
("1669","autoptimize_css_defer","","yes"),
("1670","autoptimize_css_defer_inline","","yes"),
("1671","autoptimize_css_inline","","yes"),
("1672","autoptimize_css_include_inline","on","yes"),
("1673","autoptimize_cdn_url","","yes"),
("1674","autoptimize_cache_clean","0","yes"),
("1675","autoptimize_cache_nogzip","on","yes"),
("1676","autoptimize_show_adv","0","yes"),
("1677","autoptimize_optimize_logged","on","yes"),
("1678","autoptimize_optimize_checkout","","yes"),
("849","theme_mods_Aftab-News","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:11:\"primary-nav\";i:11;s:9:\"top-nav-1\";i:44;s:9:\"top-nav-2\";i:49;s:10:\"footer-nav\";i:49;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1524822552;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:23:\"posts-listtime-widget-3\";i:1;s:20:\"posts-box-2-widget-5\";i:2;s:13:\"widget_azan-2\";i:3;s:13:\"widget_azan-3\";}s:5:\"middl\";a:10:{i:0;s:20:\"posts-box-1-widget-2\";i:1;s:20:\"posts_box_5-widget-2\";i:2;s:26:\"posts-main-number-widget-2\";i:3;s:20:\"posts-box-2-widget-2\";i:4;s:19:\"posts-main-widget-2\";i:5;s:6:\"text-4\";i:6;s:20:\"posts-box-4-widget-2\";i:7;s:21:\"posts_slider-widget-2\";i:8;s:6:\"text-3\";i:9;s:17:\"tabe-big-widget-2\";}s:4:\"left\";a:9:{i:0;s:19:\"tie-slider-widget-2\";i:1;s:18:\"last_post_author-2\";i:2;s:11:\"last_post-2\";i:3;s:15:\"banner_widget-3\";i:4;s:25:\"posts-box-author-widget-2\";i:5;s:23:\"posts-listtime-widget-2\";i:6;s:13:\"widget_tabs-2\";i:7;s:24:\"theme_wg_news_all_post-2\";i:8;s:20:\"posts-box-3-widget-2\";}s:9:\"left-page\";a:8:{i:0;s:15:\"banner_widget-4\";i:1;s:13:\"widget_azan-4\";i:2;s:11:\"last_post-3\";i:3;s:11:\"last_post-4\";i:4;s:11:\"last_post-5\";i:5;s:11:\"last_post-7\";i:6;s:11:\"last_post-6\";i:7;s:24:\"theme_wg_news_all_post-3\";}s:5:\"media\";a:1:{i:0;s:21:\"posts-box-13-widget-2\";}s:3:\"ads\";a:1:{i:0;s:15:\"banner_widget-2\";}s:8:\"footer-1\";a:1:{i:0;s:23:\"posts-listtime-widget-4\";}s:8:\"footer-2\";a:1:{i:0;s:18:\"last_post_author-3\";}s:8:\"footer-3\";a:2:{i:0;s:6:\"text-2\";i:1;s:11:\"tag_cloud-2\";}}}}","yes"),
("536","widget_widget_azan","a:5:{i:2;a:3:{s:6:\"offset\";s:1:\"0\";s:4:\"mode\";s:1:\"2\";s:4:\"city\";s:2:\"28\";}i:3;a:3:{s:6:\"offset\";s:1:\"0\";s:4:\"mode\";s:1:\"2\";s:4:\"city\";s:2:\"27\";}i:4;a:3:{s:6:\"offset\";s:1:\"0\";s:4:\"mode\";s:1:\"2\";s:4:\"city\";s:2:\"28\";}i:5;a:3:{s:6:\"offset\";s:1:\"0\";s:4:\"mode\";s:1:\"2\";s:4:\"city\";s:2:\"27\";}s:12:\"_multiwidget\";i:1;}","yes"),
("693","theme_mods_Aftab-News-3.1","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:11:\"primary-nav\";i:11;s:9:\"top-nav-1\";i:44;s:9:\"top-nav-2\";i:49;s:10:\"footer-nav\";i:49;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1524320054;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:23:\"posts-listtime-widget-3\";i:1;s:20:\"posts-box-2-widget-5\";i:2;s:13:\"widget_azan-2\";i:3;s:13:\"widget_azan-3\";}s:5:\"middl\";a:10:{i:0;s:20:\"posts-box-1-widget-2\";i:1;s:20:\"posts_box_5-widget-2\";i:2;s:26:\"posts-main-number-widget-2\";i:3;s:20:\"posts-box-2-widget-2\";i:4;s:19:\"posts-main-widget-2\";i:5;s:6:\"text-4\";i:6;s:20:\"posts-box-4-widget-2\";i:7;s:21:\"posts_slider-widget-2\";i:8;s:6:\"text-3\";i:9;s:17:\"tabe-big-widget-2\";}s:4:\"left\";a:8:{i:0;s:19:\"tie-slider-widget-2\";i:1;s:18:\"last_post_author-2\";i:2;s:11:\"last_post-2\";i:3;s:25:\"posts-box-author-widget-2\";i:4;s:23:\"posts-listtime-widget-2\";i:5;s:13:\"widget_tabs-2\";i:6;s:24:\"theme_wg_news_all_post-2\";i:7;s:20:\"posts-box-3-widget-2\";}s:9:\"left-page\";a:7:{i:0;s:13:\"widget_azan-4\";i:1;s:11:\"last_post-3\";i:2;s:11:\"last_post-4\";i:3;s:11:\"last_post-5\";i:4;s:11:\"last_post-7\";i:5;s:11:\"last_post-6\";i:6;s:24:\"theme_wg_news_all_post-3\";}s:5:\"media\";a:1:{i:0;s:21:\"posts-box-13-widget-2\";}s:3:\"ads\";a:1:{i:0;s:15:\"banner_widget-2\";}s:8:\"footer-1\";a:1:{i:0;s:23:\"posts-listtime-widget-4\";}s:8:\"footer-2\";a:1:{i:0;s:18:\"last_post_author-3\";}s:8:\"footer-3\";a:2:{i:0;s:6:\"text-2\";i:1;s:11:\"tag_cloud-2\";}}}}","yes"),
("188","recently_activated","a:1:{s:35:\"redux-framework/redux-framework.php\";i:1628586208;}","yes"),
("189","redux_version_upgraded_from","3.6.11","yes"),
("191","qaleb","a:148:{s:8:\"last_tab\";s:1:\"1\";s:13:\"logo-or-title\";s:1:\"1\";s:17:\"siteicon_uploader\";a:9:{s:3:\"url\";s:64:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/logo.png\";s:2:\"id\";s:3:\"257\";s:6:\"height\";s:3:\"177\";s:5:\"width\";s:3:\"567\";s:9:\"thumbnail\";s:71:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/logo-100x31.png\";s:5:\"title\";s:4:\"logo\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:16:\"favicon_uploader\";a:9:{s:3:\"url\";s:64:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/icon.png\";s:2:\"id\";s:2:\"26\";s:6:\"height\";s:2:\"50\";s:5:\"width\";s:2:\"50\";s:9:\"thumbnail\";s:64:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/icon.png\";s:5:\"title\";s:4:\"icon\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:11:\"post-or-ads\";s:1:\"1\";s:11:\"top-post-ac\";s:1:\"1\";s:16:\"top-post-content\";s:1:\"3\";s:20:\"top-post-type-select\";s:1:\"7\";s:14:\"top-post-count\";s:1:\"2\";s:7:\"top-ads\";s:1:\"2\";s:12:\"top-ads-html\";s:134:\"<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/themes/news-islamic/img/ads.png\" width=\"100%\" height=\"90\" alt=\"\"/> </a>\";s:8:\"hadis-ac\";s:1:\"1\";s:11:\"hadis-title\";s:38:\"امام علی (ع) می فرماید\";s:10:\"hadis-html\";s:202:\"۞ هر کس از خود بدگویی و انتقاد کند٬خود را اصلاح کرده و هر کس خودستایی نماید٬ پس به تحقیق خویش را تباه نموده است. ۞\";s:7:\"news-ac\";s:1:\"1\";s:10:\"news-title\";s:19:\"اخبار ویژه\";s:12:\"news-content\";s:1:\"2\";s:16:\"news-type-select\";s:0:\"\";s:10:\"news-count\";s:1:\"3\";s:13:\"searchform-ac\";s:1:\"1\";s:11:\"search-text\";s:19:\"جستجو کن ...\";s:6:\"jalali\";s:1:\"1\";s:5:\"milad\";s:1:\"1\";s:5:\"blank\";s:1:\"2\";s:13:\"sidbar-sticky\";s:1:\"1\";s:15:\"last-or-archive\";s:1:\"1\";s:21:\"last-or-archive-title\";s:21:\"آخرین اخبار\";s:12:\"blog-content\";s:1:\"1\";s:16:\"blog-type-select\";s:0:\"\";s:10:\"blog-count\";s:1:\"6\";s:12:\"more-blog-ac\";s:1:\"2\";s:15:\"more-blog-title\";s:17:\"لیست کامل\";s:9:\"more-blog\";s:0:\"\";s:14:\"blok-or-normal\";s:1:\"2\";s:13:\"flexslider-ac\";s:1:\"1\";s:12:\"small-or-big\";s:1:\"2\";s:10:\"color-flex\";s:7:\"#ffffff\";s:18:\"flexslider-content\";s:1:\"3\";s:22:\"flexslider-type-select\";s:2:\"59\";s:16:\"flexslider-count\";s:1:\"3\";s:15:\"scrollslider-ac\";s:1:\"1\";s:18:\"scrollslider-title\";s:19:\"اخبار ویژه\";s:20:\"scrollslider-content\";s:1:\"3\";s:24:\"scrollslider-type-select\";s:1:\"2\";s:18:\"scrollslider-count\";s:2:\"10\";s:9:\"spical-ac\";s:1:\"1\";s:12:\"spical-title\";s:19:\"گزارش خبری\";s:19:\"spical-post-content\";s:1:\"1\";s:23:\"spical-post-type-select\";s:0:\"\";s:17:\"spical-post-count\";s:1:\"4\";s:9:\"galery-ac\";s:1:\"1\";s:10:\"breadcrumb\";s:1:\"1\";s:10:\"navigation\";s:1:\"1\";s:4:\"send\";s:1:\"1\";s:5:\"print\";s:1:\"1\";s:13:\"singl-date-ac\";s:1:\"1\";s:13:\"singl-view-ac\";s:1:\"1\";s:17:\"singl-comments-ac\";s:1:\"1\";s:13:\"singl-user-ac\";s:1:\"1\";s:17:\"singl-category-ac\";s:1:\"1\";s:6:\"rotitr\";s:1:\"1\";s:4:\"lide\";s:1:\"1\";s:4:\"imag\";s:1:\"1\";s:15:\"singl-social-ac\";s:1:\"1\";s:13:\"singl-link-ac\";s:1:\"1\";s:13:\"singl-tags-ac\";s:1:\"1\";s:14:\"relate-default\";s:1:\"1\";s:12:\"norm-or-tage\";s:1:\"1\";s:20:\"relate-default-count\";s:1:\"5\";s:13:\"media-date-ac\";s:1:\"1\";s:13:\"media-view-ac\";s:1:\"1\";s:17:\"media-comments-ac\";s:1:\"1\";s:13:\"media-user-ac\";s:1:\"1\";s:15:\"media-social-ac\";s:1:\"1\";s:13:\"media-link-ac\";s:1:\"1\";s:8:\"media-ac\";s:1:\"1\";s:18:\"relate-media-title\";s:21:\"گالری ویدئو\";s:19:\"media-related-count\";s:1:\"2\";s:12:\"media-slider\";s:1:\"1\";s:13:\"media-content\";s:1:\"2\";s:17:\"media-type-select\";s:0:\"\";s:11:\"media-count\";s:1:\"1\";s:15:\"gallery-date-ac\";s:1:\"1\";s:15:\"gallery-view-ac\";s:1:\"1\";s:19:\"gallery-comments-ac\";s:1:\"1\";s:15:\"gallery-user-ac\";s:1:\"1\";s:17:\"gallery-social-ac\";s:1:\"1\";s:15:\"gallery-link-ac\";s:1:\"1\";s:15:\"gallery-tags-ac\";s:1:\"1\";s:10:\"gallery-ac\";s:1:\"1\";s:20:\"relate-gallery-title\";s:23:\"گالری تصاویر\";s:21:\"gallery-related-count\";s:1:\"4\";s:14:\"gallery-slider\";s:1:\"1\";s:15:\"gallery-content\";s:1:\"2\";s:19:\"gallery-type-select\";s:0:\"\";s:13:\"gallery-count\";s:1:\"3\";s:17:\"newspaper-date-ac\";s:1:\"1\";s:17:\"newspaper-view-ac\";s:1:\"1\";s:21:\"newspaper-comments-ac\";s:1:\"1\";s:17:\"newspaper-user-ac\";s:1:\"1\";s:19:\"newspaper-social-ac\";s:1:\"1\";s:17:\"newspaper-link-ac\";s:1:\"1\";s:12:\"newspaper-ac\";s:1:\"1\";s:22:\"relate-newspaper-title\";s:23:\"گیشه روزنامه\";s:23:\"newspaper-related-count\";s:1:\"4\";s:20:\"single-comment-title\";s:19:\"ثبت دیدگاه\";s:19:\"single-comment-text\";s:409:\"<ul>\r\n 	<li>دیدگاه های ارسال شده توسط شما، پس از تایید توسط تیم مدیریت در وب منتشر خواهد شد.</li>\r\n 	<li>پیام هایی که حاوی تهمت یا افترا باشد منتشر نخواهد شد.</li>\r\n 	<li>پیام هایی که به غیر از زبان فارسی یا غیر مرتبط باشد منتشر نخواهد شد.</li>\r\n</ul>\";s:14:\"footer-socials\";s:1:\"1\";s:12:\"social-fb-ac\";s:1:\"1\";s:9:\"social-fb\";s:24:\"آدرس لینک شما\";s:12:\"social-in-ac\";s:1:\"1\";s:9:\"social-in\";s:24:\"آدرس لینک شما\";s:12:\"social-tg-ac\";s:1:\"1\";s:9:\"social-tg\";s:24:\"آدرس لینک شما\";s:12:\"social-gp-ac\";s:1:\"2\";s:9:\"social-gp\";s:24:\"آدرس لینک شما\";s:12:\"social-tw-ac\";s:1:\"2\";s:9:\"social-tw\";s:24:\"آدرس لینک شما\";s:13:\"social-rss-ac\";s:1:\"1\";s:15:\"ads-default-top\";s:1:\"2\";s:20:\"ads-default-top-html\";s:134:\"<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/themes/Aftab-News-2/img/ads.png\" width=\"100%\" height=\"90\" alt=\"\"/> </a>\";s:18:\"ads-default-bottom\";s:1:\"2\";s:23:\"ads-default-bottom-html\";s:126:\"<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/04/ads.png\" width=\"100%\" height=\"90\" alt=\"\"/> </a>\";s:8:\"ads-left\";s:1:\"1\";s:13:\"ads-left-html\";s:1154:\"<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh/img/ads-left.png\" width=\"100%\" height=\"90\" alt=\"\"/> </a>\r\n\r\n<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh/img/ads-left.png\" width=\"100%\" height=\"90\" alt=\"\"/> </a>\r\n\r\n<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh/img/ads-left.png\" width=\"100%\" height=\"90\" alt=\"\"/> </a>\r\n\r\n\r\n<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh/img/ads-left.png\" width=\"100%\" height=\"90\" alt=\"\"/> </a>\r\n\r\n\r\n<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh/img/ads-left.png\" width=\"100%\" height=\"90\" alt=\"\"/> </a>\r\n\r\n<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh/img/ads-left.png\" width=\"100%\" height=\"90\" alt=\"\"/> </a>\r\n\r\n<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh/img/ads-left.png\" width=\"100%\" height=\"90\" alt=\"\"/> </a>\r\n\r\n\r\n<a href=\"#\"> <img src=\"http://islamic.demo-qaleb.ir/wp-content/themes/News-Nashrieh/img/ads-left.png\" width=\"100%\" height=\"90\" alt=\"\"/> </a>\";s:9:\"not-title\";s:3:\"404\";s:8:\"not-desc\";s:49:\"صفحه مورد نظر شما یافت نشد !\";s:11:\"not-problem\";s:301:\"<ul>\r\n 	<li>صفحه ای که به دنبال آن هستید ممکن است حذف یا منتقل شده است .</li>\r\n 	<li>آدرس وارد شده اشتباه باشد .</li>\r\n 	<li>در غیر این صورت از طریق فرم تماس باما به ما اطلاع دهید .</li>\r\n</ul>\";s:10:\"footer-nav\";s:1:\"1\";s:10:\"footer-top\";s:1:\"1\";s:10:\"topcontrol\";s:1:\"1\";s:12:\"footer-cp-ac\";s:1:\"1\";s:14:\"footer-cp-logo\";a:9:{s:3:\"url\";s:71:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/footer-logo.png\";s:2:\"id\";s:3:\"258\";s:6:\"height\";s:2:\"72\";s:5:\"width\";s:2:\"70\";s:9:\"thumbnail\";s:77:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/footer-logo-68x70.png\";s:5:\"title\";s:11:\"footer-logo\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:14:\"footer-cp-text\";s:169:\"                                     تمام حقوق این وب سایت برای مجله خبری نشریه محفوظ است.                                     \";s:14:\"footer-cb-text\";s:162:\"                                     نشر مطالب با ذکر نام مجله خبری نشریه بلامانع است.                                     \";s:7:\"color-1\";s:7:\"#ff0000\";s:7:\"color-2\";s:7:\"#ff0000\";s:7:\"color-4\";s:7:\"#ffffff\";s:11:\"color-or-bg\";s:1:\"1\";s:7:\"color-3\";s:7:\"#ffffff\";s:8:\"body-img\";a:9:{s:3:\"url\";s:61:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2019/08/1.png\";s:2:\"id\";s:3:\"356\";s:6:\"height\";s:3:\"102\";s:5:\"width\";s:3:\"102\";s:9:\"thumbnail\";s:68:\"http://islamic.demo-qaleb.ir/wp-content/uploads/2019/08/1-100x70.png\";s:5:\"title\";s:1:\"1\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:5:\"img-f\";s:1:\"1\";s:10:\"box-shadow\";s:1:\"2\";s:6:\"n-site\";s:25:\"کلکسیون طراحی\";s:6:\"l-site\";s:19:\"https://wp-qaleb.ir\";s:18:\"opt-ace-editor-css\";s:29:\"#header{\n   margin: 0 auto;\n}\";s:17:\"opt-ace-editor-js\";s:39:\"jQuery(document).ready(function(){\n\n});\";s:18:\"opt-ace-editor-php\";s:0:\"\";}","yes"),
("192","qaleb-transients","a:2:{s:14:\"changed_values\";a:2:{s:11:\"color-or-bg\";s:1:\"2\";s:5:\"img-f\";s:1:\"2\";}s:9:\"last_save\";i:1628586924;}","yes"),
("199","ztjalali_options","{\"force_timezone\":false,\"change_date_to_jalali\":true,\"change_jdate_number_to_persian\":true,\"change_url_date_to_jalali\":false,\"afghan_month_name\":false,\"disallow_month_short_name\":true,\"change_title_number_to_persian\":true,\"change_content_number_to_persian\":true,\"change_excerpt_number_to_persian\":true,\"change_comment_number_to_persian\":true,\"change_commentcount_number_to_persian\":false,\"change_category_number_to_persian\":false,\"change_point_to_persian\":true,\"change_arabic_to_persian\":false,\"change_archive_title\":true,\"save_changes_in_db\":false,\"ztjalali_admin_style\":false,\"persian_planet\":true}","yes"),
("200","ztjalali_version","5.0.1","yes"),
("202","widget_ztjalali_archive","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("203","widget_ztjalali_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("250","media_category_children","a:1:{i:48;a:2:{i:0;i:36;i:1;i:39;}}","yes"),
("247","gallery_category_children","a:1:{i:45;a:3:{i:0;i:33;i:1;i:46;i:2;i:47;}}","yes"),
("283","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1534","new_admin_email","maerefat.67@gmail.com","yes"),
("1538","theme_mods_news-islamic","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:10:\"footer-nav\";i:49;s:9:\"main-menu\";i:11;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1545486639;s:4:\"data\";a:10:{s:19:\"wp_inactive_widgets\";a:13:{i:0;s:18:\"last_post_author-2\";i:1;s:18:\"last_post_author-3\";i:2;s:13:\"widget_tabs-2\";i:3;s:19:\"tie-slider-widget-2\";i:4;s:24:\"theme_wg_news_all_post-2\";i:5;s:24:\"theme_wg_news_all_post-3\";i:6;s:13:\"widget_azan-2\";i:7;s:13:\"widget_azan-3\";i:8;s:6:\"text-4\";i:9;s:6:\"text-3\";i:10;s:13:\"widget_azan-4\";i:11;s:6:\"text-2\";i:12;s:11:\"tag_cloud-2\";}s:4:\"logo\";a:1:{i:0;s:13:\"widget_azan-5\";}s:5:\"right\";a:8:{i:0;s:20:\"last_post_author_3-2\";i:1;s:20:\"last_post_author_5-2\";i:2;s:20:\"last_post_author_2-2\";i:3;s:18:\"last_post_author-4\";i:4;s:24:\"theme_wg_news_all_post-4\";i:5;s:16:\"last_post_time-2\";i:6;s:21:\"last_post_newspaper-2\";i:7;s:19:\"ztjalali_calendar-2\";}s:5:\"middl\";a:5:{i:0;s:16:\"last_post_titr-2\";i:1;s:16:\"last_post_list-2\";i:2;s:16:\"last_post_list-3\";i:3;s:16:\"last_post_titr-3\";i:4;s:20:\"last_post_author_4-2\";}s:4:\"left\";a:1:{i:0;s:12:\"categories-2\";}s:10:\"page-right\";a:2:{i:0;s:19:\"tie-slider-widget-3\";i:1;s:20:\"last_post_author_3-3\";}s:9:\"page-left\";a:3:{i:0;s:16:\"last_post_titr-4\";i:1;s:13:\"widget_tabs-3\";i:2;s:24:\"theme_wg_news_all_post-5\";}s:12:\"footer-right\";a:1:{i:0;s:16:\"last_post_list-6\";}s:12:\"footer-middl\";a:1:{i:0;s:16:\"last_post_list-5\";}s:11:\"footer-left\";a:1:{i:0;s:16:\"last_post_list-4\";}}}}","yes"),
("1539","widget_last_post_author_2","a:5:{i:2;a:4:{s:12:\"widget_title\";s:19:\"ویژه امروز\";s:8:\"post_num\";s:1:\"3\";s:8:\"post_cat\";s:1:\"5\";s:11:\"limit_title\";s:0:\"\";}i:3;a:4:{s:12:\"widget_title\";s:18:\"نویسندگان\";s:8:\"post_num\";s:1:\"3\";s:8:\"post_cat\";s:1:\"9\";s:11:\"limit_title\";s:0:\"\";}i:6;a:4:{s:12:\"widget_title\";s:29:\"گفتگو با آشنا ....\";s:8:\"post_num\";s:1:\"1\";s:8:\"post_cat\";s:1:\"6\";s:11:\"limit_title\";s:0:\"\";}i:7;a:4:{s:12:\"widget_title\";s:39:\"بـرداشـت اجـتـمـاعـی\";s:8:\"post_num\";s:1:\"3\";s:8:\"post_cat\";s:1:\"6\";s:11:\"limit_title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("21843","_site_transient_timeout_community-events-93add0a73d6b6904b31ec16518cc33a6","1628629454","no"),
("21844","_site_transient_community-events-93add0a73d6b6904b31ec16518cc33a6","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:10:\"86.57.95.0\";}s:6:\"events\";a:2:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:66:\"Watch Party + Discussion group: Content Creation with Block Editor\";s:3:\"url\";s:68:\"https://www.meetup.com/learn-wordpress-discussions/events/279774777/\";s:6:\"meetup\";s:27:\"Learn WordPress Discussions\";s:10:\"meetup_url\";s:51:\"https://www.meetup.com/learn-wordpress-discussions/\";s:4:\"date\";s:19:\"2021-08-11 19:00:00\";s:8:\"end_date\";s:19:\"2021-08-11 20:00:00\";s:20:\"start_unix_timestamp\";i:1628733600;s:18:\"end_unix_timestamp\";i:1628737200;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:37.779998779297003;s:9:\"longitude\";d:-122.41999816895;}}i:1;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:54:\"WordCamp Florianópolis, Santa Catarina &#8211; Brazil\";s:3:\"url\";s:34:\"https://floripa.wordcamp.org/2021/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2021-08-11 19:00:00\";s:8:\"end_date\";s:19:\"2021-08-12 00:00:00\";s:20:\"start_unix_timestamp\";i:1628719200;s:18:\"end_unix_timestamp\";i:1628737200;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"BR\";s:8:\"latitude\";d:-27.595319799999999;s:9:\"longitude\";d:-48.554292699999998;}}}}","no"),
("21839","_site_transient_timeout_theme_roots","1628588586","no"),
("21840","_site_transient_theme_roots","a:2:{s:15:\"News-Nashrieh-o\";s:7:\"/themes\";s:13:\"News-Nashrieh\";s:7:\"/themes\";}","no"),
("21841","_transient_timeout_plugin_slugs","1628672915","no"),
("21842","_transient_plugin_slugs","a:5:{i:0;s:14:\"azan/index.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:35:\"classic-widgets/classic-widgets.php\";i:3;s:29:\"duplicator/duplicator-pro.php\";i:4;s:23:\"wp-jalali/wp-jalali.php\";}","no"),
("21845","_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a","1628597077","no"),
("21846","_site_transient_poptags_40cd750bba9870f18aada2478b24840a","O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:5062;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4759;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2724;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2595;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2007;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1863;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1845;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1525;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1512;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1507;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1500;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1496;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1474;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1311;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1276;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1269;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1236;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1160;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1129;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1059;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:966;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:938;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:914;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:890;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:887;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:835;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:819;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:813;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:813;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:791;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:762;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:751;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:732;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:729;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:728;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:715;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:701;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:684;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:667;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:666;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:665;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:662;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:661;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:658;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:652;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:626;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:602;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:599;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:592;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:592;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:577;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:574;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:567;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:565;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:563;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:557;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:550;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:548;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:548;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:539;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:537;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:531;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:530;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:523;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:513;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:508;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:499;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:497;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:497;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:488;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:482;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:471;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:463;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:463;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:459;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:456;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:453;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:448;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:446;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:444;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:434;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:427;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:423;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:417;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:411;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:409;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:406;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:401;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:398;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:391;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:389;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:384;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:383;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:380;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:376;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:371;}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";i:368;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:367;}s:16:\"google-analytics\";a:3:{s:4:\"name\";s:16:\"google analytics\";s:4:\"slug\";s:16:\"google-analytics\";s:5:\"count\";i:359;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:357;}}","no"),
("5357","theme_mods_News-Nashrieh.2.5","a:3:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";i:11;s:10:\"footer-nav\";i:49;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1564821180;s:4:\"data\";a:10:{s:19:\"wp_inactive_widgets\";a:20:{i:0;s:18:\"last_post_author-2\";i:1;s:18:\"last_post_author-3\";i:2;s:18:\"last_post_author-4\";i:3;s:20:\"last_post_author_2-2\";i:4;s:20:\"last_post_author_3-2\";i:5;s:20:\"last_post_author_5-2\";i:6;s:13:\"widget_tabs-2\";i:7;s:16:\"last_post_time-2\";i:8;s:19:\"tie-slider-widget-2\";i:9;s:24:\"theme_wg_news_all_post-2\";i:10;s:24:\"theme_wg_news_all_post-3\";i:11;s:24:\"theme_wg_news_all_post-4\";i:12;s:21:\"last_post_newspaper-2\";i:13;s:13:\"widget_azan-2\";i:14;s:13:\"widget_azan-3\";i:15;s:6:\"text-4\";i:16;s:6:\"text-3\";i:17;s:13:\"widget_azan-4\";i:18;s:6:\"text-2\";i:19;s:11:\"tag_cloud-2\";}s:4:\"logo\";a:1:{i:0;s:13:\"widget_azan-5\";}s:5:\"right\";a:6:{i:0;s:20:\"last_post_author_5-3\";i:1;s:20:\"last_post_author_3-4\";i:2;s:20:\"last_post_author_2-3\";i:3;s:18:\"last_post_author-5\";i:4;s:16:\"last_post_time-3\";i:5;s:19:\"ztjalali_calendar-2\";}s:5:\"middl\";a:5:{i:0;s:16:\"last_post_titr-2\";i:1;s:16:\"last_post_list-2\";i:2;s:16:\"last_post_list-3\";i:3;s:16:\"last_post_titr-3\";i:4;s:20:\"last_post_author_4-2\";}s:4:\"left\";a:1:{i:0;s:12:\"categories-2\";}s:10:\"page-right\";a:2:{i:0;s:19:\"tie-slider-widget-3\";i:1;s:20:\"last_post_author_3-3\";}s:9:\"page-left\";a:3:{i:0;s:16:\"last_post_titr-4\";i:1;s:13:\"widget_tabs-3\";i:2;s:24:\"theme_wg_news_all_post-5\";}s:12:\"footer-right\";a:1:{i:0;s:16:\"last_post_list-6\";}s:12:\"footer-middl\";a:1:{i:0;s:16:\"last_post_list-5\";}s:11:\"footer-left\";a:1:{i:0;s:16:\"last_post_list-4\";}}}}","yes"),
("5910","_transient_twentyfifteen_categories","2","yes"),
("5908","theme_mods_twentyfifteen","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:11;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1547299041;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:9:{i:0;s:13:\"widget_azan-2\";i:1;s:13:\"widget_azan-3\";i:2;s:6:\"text-4\";i:3;s:6:\"text-3\";i:4;s:13:\"widget_azan-4\";i:5;s:6:\"text-2\";i:6;s:11:\"tag_cloud-2\";i:7;s:13:\"widget_azan-5\";i:8;s:12:\"categories-2\";}s:9:\"sidebar-1\";a:1:{i:0;s:19:\"ztjalali_calendar-2\";}}}}","yes"),
("10135","theme_mods_News-Nashrieh","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";i:11;s:10:\"footer-nav\";i:49;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1569672384;s:4:\"data\";a:10:{s:19:\"wp_inactive_widgets\";a:20:{i:0;s:18:\"last_post_author-2\";i:1;s:18:\"last_post_author-3\";i:2;s:18:\"last_post_author-4\";i:3;s:20:\"last_post_author_2-2\";i:4;s:20:\"last_post_author_3-2\";i:5;s:20:\"last_post_author_5-2\";i:6;s:13:\"widget_tabs-2\";i:7;s:16:\"last_post_time-2\";i:8;s:19:\"tie-slider-widget-2\";i:9;s:24:\"theme_wg_news_all_post-2\";i:10;s:24:\"theme_wg_news_all_post-3\";i:11;s:24:\"theme_wg_news_all_post-4\";i:12;s:21:\"last_post_newspaper-2\";i:13;s:13:\"widget_azan-2\";i:14;s:13:\"widget_azan-3\";i:15;s:6:\"text-4\";i:16;s:6:\"text-3\";i:17;s:13:\"widget_azan-4\";i:18;s:6:\"text-2\";i:19;s:11:\"tag_cloud-2\";}s:4:\"logo\";a:2:{i:0;s:20:\"last_post_author_5-5\";i:1;s:20:\"last_post_author_2-6\";}s:5:\"right\";a:7:{i:0;s:20:\"last_post_author_5-3\";i:1;s:20:\"last_post_author_3-4\";i:2;s:20:\"last_post_author_2-3\";i:3;s:18:\"last_post_author-5\";i:4;s:16:\"last_post_time-3\";i:5;s:13:\"widget_azan-5\";i:6;s:19:\"ztjalali_calendar-2\";}s:5:\"middl\";a:5:{i:0;s:16:\"last_post_titr-2\";i:1;s:16:\"last_post_list-2\";i:2;s:16:\"last_post_list-3\";i:3;s:16:\"last_post_titr-3\";i:4;s:20:\"last_post_author_4-2\";}s:4:\"left\";a:2:{i:0;s:6:\"text-5\";i:1;s:12:\"categories-2\";}s:10:\"page-right\";a:2:{i:0;s:19:\"tie-slider-widget-3\";i:1;s:20:\"last_post_author_3-3\";}s:9:\"page-left\";a:3:{i:0;s:16:\"last_post_titr-4\";i:1;s:13:\"widget_tabs-3\";i:2;s:24:\"theme_wg_news_all_post-5\";}s:12:\"footer-right\";a:1:{i:0;s:16:\"last_post_list-6\";}s:12:\"footer-middl\";a:1:{i:0;s:16:\"last_post_list-5\";}s:11:\"footer-left\";a:1:{i:0;s:16:\"last_post_list-4\";}}}}","yes"),
("11221","su_presets_tabs","a:1:{s:9:\"last_used\";a:3:{s:2:\"id\";s:9:\"last_used\";s:4:\"name\";s:18:\"Last used settings\";s:8:\"settings\";a:6:{s:5:\"style\";s:7:\"default\";s:6:\"active\";s:1:\"2\";s:8:\"vertical\";s:3:\"yes\";s:6:\"mobile\";s:5:\"stack\";s:5:\"class\";s:0:\"\";s:7:\"content\";s:302:\"[su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab]\n[su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab]\n[su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab]\";}}}","yes"),
("11239","theme_mods_twentyten","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:11;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1569672399;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:7:{i:0;s:13:\"widget_azan-2\";i:1;s:13:\"widget_azan-3\";i:2;s:6:\"text-4\";i:3;s:6:\"text-3\";i:4;s:13:\"widget_azan-4\";i:5;s:6:\"text-2\";i:6;s:11:\"tag_cloud-2\";}s:19:\"primary-widget-area\";a:2:{i:0;s:13:\"widget_azan-5\";i:1;s:19:\"ztjalali_calendar-2\";}s:21:\"secondary-widget-area\";a:2:{i:0;s:6:\"text-5\";i:1;s:12:\"categories-2\";}s:24:\"first-footer-widget-area\";a:0:{}s:25:\"second-footer-widget-area\";a:0:{}s:24:\"third-footer-widget-area\";a:0:{}s:25:\"fourth-footer-widget-area\";a:0:{}}}}","yes"),
("11206","su_option_custom-formatting","on","no"),
("11207","su_option_skip","on","no"),
("11208","su_option_prefix","su_","no"),
("11209","su_option_custom-css","","no"),
("21861","wp_page_for_privacy_policy","0","yes"),
("21862","show_comments_cookies_opt_in","1","yes"),
("21863","admin_email_lifespan","0","yes"),
("21864","disallowed_keys","","no"),
("21865","comment_previously_approved","1","yes"),
("21866","auto_plugin_theme_update_emails","a:0:{}","no"),
("21867","auto_update_core_dev","enabled","yes"),
("21868","auto_update_core_minor","enabled","yes"),
("21869","auto_update_core_major","unset","yes"),
("21870","wp_force_deactivated_plugins","a:0:{}","yes"),
("21872","db_upgraded","","yes"),
("21886","_transient_timeout_News-Nashrieh_license_messagech","1628673194","no"),
("21887","_transient_News-Nashrieh_license_messagech","مشکلی در لایسنس بوجود آمده است. از طریق دکمه ( فعال سازی لایسنس ) اقدام به فعال سازی مجدد آن نمائید.","no"),
("21876","recovery_keys","a:0:{}","yes"),
("21877","https_detection_errors","a:0:{}","yes"),
("21878","can_compress_scripts","0","no"),
("21884","_transient_timeout_News-Nashriehminutes","1628673190","no"),
("21885","_transient_News-Nashriehminutes","1","no"),
("21901","News-Nashrieh_license_key","","yes"),
("21912","_transient_timeout_News-Nashrieh_license_message","1628673963","no"),
("21913","_transient_News-Nashrieh_license_message","ثبت کد لایسنس الزامی می باشد.","no"),
("21914","duplicator_pro_package_active","{\n    \"Created\": \"2021-08-10 09:26:18\",\n    \"Version\": \"3.8.8.1\",\n    \"VersionWP\": \"5.8\",\n    \"VersionDB\": \"5.7.32\",\n    \"VersionPHP\": \"7.4.11\",\n    \"VersionOS\": \"Linux\",\n    \"ID\": null,\n    \"Name\": \"20210810_d8acd985d987d988d8b1db8cd8a7d8\",\n    \"Hash\": \"538e5b723e2ac0f51400_20210810092618\",\n    \"NameHash\": \"20210810_d8acd985d987d988d8b1db8cd8a7d8_538e5b723e2ac0f51400_20210810092618\",\n    \"Type\": 0,\n    \"Notes\": \"\",\n    \"StorePath\": \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"http:\\/\\/islamic.demo-qaleb.ir\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20210810_d8acd985d987d988d8b1db8cd8a7d8_538e5b723e2ac0f51400_20210810092618_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"\\u067e\\u06cc\\u0634 \\u0641\\u0631\\u0636\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": null,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/.opcache\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/.tmb\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/cache\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/old-cache\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/updraft\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/wfcache\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/.htaccess\",\n            \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"File\": null,\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/demoqale\\/islamic.demo-qaleb.ir\",\n        \"Size\": 110643469,\n        \"Dirs\": null,\n        \"DirCount\": 588,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 5491,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"Unreadable\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Unreadable\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": null,\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\",\n                \"latin1_swedish_ci\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"demoqale_islam\",\n            \"tablesBaseCount\": 17,\n            \"tablesFinalCount\": 17,\n            \"tablesRowCount\": 1942,\n            \"tablesSizeOnDisk\": 1263578,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"rows\": \"2\",\n                    \"size\": 11696\n                },\n                \"wp_comments\": {\n                    \"rows\": \"4\",\n                    \"size\": 12516\n                },\n                \"wp_duplicator_packages\": {\n                    \"rows\": \"1\",\n                    \"size\": 10888\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"rows\": \"5\",\n                    \"size\": 9784\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"rows\": \"0\",\n                    \"size\": 1024\n                },\n                \"wp_ewwwio_images\": {\n                    \"rows\": \"0\",\n                    \"size\": 4096\n                },\n                \"wp_links\": {\n                    \"rows\": \"0\",\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"rows\": \"311\",\n                    \"size\": 165244\n                },\n                \"wp_postmeta\": {\n                    \"rows\": \"899\",\n                    \"size\": 352820\n                },\n                \"wp_posts\": {\n                    \"rows\": \"254\",\n                    \"size\": 617416\n                },\n                \"wp_smush_dir_images\": {\n                    \"rows\": \"0\",\n                    \"size\": 1024\n                },\n                \"wp_term_relationships\": {\n                    \"rows\": \"290\",\n                    \"size\": 22642\n                },\n                \"wp_term_taxonomy\": {\n                    \"rows\": \"59\",\n                    \"size\": 8740\n                },\n                \"wp_termmeta\": {\n                    \"rows\": \"0\",\n                    \"size\": 4096\n                },\n                \"wp_terms\": {\n                    \"rows\": \"59\",\n                    \"size\": 16992\n                },\n                \"wp_usermeta\": {\n                    \"rows\": \"57\",\n                    \"size\": 15132\n                },\n                \"wp_users\": {\n                    \"rows\": \"1\",\n                    \"size\": 8444\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"version\": \"5.7.32\",\n            \"versionComment\": \"MySQL Community Server - (GPL)\",\n            \"tableWiseRowCounts\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": null,\n        \"File\": null,\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"DBMode\": null,\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - (GPL)\",\n        \"dbStorePathPublic\": null\n    },\n    \"Status\": 5,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": null,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": -1,\n        \"current_build_compression\": true,\n        \"custom_data\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tableIndex\": 0,\n        \"tableOffset\": 0,\n        \"totalRowOffset\": 0,\n        \"chunkIndex\": null,\n        \"validationStage1\": false,\n        \"bulkOffset\": 0,\n        \"bulkSizeOffset\": 0,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"tablesToProcess\": [],\n        \"startTime\": 0,\n        \"fileOffset\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"totalSchemaSize\": 0,\n        \"tablesSchemaSizes\": []\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5\n}","yes"),
("21891","News-Nashrieh_license_key_statuss","109","yes"),
("21899","_transient_timeout_News-Nashrieh_license_key_statuss","1628673194","no"),
("21900","_transient_News-Nashrieh_license_key_statuss","301","no"),
("21908","_site_transient_update_plugins","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1628587502;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:6:{s:14:\"azan/index.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:18:\"w.org/plugins/azan\";s:4:\"slug\";s:4:\"azan\";s:6:\"plugin\";s:14:\"azan/index.php\";s:11:\"new_version\";s:3:\"0.6\";s:3:\"url\";s:35:\"https://wordpress.org/plugins/azan/\";s:7:\"package\";s:47:\"https://downloads.wordpress.org/plugin/azan.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:55:\"https://s.w.org/plugins/geopattern-icon/azan_388ff3.svg\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:59:\"https://ps.w.org/azan/assets/banner-772x250.png?rev=1010311\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.0\";}s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:35:\"classic-widgets/classic-widgets.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/classic-widgets\";s:4:\"slug\";s:15:\"classic-widgets\";s:6:\"plugin\";s:35:\"classic-widgets/classic-widgets.php\";s:11:\"new_version\";s:3:\"0.2\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/classic-widgets/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/classic-widgets.0.2.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:59:\"https://s.w.org/plugins/geopattern-icon/classic-widgets.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.4.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.4.2.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:67:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=2279696\";s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.5\";}s:29:\"duplicator/duplicator-pro.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:29:\"duplicator/duplicator-pro.php\";s:11:\"new_version\";s:5:\"1.4.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/duplicator.1.4.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2083921\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2083921\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2085472\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:23:\"wp-jalali/wp-jalali.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/wp-jalali\";s:4:\"slug\";s:9:\"wp-jalali\";s:6:\"plugin\";s:23:\"wp-jalali/wp-jalali.php\";s:11:\"new_version\";s:5:\"5.0.1\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wp-jalali/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wp-jalali.5.0.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:61:\"https://ps.w.org/wp-jalali/assets/icon-256x256.png?rev=983015\";s:2:\"1x\";s:61:\"https://ps.w.org/wp-jalali/assets/icon-128x128.png?rev=983015\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:63:\"https://ps.w.org/wp-jalali/assets/banner-772x250.png?rev=982617\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.9\";}}s:7:\"checked\";a:6:{s:14:\"azan/index.php\";s:3:\"0.6\";s:33:\"classic-editor/classic-editor.php\";s:5:\"1.6.2\";s:35:\"classic-widgets/classic-widgets.php\";s:3:\"0.2\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"5.4.2\";s:29:\"duplicator/duplicator-pro.php\";s:3:\"7.1\";s:23:\"wp-jalali/wp-jalali.php\";s:5:\"5.0.1\";}}","no"),
("21911","News-Nashrieh_license_key_status","109","yes"),
("21902","_transient_timeout_settings_errors","1628587593","no"),
("21903","_transient_settings_errors","a:1:{i:0;a:4:{s:7:\"setting\";s:7:\"general\";s:4:\"code\";s:16:\"settings_updated\";s:7:\"message\";s:31:\"تنظیمات ذخیره شد.\";s:4:\"type\";s:7:\"success\";}}","no");


/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES 
("1","2","_wp_page_template","page-big.php"),
("2","1","_edit_lock","1564827440:2"),
("156","26","_wp_attachment_metadata","a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:16:\"2018/03/icon.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("155","26","_wp_attached_file","2018/03/icon.png"),
("1358","301","post_views_count","9"),
("1356","303","post_views_count","16"),
("1357","304","post_views_count","7"),
("1355","302","post_views_count","11"),
("18","9","_menu_item_type","taxonomy"),
("19","9","_menu_item_menu_item_parent","0"),
("20","9","_menu_item_object_id","1"),
("21","9","_menu_item_object","category"),
("22","9","_menu_item_target",""),
("23","9","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("24","9","_menu_item_xfn",""),
("25","9","_menu_item_url",""),
("27","10","_menu_item_type","taxonomy"),
("28","10","_menu_item_menu_item_parent","9"),
("29","10","_menu_item_object_id","6"),
("30","10","_menu_item_object","category"),
("31","10","_menu_item_target",""),
("32","10","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("33","10","_menu_item_xfn",""),
("34","10","_menu_item_url",""),
("36","11","_menu_item_type","taxonomy"),
("37","11","_menu_item_menu_item_parent","9"),
("38","11","_menu_item_object_id","5"),
("39","11","_menu_item_object","category"),
("40","11","_menu_item_target",""),
("41","11","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("42","11","_menu_item_xfn",""),
("43","11","_menu_item_url",""),
("45","12","_menu_item_type","taxonomy"),
("46","12","_menu_item_menu_item_parent","9"),
("47","12","_menu_item_object_id","4"),
("48","12","_menu_item_object","category"),
("49","12","_menu_item_target",""),
("50","12","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("51","12","_menu_item_xfn",""),
("52","12","_menu_item_url",""),
("54","13","_menu_item_type","taxonomy"),
("55","13","_menu_item_menu_item_parent","9"),
("56","13","_menu_item_object_id","8"),
("57","13","_menu_item_object","category"),
("58","13","_menu_item_target",""),
("59","13","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("60","13","_menu_item_xfn",""),
("61","13","_menu_item_url",""),
("63","14","_menu_item_type","taxonomy"),
("64","14","_menu_item_menu_item_parent","9"),
("65","14","_menu_item_object_id","7"),
("66","14","_menu_item_object","category"),
("67","14","_menu_item_target",""),
("68","14","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("69","14","_menu_item_xfn",""),
("70","14","_menu_item_url",""),
("72","15","_menu_item_type","taxonomy"),
("73","15","_menu_item_menu_item_parent","0"),
("74","15","_menu_item_object_id","10"),
("75","15","_menu_item_object","category"),
("76","15","_menu_item_target",""),
("77","15","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("78","15","_menu_item_xfn",""),
("79","15","_menu_item_url",""),
("144","1","_edit_last","2"),
("81","16","_menu_item_type","taxonomy"),
("82","16","_menu_item_menu_item_parent","0"),
("83","16","_menu_item_object_id","2"),
("84","16","_menu_item_object","category"),
("85","16","_menu_item_target",""),
("86","16","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("87","16","_menu_item_xfn",""),
("88","16","_menu_item_url",""),
("90","17","_menu_item_type","taxonomy"),
("91","17","_menu_item_menu_item_parent","0"),
("92","17","_menu_item_object_id","3"),
("93","17","_menu_item_object","category"),
("94","17","_menu_item_target",""),
("95","17","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("96","17","_menu_item_xfn",""),
("97","17","_menu_item_url",""),
("1349","358","_menu_item_url","http://islamic.demo-qaleb.ir/wp-content/uploads/2019/08/box.html"),
("1348","358","_menu_item_xfn",""),
("1347","358","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("1346","358","_menu_item_target",""),
("1345","358","_menu_item_object","custom"),
("1344","358","_menu_item_object_id","358"),
("1343","358","_menu_item_menu_item_parent","349"),
("1342","358","_menu_item_type","custom"),
("1341","357","_wp_attached_file","2019/08/box.html"),
("899","213","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:18:\"2018/03/9876-1.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"9876-1-100x67.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"9876-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:17:\"9876-1-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:18:\"9876-1-600x320.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:17:\"9876-1-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:18:\"9876-1-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:18:\"9876-1-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:18:\"9876-1-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:18:\"9876-1-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:18:\"9876-1-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:17:\"9876-1-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:16:\"9876-1-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:18:\"9876-1-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:18:\"9876-1-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:12:\"MehrNews.com\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:12:\"MehrNews.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("898","213","_wp_attached_file","2018/03/9876-1.jpg"),
("1340","356","_wp_attachment_metadata","a:5:{s:5:\"width\";i:102;s:6:\"height\";i:102;s:4:\"file\";s:13:\"2019/08/1.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:12:\"1-100x70.png\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:4:\"post\";a:4:{s:4:\"file\";s:12:\"1-102x85.png\";s:5:\"width\";i:102;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:13:\"1-102x100.png\";s:5:\"width\";i:102;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1339","356","_wp_attached_file","2019/08/1.png"),
("150","1","lead","امروز که در پنجمین دهه از عمر پر برکت انقلاب اسلامی به مدد حضرت ولی عصر (عج) و هدایت حکیمانه امام(ره) و رهبری مدبرانه حضرتعالی گام اول انقلاب که ترجمان جامع «ما می‌توانیم» بود، محقق شد، لیکن وجود مواردی اعم از نفوذ خوی اشرافیت و کاخ نشینی، نبود شفافیت و پاسخگویی در عملکرد‌ها، مرعوبیت و عدم مرزبندی برخی از مسئولان در برابر دشمن، در برهه‌هایی از این زمان چهل ساله باعث تلخی کام مردم عزیز ایران اسلامی شد. در شرایطی که با برخی اقدامات مشخص مانند رشد صادرات فرآورده‌های نفتی و محصولات غیر نفتی، اتکای بودجه داخلی به مالیات و انجام طرح‌های معطل مانده نظیر مالیات بر عایدی سرمایه، مالیات بر مسکن خالی، مالیات برخی اقشار نظیر پزشکان و وکلا و یا با برقراری سامانه‌های مولد شفافیت، می‌توان با بسیاری از ناکارآمدی‌ها و سرچشمه‌های فساد مبارزه کرد."),
("151","1","meta-text-1","دیدار دانشجویان با امام خامنه‌ای"),
("152","1","meta-text-3","حسن رحیمی"),
("153","1","meta-text-4","خبرگذای تسنیم"),
("157","27","_edit_last","1"),
("158","27","_edit_lock","1522392522:1"),
("894","212","_wp_attached_file","2018/03/6ii.jpg"),
("895","212","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:15:\"2018/03/6ii.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"6ii-100x67.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"6ii-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:14:\"6ii-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:15:\"6ii-600x320.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:14:\"6ii-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:15:\"6ii-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:15:\"6ii-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:15:\"6ii-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:15:\"6ii-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:15:\"6ii-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:14:\"6ii-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:13:\"6ii-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:15:\"6ii-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:15:\"6ii-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:12:\"MehrNews.com\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:12:\"MehrNews.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("167","27","post_views_count","185"),
("163","27","lead","در دقایق باقی مانده پرسپولیس بر فشار حملاتش اضافه کرد تا با کسب یک امتیاز قهرمانی اش را مسجل کند اما سایپایی ها اجازه باز شدن دروازه شان برای بار دوم را ندادند تا با کسب سه امتیاز ارزشمند این بازی، قهرمانی سرخپوشان را هم به تعویق بیندازند."),
("164","27","meta-text-1","هفته بیست و ششم لیگ برتر؛"),
("165","27","meta-text-3","جواد خیابانی"),
("166","27","meta-text-4","خبرگذاری تسنیم"),
("168","30","_edit_last","1"),
("169","30","_edit_lock","1522387753:1"),
("828","30","_thumbnail_id","194"),
("826","194","_wp_attached_file","2018/03/868-2.jpg"),
("827","194","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:17:\"2018/03/868-2.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"868-2-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"868-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:16:\"868-2-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:17:\"868-2-600x320.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:16:\"868-2-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:17:\"868-2-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:17:\"868-2-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:17:\"868-2-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:17:\"868-2-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:17:\"868-2-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:16:\"868-2-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:15:\"868-2-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:17:\"868-2-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:17:\"868-2-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:12:\"MehrNews.com\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:12:\"MehrNews.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("179","30","post_views_count","39"),
("174","30","lead","فرمانده انتظامی استان مرکزی خاطرنشان ساخت: مبارزه با قاچاق و توزیع موادمخدر از برنامه های اولویت دار ستاد فرماندهی انتظامی استان مرکزی است که همواره با جدیت و به صورت شبانه روزی دنبال می شود."),
("175","30","meta-text-1","فرمانده انتظامی استان مرکزی خبرداد؛"),
("176","30","meta-text-3","رضا یاری"),
("177","30","meta-text-4","خبرگذاری فارس"),
("180","33","_edit_last","2"),
("181","33","_edit_lock","1592828009:2"),
("812","33","_thumbnail_id","190"),
("810","190","_wp_attached_file","2018/03/868.jpg"),
("811","190","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:15:\"2018/03/868.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"868-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"868-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:14:\"868-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:15:\"868-600x320.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:14:\"868-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:15:\"868-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:15:\"868-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:15:\"868-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:15:\"868-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:15:\"868-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:14:\"868-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:13:\"868-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:15:\"868-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:15:\"868-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:12:\"MehrNews.com\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:12:\"MehrNews.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("191","36","_edit_last","1"),
("186","33","lead","خراسان رضوی _ مدیرکل امور اتباع و مهاجرین خارجی خراسان رضوی از تصویب اعطای گواهینامه رانندگی به اتباع خارجی دارای کارت آمایش و خروج و مراجعت قانونی آنها خبر داد."),
("187","33","meta-text-1","مدیرکل امور اتباع و مهاجرین خارجی خراسان رضوی خبر داد؛"),
("188","33","meta-text-3","احمد جهانی"),
("189","33","meta-text-4","دانشجو"),
("192","36","_edit_lock","1522383004:1"),
("193","37","_wp_attached_file","2018/03/2658388.jpg"),
("194","37","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:19:\"2018/03/2658388.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"2658388-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"2658388-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-97\";a:4:{s:4:\"file\";s:17:\"2658388-97x67.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:19:\"2658388-600x320.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:18:\"2658388-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-182\";a:4:{s:4:\"file\";s:19:\"2658388-182x123.jpg\";s:5:\"width\";i:182;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:19:\"2658388-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:19:\"2658388-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:19:\"2658388-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:19:\"2658388-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:18:\"2658388-145x90.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:90;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:17:\"2658388-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:19:\"2658388-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:19:\"2658388-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:12:\"MehrNews.com\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:12:\"MehrNews.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("195","36","_thumbnail_id","37"),
("201","39","_edit_last","1"),
("197","36","lead","وزیر علوم در یادداشتی پیرامون نامگذاری سال جدید توسط مقام معظم رهبری بر نقش دانشگاه و نخبگان کشور در تحقق شعار «حمایت از کالای ایرانی» تاکید کرد."),
("198","36","meta-text-1","وزیر علوم در یادداشتی تاکید کرد؛"),
("199","36","meta-text-3","منصور غلامی"),
("200","36","meta-text-4","خبرگذاری فارس"),
("202","39","_edit_lock","1522341558:1"),
("203","40","_wp_attached_file","2018/03/2184306.jpg"),
("204","40","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:19:\"2018/03/2184306.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"2184306-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"2184306-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-97\";a:4:{s:4:\"file\";s:17:\"2184306-97x67.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:19:\"2184306-600x320.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:18:\"2184306-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-182\";a:4:{s:4:\"file\";s:19:\"2184306-182x123.jpg\";s:5:\"width\";i:182;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:19:\"2184306-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:19:\"2184306-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:19:\"2184306-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:19:\"2184306-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:18:\"2184306-145x90.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:90;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:17:\"2184306-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:19:\"2184306-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:19:\"2184306-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:12:\"MehrNews.com\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:12:\"MehrNews.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("205","39","_thumbnail_id","40"),
("211","39","post_views_count","39"),
("207","39","lead","رئیس دانشگاه پیام نور مهمترین برنامه های این دانشگاه در سال جاری را گسترش رشته های تحصیلات تکمیلی با تاکید بر رشته های کاربردی و مورد نیاز جامعه برشمرد. به گزارش خبرگزاری مهر به نقل از دانشگاه پیام نور، محمدرضا زمانی برنامه های آموزشی، پژوهشی و فرهنگی دانشگاه پیام نور در سال ۹۷ را تشریح کرد"),
("208","39","meta-text-1","رئیس دانشگاه خبر داد؛"),
("209","39","meta-text-3","زهرا سیفی"),
("210","39","meta-text-4","خبرگذاری فردا"),
("212","42","_edit_last","1"),
("213","42","_edit_lock","1522387401:1"),
("214","43","_wp_attached_file","2018/03/2700894.jpg"),
("215","43","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:19:\"2018/03/2700894.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"2700894-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"2700894-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-97\";a:4:{s:4:\"file\";s:17:\"2700894-97x67.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:19:\"2700894-600x320.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:18:\"2700894-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-182\";a:4:{s:4:\"file\";s:19:\"2700894-182x123.jpg\";s:5:\"width\";i:182;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:19:\"2700894-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:19:\"2700894-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:19:\"2700894-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:19:\"2700894-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:18:\"2700894-145x90.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:90;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:17:\"2700894-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:19:\"2700894-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:19:\"2700894-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:12:\"MehrNews.com\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:12:\"MehrNews.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("216","42","_thumbnail_id","43"),
("222","45","_edit_last","1"),
("218","42","lead","رئیس هیأت موسس دانشگاه آزاد با بیان اینکه روز گذشته بودجه سال ۹۷ دانشگاه آزاد در جلسه هیات امنا دانشگاه تصویب شد، گفت: موضوع اساتید دو شغله را سیاسی کردند."),
("219","42","meta-text-1","ولایتی خبر داد:"),
("220","42","meta-text-3","علی اکبر ولایتی"),
("221","42","meta-text-4","خبرگذاری تسنیم"),
("223","45","_edit_lock","1522345304:1"),
("224","46","_wp_attached_file","2018/03/2355570.jpg"),
("225","46","_wp_attachment_metadata","a:5:{s:5:\"width\";i:620;s:6:\"height\";i:413;s:4:\"file\";s:19:\"2018/03/2355570.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"2355570-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"2355570-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-97\";a:4:{s:4:\"file\";s:17:\"2355570-97x67.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:19:\"2355570-620x320.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:18:\"2355570-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-182\";a:4:{s:4:\"file\";s:19:\"2355570-182x123.jpg\";s:5:\"width\";i:182;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:19:\"2355570-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:19:\"2355570-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:19:\"2355570-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:19:\"2355570-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:18:\"2355570-145x90.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:90;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:19:\"2355570-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:17:\"2355570-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:19:\"2355570-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:19:\"2355570-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:12:\"MehrNews.com\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:12:\"MehrNews.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("226","45","_thumbnail_id","46"),
("232","48","_edit_last","2"),
("228","45","lead","دشمن از طریق این فضا وارد خانه‌های ما شده است لذا باید برای آن تدبیری اندیشید و گرچه ما مخالف فضای مجازی و بسته شدن آن و دیوار کشیدن به دور کشور نیستیم اما نباید اجازه دهیم هر میکروبی وارد خانواده‌های ما شود."),
("229","45","meta-text-1","آیت الله سبحانی:"),
("230","45","meta-text-3","حسن رحیمی"),
("231","45","meta-text-4","دانشجو"),
("233","48","_edit_lock","1536651864:2"),
("853","48","_thumbnail_id","201"),
("1245","312","_wp_attached_file","2018/03/1396021812323520710768794.jpg"),
("1246","312","_wp_attachment_metadata","a:5:{s:5:\"width\";i:700;s:6:\"height\";i:456;s:4:\"file\";s:37:\"2018/03/1396021812323520710768794.jpg\";s:5:\"sizes\";a:21:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1396021812323520710768794-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1396021812323520710768794-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1396021812323520710768794-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1396021812323520710768794-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1396021812323520710768794-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1396021812323520710768794-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1396021812323520710768794-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-700x456.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:456;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1396021812323520710768794-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}"),
("838","63","post_views_count","283"),
("242","51","_edit_last","2"),
("238","48","lead","به گزارش خبرگزاری تسنیم از مشهدمقدس، مقام معظم رهبری طبق یک سنت هرساله امسال نیز در آغازین روز فروردین ماه در جوار بارگاه سراسر نور و ملکوتی امام رضا(ع) سخنرانی نوروزی خود را ایراد خواهند کرد."),
("239","48","meta-text-1","حدود دو ساعت دیگر سخنرانی نوروزی مقام معظم رهبری در حرم منور رضوی ایراد می‌شود."),
("240","48","meta-text-3","احمد جهانی"),
("241","48","meta-text-4","خبرگذاری تسنیم"),
("243","51","_edit_lock","1536651927:2"),
("244","52","_wp_attached_file","2018/03/147253950390490800.jpg"),
("245","52","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:253;s:4:\"file\";s:30:\"2018/03/147253950390490800.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"147253950390490800-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"147253950390490800-300x190.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-97\";a:4:{s:4:\"file\";s:28:\"147253950390490800-97x67.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:29:\"147253950390490800-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-182\";a:4:{s:4:\"file\";s:30:\"147253950390490800-182x123.jpg\";s:5:\"width\";i:182;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:30:\"147253950390490800-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:30:\"147253950390490800-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:30:\"147253950390490800-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:29:\"147253950390490800-145x90.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:90;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:28:\"147253950390490800-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:30:\"147253950390490800-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:30:\"147253950390490800-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}"),
("246","51","_thumbnail_id","52"),
("252","54","_edit_last","1"),
("248","51","lead","به گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم «پویا»، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود."),
("249","51","meta-text-1","بیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند."),
("250","51","meta-text-3","علی صادقی"),
("251","51","meta-text-4","خبرگذاری تسنیم"),
("253","54","_edit_lock","1522342323:1"),
("254","55","_wp_attached_file","2018/03/85632.jpg"),
("255","55","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:382;s:4:\"file\";s:17:\"2018/03/85632.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"85632-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"85632-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-97\";a:4:{s:4:\"file\";s:15:\"85632-97x67.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:17:\"85632-600x320.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:16:\"85632-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-182\";a:4:{s:4:\"file\";s:17:\"85632-182x123.jpg\";s:5:\"width\";i:182;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:17:\"85632-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:17:\"85632-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:17:\"85632-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:17:\"85632-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:16:\"85632-145x90.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:90;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:15:\"85632-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:17:\"85632-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:17:\"85632-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1476040782\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}"),
("256","54","_thumbnail_id","55"),
("262","57","_edit_last","2"),
("258","54","lead","نرگس آبیار کارگردان در جشن سینما و کتاب که به همت خانه هنرمندان برگزار شده بود، گفت: نویسنده ها مقداری کوتاه بیایند و کمتر سخت بگیرند و فیلم سازان هم آن قدر نخواهند که خود مولف باشند و فیلمنامه بنویسند. به گزارش خبرنگارفرهنگی خبرگزاری تسنیم، جشن سینما و کتاب عصر روز شنبه ۲۱ شهریور می باشد."),
("259","54","meta-text-1","جشن سینما و کتاب عصر روز ۲۱ شهریورماه"),
("260","54","meta-text-3","نسرین بختیاری"),
("261","54","meta-text-4","خبرگذاری فردا"),
("263","57","_edit_lock","1548526424:2"),
("808","57","_thumbnail_id","188"),
("806","188","_wp_attached_file","2018/03/58.jpg"),
("807","188","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:14:\"2018/03/58.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:12:\"58-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"58-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:13:\"58-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:14:\"58-600x320.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:13:\"58-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:14:\"58-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:14:\"58-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:14:\"58-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:14:\"58-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:14:\"58-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:13:\"58-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:12:\"58-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:14:\"58-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:14:\"58-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("272","60","_edit_last","1"),
("268","57","lead","به گزارش خبرنگار اقتصادی وزیر راه و شهرسازی و فرمانده قرارگاه خاتم‌الانبیاء امروز پس از بازدید از آزادراه کنارگذر جنوبی تهران از عملیات اجرایی پیشرفت پروژه راه‌آهن سریع‌السیر تهران-قم-اصفهان بازدید کردند. این پروژه که برای اولین بار در کشور اجرا می‌شود به پیمانکاری قرارگاه خاتم‌الانبیاء و کارفرمایی دولت اجرا می‌شود."),
("269","57","meta-text-1","پروژه راه‌آهن سریع السیر تهران-قم-اصفهان"),
("270","57","meta-text-3","زهرا سیفی"),
("271","57","meta-text-4","خبرگذاری تسنیم"),
("273","60","_edit_lock","1522392246:1"),
("871","60","_thumbnail_id","205"),
("282","63","_edit_last","2"),
("278","60","lead","ربیعی با اعتقاد بر اینکه باید برای مبارزه با فساد به فکر شایسته سالاری و اصلاح ساختارها به همراه تقویت نظارت ها باشم، گفت: با برگزاری همایش مقابله با فساد و همکاری دستگاه ها اجرایی می توانیم در مقابله با فساد اقدامات کارآمدی را انجام دهیم."),
("279","60","meta-text-1","مبارزه با فساد به فکر شایسته سالاری"),
("280","60","meta-text-3","احمد جهانی"),
("281","60","meta-text-4","خبرگذای مهر"),
("283","63","_edit_lock","1536651851:2"),
("866","63","_thumbnail_id","204"),
("868","60","post_views_count","126"),
("292","66","_edit_last","1"),
("288","63","lead","به گزارش خبرگزاری نسیم، همایش ملی «ارتقای سلامت اداری و مبارزه با فساد» با حضور سران سه قوه و جمعی از مسئولین عالی‌رتبه کشوری و لشکری در سالن اجلاس سران برگزار شد. در این همایش ولی‌الله سیف رییس کل بانک مرکزی به ایراد سخن پرداخت"),
("289","63","meta-text-1","ارتقای سلامت اداری و مبارزه با فساد"),
("290","63","meta-text-3","غلامرضا سیف"),
("291","63","meta-text-4","خبرگذاری فارس"),
("293","66","_edit_lock","1522392469:1"),
("890","210","_wp_attached_file","2018/03/8h6.jpg"),
("891","210","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:15:\"2018/03/8h6.jpg\";s:5:\"sizes\";a:19:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"8h6-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"8h6-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"8h6-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:15:\"8h6-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:14:\"8h6-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:15:\"8h6-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:14:\"8h6-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:15:\"8h6-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:15:\"8h6-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:15:\"8h6-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:15:\"8h6-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:15:\"8h6-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:15:\"8h6-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:14:\"8h6-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:15:\"8h6-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:13:\"8h6-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:15:\"8h6-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:15:\"8h6-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:15:\"8h6-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("892","66","_thumbnail_id","210"),
("896","27","_thumbnail_id","212"),
("303","70","_edit_last","1"),
("298","66","lead","&quot;آخر کار&quot; آخوندی در آستانه چهارشنبه سوری / در حالی قرار است امروز وزیر راه و شهرسازی برای سومین بار استیضاح شود که پیش‌بینی فرجام این داستان با توجه به اتفاقات پشت‌پرده پیچیده و سخت است."),
("299","66","meta-text-1","کاریکاتور :"),
("300","66","meta-text-3","جواد خیابانی"),
("301","66","meta-text-4","خبرگذاری فارس"),
("304","70","_edit_lock","1522392469:1"),
("315","73","_edit_last","1"),
("882","208","_wp_attached_file","2018/03/hh.jpg"),
("883","208","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:14:\"2018/03/hh.jpg\";s:5:\"sizes\";a:19:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"hh-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"hh-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:14:\"hh-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:14:\"hh-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:13:\"hh-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:14:\"hh-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:13:\"hh-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:14:\"hh-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:14:\"hh-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:14:\"hh-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:14:\"hh-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:14:\"hh-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:14:\"hh-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:13:\"hh-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:14:\"hh-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:12:\"hh-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:14:\"hh-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:14:\"hh-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:14:\"hh-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("884","73","_thumbnail_id","208"),
("1316","351","_menu_item_xfn",""),
("309","70","lead","رابطه بین سلفی‌های موبایلی و عمل‌های جراحی زیبایی / نتایج تحقیقات جدید نشان می‌دهد کسانی که با گوشی هوشمند بیشتر از خودشان عکس‌های سلفی می‌گیرند، احتمال زیادی دارد که در معرض عمل‌های جراحی زیبایی قرار بگیرند. "),
("310","70","meta-text-1","کاریکاتور :"),
("311","70","meta-text-3","حسن رحیمی"),
("312","70","meta-text-4","خبرگذاری تسنیم"),
("1060","66","post_views_count","147"),
("318","73","lead","اعتماد از دست رفته مردم با اعاده اموال نامشروع مسئولان بازمی‌گردد/ مجلسی‌ها به جای مصاحبه مکرر بر روی تصویب طرح تمرکز کنند / عضو شورای مرکزی کانون دانشگاهیان گفت: اعتماد از دست رفته مردم با عمل بازمی‌گردد نه با حرف، مردم دوست دارند بشوند اموال نامشروعی که فلان شخص یا فلان گروه ربوده بودند به خزانه بازگشت. "),
("319","73","meta-text-1","کاریکاتور :"),
("320","73","meta-text-3","زهرا ساختمانیان"),
("321","73","meta-text-4","دانشجو"),
("322","73","_edit_lock","1522392470:1"),
("1314","351","_menu_item_target",""),
("886","209","_wp_attached_file","2018/03/88j.jpg"),
("887","209","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:15:\"2018/03/88j.jpg\";s:5:\"sizes\";a:19:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"88j-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"88j-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"88j-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:15:\"88j-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:14:\"88j-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:15:\"88j-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:14:\"88j-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:15:\"88j-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:15:\"88j-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:15:\"88j-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:15:\"88j-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:15:\"88j-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:15:\"88j-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:14:\"88j-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:15:\"88j-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:13:\"88j-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:15:\"88j-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:15:\"88j-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:15:\"88j-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("888","70","_thumbnail_id","209"),
("1313","351","_menu_item_object","custom"),
("327","77","_edit_last","1"),
("328","77","_edit_lock","1535896608:2"),
("1312","351","_menu_item_object_id","351"),
("874","206","_wp_attached_file","2018/03/987654.jpg"),
("875","206","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:18:\"2018/03/987654.jpg\";s:5:\"sizes\";a:19:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"987654-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"987654-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"987654-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"987654-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:17:\"987654-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:18:\"987654-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:17:\"987654-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:18:\"987654-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:18:\"987654-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:18:\"987654-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:18:\"987654-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:18:\"987654-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:18:\"987654-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:17:\"987654-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:18:\"987654-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:16:\"987654-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:18:\"987654-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:18:\"987654-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:18:\"987654-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("876","77","_thumbnail_id","206"),
("1311","351","_menu_item_menu_item_parent","349"),
("337","80","_edit_last","1"),
("333","77","lead","جهانگیری: قیمت‌ کالاها در شب عید سبب نگرانی مردم نمی‌شود / معاون اول رئیس‌جمهور با تأکید به اینکه قیمت‌ کالاها در شب عید سبب نگرانی مردم نمی‌شود، گفت: انبارهای کشور به‌اندازه کافی کالا دارد و مردم برای شب عید نگرانی نخواهند داشت. "),
("334","77","meta-text-1","کاریکاتور :"),
("335","77","meta-text-3","نسرین بختیاری"),
("336","77","meta-text-4","خبرگذاری فارس"),
("338","80","_edit_lock","1522392381:1"),
("1015","231","_menu_item_object","media_category"),
("878","207","_wp_attached_file","2018/03/987654678.jpg"),
("879","207","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:21:\"2018/03/987654678.jpg\";s:5:\"sizes\";a:19:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"987654678-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"987654678-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"987654678-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"987654678-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:20:\"987654678-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:21:\"987654678-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:20:\"987654678-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:21:\"987654678-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:21:\"987654678-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:21:\"987654678-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:21:\"987654678-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:21:\"987654678-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:21:\"987654678-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:20:\"987654678-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:21:\"987654678-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:19:\"987654678-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:21:\"987654678-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:21:\"987654678-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:21:\"987654678-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("880","80","_thumbnail_id","207"),
("347","84","_edit_last","1"),
("343","80","lead","دولت ترامپ در ایستگاه یک‌سالگی | نگاه آمریکایی‌ها به عملکرد ترامپ در یکسال گذشته / ررسی روند تغییرات دیدگاه شهروندان آمریکایی در تأیید یا عدم تأیید عملکرد دولت ترامپ طی یکسال اخیر نشان دهنده یک تغییر و روند ثابت در افزایش دیدگاه منفی آمریکایی‌ها نسبت به دولت‌شان است. "),
("344","80","meta-text-1","کاریکاتور :"),
("345","80","meta-text-3","رضا یاری"),
("346","80","meta-text-4","دانشجو"),
("348","84","_edit_lock","1522346828:1"),
("349","85","_wp_attached_file","2018/03/13950823165007209195654.jpg"),
("350","85","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:35:\"2018/03/13950823165007209195654.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:34:\"13950823165007209195654-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:34:\"13950823165007209195654-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:34:\"13950823165007209195654-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:33:\"13950823165007209195654-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:35:\"13950823165007209195654-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("351","86","_wp_attached_file","2018/03/7.jpg"),
("352","86","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:13:\"2018/03/7.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"7-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:13:\"7-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:12:\"7-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:13:\"7-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:12:\"7-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:13:\"7-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:13:\"7-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:13:\"7-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:13:\"7-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:13:\"7-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:13:\"7-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:12:\"7-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:13:\"7-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:11:\"7-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:13:\"7-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:13:\"7-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:13:\"7-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("353","87","_wp_attached_file","2018/03/139508231650066929195654.jpg"),
("354","87","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139508231650066929195654.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139508231650066929195654-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139508231650066929195654-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139508231650066929195654-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139508231650066929195654-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139508231650066929195654-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("355","88","_wp_attached_file","2018/03/139508231650074269195654.jpg"),
("356","88","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139508231650074269195654.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139508231650074269195654-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139508231650074269195654-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139508231650074269195654-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139508231650074269195654-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139508231650074269195654-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("365","84","_thumbnail_id","86"),
("366","84","meta-text-6",""),
("367","84","post_views_count","1315"),
("368","94","_edit_last","2"),
("369","94","_edit_lock","1536652104:2"),
("1230","94","_thumbnail_id","296"),
("1232","308","_edit_last","2"),
("1233","308","_edit_lock","1544437669:2"),
("1234","309","_wp_attached_file","2018/09/1397052820470746015081294.jpg"),
("1235","309","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:37:\"2018/09/1397052820470746015081294.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1397052820470746015081294-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1397052820470746015081294-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1397052820470746015081294-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1397052820470746015081294-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1397052820470746015081294-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1397052820470746015081294-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1397052820470746015081294-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1397052820470746015081294-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("378","97","_edit_last","1"),
("374","94","lead","در جدول رده بندی آمریکا با ۱۰ طلا، ۱۱ نقره و ۱۰ برنز و مجموع ۳۱ در رده اول قرار دارد، چین با ۱۰ طلا، ۵ نقره و ۸ برنز و مجموع ۲۳ در رده دوم و ژاپن با ۶ طلا، یک نقره و ۱۱ برنز در مکان سوم جدول توزیع مدال‌ها قرار دارند."),
("359","90","_wp_attached_file","2018/03/139508231650089109195654.jpg"),
("360","90","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139508231650089109195654.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139508231650089109195654-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139508231650089109195654-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139508231650089109195654-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139508231650089109195654-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139508231650089109195654-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("361","91","_wp_attached_file","2018/03/13950823165010049195664.jpg"),
("362","91","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:35:\"2018/03/13950823165010049195664.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:34:\"13950823165010049195664-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:34:\"13950823165010049195664-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:34:\"13950823165010049195664-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:33:\"13950823165010049195664-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:35:\"13950823165010049195664-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("363","92","_wp_attached_file","2018/03/139508231650104109195664.jpg"),
("364","92","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139508231650104109195664.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139508231650104109195664-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139508231650104109195664-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139508231650104109195664-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139508231650104109195664-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139508231650104109195664-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("375","94","meta-text-1","قزاقستان با کسب دو طلای شنا و وزنه برداری در این روز به رتبه یازدهم صعود کرد"),
("376","94","meta-text-3","احمد جهانی"),
("377","94","meta-text-4","خبرگذاری فردا"),
("379","97","_edit_lock","1522347141:1"),
("380","98","_wp_attached_file","2018/03/98.jpg"),
("381","98","_wp_attachment_metadata","a:5:{s:5:\"width\";i:434;s:6:\"height\";i:293;s:4:\"file\";s:14:\"2018/03/98.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"98-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"98-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:13:\"98-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:13:\"98-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:14:\"98-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:14:\"98-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:14:\"98-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:14:\"98-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:14:\"98-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:13:\"98-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:12:\"98-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:14:\"98-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:14:\"98-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("382","97","_thumbnail_id","98"),
("388","100","_edit_last","1"),
("384","97","lead","به گزارش پایگاه اطلاع رسانی شبکه خبر، رئیس جمهور در پایان سفر دو روزه به جمهوری آذربایجان، وارد تهران شد. روحانی در این سفر ضمن دیدار و گفتگو با الهام علی‌اف رئیس جمهوری آذربایجان، در اجلاس سه جانبه ایران، روسیه و آذربایجان شرکت کرد."),
("385","97","meta-text-1","مقابله با تروریسم از دیگر مفاد این بیانیه سه جانبه است"),
("386","97","meta-text-3","نسرین بختیاری"),
("387","97","meta-text-4","خبرگذاری تسنیم"),
("389","100","_edit_lock","1522348335:1"),
("390","101","_wp_attached_file","2018/03/139309121707301214215833.jpg"),
("391","101","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:280;s:4:\"file\";s:36:\"2018/03/139309121707301214215833.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139309121707301214215833-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139309121707301214215833-300x210.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139309121707301214215833-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139309121707301214215833-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139309121707301214215833-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139309121707301214215833-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139309121707301214215833-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139309121707301214215833-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139309121707301214215833-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139309121707301214215833-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139309121707301214215833-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139309121707301214215833-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("392","100","_thumbnail_id","101"),
("394","100","lead","به گزارش خبرنگار قضایی خبرگزاری نسیم حجت الاسلام پورمحمدی وزیر دادگستری در حاشیه همایش ارتقای سلامت اداری و مبارزه با فساد، در پاسخ به سوال خبرنگار تسنیم مبنی بر اینکه برخی شنیده‌ها از انحلال شورای دستگاه‌های نظارتی حکایت دارد"),
("395","100","meta-text-1","دغدغه مقام معظم رهبری، دغدغه‌ای کاملا جدی است و خودمان نیز همین پیش‌بینی را داشتیم"),
("396","100","meta-text-3","رضا یاری"),
("397","100","meta-text-4","خبرگذاری فردا"),
("1014","231","_menu_item_object_id","48"),
("917","33","post_views_count","35"),
("907","137","menu-icons","a:8:{s:4:\"type\";s:9:\"dashicons\";s:4:\"icon\";s:22:\"dashicons-format-image\";s:10:\"hide_label\";s:0:\"\";s:8:\"position\";s:6:\"before\";s:14:\"vertical_align\";s:6:\"middle\";s:9:\"font_size\";s:3:\"1.2\";s:9:\"svg_width\";s:1:\"1\";s:10:\"image_size\";s:9:\"thumbnail\";}"),
("908","142","menu-icons","a:8:{s:4:\"type\";s:9:\"dashicons\";s:4:\"icon\";s:22:\"dashicons-format-video\";s:10:\"hide_label\";s:0:\"\";s:8:\"position\";s:6:\"before\";s:14:\"vertical_align\";s:6:\"middle\";s:9:\"font_size\";s:3:\"1.2\";s:9:\"svg_width\";s:1:\"1\";s:10:\"image_size\";s:9:\"thumbnail\";}"),
("909","172","menu-icons","a:8:{s:4:\"type\";s:9:\"dashicons\";s:4:\"icon\";s:21:\"dashicons-admin-users\";s:10:\"hide_label\";s:0:\"\";s:8:\"position\";s:6:\"before\";s:14:\"vertical_align\";s:6:\"middle\";s:9:\"font_size\";s:3:\"1.2\";s:9:\"svg_width\";s:1:\"1\";s:10:\"image_size\";s:9:\"thumbnail\";}"),
("910","173","menu-icons","a:8:{s:4:\"type\";s:9:\"dashicons\";s:4:\"icon\";s:19:\"dashicons-email-alt\";s:10:\"hide_label\";s:0:\"\";s:8:\"position\";s:6:\"before\";s:14:\"vertical_align\";s:6:\"middle\";s:9:\"font_size\";s:3:\"1.2\";s:9:\"svg_width\";s:1:\"1\";s:10:\"image_size\";s:9:\"thumbnail\";}"),
("911","42","post_views_count","59"),
("916","100","post_views_count","272"),
("914","45","post_views_count","91"),
("915","106","post_views_count","428"),
("1104","257","_wp_attached_file","2018/08/logo.png"),
("1105","257","_wp_attachment_metadata","a:5:{s:5:\"width\";i:567;s:6:\"height\";i:177;s:4:\"file\";s:16:\"2018/08/logo.png\";s:5:\"sizes\";a:19:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"logo-100x31.png\";s:5:\"width\";i:100;s:6:\"height\";i:31;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"logo-300x94.png\";s:5:\"width\";i:300;s:6:\"height\";i:94;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:16:\"logo-230x160.png\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:16:\"logo-230x135.png\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:16:\"logo-330x177.png\";s:5:\"width\";i:330;s:6:\"height\";i:177;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:16:\"logo-290x177.png\";s:5:\"width\";i:290;s:6:\"height\";i:177;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:14:\"logo-77x55.png\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:15:\"logo-130x95.png\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:16:\"logo-410x177.png\";s:5:\"width\";i:410;s:6:\"height\";i:177;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:16:\"logo-222x147.png\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:14:\"logo-93x68.png\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:14:\"logo-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:15:\"logo-105x85.png\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:14:\"logo-65x55.png\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:16:\"logo-310x177.png\";s:5:\"width\";i:310;s:6:\"height\";i:177;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:16:\"logo-330x177.png\";s:5:\"width\";i:330;s:6:\"height\";i:177;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:16:\"logo-490x177.png\";s:5:\"width\";i:490;s:6:\"height\";i:177;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:16:\"logo-145x100.png\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:16:\"logo-360x177.png\";s:5:\"width\";i:360;s:6:\"height\";i:177;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1010","230","_menu_item_url",""),
("1012","231","_menu_item_type","taxonomy"),
("1013","231","_menu_item_menu_item_parent","0"),
("1337","354","_wp_attached_file","2019/08/slider.html"),
("1338","355","_wp_attached_file","2019/08/sliderm.html"),
("1006","230","_menu_item_object","gallery_category"),
("1005","230","_menu_item_object_id","45"),
("1004","230","_menu_item_menu_item_parent","0"),
("1003","230","_menu_item_type","taxonomy"),
("1057","54","post_views_count","77"),
("1303","350","_menu_item_object_id","350"),
("1304","350","_menu_item_object","custom"),
("1302","350","_menu_item_menu_item_parent","349"),
("1301","350","_menu_item_type","custom"),
("1362","160","post_views_count","0"),
("1299","349","_menu_item_url","http://#"),
("1298","349","_menu_item_xfn",""),
("1058","70","post_views_count","111"),
("1059","73","post_views_count","130"),
("1308","350","_menu_item_url","http://islamic.demo-qaleb.ir/wp-content/uploads/2019/08/slider.html"),
("1307","350","_menu_item_xfn",""),
("1306","350","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("1305","350","_menu_item_target",""),
("1094","250","_wp_attached_file","2018/03/139307150821491843794434.jpg"),
("1095","250","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139307150821491843794434.jpg\";s:5:\"sizes\";a:19:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"139307150821491843794434-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139307150821491843794434-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139307150821491843794434-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139307150821491843794434-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139307150821491843794434-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139307150821491843794434-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("409","106","_edit_last","1"),
("417","109","_edit_last","1"),
("412","106","lead"," تهران به عنوان پایتخت کشور و با این وسعت و وجود ۲۲۰۰ساختمان فرهنگی و تاریخی،ظرفیت بی بدیلی از  جاذبه های دیدنی و گردشگری را داراست که معتقدم در معرفی این جاذبه ها و بهره مندی از ظرفیت های موجود،غفلت شده است."),
("413","106","meta-text-1","عضو شورای اسلامی شهر تهران گفت:"),
("414","106","meta-text-3","زهرا سیفی"),
("415","106","meta-text-4","خبرگذای مهر"),
("416","106","_edit_lock","1524772690:1"),
("418","109","_edit_lock","1522348662:1"),
("419","110","_wp_attached_file","2018/03/139507180953311398885994.jpg"),
("420","110","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139507180953311398885994.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139507180953311398885994-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139507180953311398885994-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139507180953311398885994-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139507180953311398885994-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139507180953311398885994-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("421","109","_thumbnail_id","110"),
("422","109","meta-text-7","اصغر زیوری"),
("423","109","href-link-player","https://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/07/17/139507170934296358873955.mp4"),
("424","109","href-link-1080","https://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/07/17/139507170934296358873955.mp4"),
("425","109","href-link-720","https://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/07/17/139507170934296358873955.mp4"),
("426","109","href-link-480","https://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/07/17/139507170934296358873955.mp4"),
("427","109","href-link-360",""),
("428","109","href-link-240",""),
("429","109","post_views_count","1115"),
("430","112","_edit_last","2"),
("431","112","_edit_lock","1536227252:2"),
("433","112","lead","سردار شیرازی با بیان اینکه در عقیدتی سیاسی فرماندهی کل قوا با تدبیر رهبر انقلاب مرکز راهبردی فرهنگی ایجاد می شود، گفت: اثرگذاری کار فرهنگی مورد تاکید رهبر انقلاب است."),
("434","112","meta-text-1","زمینه آموزش و پرورش و آموزش عالی"),
("435","112","meta-text-3","علی صادقی"),
("436","112","meta-text-4","خبرگذاری فارس"),
("855","1","post_views_count","379"),
("1016","231","_menu_item_target",""),
("1310","351","_menu_item_type","custom"),
("1297","349","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("1296","349","_menu_item_target",""),
("1295","349","_menu_item_object","custom"),
("1294","349","_menu_item_object_id","349"),
("1293","349","_menu_item_menu_item_parent","0"),
("1292","349","_menu_item_type","custom"),
("441","116","_edit_last","1"),
("442","116","_edit_lock","1535868126:2"),
("443","117","_wp_attached_file","2018/03/3-1.jpg"),
("444","117","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:15:\"2018/03/3-1.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"3-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"3-1-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"3-1-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:14:\"3-1-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:15:\"3-1-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:14:\"3-1-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:15:\"3-1-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:15:\"3-1-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:15:\"3-1-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:15:\"3-1-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:15:\"3-1-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:15:\"3-1-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:14:\"3-1-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:15:\"3-1-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:13:\"3-1-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:15:\"3-1-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:15:\"3-1-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:15:\"3-1-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("445","118","_wp_attached_file","2018/03/3-3.jpg"),
("446","118","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:15:\"2018/03/3-3.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"3-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"3-3-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"3-3-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:14:\"3-3-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:15:\"3-3-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:14:\"3-3-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:15:\"3-3-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:15:\"3-3-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:15:\"3-3-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:15:\"3-3-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:15:\"3-3-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:15:\"3-3-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:14:\"3-3-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:15:\"3-3-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:13:\"3-3-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:15:\"3-3-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:15:\"3-3-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:15:\"3-3-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("447","119","_wp_attached_file","2018/03/3-5.jpg"),
("448","119","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:15:\"2018/03/3-5.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"3-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"3-5-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"3-5-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:14:\"3-5-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:15:\"3-5-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:14:\"3-5-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:15:\"3-5-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:15:\"3-5-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:15:\"3-5-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:15:\"3-5-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:15:\"3-5-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:15:\"3-5-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:14:\"3-5-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:15:\"3-5-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:13:\"3-5-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:15:\"3-5-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:15:\"3-5-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:15:\"3-5-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("449","120","_wp_attached_file","2018/03/IMG12580183.jpg"),
("450","120","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:1067;s:4:\"file\";s:23:\"2018/03/IMG12580183.jpg\";s:5:\"sizes\";a:19:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"IMG12580183-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"IMG12580183-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"IMG12580183-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"IMG12580183-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:22:\"IMG12580183-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:23:\"IMG12580183-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:22:\"IMG12580183-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:23:\"IMG12580183-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:23:\"IMG12580183-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:23:\"IMG12580183-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:23:\"IMG12580183-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:23:\"IMG12580183-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:23:\"IMG12580183-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:22:\"IMG12580183-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:23:\"IMG12580183-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:21:\"IMG12580183-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:23:\"IMG12580183-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:24:\"IMG12580183-1095x550.jpg\";s:5:\"width\";i:1095;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:23:\"IMG12580183-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("451","121","_wp_attached_file","2018/03/3-2.jpg"),
("452","121","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:15:\"2018/03/3-2.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"3-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"3-2-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"3-2-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:14:\"3-2-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:15:\"3-2-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:14:\"3-2-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:15:\"3-2-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:15:\"3-2-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:15:\"3-2-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:15:\"3-2-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:15:\"3-2-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:15:\"3-2-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:14:\"3-2-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:15:\"3-2-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:13:\"3-2-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:15:\"3-2-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:15:\"3-2-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:15:\"3-2-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("453","122","_wp_attached_file","2018/03/3-4.jpg"),
("454","122","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:15:\"2018/03/3-4.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"3-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"3-4-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"3-4-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:14:\"3-4-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:15:\"3-4-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:14:\"3-4-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:15:\"3-4-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:15:\"3-4-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:15:\"3-4-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:15:\"3-4-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:15:\"3-4-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:15:\"3-4-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:14:\"3-4-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:15:\"3-4-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:13:\"3-4-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:15:\"3-4-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:15:\"3-4-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:15:\"3-4-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("455","116","_thumbnail_id","117"),
("456","116","meta-text-6","علی محمدیان"),
("457","113","_edit_last","1"),
("458","113","_edit_lock","1522349666:1"),
("459","124","_wp_attached_file","2018/03/139507171249242728877264.jpg"),
("460","124","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139507171249242728877264.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139507171249242728877264-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139507171249242728877264-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139507171249242728877264-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139507171249242728877264-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139507171249242728877264-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("461","113","_thumbnail_id","124"),
("462","113","meta-text-7","اصغر زیوری"),
("463","113","href-link-player","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/06/28/139506281558099898693505.mp4"),
("464","113","href-link-1080","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/06/28/139506281558099898693505.mp4"),
("465","113","href-link-720","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/06/28/139506281558099898693505.mp4"),
("466","113","href-link-480","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/06/28/139506281558099898693505.mp4"),
("467","113","href-link-360","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/06/28/139506281558099898693505.mp4"),
("468","113","href-link-240","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/06/28/139506281558099898693505.mp4"),
("480","129","_edit_last","2"),
("481","129","_edit_lock","1536227303:2"),
("482","130","_wp_attached_file","2018/03/139507171343121718878494.jpg"),
("483","130","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139507171343121718878494.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139507171343121718878494-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139507171343121718878494-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139507171343121718878494-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139507171343121718878494-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139507171343121718878494-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("484","131","_wp_attached_file","2018/03/139507171343157968878494.jpg"),
("485","131","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139507171343157968878494.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139507171343157968878494-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139507171343157968878494-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139507171343157968878494-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139507171343157968878494-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139507171343157968878494-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("486","132","_wp_attached_file","2018/03/13950717134319148878494.jpg"),
("487","132","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:35:\"2018/03/13950717134319148878494.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:34:\"13950717134319148878494-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:34:\"13950717134319148878494-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:34:\"13950717134319148878494-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:33:\"13950717134319148878494-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:35:\"13950717134319148878494-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("488","133","_wp_attached_file","2018/03/139507171343191558878494.jpg"),
("489","133","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139507171343191558878494.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139507171343191558878494-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139507171343191558878494-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139507171343191558878494-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139507171343191558878494-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139507171343191558878494-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("490","134","_wp_attached_file","2018/03/139507180953393588885994.jpg"),
("491","134","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139507180953393588885994.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139507180953393588885994-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139507180953393588885994-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139507180953393588885994-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139507180953393588885994-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139507180953393588885994-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("492","135","_wp_attached_file","2018/03/139508231650081139195654.jpg"),
("493","135","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139508231650081139195654.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139508231650081139195654-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139508231650081139195654-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139508231650081139195654-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139508231650081139195654-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139508231650081139195654-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("494","129","_thumbnail_id","134"),
("495","129","meta-text-6","امید دشتی"),
("496","129","post_views_count","1231"),
("497","116","post_views_count","1234"),
("498","137","_menu_item_type","taxonomy"),
("499","137","_menu_item_menu_item_parent","0"),
("500","137","_menu_item_object_id","45"),
("501","137","_menu_item_object","gallery_category"),
("502","137","_menu_item_target",""),
("503","137","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("504","137","_menu_item_xfn",""),
("505","137","_menu_item_url",""),
("537","142","_menu_item_object","media_category"),
("507","138","_menu_item_type","taxonomy"),
("508","138","_menu_item_menu_item_parent","137"),
("509","138","_menu_item_object_id","47"),
("510","138","_menu_item_object","gallery_category"),
("511","138","_menu_item_target",""),
("512","138","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("513","138","_menu_item_xfn",""),
("514","138","_menu_item_url",""),
("535","142","_menu_item_menu_item_parent","0"),
("516","139","_menu_item_type","taxonomy"),
("517","139","_menu_item_menu_item_parent","137"),
("518","139","_menu_item_object_id","33"),
("519","139","_menu_item_object","gallery_category"),
("520","139","_menu_item_target",""),
("521","139","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("522","139","_menu_item_xfn",""),
("523","139","_menu_item_url",""),
("536","142","_menu_item_object_id","48"),
("525","140","_menu_item_type","taxonomy"),
("526","140","_menu_item_menu_item_parent","137"),
("527","140","_menu_item_object_id","46"),
("528","140","_menu_item_object","gallery_category"),
("529","140","_menu_item_target",""),
("530","140","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("531","140","_menu_item_xfn",""),
("532","140","_menu_item_url",""),
("534","142","_menu_item_type","taxonomy"),
("538","142","_menu_item_target",""),
("539","142","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("540","142","_menu_item_xfn",""),
("541","142","_menu_item_url",""),
("563","145","_edit_lock","1522349978:1"),
("543","143","_menu_item_type","taxonomy"),
("544","143","_menu_item_menu_item_parent","142"),
("545","143","_menu_item_object_id","39"),
("546","143","_menu_item_object","media_category"),
("547","143","_menu_item_target",""),
("548","143","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("549","143","_menu_item_xfn",""),
("550","143","_menu_item_url",""),
("562","145","_edit_last","1"),
("552","144","_menu_item_type","taxonomy"),
("553","144","_menu_item_menu_item_parent","142"),
("554","144","_menu_item_object_id","36"),
("555","144","_menu_item_object","media_category"),
("556","144","_menu_item_target",""),
("557","144","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("558","144","_menu_item_xfn",""),
("559","144","_menu_item_url",""),
("561","113","post_views_count","1140"),
("564","146","_wp_attached_file","2018/03/6875_m.jpg"),
("565","146","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:900;s:4:\"file\";s:18:\"2018/03/6875_m.jpg\";s:5:\"sizes\";a:19:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"6875_m-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"6875_m-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"6875_m-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"6875_m-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:17:\"6875_m-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:18:\"6875_m-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:17:\"6875_m-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:18:\"6875_m-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:18:\"6875_m-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:18:\"6875_m-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:18:\"6875_m-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:18:\"6875_m-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:18:\"6875_m-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:17:\"6875_m-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:18:\"6875_m-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:16:\"6875_m-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:18:\"6875_m-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:19:\"6875_m-1095x550.jpg\";s:5:\"width\";i:1095;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:18:\"6875_m-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("568","145","_thumbnail_id","146"),
("569","145","meta-text-7","رضا مهری"),
("570","145","href-link-player","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/07/12/139507121031443178829535.mp4"),
("571","145","href-link-1080","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/07/12/139507121031443178829535.mp4"),
("572","145","href-link-720","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/07/12/139507121031443178829535.mp4"),
("573","145","href-link-480","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/07/12/139507121031443178829535.mp4");

INSERT INTO `wp_postmeta` VALUES 
("574","145","href-link-360","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/07/12/139507121031443178829535.mp4"),
("575","145","href-link-240","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/07/12/139507121031443178829535.mp4"),
("576","145","post_views_count","1174"),
("577","149","_edit_last","1"),
("578","149","_edit_lock","1522351417:1"),
("590","149","_thumbnail_id","152"),
("591","152","_wp_attached_file","2018/03/trump-e-netayauh-01.jpg"),
("592","152","_wp_attachment_metadata","a:5:{s:5:\"width\";i:960;s:6:\"height\";i:640;s:4:\"file\";s:31:\"2018/03/trump-e-netayauh-01.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:30:\"trump-e-netayauh-01-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:30:\"trump-e-netayauh-01-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:30:\"trump-e-netayauh-01-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:29:\"trump-e-netayauh-01-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-960x550.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:31:\"trump-e-netayauh-01-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("582","149","meta-text-7","رضا مهری"),
("583","149","href-link-player","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/05/25/139505250956593708386825.mp4"),
("584","149","href-link-1080","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/05/25/139505250956593708386825.mp4"),
("585","149","href-link-720","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/05/25/139505250956593708386825.mp4"),
("586","149","href-link-480","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/05/25/139505250956593708386825.mp4"),
("587","149","href-link-360","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/05/25/139505250956593708386825.mp4"),
("588","149","href-link-240","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/05/25/139505250956593708386825.mp4"),
("589","149","post_views_count","1230"),
("593","153","_edit_last","2"),
("594","153","_edit_lock","1535867884:2"),
("1169","287","_wp_attached_file","2018/03/1693305_800.jpg"),
("1170","287","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1084;s:6:\"height\";i:598;s:4:\"file\";s:23:\"2018/03/1693305_800.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"1693305_800-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"1693305_800-300x165.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"1693305_800-768x424.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:424;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"1693305_800-800x441.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:23:\"1693305_800-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:23:\"1693305_800-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:23:\"1693305_800-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:23:\"1693305_800-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:21:\"1693305_800-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:22:\"1693305_800-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:23:\"1693305_800-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:23:\"1693305_800-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:23:\"1693305_800-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:21:\"1693305_800-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:21:\"1693305_800-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:22:\"1693305_800-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:21:\"1693305_800-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:23:\"1693305_800-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:23:\"1693305_800-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:23:\"1693305_800-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:23:\"1693305_800-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:23:\"1693305_800-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:23:\"1693305_800-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}"),
("598","153","meta-text-7","رضا مهری"),
("599","153","href-link-player","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/04/14/139504141056056748067275.mp4"),
("600","153","href-link-1080","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/04/14/139504141056056748067275.mp4"),
("601","153","href-link-720","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/04/14/139504141056056748067275.mp4"),
("602","153","href-link-480","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/04/14/139504141056056748067275.mp4"),
("603","153","href-link-360","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/04/14/139504141056056748067275.mp4"),
("604","153","href-link-240","http://newsmedia.tasnimnews.com/Tasnim/Uploaded/Video/1395/04/14/139504141056056748067275.mp4"),
("605","153","post_views_count","1549"),
("606","156","_edit_last","1"),
("607","156","_edit_lock","1522393786:1"),
("608","157","_wp_attached_file","2018/03/1396021400472221110723224.jpg"),
("609","157","_wp_attachment_metadata","a:5:{s:5:\"width\";i:500;s:6:\"height\";i:348;s:4:\"file\";s:37:\"2018/03/1396021400472221110723224.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"1396021400472221110723224-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1396021400472221110723224-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:36:\"1396021400472221110723224-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:37:\"1396021400472221110723224-500x320.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:36:\"1396021400472221110723224-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:37:\"1396021400472221110723224-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:37:\"1396021400472221110723224-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:37:\"1396021400472221110723224-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:37:\"1396021400472221110723224-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:37:\"1396021400472221110723224-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:36:\"1396021400472221110723224-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:35:\"1396021400472221110723224-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:37:\"1396021400472221110723224-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:37:\"1396021400472221110723224-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("610","156","_thumbnail_id","157"),
("616","159","_edit_last","2"),
("612","156","lead","باید بگوییم ما در این ۲ سال و در پی بی‌قانونی وزیر همین دولت، در برودت سوزناک زمستان و زیر آفتاب سوزان تابستان اعتراض کردیم و بارها به مسئولین دولتی و حتی خود شما نامه نوشتیم."),
("918","36","post_views_count","37"),
("1009","230","_menu_item_xfn",""),
("1008","230","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("1007","230","_menu_item_target",""),
("613","156","meta-text-1","ریاست محترم حقوقدان جمهور"),
("614","156","meta-text-3","علی صادقی"),
("615","156","meta-text-4","خبرگذاری تسنیم"),
("617","159","_edit_lock","1535867418:2"),
("618","160","_wp_attached_file","2018/03/139507171900058878882764.jpg"),
("619","160","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139507171900058878882764.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139507171900058878882764-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139507171900058878882764-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139507171900058878882764-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139507171900058878882764-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139507171900058878882764-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("620","161","_wp_attached_file","2018/03/139507171900048878882764.jpg"),
("621","161","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139507171900048878882764.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139507171900048878882764-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139507171900048878882764-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139507171900048878882764-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139507171900048878882764-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139507171900048878882764-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("622","162","_wp_attached_file","2018/03/139507171900069348882764.jpg"),
("623","162","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139507171900069348882764.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139507171900069348882764-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139507171900069348882764-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139507171900069348882764-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139507171900069348882764-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139507171900069348882764-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("624","163","_wp_attached_file","2018/03/139507171900074818882764.jpg"),
("625","163","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/03/139507171900074818882764.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139507171900074818882764-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139507171900074818882764-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139507171900074818882764-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139507171900074818882764-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139507171900074818882764-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("626","159","_thumbnail_id","286"),
("627","159","meta-text-6","علی محمدیان"),
("628","159","post_views_count","1277"),
("629","165","_menu_item_type","custom"),
("630","165","_menu_item_menu_item_parent","0"),
("631","165","_menu_item_object_id","165"),
("632","165","_menu_item_object","custom"),
("633","165","_menu_item_target",""),
("634","165","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("635","165","_menu_item_xfn",""),
("636","165","_menu_item_url","http://islamic.demo-qaleb.ir/feed/rss/"),
("668","170","_edit_lock","1569672722:2"),
("638","166","_menu_item_type","custom"),
("639","166","_menu_item_menu_item_parent","0"),
("640","166","_menu_item_object_id","166"),
("641","166","_menu_item_object","custom"),
("642","166","_menu_item_target",""),
("643","166","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("644","166","_menu_item_xfn",""),
("645","166","_menu_item_url","http://#"),
("667","170","_edit_last","2"),
("647","167","_menu_item_type","custom"),
("648","167","_menu_item_menu_item_parent","0"),
("649","167","_menu_item_object_id","167"),
("650","167","_menu_item_object","custom"),
("651","167","_menu_item_target",""),
("652","167","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("653","167","_menu_item_xfn",""),
("654","167","_menu_item_url","http://#"),
("666","2","_edit_last","2"),
("656","168","_menu_item_type","custom"),
("657","168","_menu_item_menu_item_parent","0"),
("658","168","_menu_item_object_id","168"),
("659","168","_menu_item_object","custom"),
("660","168","_menu_item_target",""),
("661","168","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("662","168","_menu_item_xfn",""),
("663","168","_menu_item_url","http://#"),
("665","2","_edit_lock","1564830665:2"),
("669","170","_wp_page_template","page-big.php"),
("670","172","_menu_item_type","post_type"),
("671","172","_menu_item_menu_item_parent","0"),
("672","172","_menu_item_object_id","170"),
("673","172","_menu_item_object","page"),
("674","172","_menu_item_target",""),
("675","172","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("676","172","_menu_item_xfn",""),
("677","172","_menu_item_url",""),
("689","174","_menu_item_type","custom"),
("679","173","_menu_item_type","post_type"),
("680","173","_menu_item_menu_item_parent","0"),
("681","173","_menu_item_object_id","2"),
("682","173","_menu_item_object","page"),
("683","173","_menu_item_target",""),
("684","173","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("685","173","_menu_item_xfn",""),
("686","173","_menu_item_url",""),
("688","2","post_views_count","15"),
("690","174","_menu_item_menu_item_parent","15"),
("691","174","_menu_item_object_id","174"),
("692","174","_menu_item_object","custom"),
("693","174","_menu_item_target",""),
("694","174","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("695","174","_menu_item_xfn",""),
("696","174","_menu_item_url","http://#"),
("698","175","_menu_item_type","custom"),
("699","175","_menu_item_menu_item_parent","15"),
("700","175","_menu_item_object_id","175"),
("701","175","_menu_item_object","custom"),
("702","175","_menu_item_target",""),
("703","175","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("704","175","_menu_item_xfn",""),
("705","175","_menu_item_url","http://#"),
("707","176","_menu_item_type","custom"),
("708","176","_menu_item_menu_item_parent","15"),
("709","176","_menu_item_object_id","176"),
("710","176","_menu_item_object","custom"),
("711","176","_menu_item_target",""),
("712","176","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("713","176","_menu_item_xfn",""),
("714","176","_menu_item_url","http://#"),
("799","97","post_views_count","239"),
("716","177","_menu_item_type","custom"),
("717","177","_menu_item_menu_item_parent","15"),
("718","177","_menu_item_object_id","177"),
("719","177","_menu_item_object","custom"),
("720","177","_menu_item_target",""),
("721","177","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("722","177","_menu_item_xfn",""),
("723","177","_menu_item_url","http://#"),
("795","112","post_views_count","594"),
("725","178","_menu_item_type","custom"),
("726","178","_menu_item_menu_item_parent","15"),
("727","178","_menu_item_object_id","178"),
("728","178","_menu_item_object","custom"),
("729","178","_menu_item_target",""),
("730","178","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("731","178","_menu_item_xfn",""),
("732","178","_menu_item_url","http://#"),
("734","179","_menu_item_type","custom"),
("735","179","_menu_item_menu_item_parent","15"),
("736","179","_menu_item_object_id","179"),
("737","179","_menu_item_object","custom"),
("738","179","_menu_item_target",""),
("739","179","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("740","179","_menu_item_xfn",""),
("741","179","_menu_item_url","http://#"),
("793","48","post_views_count","121"),
("743","180","_menu_item_type","custom"),
("744","180","_menu_item_menu_item_parent","15"),
("745","180","_menu_item_object_id","180"),
("746","180","_menu_item_object","custom"),
("747","180","_menu_item_target",""),
("748","180","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("749","180","_menu_item_xfn",""),
("750","180","_menu_item_url","http://#"),
("792","77","post_views_count","150"),
("752","181","_menu_item_type","custom"),
("753","181","_menu_item_menu_item_parent","15"),
("754","181","_menu_item_object_id","181"),
("755","181","_menu_item_object","custom"),
("756","181","_menu_item_target",""),
("757","181","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("758","181","_menu_item_xfn",""),
("759","181","_menu_item_url","http://#"),
("791","80","post_views_count","255"),
("761","182","_menu_item_type","custom"),
("762","182","_menu_item_menu_item_parent","15"),
("763","182","_menu_item_object_id","182"),
("764","182","_menu_item_object","custom"),
("765","182","_menu_item_target",""),
("766","182","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("767","182","_menu_item_xfn",""),
("768","182","_menu_item_url","http://#"),
("790","51","post_views_count","191"),
("770","183","_menu_item_type","custom"),
("771","183","_menu_item_menu_item_parent","15"),
("772","183","_menu_item_object_id","183"),
("773","183","_menu_item_object","custom"),
("774","183","_menu_item_target",""),
("775","183","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("776","183","_menu_item_xfn",""),
("777","183","_menu_item_url","http://#"),
("789","94","post_views_count","346"),
("779","184","_menu_item_type","custom"),
("780","184","_menu_item_menu_item_parent","15"),
("781","184","_menu_item_object_id","184"),
("782","184","_menu_item_object","custom"),
("783","184","_menu_item_target",""),
("784","184","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("785","184","_menu_item_xfn",""),
("786","184","_menu_item_url","http://#"),
("788","156","post_views_count","724"),
("864","204","_wp_attached_file","2018/03/7607.jpg"),
("865","204","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:410;s:4:\"file\";s:16:\"2018/03/7607.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"7607-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"7607-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:15:\"7607-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:16:\"7607-600x320.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:15:\"7607-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:16:\"7607-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:16:\"7607-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:16:\"7607-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:16:\"7607-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:16:\"7607-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:15:\"7607-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:16:\"7607-600x410.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:14:\"7607-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:16:\"7607-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:16:\"7607-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("869","205","_wp_attached_file","2018/03/9876.jpg"),
("870","205","_wp_attachment_metadata","a:5:{s:5:\"width\";i:640;s:6:\"height\";i:427;s:4:\"file\";s:16:\"2018/03/9876.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"9876-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"9876-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:15:\"9876-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:16:\"9876-640x320.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:15:\"9876-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:16:\"9876-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:16:\"9876-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:16:\"9876-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:16:\"9876-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:16:\"9876-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:15:\"9876-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:16:\"9876-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:14:\"9876-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:16:\"9876-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:16:\"9876-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("851","201","_wp_attached_file","2018/03/668.jpg"),
("852","201","_wp_attachment_metadata","a:5:{s:5:\"width\";i:700;s:6:\"height\";i:474;s:4:\"file\";s:15:\"2018/03/668.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"668-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"668-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:14:\"668-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:15:\"668-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:14:\"668-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:15:\"668-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:15:\"668-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:15:\"668-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:15:\"668-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:15:\"668-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:14:\"668-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:15:\"668-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:13:\"668-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:15:\"668-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:15:\"668-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}"),
("1017","231","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("1018","231","_menu_item_xfn",""),
("1019","231","_menu_item_url",""),
("1021","232","_menu_item_type","taxonomy"),
("1022","232","_menu_item_menu_item_parent","231"),
("1023","232","_menu_item_object_id","39"),
("1024","232","_menu_item_object","media_category"),
("1025","232","_menu_item_target",""),
("1026","232","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("1027","232","_menu_item_xfn",""),
("1028","232","_menu_item_url",""),
("1030","233","_menu_item_type","taxonomy"),
("1031","233","_menu_item_menu_item_parent","231"),
("1032","233","_menu_item_object_id","36"),
("1033","233","_menu_item_object","media_category"),
("1034","233","_menu_item_target",""),
("1035","233","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("1036","233","_menu_item_xfn",""),
("1037","233","_menu_item_url",""),
("1039","234","_menu_item_type","taxonomy"),
("1040","234","_menu_item_menu_item_parent","230"),
("1041","234","_menu_item_object_id","33"),
("1042","234","_menu_item_object","gallery_category"),
("1043","234","_menu_item_target",""),
("1044","234","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("1045","234","_menu_item_xfn",""),
("1046","234","_menu_item_url",""),
("1048","235","_menu_item_type","taxonomy"),
("1049","235","_menu_item_menu_item_parent","230"),
("1050","235","_menu_item_object_id","47"),
("1051","235","_menu_item_object","gallery_category"),
("1052","235","_menu_item_target",""),
("1053","235","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("1054","235","_menu_item_xfn",""),
("1055","235","_menu_item_url",""),
("1067","241","_wp_attached_file","2018/04/139511221805479359973314.jpg"),
("1068","241","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/04/139511221805479359973314.jpg\";s:5:\"sizes\";a:19:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"139511221805479359973314-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-100\";a:4:{s:4:\"file\";s:35:\"139511221805479359973314-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-650\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-650x320.jpg\";s:5:\"width\";i:650;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-135\";a:4:{s:4:\"file\";s:35:\"139511221805479359973314-135x95.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-185\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-185x125.jpg\";s:5:\"width\";i:185;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-410\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-410x285.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-293\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-293x200.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-755\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-755x522.jpg\";s:5:\"width\";i:755;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-360\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-260\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-145\";a:4:{s:4:\"file\";s:35:\"139511221805479359973314-145x95.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-620\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-620x410.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:410;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"img-50\";a:4:{s:4:\"file\";s:34:\"139511221805479359973314-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-255\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-255x170.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"img-1140\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-800x550.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"img-200\";a:4:{s:4:\"file\";s:36:\"139511221805479359973314-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1114","262","_wp_attached_file","2018/08/wwww.wp-qaleb.ir-2.jpg"),
("1115","262","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:413;s:4:\"file\";s:30:\"2018/08/wwww.wp-qaleb.ir-2.jpg\";s:5:\"sizes\";a:20:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-2-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-300x207.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:207;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-2-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-2-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-2-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-2-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-2-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-2-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-2-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1106","258","_wp_attached_file","2018/08/footer-logo.png"),
("1107","258","_wp_attachment_metadata","a:5:{s:5:\"width\";i:70;s:6:\"height\";i:72;s:4:\"file\";s:23:\"2018/08/footer-logo.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"footer-logo-68x70.png\";s:5:\"width\";i:68;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:21:\"footer-logo-70x55.png\";s:5:\"width\";i:70;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:21:\"footer-logo-70x68.png\";s:5:\"width\";i:70;s:6:\"height\";i:68;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:21:\"footer-logo-65x55.png\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1110","260","_edit_last","2"),
("1111","260","_edit_lock","1535720442:2"),
("1112","261","_wp_attached_file","2018/08/wwww.wp-qaleb.ir-1.jpg"),
("1113","261","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:438;s:4:\"file\";s:30:\"2018/08/wwww.wp-qaleb.ir-1.jpg\";s:5:\"sizes\";a:20:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-1-96x70.jpg\";s:5:\"width\";i:96;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-300x219.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:219;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-1-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-1-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-1-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-1-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-1-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-1-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-1-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1093","57","post_views_count","100"),
("1096","106","_thumbnail_id","250"),
("1315","351","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("1116","263","_wp_attached_file","2018/08/wwww.wp-qaleb.ir-3.jpg"),
("1117","263","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:435;s:4:\"file\";s:30:\"2018/08/wwww.wp-qaleb.ir-3.jpg\";s:5:\"sizes\";a:20:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-3-97x70.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-300x218.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:218;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-3-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-3-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-3-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-3-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-3-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-3-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-3-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1118","264","_wp_attached_file","2018/08/wwww.wp-qaleb.ir-4.jpg"),
("1119","264","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:433;s:4:\"file\";s:30:\"2018/08/wwww.wp-qaleb.ir-4.jpg\";s:5:\"sizes\";a:20:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-4-97x70.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-300x217.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:217;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-4-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-4-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-4-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-4-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-4-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-4-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-4-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1120","265","_wp_attached_file","2018/08/wwww.wp-qaleb.ir-5.jpg"),
("1121","265","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:406;s:4:\"file\";s:30:\"2018/08/wwww.wp-qaleb.ir-5.jpg\";s:5:\"sizes\";a:20:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-5-100x68.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-5-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-5-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-5-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-5-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-5-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-5-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-5-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1122","266","_wp_attached_file","2018/08/wwww.wp-qaleb.ir-6.jpg"),
("1123","266","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:434;s:4:\"file\";s:30:\"2018/08/wwww.wp-qaleb.ir-6.jpg\";s:5:\"sizes\";a:20:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-6-97x70.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-300x217.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:217;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-6-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-6-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-6-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-6-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:29:\"wwww.wp-qaleb.ir-6-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:28:\"wwww.wp-qaleb.ir-6-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:30:\"wwww.wp-qaleb.ir-6-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1124","260","_thumbnail_id","261"),
("1125","268","_edit_last","2"),
("1126","268","_edit_lock","1535720607:2"),
("1127","260","post_views_count","2"),
("1128","268","_thumbnail_id","262"),
("1129","270","_edit_last","2"),
("1130","270","_edit_lock","1535720630:2"),
("1131","273","_edit_last","2"),
("1132","273","_edit_lock","1535720610:2"),
("1133","272","_edit_last","2"),
("1134","272","_edit_lock","1535720607:2"),
("1135","271","_edit_last","2"),
("1136","271","_edit_lock","1535720607:2"),
("1137","271","_thumbnail_id","263"),
("1138","272","_thumbnail_id","264"),
("1139","273","_thumbnail_id","265"),
("1140","270","_thumbnail_id","266"),
("1141","270","post_views_count","361"),
("1142","278","_edit_last","2"),
("1143","278","_edit_lock","1537094130:2"),
("1167","286","_wp_attachment_metadata","a:5:{s:5:\"width\";i:750;s:6:\"height\";i:460;s:4:\"file\";s:20:\"2018/03/جنوب.jpg\";s:5:\"sizes\";a:21:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"جنوب-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"جنوب-300x184.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:184;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:20:\"جنوب-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:20:\"جنوب-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:20:\"جنوب-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:20:\"جنوب-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:18:\"جنوب-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:19:\"جنوب-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:20:\"جنوب-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:20:\"جنوب-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:20:\"جنوب-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:18:\"جنوب-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:18:\"جنوب-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:19:\"جنوب-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:18:\"جنوب-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:20:\"جنوب-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:20:\"جنوب-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:20:\"جنوب-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:20:\"جنوب-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:20:\"جنوب-700x460.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:460;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:20:\"جنوب-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1166","286","_wp_attached_file","2018/03/جنوب.jpg"),
("1177","288","_wp_attached_file","2018/08/42040435_303.jpg"),
("1178","288","_wp_attachment_metadata","a:5:{s:5:\"width\";i:619;s:6:\"height\";i:394;s:4:\"file\";s:24:\"2018/08/42040435_303.jpg\";s:5:\"sizes\";a:20:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"42040435_303-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"42040435_303-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:24:\"42040435_303-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:24:\"42040435_303-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:24:\"42040435_303-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:24:\"42040435_303-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:22:\"42040435_303-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:23:\"42040435_303-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:24:\"42040435_303-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:24:\"42040435_303-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:24:\"42040435_303-610x394.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:22:\"42040435_303-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:22:\"42040435_303-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:23:\"42040435_303-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:22:\"42040435_303-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:24:\"42040435_303-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:24:\"42040435_303-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:24:\"42040435_303-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:24:\"42040435_303-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:24:\"42040435_303-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}"),
("1179","278","_thumbnail_id","288"),
("1181","289","_edit_last","2"),
("1182","289","_edit_lock","1535895952:2"),
("1183","290","_wp_attached_file","2018/09/Sony-Xperia-Z3-4.jpg"),
("1184","290","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:28:\"2018/09/Sony-Xperia-Z3-4.jpg\";s:5:\"sizes\";a:20:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"Sony-Xperia-Z3-4-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:26:\"Sony-Xperia-Z3-4-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:27:\"Sony-Xperia-Z3-4-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:26:\"Sony-Xperia-Z3-4-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:26:\"Sony-Xperia-Z3-4-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:27:\"Sony-Xperia-Z3-4-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:26:\"Sony-Xperia-Z3-4-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:28:\"Sony-Xperia-Z3-4-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:17:\"Canon EOS Kiss X4\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1409939573\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}"),
("1152","278","post_views_count","1537"),
("1148","278","lead","به گزارش خبرنگار سیاسی خبرگزاری تسنیم، آیت‌الله سیداحمد خاتمی خطیب نماز جمعه این هفته تهران در خطبه‌‌های دوم این نماز ضمن گرامیداشت عید غدیر و تشکر از مردم به دلیل بزرگداشت پرشکو این عید، گفت: آفرین بر شما که در عصر خودتان به خوبی فهمیدید که بیعت با غدیر، بیعت با ولایت فقیه است و سنگ تمام گذاشتید."),
("1149","278","meta-text-1","خطیب نماز جمعه این هفته تهران:"),
("1150","278","meta-text-3","حسن رحیمی"),
("1151","278","meta-text-4","خبرگذاری تسنیم"),
("1168","159","meta-text-11",""),
("1171","153","_thumbnail_id","287"),
("1176","278","_wp_old_slug","%d8%ac%d9%84%d8%b3%d9%87-%d8%b3%d8%a4%d8%a7%d9%84-%d8%a7%d8%b2-%d8%b1%d8%a6%db%8c%d8%b3%e2%80%8c%d8%ac%d9%85%d9%87%d9%88%d8%b1-%d9%86%d8%b4%d8%a7%d9%86-%d8%af%d8%a7%d8%af-%da%a9%d9%87-%d9%85__trashed"),
("1185","289","_thumbnail_id","290"),
("1186","289","meta-text-7","اصغر زیوری"),
("1187","289","href-link-player","https://hw1.cdn.asset.aparat.com/aparat-video/89624904faaec4602a40f69962c84c6e11701481-720p__61989.mp4"),
("1188","289","href-link-1080","https://hw1.cdn.asset.aparat.com/aparat-video/89624904faaec4602a40f69962c84c6e11701481-720p__61989.mp4"),
("1189","289","href-link-720","https://hw1.cdn.asset.aparat.com/aparat-video/89624904faaec4602a40f69962c84c6e11701481-720p__61989.mp4"),
("1190","289","href-link-480","https://hw1.cdn.asset.aparat.com/aparat-video/89624904faaec4602a40f69962c84c6e11701481-480p__61989.mp4"),
("1191","289","href-link-360","https://hw1.cdn.asset.aparat.com/aparat-video/89624904faaec4602a40f69962c84c6e11701481-480p__61989.mp4"),
("1192","289","href-link-240","https://hw1.cdn.asset.aparat.com/aparat-video/89624904faaec4602a40f69962c84c6e11701481-360p__61989.mp4"),
("1193","289","post_views_count","1115"),
("1194","292","_edit_last","2"),
("1195","292","_edit_lock","1535896424:2"),
("1196","293","_wp_attached_file","2018/09/1397060911243894815212694.jpg"),
("1197","293","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:37:\"2018/09/1397060911243894815212694.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1397060911243894815212694-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1397060911243894815212694-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1397060911243894815212694-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1397060911243894815212694-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1397060911243894815212694-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1397060911243894815212694-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1397060911243894815212694-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1397060911243894815212694-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1198","294","_wp_attached_file","2018/09/1397060911243880715212694.jpg"),
("1199","294","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:37:\"2018/09/1397060911243880715212694.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1397060911243880715212694-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1397060911243880715212694-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1397060911243880715212694-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1397060911243880715212694-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1397060911243880715212694-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1397060911243880715212694-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1397060911243880715212694-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1397060911243880715212694-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1200","295","_wp_attached_file","2018/09/1397060911243922915212694.jpg"),
("1201","295","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:37:\"2018/09/1397060911243922915212694.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1397060911243922915212694-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1397060911243922915212694-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1397060911243922915212694-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1397060911243922915212694-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1397060911243922915212694-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1397060911243922915212694-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1397060911243922915212694-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1397060911243922915212694-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1202","296","_wp_attached_file","2018/09/1397060911243947915212694.jpg"),
("1203","296","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:37:\"2018/09/1397060911243947915212694.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1397060911243947915212694-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1397060911243947915212694-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1397060911243947915212694-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1397060911243947915212694-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1397060911243947915212694-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1397060911243947915212694-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1397060911243947915212694-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1397060911243947915212694-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1204","297","_wp_attached_file","2018/09/1397060911243960415212694.jpg"),
("1205","297","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:37:\"2018/09/1397060911243960415212694.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1397060911243960415212694-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1397060911243960415212694-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1397060911243960415212694-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1397060911243960415212694-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1397060911243960415212694-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1397060911243960415212694-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1397060911243960415212694-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1397060911243960415212694-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1206","298","_wp_attached_file","2018/09/139706091124398915212694.jpg"),
("1207","298","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:36:\"2018/09/139706091124398915212694.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"139706091124398915212694-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:34:\"139706091124398915212694-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:35:\"139706091124398915212694-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:34:\"139706091124398915212694-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:34:\"139706091124398915212694-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:35:\"139706091124398915212694-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:34:\"139706091124398915212694-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:36:\"139706091124398915212694-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1208","292","_thumbnail_id","293"),
("1209","292","meta-text-6","ابراهیم دشتی"),
("1210","292","meta-text-11","به گزارش \"ورزش سه\"، امیرقلعه نویی در کنفرانس خبری پیش از دیدار برابر پارس جنوبی جم گفته بود که ترجیح می دهد تساوی 2 بر 2 در بازی ببیند تا بدون گل. در بازی های گذشته نیز نمایش سپاهانی ها علاقمندان به فوتبال را از تماشای یک فوتبال زیبا سیراب کرده بود، اما در مقابل پارس جنوبی جم و شاگردان مهدی تارتار شرایط برای این تیم بسیار سخت تر از دیدارهای گذشته شد"),
("1211","292","post_views_count","961"),
("1212","300","_edit_last","2"),
("1213","300","_edit_lock","1535896512:2"),
("1214","301","_wp_attached_file","2018/09/1397051414445958214943494.jpg"),
("1215","301","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:37:\"2018/09/1397051414445958214943494.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1397051414445958214943494-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1397051414445958214943494-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1397051414445958214943494-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1397051414445958214943494-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1397051414445958214943494-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1397051414445958214943494-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1397051414445958214943494-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1397051414445958214943494-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1216","302","_wp_attached_file","2018/09/1397051414445969214943494.jpg"),
("1217","302","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:37:\"2018/09/1397051414445969214943494.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1397051414445969214943494-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1397051414445969214943494-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1397051414445969214943494-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1397051414445969214943494-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1397051414445969214943494-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1397051414445969214943494-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1397051414445969214943494-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1397051414445969214943494-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1218","303","_wp_attached_file","2018/09/1397051414445977014943494.jpg"),
("1219","303","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:37:\"2018/09/1397051414445977014943494.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1397051414445977014943494-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1397051414445977014943494-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1397051414445977014943494-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1397051414445977014943494-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1397051414445977014943494-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1397051414445977014943494-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1397051414445977014943494-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1397051414445977014943494-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1220","304","_wp_attached_file","2018/09/1397051414450039514943494.jpg"),
("1221","304","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:37:\"2018/09/1397051414450039514943494.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1397051414450039514943494-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1397051414450039514943494-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1397051414450039514943494-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1397051414450039514943494-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1397051414450039514943494-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1397051414450039514943494-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1397051414450039514943494-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1397051414450039514943494-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1222","305","_wp_attached_file","2018/09/1397051414450062914943494.jpg"),
("1223","305","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:37:\"2018/09/1397051414450062914943494.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1397051414450062914943494-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1397051414450062914943494-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1397051414450062914943494-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1397051414450062914943494-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1397051414450062914943494-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1397051414450062914943494-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1397051414450062914943494-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1397051414450062914943494-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1224","306","_wp_attached_file","2018/09/1397051414450087914943494.jpg"),
("1225","306","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:557;s:4:\"file\";s:37:\"2018/09/1397051414450087914943494.jpg\";s:5:\"sizes\";a:23:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"1397051414450087914943494-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-768x535.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:535;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-800x557.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:557;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:35:\"1397051414450087914943494-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:36:\"1397051414450087914943494-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:35:\"1397051414450087914943494-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:35:\"1397051414450087914943494-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:36:\"1397051414450087914943494-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:35:\"1397051414450087914943494-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:37:\"1397051414450087914943494-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1226","300","_thumbnail_id","301"),
("1227","300","meta-text-6","علی محمدیان"),
("1228","300","meta-text-11","مراسم بزرگداشت روز حقوق بشر اسلامی و کرامت انسانی و اعطای چهارمین جایزه حقوق بشر اسلامی امروز ۱۴ مرداد با حضور آیت‌الله آملی لاریجانی رئیس قوه قضاییه و محمد جواد لاریجانی دبیر ستاد حقوق بشر درمجتمع فرهنگی شهید بهشتی برگزار شد."),
("1229","300","post_views_count","1017"),
("1236","308","_thumbnail_id","309"),
("1243","308","post_views_count","1408"),
("1238","308","lead","به گزارش خبرگزاری تسنیم و به نقل از مرکز اطلاع‌رسانی وزارت ورزش و جوانان، حضرت آیت‌الله خامنه‌ای رهبر معظم انقلاب به‌مناسبت موفقیت‌های کاروان ورزشکاران ایران در بازی‌های آسیایی 2018 اندونزی، پیامی صادر فرمودند."),
("1239","308","meta-text-1","رهبر معظم انقلاب اسلامی پیام تبریکی برای مدال‌آوران بازی‌های آسیایی ۲۰۱۸ صادر کردند."),
("1240","308","meta-text-3","حسن رحیمی"),
("1241","308","meta-text-4","خبرگذاری تسنیم"),
("1247","112","_thumbnail_id","312"),
("1249","129","meta-text-11",""),
("1250","271","post_views_count","46"),
("1251","272","post_views_count","61"),
("1257","273","post_views_count","69"),
("1259","268","post_views_count","15"),
("1260","170","post_views_count","2"),
("1264","332","_wp_attached_file","2018/03/Placko-new-building-plan-03.jpg"),
("1265","332","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:646;s:4:\"file\";s:39:\"2018/03/Placko-new-building-plan-03.jpg\";s:5:\"sizes\";a:24:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"Placko-new-building-plan-03-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-300x162.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:162;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-768x413.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:413;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-800x431.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:431;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-item\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-230x160.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"list-blog\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-230x135.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-one\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"blok-tow\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-290x192.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"top-post\";a:4:{s:4:\"file\";s:37:\"Placko-new-building-plan-03-77x55.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"spical-post\";a:4:{s:4:\"file\";s:38:\"Placko-new-building-plan-03-130x95.jpg\";s:5:\"width\";i:130;s:6:\"height\";i:95;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"flexslider\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-410x265.jpg\";s:5:\"width\";i:410;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"scroll-box\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"single-thumb\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-610x400.jpg\";s:5:\"width\";i:610;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_1\";a:4:{s:4:\"file\";s:37:\"Placko-new-building-plan-03-93x68.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_2\";a:4:{s:4:\"file\";s:37:\"Placko-new-building-plan-03-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_3\";a:4:{s:4:\"file\";s:38:\"Placko-new-building-plan-03-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_4\";a:4:{s:4:\"file\";s:37:\"Placko-new-building-plan-03-65x55.jpg\";s:5:\"width\";i:65;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"post_author_5\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-310x210.jpg\";s:5:\"width\";i:310;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post_newspaper\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-330x270.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"videoItem-big\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"gallery-slider\";a:4:{s:4:\"file\";s:40:\"Placko-new-building-plan-03-1170x620.jpg\";s:5:\"width\";i:1170;s:6:\"height\";i:620;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-gallery\";a:4:{s:4:\"file\";s:39:\"Placko-new-building-plan-03-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}"),
("1286","345","_wp_attached_file","2019/08/logo2.png"),
("1268","57","_wp_old_slug","%d8%a8%d8%b1%d8%b1%d8%b3%db%8c-%d8%ac%d8%b2%d8%a6%db%8c%d8%a7%d8%aa-%d8%a7%d8%ac%d8%b1%d8%a7%db%8c-%d8%b1%d8%a7%d9%87%e2%80%8c%d8%a2%d9%87%d9%86-%d8%b3%d8%b1%db%8c%d8%b9%e2%80%8c%d8%a7%d9%84%d8%b3"),
("1281","344","_wp_attached_file","2018/03/6.jpg"),
("1282","344","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1068;s:6:\"height\";i:1464;s:4:\"file\";s:13:\"2018/03/6.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:12:\"6-100x70.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"6-182x250.jpg\";s:5:\"width\";i:182;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:14:\"6-768x1053.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1053;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:13:\"6-438x600.jpg\";s:5:\"width\";i:438;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:4:\"blok\";a:4:{s:4:\"file\";s:13:\"6-330x230.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:3:\"box\";a:4:{s:4:\"file\";s:13:\"6-222x147.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:4:\"post\";a:4:{s:4:\"file\";s:12:\"6-105x85.jpg\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"Item-big\";a:4:{s:4:\"file\";s:13:\"6-490x320.jpg\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:13:\"6-145x100.jpg\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:13:\"6-700x490.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:490;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"gallery-slider\";a:4:{s:4:\"file\";s:14:\"6-1068x620.jpg\";s:5:\"width\";i:1068;s:6:\"height\";i:620;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:13:\"6-360x250.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"flexsbig\";a:4:{s:4:\"file\";s:13:\"6-420x510.jpg\";s:5:\"width\";i:420;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:38:\"دیدار اساتید دانشگاه\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:9:\"Leader.ir\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:38:\"دیدار اساتید دانشگاه\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:1:{i:0;s:10:\"1396/03/31\";}}}"),
("1283","1","_thumbnail_id","344"),
("1272","1","_wp_old_slug","%d8%b3%d9%84%d8%a7%d9%85-%d8%af%d9%86%db%8c%d8%a7"),
("1287","345","_wp_attachment_metadata","a:5:{s:5:\"width\";i:567;s:6:\"height\";i:647;s:4:\"file\";s:17:\"2019/08/logo2.png\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"logo2-100x70.png\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"logo2-219x250.png\";s:5:\"width\";i:219;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:17:\"logo2-526x600.png\";s:5:\"width\";i:526;s:6:\"height\";i:600;s:9:\"mime-type\";s:9:\"image/png\";}s:4:\"blok\";a:4:{s:4:\"file\";s:17:\"logo2-330x230.png\";s:5:\"width\";i:330;s:6:\"height\";i:230;s:9:\"mime-type\";s:9:\"image/png\";}s:3:\"box\";a:4:{s:4:\"file\";s:17:\"logo2-222x147.png\";s:5:\"width\";i:222;s:6:\"height\";i:147;s:9:\"mime-type\";s:9:\"image/png\";}s:4:\"post\";a:4:{s:4:\"file\";s:16:\"logo2-105x85.png\";s:5:\"width\";i:105;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"Item-big\";a:4:{s:4:\"file\";s:17:\"logo2-490x320.png\";s:5:\"width\";i:490;s:6:\"height\";i:320;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"videoItem\";a:4:{s:4:\"file\";s:17:\"logo2-145x100.png\";s:5:\"width\";i:145;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"mediaItem\";a:4:{s:4:\"file\";s:17:\"logo2-567x490.png\";s:5:\"width\";i:567;s:6:\"height\";i:490;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"gallery-slider\";a:4:{s:4:\"file\";s:17:\"logo2-567x620.png\";s:5:\"width\";i:567;s:6:\"height\";i:620;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:17:\"logo2-360x250.png\";s:5:\"width\";i:360;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"flexsbig\";a:4:{s:4:\"file\";s:17:\"logo2-420x510.png\";s:5:\"width\";i:420;s:6:\"height\";i:510;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("1317","351","_menu_item_url","http://islamic.demo-qaleb.ir/wp-content/uploads/2019/08/sliderm.html"),
("1319","352","_menu_item_type","custom"),
("1320","352","_menu_item_menu_item_parent","0"),
("1321","352","_menu_item_object_id","352"),
("1322","352","_menu_item_object","custom"),
("1323","352","_menu_item_target",""),
("1324","352","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("1325","352","_menu_item_xfn",""),
("1326","352","_menu_item_url","http://islamic.demo-qaleb.ir/"),
("1327","352","_menu_item_orphaned","1564829820"),
("1328","353","_menu_item_type","custom"),
("1329","353","_menu_item_menu_item_parent","349"),
("1330","353","_menu_item_object_id","353"),
("1331","353","_menu_item_object","custom"),
("1332","353","_menu_item_target",""),
("1333","353","_menu_item_classes","a:1:{i:0;s:0:\"\";}"),
("1334","353","_menu_item_xfn",""),
("1335","353","_menu_item_url","http://islamic.demo-qaleb.ir/"),
("1361","294","post_views_count","0"),
("1363","90","post_views_count","0"),
("1364","130","post_views_count","0"),
("1365","117","post_views_count","0"),
("1366","120","post_views_count","0"),
("1371","377","_form","<label> Your name\n    [text* your-name] </label>\n\n<label> Your email\n    [email* your-email] </label>\n\n<label> موضوع\n    [text* your-subject] </label>\n\n<label> Your message (optional)\n    [textarea your-message] </label>\n\n[submit \"Submit\"]"),
("1372","377","_mail","a:8:{s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:47:\"[_site_title] <wordpress@islamic.demo-qaleb.ir>\";s:4:\"body\";s:203:\"از : [your-name] <[your-email]>\nموضوع: [your-subject]\n\nمحتوای پیام :\n[your-message]\n\n-- \nاین ایمیل از فرم تماس در [_site_title] ([_site_url]) ارسال شده است.\";s:9:\"recipient\";s:19:\"[_site_admin_email]\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}"),
("1373","377","_mail_2","a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:47:\"[_site_title] <wordpress@islamic.demo-qaleb.ir>\";s:4:\"body\";s:141:\"محتوای پیام :\n[your-message]\n\n-- \nاین ایمیل از فرم تماس در [_site_title] ([_site_url]) ارسال شده است.\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:29:\"Reply-To: [_site_admin_email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}"),
("1374","377","_messages","a:12:{s:12:\"mail_sent_ok\";s:88:\"از پیام شما متشکریم، پیام شما با موفقیت ارسال شد.\";s:12:\"mail_sent_ng\";s:112:\"مشکلی در ارسال پیام شما بوجود آمده است، لطفا دوباره تلاش کنید.\";s:16:\"validation_error\";s:137:\"یک یا چند تا از مقادیر وارد شده مشکل دارد، لطفا پس از بررسی دوباره تلاش کنید.\";s:4:\"spam\";s:112:\"مشکلی در ارسال پیام شما بوجود آمده است، لطفا دوباره تلاش کنید.\";s:12:\"accept_terms\";s:120:\"شما باید با شرایط و قوانین موافقت کنید تا قادر به ارسال پیام باشید.\";s:16:\"invalid_required\";s:50:\"پر کردن این قسمت اجباری است.\";s:16:\"invalid_too_long\";s:47:\"مقدار وارد شده طولانی است.\";s:17:\"invalid_too_short\";s:45:\"مقدار وارد شده کوتاه است.\";s:13:\"upload_failed\";s:64:\"مشکلی در آپلود فایل شما رخ داده است.\";s:24:\"upload_file_type_invalid\";s:79:\"شما اجازه ندارید از این نوع فایل آپلود کنید.\";s:21:\"upload_file_too_large\";s:50:\"حجم فایل شما بسیار زیاد است.\";s:23:\"upload_failed_php_error\";s:64:\"مشکلی در آپلود فایل شما رخ داده است.\";}"),
("1375","377","_additional_settings",NULL),
("1376","377","_locale","fa_IR");


/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES 
("1","2","2018-03-29 19:12:26","2018-03-29 15:42:26","<p dir=\"RTL\">جمعی از دانشجویان عصر امروز با حضور در حسینیه امام خمینی (ره) با رهبر معظم انقلاب دیدار کردند.</p>\r\n<p dir=\"RTL\">علیرضا شریفی، از دانشجویان بسیجی به نمایندگی از بسیج دانشجویی در این نشست سخنانی را مطرح کرد.</p>\r\n<p dir=\"RTL\">وی در بخشی از سخنان خود اظهار داشت: امروز که در پنجمین دهه از عمر پر برکت انقلاب اسلامی به مدد حضرت ولی عصر (عج) و هدایت حکیمانه امام(ره) و رهبری مدبرانه حضرتعالی گام اول انقلاب که ترجمان جامع «ما می‌توانیم» بود، محقق شد، لیکن وجود مواردی اعم از نفوذ خوی اشرافیت و کاخ نشینی، نبود شفافیت و پاسخگویی در عملکرد‌ها، مرعوبیت و عدم مرزبندی برخی از مسئولان در برابر دشمن، در برهه‌هایی از این زمان چهل ساله باعث تلخی کام مردم عزیز ایران اسلامی شد.</p>\r\nاین فعال دانشجویی با بیان اینکه اعتقاد ما این است که در طول این سال‌ها اگر قصوری دیده شد، به علت دوری و فاصله گرفتن کارگزاران نظام از آرمان‌های انقلاب بود و هر کجا که شاهد رشد، پیشرفت و اعتلای نظام و مردم بوده ایم، آن زمانی بوده است که مسئولین کشور با روحیه جهادی و انقلابی عامل به ارزش ها، اصول، آرمان‌ها و منویات امام و رهبری عزیز بودند، تصریح کرد: حال در ابتدای گام دوم انقلاب به عنوان افسران جوان جنگ نرم برآن شدیم نکاتی را با امام و ولی زمانمان در میان گذاریم تا ضمن بهره مندی از رهنمود‌های حکیمانه و هدایتگرانه شما، بتوانیم نقش و جایگاه خود را در مسیر رسیدن به تمدن نوین اسلامی بیش از پیش فهم کنیم.\r\n\r\nشریفی افزود: در گام اول انقلاب که گام طراحی و ایجاد بستر‌های حکمرانی اسلامی بود، دانشگاه و دانشجو، به عنوان مبدا و محور تحولات در جامعه به ایفای نقش پرداختند.اکنون و در گام دوم و با توجه به پر رنگ بودن جایگاه نسل جوان در این مرحله، فرزندان بسیجی رهبر انقلاب در دانشگاه‌های سراسر کشور به عنوان مروجان حقیقت «نظام انقلابی» همت بر آن شده و دارند که با نگاهی تحولی و رویکردی مساله محور، مبتنی بر آرمان‌ها و واقعیت ها، نیاز‌های روز جامعه را از دریچه نگاه مردم دنبال و مطالبه کنند. از همین رو فرزندانتان، آمادگی کامل خود را جهت نظریه پردازی، طراحی الگو‌های ایجابی و تربیت نیرو‌های ملتزم در مسیر جوان سازی و مردمی سازی حکمرانی اعلام می‌دارند.\r\n\r\nنماینده بسیج دانشجوی با بیان اینکه در شرایط جنگ اقتصادی، تبیین و به کارگیری نظریه مقاومت در حوزه اقتصاد، ضرورتی اجتناب ناپذیر است، ادامه داد: اما امروز و در این جنگ اقتصادی آرایش جنگی متناسب از دولت مردان دیده نمی‌شود، چرا که عدم توانمندی در کنترل بازار، وجود احتکار، فعالیت شبکه خزنده اخلال گران اقتصادی و گرانی‌های افسار گسیخته موجب شده معیشت مردم به گروگان ناکارآمدی مسئولین درآید.\r\n\r\nوی تاکید کرد: در شرایطی که با برخی اقدامات مشخص مانند رشد صادرات فرآورده‌های نفتی و محصولات غیر نفتی، اتکای بودجه داخلی به مالیات و انجام طرح‌های معطل مانده نظیر مالیات بر عایدی سرمایه، مالیات بر مسکن خالی، مالیات برخی اقشار نظیر پزشکان و وکلا و یا با برقراری سامانه‌های مولد شفافیت، می‌توان با بسیاری از ناکارآمدی‌ها و سرچشمه‌های فساد مبارزه کرد. البته در این کشاکش صدایی از بهارستان به گوش نمی‌رسد. به نظر می‌آید نمایندگان نیز در حال گرفتن آرایش جنگی اند؛ اما خدا می‌داند انتخاباتی یا اقتصادی؟!\r\n\r\nاین دانشجوی بسیجی به نقش قوه قضائیه نیز در این بین اشاره کرد و گفت: از طرفی نقش قوه قضاییه به عنوان نظام قضایی که باید انقلابی باشد، در مسیر رسیدن به تمدن نوین اسلامی بسیار برجسته است. قوه عدلیه به عنوان نماد کارآمدی نظام اسلامی در برقراری عدالت و احقاق حقوق عامه در کنار برخورد قاطع با اهمال کاران و زالو صفتان اقتصادی بیشتر از قبل باید به مقوله ایجادِ ساز و کار‌های پیشگیری از جرائم و مفاسد کلان بپردازد.\r\n\r\nوی اضافه کرد: اینکه قوه محترم، دادگاه‌های علنی برپا دارد و با مجرمین با شدت برخورد کند خوب است، اما آنچه بهتر است حضور فعال دستگاه قضا در عرصه ایجاد نرم افزار‌های قدرتمند نظارت و پیشگیری است که بسیاری از مفاسد اقتصادی و اداری فعلی می توانند قبل از اینکه در رسانه‌ها و دادگاه‌ها آینه دق شوند و در مقابل چشمان مردم قرار بگیرند، پشت سدی از ساز و کار‌های دقیق بمانند و اساسا مبادی فساد زایی وجود نداشته باشد که محل سواستفاده فرصت طلبان شود.\r\n\r\nاین فعال دانشجویی با اشاره به اینکه امروز با نگاه کلان نسبت به معضلات نظام در می‌یابیم عمده آن‌ها ناشی از عدم انطباق قوانین و مصوبات با سیاست‌های کلی نظام است، یادآور شد:  نمونه‌های مختلفی نظیر قانون مدیریت خدمات کشوری، CFT و پالرمو نشان از عدم تطبیق قوانین مصوب مجلس با سیاست‌های کلی نظام دارد. با تدبیر حضرتعالی هیئت عالی نظارت مجمع تشخیص مصلحت برای رفع این معضل شکل گرفت، اما بعضی کج‌اندیشان درتلاشند این هیئت را غیرقانونی و صرفا مشورتی جلوه دهند، در حالیکه نظارت بر حسن اجرای سیاست‌های کلی نظام جزئی از اختیارات مصرح رهبری در اصل110  قانون اساسی است که به این هیئت تفویض شده است. از این رو از حضرتعالی درخواست می‌کنیم با عنایت به اختیارات قانونیتان در قانون اساسی، در صورت صلاحدید به عنوان فصل الخطاب به این مسئله بپردازید تا یکبار برای همیشه، تکلیف همگان در این زمینه روشن گردد.\r\n\r\nنماینده بسیج دانشجویی به لزوم تفکیک ریاست دو شورای عالی فضای مجازی و انقلاب فرهنگی از ریاست جمهوری اشاره کرد و گفت: حضرت آقا؛ در عرصه مقابله با جنگ نرم دشمن و تهاجم فرهنگی غرب بنظر می‌رسد بخشی از ناکارآمدی‌ها و عقب‌ماندگی‌های موجود، ناشی از ضعف ساختار اداره دو شورای عالی فضای مجازی و انقلاب فرهنگی است.\r\n\r\nوی تصریح کرد: چنانچه تفکیک ریاست مجمع تشخیص مصلحت نظام از جایگاه ریاست جمهوری سبب کارآمدی و ارتقاء جایگاه مجمع تشخیص شد، حال این پیشنهاد قابل بررسی است که به دلیل مشغله رؤسای دولت‌ها به امر مدیریت اجرایی که به کاهش کمی و کیفی جلسات این دو شورا انجامیده و هم‌چنین نیاز به سیاست‌گذاری یکپارچه و غیرجناحی نظام در مسائل فرهنگی و جنگ رسانه‌ای، تفکیک ریاست این دو شورای عالی از جایگاه ریاست جمهوری و انتصاب رؤسای مستقل از رؤسای قوا می‌تواند یک اقدام مؤثر برای نزدیک شدن خروجی سیاست‌گذاری این دو شورا به اهداف عالیه آن‌ها گردد؛ البته حضور مستمر رؤسای قوا و مسئولین اجرایی و تقنینی برای ضمانت هماهنگی اجرایی امور قطعا مورد تأکید است.\r\n\r\nشریفی در ادامه سخنان خود خطاب به رهبر انقلاب اظهار داشت: موارد فوق به این سوال مشخص منتهی می‌شود که چه میزان از مشکلات و مسائل کشور ناظر بر کارگزاران و مسئولین است و چه مقدار منتهی به ناکارآمدی برخی ساز و کار‌ها و ساختار‌ها؟! خوشحال می‌شویم که بدانیم در نگاه معظم له اشکالات امروز کشور و خاصتاً نظام سیاسی، اداری و اقتصادی را ناظر بر کارگزار می‌دانید و یا ساختار؟!","لزوم تفکیک ریاست شورای فضای مجازی و شورای انقلاب فرهنگی","","publish","open","open","","%d9%84%d8%b2%d9%88%d9%85-%d8%aa%d9%81%da%a9%db%8c%da%a9-%d8%b1%db%8c%d8%a7%d8%b3%d8%aa-%d8%b4%d9%88%d8%b1%d8%a7%db%8c-%d9%81%d8%b6%d8%a7%db%8c-%d9%85%d8%ac%d8%a7%d8%b2%db%8c-%d9%88-%d8%b4%d9%88%d8%b1","","","2019-08-03 13:29:51","2019-08-03 08:59:51","","0","http://islamic.demo-qaleb.ir/?p=1","0","post","","2"),
("2","2","2018-03-29 19:12:26","2018-03-29 15:42:26","این یک برگه‌ی نمونه است که با یک نوشته در وبلاگ تفاوت دارد زیرا برگه‌ها در یک مکان ثابت می‌مانند و معمولاً در فهرست پیوندهای درونی سایت شما نمایش داده می‌شوند (در بیشتر پوسته‌ها). بیشتر افراد کار کردن با برگه‌ها را از یک برگه‌ی «درباره من» که آن‌ها را به خوانندگان سایت معرفی می‌کند، شروع می‌کنند. برای مثال این‌چنین می‌گویند:\r\n<blockquote>سلام دوستان، من روزها یک کارمند اداری هستم و شب‌ها یک راننده تاکسی، این وبلاگ من است. من در اهواز زندگی می‌کنم که شهری در جنوب غربی ایران است.</blockquote>\r\nیا چیزی شبیه این:\r\n<blockquote>شرکت XYZ در سال ۱۳۶۵ تاسیس شد و ارائه‌دهنده محصولات صنعتی است. این شرکت ۲۰۰۰ کارگر و کارمند دارد. امیدواریم از محصولات ما راضی باشید.</blockquote>\r\nبه‌عنوان یک کاربر تازه‌ی وردپرس فارسی شما برای پاک کردن این برگه و ساختن برگه‌های تازه می‌توانید به پیشخوان خود مراجعه کنید. موفق باشید!","تماس با ما","","publish","closed","open","","cunect","","","2018-11-27 07:48:29","2018-11-27 04:18:29","","0","http://islamic.demo-qaleb.ir/?page_id=2","0","page","","0"),
("241","1","2018-04-19 10:11:29","2018-04-19 05:41:29","","139511221805479359973314","","inherit","open","closed","","139511221805479359973314","","","2018-04-19 10:11:29","2018-04-19 05:41:29","","0","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/04/139511221805479359973314.jpg","0","attachment","image/jpeg","0"),
("4","1","2018-03-29 19:29:16","2018-03-29 15:59:16","<span class=\"intro-text\">سرمربی تیم فوتبال استقلال با بیان اینکه می‌توانستیم در نیمه اول بازی با نفت تهران برنده باشیم، گفت: بر خلاف نظر کارلوس کی‌روش بازیکنان استقلال برای جام جهانی آماده هستند.</span>\n<div class=\"full-text\">\n\nبه گزارش خبرنگار مهر، وینفرد شفر بعد از پایان بازی استقلال و نفت تهران گفت: می توانستیم در همان نیمه اول برنده بازی باشیم. نمی خواستم در نیمه دوم ابراهیمی و غفوری را بیاورم ولی اگر آنها نمی آمدند شاید برنده نمی شدیم.\n\nوی افزود: تیم ما شخصیت تیمی خوبی دارد. به بازیکنانم تبریک می گویم. امیدوارم بازیکنان ما مصدوم نباشند. باید شرایط ملی پوشان را بررسی کنم. آنها مقابل تونس و الجزایر همراه تیم ملی بودند و شب گذشته به ایران بازگشتند. مسئولیت بازیکنان با من است و نمی دانم این چه شرایطی است.\n\nسرمربی استقلال تاکید کرد: شما دیدید که دو بازیکن ملی پوش ما چه عملکرد خوبی داشتند. روز گذشته در نشست خبری گفتم بازیکنان ما بسیار آماده اند.\n\nشفر درباره اینکه آیا بر خلاف نظر کارلوس کی روش بازیکنانش برای جام جهانی هم آماده هستند؟ تاکید کرد: بله، روزبه ۹۰ دقیقه بدون اشتباه بازی کرد. امید و وریا عملکرد خوبی داشتند. آنها از هر نظر آماده هستند. هر دو بازی تیم ملی مقابل تونس و الجزایر را تماشا کردم. حتی بازیکنانی که خارج از ایران بازی می کنند، در باشگاه های خودشان ۹۰ دقیقه بازی نمی کنند.\n\nسرمربی استقلال همچنین در نشست خبری حاضر شد و در جمع خبرنگاران گفت: بابت نیمه دوم خوشحالم. ما نیمه اول فرصت داشتیم تا بازی یک بر صفر، دو بر صفر و حتی سه بر صفر کنیم. اگر هر دفعه بخواهیم اشتباهات مشابه را تکرار کنیم نمی توانیم به گل برسیم. بعد از نیمه اول خیلی بلند با بازیکنانم صحبت کردم. به آنها گفتم که باید در نیمه دوم همه شخصیت تیمی ما را ببینند. نمی خواستم ملی پوشانم را به بازی ببرم چون خیلی خسته بودند ولی از دو نفر از آنها استفاده کردم. بازیکنان ملی پوش ما نشان دادند چقدر خوب و با شخصیت هستند. من این را راجع به ملی پوشان خودمان می گویم چون من سرمربی استقلال هستم. همه دیدند که ملی پوشان ما چقدر خوب کار کردند.\n\nوی درباره تغییر استقلال با حضور ملی پوشان اظهار کرد: در نیمه اول جابر و قربانی فرصت های خوبی داشتند. من اگر مهاجم باشم زندگی ام را می گذارم برای زدن ضربه آخر تا توپ گل شود. در نیمه دوم نمی خواستم ابراهیمی را بازی دهم چون بازی کرده بود ولی بدون او و وریا نمی توانستیم برنده شویم. باید تبریک هم بگویم به حیدری که خیلی خوب فشار آورد و استارت زد. بازیکنان ما برای جام جهانی و تورنمنت های بزرگ آماده هستند. نظم و ذهنیت آنها آماده است. بازیکنان می توانند در جام جهانی خیلی خوب کار کنند.\n\nشفر درباره بازی با الریان قطر در لیگ قهرمانان آسیا بیان کرد: فردا راجع به این بازی می توان صحبت کرد. باید بازی به بازی تمرکز کنیم. باید ببینیم وضعیت باقری چگونه است. شاید تیام بتواند بازی کند. باید ببینیم فردا به چه شکلی خواهد بود. باید با بازیکنان صحبت کنیم و ببینیم شرایطمان چگونه است. بردن و پیروزی ما برای بازیکنان خیلی مهم است. آنها می توانند نتیجه بازی را عوض کنند و می شود این روحیه را در بازی با الریان هم حفظ کنیم.\n\nاو در پایان در پاسخ به این سوال که چرا به داور معترض بود، گفت: عصبانیت ما درباره داور نبود. از بازیکنان خودمان عصبی بودم. باید بر می گشتند ولی بر نمی گشتند. شاید داور فکر می کرد دارم با او صحبت می کنم ولی اینگونه نبود!\n\n</div>","شفر: بازیکنان ما برای جام جهانی آماده هستند","","inherit","closed","closed","","1-autosave-v1","","","2018-03-29 19:29:16","2018-03-29 15:59:16","","1","http://islamic.demo-qaleb.ir/?p=4","0","revision","","0"),
("212","1","2018-03-30 11:20:38","2018-03-30 06:50:38","","6ii","","inherit","open","closed","","6ii","","","2018-03-30 11:20:38","2018-03-30 06:50:38","","27","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/6ii.jpg","0","attachment","image/jpeg","0"),
("26","1","2018-03-29 19:53:28","2018-03-29 16:23:28","","icon","","inherit","open","closed","","icon","","","2018-03-29 19:53:28","2018-03-29 16:23:28","","0","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/icon.png","0","attachment","image/png","0"),
("27","1","2018-03-29 19:56:41","2018-03-29 16:26:41","<span class=\"intro-text\">دیدار تیم های فوتبال پرسپولیس و سایپا درشرایطی با شکست سرخپوشان به پایان رسید که شاگردان برانکو با یک تساوی می توانستند قهرمانی فصل گذشته را تکرار کنند. </span>\r\n<div class=\"full-text\">\r\n\r\nبه گزارش خبرنگار مهر، تیم فوتبال پرسپولیس در هفته بیست و ششم لیگ برتر فوتبال امروز پنجشنبه و از ساعت ۱۸:۴۵ در ورزشگاه آزادی به مصاف سایپا رفت که این بازی با نتیجه ۲ بر یک به سود سایپا به اتمام رسید. آرمان رمضانی(۲۲) و امید خالدی(۲۵) برای سایپا و علی علیپور(۷۵ - پنالتی) برای پرسپولیس گل زدند.\r\n\r\nپرسپولیس در غیاب ملی پوشانش به این مسابقه پای گذاشته بود و غیبت نفرات اصلی خودش را در نیمه اول به شدت احساس کرد.\r\n\r\nابتدا آرمان رمضانی در دقیقه ۲۲ گل اول را در صحنه ای مشکوک به آفساید برای سایپا به ثمر رساند. شاگردان برانکو که عملکرد ضعیفی در دقایق میانی نیمه اول داشتند، در دقیقه ۲۶ روی ضربه سر امید خالدی گل دوم را دریافت کردند.\r\n\r\nپرسپولیس بعد از این دو گل بر شدت حملاتش افزود. در دقیقه  ۳۰ علی علیپور با ضربه سر تیرک دروازه سایپا را به لرزه درآورد ولی موقعیت های این تیم از دست رفت تا نیمه اول با همان دو گل به پایان برسد.\r\n\r\nدر نیمه دوم سرخپوشان تلاش زیادی کردند تا گل های خورده را جبران کنند. شاگردان برانکو صاحب فرصت های زیادی هم شدند اما دفاع چند لایه سایپا اجازه رسیدن به گل را نداد تا اینکه دقیقه ۷۵ علی علیپور از روی نقطه پنالتی یکی از گل ها را جبران کرد.\r\n\r\nدر دقایق باقی مانده پرسپولیس بر فشار حملاتش اضافه کرد تا با کسب یک امتیاز قهرمانی اش را مسجل کند اما سایپایی ها اجازه باز شدن دروازه شان برای بار دوم را ندادند تا با کسب سه امتیاز ارزشمند این بازی، قهرمانی سرخپوشان را هم به تعویق بیندازند.\r\n\r\n</div>","شکست پرسپولیس برابر سایپا/ دایی اجازه نداد برانکو قهرمان شود","","publish","open","open","","%d8%b4%da%a9%d8%b3%d8%aa-%d9%be%d8%b1%d8%b3%d9%be%d9%88%d9%84%db%8c%d8%b3-%d8%a8%d8%b1%d8%a7%d8%a8%d8%b1-%d8%b3%d8%a7%db%8c%d9%be%d8%a7-%d8%af%d8%a7%db%8c%db%8c-%d8%a7%d8%ac%d8%a7%d8%b2%d9%87-%d9%86","","","2018-03-30 11:20:41","2018-03-30 06:50:41","","0","http://islamic.demo-qaleb.ir/?p=27","0","post","","0"),
("9","1","2018-03-29 19:27:33","2018-03-29 15:57:33"," ","","","publish","closed","closed","","9","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=9","6","nav_menu_item","","0"),
("10","1","2018-03-29 19:27:33","2018-03-29 15:57:33"," ","","","publish","closed","closed","","10","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","1","http://islamic.demo-qaleb.ir/?p=10","7","nav_menu_item","","0"),
("11","1","2018-03-29 19:27:33","2018-03-29 15:57:33"," ","","","publish","closed","closed","","11","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","1","http://islamic.demo-qaleb.ir/?p=11","8","nav_menu_item","","0"),
("12","1","2018-03-29 19:27:33","2018-03-29 15:57:33"," ","","","publish","closed","closed","","12","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","1","http://islamic.demo-qaleb.ir/?p=12","9","nav_menu_item","","0"),
("13","1","2018-03-29 19:27:33","2018-03-29 15:57:33"," ","","","publish","closed","closed","","13","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","1","http://islamic.demo-qaleb.ir/?p=13","10","nav_menu_item","","0"),
("14","1","2018-03-29 19:27:33","2018-03-29 15:57:33"," ","","","publish","closed","closed","","14","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","1","http://islamic.demo-qaleb.ir/?p=14","11","nav_menu_item","","0"),
("15","1","2018-03-29 19:27:33","2018-03-29 15:57:33"," ","","","publish","closed","closed","","15","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=15","14","nav_menu_item","","0"),
("16","1","2018-03-29 19:27:33","2018-03-29 15:57:33"," ","","","publish","closed","closed","","16","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=16","12","nav_menu_item","","0"),
("17","1","2018-03-29 19:27:33","2018-03-29 15:57:33"," ","","","publish","closed","closed","","17","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=17","13","nav_menu_item","","0"),
("358","2","2019-08-03 15:39:39","2019-08-03 11:09:39","","صفحه نخست 4","","publish","closed","closed","","%d8%b5%d9%81%d8%ad%d9%87-%d9%86%d8%ae%d8%b3%d8%aa-4","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=358","5","nav_menu_item","","0"),
("357","2","2019-08-03 15:39:00","2019-08-03 11:09:00","","box","","inherit","open","closed","","box","","","2019-08-03 15:39:00","2019-08-03 11:09:00","","0","http://islamic.demo-qaleb.ir/wp-content/uploads/2019/08/box.html","0","attachment","text/html","0"),
("23","1","2018-03-29 19:28:14","2018-03-29 15:58:14","به وردپرس فارسی خوش آمدید.‌ این نخستین نوشته‌‌ی شماست. می‌توانید ویرایش یا پاکش کنید و پس از آن نوشتن را آغاز کنید!","شفر: بازیکنان ما برای جام جهانی آماده هستند","","inherit","closed","closed","","1-revision-v1","","","2018-03-29 19:28:14","2018-03-29 15:58:14","","1","http://islamic.demo-qaleb.ir/?p=23","0","revision","","0"),
("213","1","2018-03-30 11:21:00","2018-03-30 06:51:00","","9876","","inherit","open","closed","","9876-2","","","2018-03-30 11:21:00","2018-03-30 06:51:00","","1","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/9876-1.jpg","0","attachment","image/jpeg","0"),
("25","1","2018-03-29 19:29:54","2018-03-29 15:59:54","<span class=\"intro-text\">سرمربی تیم فوتبال استقلال با بیان اینکه می‌توانستیم در نیمه اول بازی با نفت تهران برنده باشیم، گفت: بر خلاف نظر کارلوس کی‌روش بازیکنان استقلال برای جام جهانی آماده هستند.</span>\r\n<div class=\"full-text\">\r\n\r\nبه گزارش خبرنگار مهر، وینفرد شفر بعد از پایان بازی استقلال و نفت تهران گفت: می توانستیم در همان نیمه اول برنده بازی باشیم. نمی خواستم در نیمه دوم ابراهیمی و غفوری را بیاورم ولی اگر آنها نمی آمدند شاید برنده نمی شدیم.\r\n\r\nوی افزود: تیم ما شخصیت تیمی خوبی دارد. به بازیکنانم تبریک می گویم. امیدوارم بازیکنان ما مصدوم نباشند. باید شرایط ملی پوشان را بررسی کنم. آنها مقابل تونس و الجزایر همراه تیم ملی بودند و شب گذشته به ایران بازگشتند. مسئولیت بازیکنان با من است و نمی دانم این چه شرایطی است.\r\n\r\nسرمربی استقلال تاکید کرد: شما دیدید که دو بازیکن ملی پوش ما چه عملکرد خوبی داشتند. روز گذشته در نشست خبری گفتم بازیکنان ما بسیار آماده اند.\r\n\r\nشفر درباره اینکه آیا بر خلاف نظر کارلوس کی روش بازیکنانش برای جام جهانی هم آماده هستند؟ تاکید کرد: بله، روزبه ۹۰ دقیقه بدون اشتباه بازی کرد. امید و وریا عملکرد خوبی داشتند. آنها از هر نظر آماده هستند. هر دو بازی تیم ملی مقابل تونس و الجزایر را تماشا کردم. حتی بازیکنانی که خارج از ایران بازی می کنند، در باشگاه های خودشان ۹۰ دقیقه بازی نمی کنند.\r\n\r\nسرمربی استقلال همچنین در نشست خبری حاضر شد و در جمع خبرنگاران گفت: بابت نیمه دوم خوشحالم. ما نیمه اول فرصت داشتیم تا بازی یک بر صفر، دو بر صفر و حتی سه بر صفر کنیم. اگر هر دفعه بخواهیم اشتباهات مشابه را تکرار کنیم نمی توانیم به گل برسیم. بعد از نیمه اول خیلی بلند با بازیکنانم صحبت کردم. به آنها گفتم که باید در نیمه دوم همه شخصیت تیمی ما را ببینند. نمی خواستم ملی پوشانم را به بازی ببرم چون خیلی خسته بودند ولی از دو نفر از آنها استفاده کردم. بازیکنان ملی پوش ما نشان دادند چقدر خوب و با شخصیت هستند. من این را راجع به ملی پوشان خودمان می گویم چون من سرمربی استقلال هستم. همه دیدند که ملی پوشان ما چقدر خوب کار کردند.\r\n\r\nوی درباره تغییر استقلال با حضور ملی پوشان اظهار کرد: در نیمه اول جابر و قربانی فرصت های خوبی داشتند. من اگر مهاجم باشم زندگی ام را می گذارم برای زدن ضربه آخر تا توپ گل شود. در نیمه دوم نمی خواستم ابراهیمی را بازی دهم چون بازی کرده بود ولی بدون او و وریا نمی توانستیم برنده شویم. باید تبریک هم بگویم به حیدری که خیلی خوب فشار آورد و استارت زد. بازیکنان ما برای جام جهانی و تورنمنت های بزرگ آماده هستند. نظم و ذهنیت آنها آماده است. بازیکنان می توانند در جام جهانی خیلی خوب کار کنند.\r\n\r\nشفر درباره بازی با الریان قطر در لیگ قهرمانان آسیا بیان کرد: فردا راجع به این بازی می توان صحبت کرد. باید بازی به بازی تمرکز کنیم. باید ببینیم وضعیت باقری چگونه است. شاید تیام بتواند بازی کند. باید ببینیم فردا به چه شکلی خواهد بود. باید با بازیکنان صحبت کنیم و ببینیم شرایطمان چگونه است. بردن و پیروزی ما برای بازیکنان خیلی مهم است. آنها می توانند نتیجه بازی را عوض کنند و می شود این روحیه را در بازی با الریان هم حفظ کنیم.\r\n\r\nاو در پایان در پاسخ به این سوال که چرا به داور معترض بود، گفت: عصبانیت ما درباره داور نبود. از بازیکنان خودمان عصبی بودم. باید بر می گشتند ولی بر نمی گشتند. شاید داور فکر می کرد دارم با او صحبت می کنم ولی اینگونه نبود!\r\n\r\n</div>","شفر: بازیکنان ما برای جام جهانی آماده هستند","","inherit","closed","closed","","1-revision-v1","","","2018-03-29 19:29:54","2018-03-29 15:59:54","","1","http://islamic.demo-qaleb.ir/?p=25","0","revision","","0"),
("189","1","2018-03-30 09:55:41","2018-03-30 05:25:41","<div class=\"full-text\">\n\nبه گزارش خبرنگار مهر، علی اکبر ولایتی رئیس هیأت امنای دانشگاه آزاد اسلامی در نشست خبری امروز خاطر نشان کرد: روز گذشته بودجه سال ۹۷ دانشگاه آزاد در جلسه هیات امنا دانشگاه تصویب شد و ۵ درصد وابستگی بودجه دانشگاه به شهریه نسبت به سال گذشته کاهش یافت.\n\nوی با بیان اینکه در مناطق محروم افزایش شهریه نداریم، افزود: ۲ هزار میلیارد ریال از شهریه این دانشگاه به جذب هیات علمی جوان اختصاص داده  شد.\n\n<span dir=\"RTL\">ولایتی افزود: فیش های حقوقی که از مسئولین قبلی دانشگاه آزاد اعلام شد واقعیتی بود که دیگر اینگونه نیست. اکنون حقوق ها براساس‌مصوبات دولت است و میزان حقوق ها بسیار کم است.</span>\n\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد گفت: ۱۰.۵ درصد بودجه سال آینده دانشگاه آزاد به فعالیت‌های پژوهشی اختصاص می‌یابد.\n\nوی با اشاره به اختصاص ۲۰۰۰ میلیارد ریال برای جذب عضو هیأت علمی جوان در این دانشگاه افزود: کشور فارغ‌التحصیلان جوان زیادی دارد که دانشگاه آزاد برنامه دارد از این افراد استفاده کند.\n\nولایتی اظهار داشت: میزان بودجه فرهنگی دانشگاه آزاد نسبت به سال گذشته افزایش یافته که بودجه فعالیت‌های ورزشی نیز بر این اساس افزایش خواهد یافت.\n\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد خاطرنشان کرد: ۱۴ هزار نخبه جذب دانشگاه آزاد شده‌اند که از این تعداد ۶۰ درصد آنها از بدنه دانشگاه آزاد و ۴۰ درصد مربوط به دانشگاه‌های دولتی بوده است.\n\nوی گفت: فعال‌ کردن برخی از باغ‌های این دانشگاه‌ که در شهرستان‌های مختلف وجود دارد و وقف شده‌اند نیز از برنامه‌های این دانشگاه برای سال آینده است.\n\n<strong>حجم قراردادهای دانشگاه آزاد با دستگاههای اجرایی</strong>\n\nولایتی با بیان اینکه دانشگاه آزاد قراردادهای مختلفی با مؤسسات و دستگاه‌های مختلف از جمله مؤسسه استاندارد دارد، تأکید کرد: تاکنون این دانشگاه ۵۰۰ میلیارد ریال قرارداد با دستگاه‌ها و مؤسسات مختلف با محوریت اقتصاد دانش‌بنیان منعقد کرده است.\n\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد تصریح کرد: دانشگاه آزاد آزمایشگاه‌های پیشرفته بسیاری دارد که ۳۰۰ آزمایشگاه آن در مناطق مرزی وجود دارد؛ بنابراین این آزمایشگاه‌ها می‌توانند محلی برای کنترل کیفی محصولات صادراتی و وارداتی باشد.\n\nبه گفته وی، در این راستا با مؤسسه استاندارد تفاهمنامه‌ای منعقد شده است.\n\n<strong>رقم بودجه دانشگاه آزاد برای سال آینده</strong>\n\nولایتی تأکید کرد: بودجه دانشگاه آزاد برای سال ۹۷، ۷۲ هزار و ۸۰۷ میلیارد ریال است که از درآمدهای این دانشگاه تأمین می‌شود و در سال آینده وابستگی بودجه به شهریه حدود پنج درصد کاهش یافته است.\n\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد اظهار داشت: از این میزان ۶۶ هزار و ۴۶۵‌ میلیارد ریال مربوط به هزینه‌های پرسنلی و بیش از ۵۰۰۰ میلیارد ریال هزینه‌های سرمایه‌ای است.\n\nوی خاطرنشان کرد: روز گذشته خبری در برخی رسانه‌ها منتشر شد که در دوره مدیریت قبلی رئیس یک واحد به دلیل قبول نکردن ساختن یک ساختمان تغییر کرده است.\n\nولایتی ادامه داد: در دوره قبل از سوی مدیریت دانشگاه به رئیس یک واحد تکلیف شده بود که ساختمانی را بسازد که آن مدیر قبول نکرد و بنابراین وی تغییر کرد و فرد جدیدی برای این واحد انتخاب شد.\n\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد عنوان کرد: رئیس جدید واحد پذیرفت که ساختمانی را احداث کند که این ساختمان حدود ۳۰ میلیارد تومان هزینه داشته و همچنان نیز بخشی از آن بلااستفاده است.\n\nوی افزود: این موضوع در مدیریت جدید پیگیری شد و پرونده به مراجع قضایی ارسال شده است.\n\n<strong>میزان حقوق مدیران فعلی دانشگاه آزاد</strong>\n\nولایتی در خصوص حقوق مدیران فعلی دانشگاه آزاد گفت: میزان حقوق مدیران بر اساس مصوبات دولت است و هر چه دولت تعیین کرده باشد، آن میزان رعایت می‌شود، اما اکنون میزان حقوق مدیران بسیار کمتر است.\n\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد درباره شایعاتی مبنی بر استعفای فرهاد رهبر رئیس دانشگاه آزاد افزود: برخی‌ها نمی‌خواهند پیشرفت دانشگاه آزاد را ببینند؛ بنابراین این نوع شایعات را مطرح می‌کنند.\n\nوی گفت: افرادی که اکنون در رده‌های مدیریتی این دانشگاه مشغول به فعالیت هستند، افرادی باسابقه در بخش‌های مختلف جامعه از جمله آموزش عالی به شمار می‌روند؛ به طور مثال دکتر رهبر در رزومه کاری خود، ریاست سازمان برنامه و ریاست دانشگاه تهران را داشته است.\n\nولایتی تأکید کرد: همچنین دیگر مدیران این دانشگاه نیز سِمَت‌های مدیریتی در دانشگاه‌های بزرگ کشور داشته‌اند.\n\n<strong>در حال مبارزه با ولنگاری مالی هستیم</strong>\n\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد خاطرنشان کرد: با توجه به اینکه اکنون در دانشگاه آزاد به دنبال مبارزه با ولنگاری مالی، ریخت و پاش‌ها و ساخت و سازهای بی‌اثر هستیم، برخی آرزو دارند مدیریت این دانشگاه که راه دیگری را دنبال می‌کند، موفق نشود.\n\nوی ادامه داد: برخی از ساخت و سازهایی که در مدیریت قبلی این دانشگاه انجام شده، همچنان بدون کاربرد است.\n\nولایتی گفت: از ۳۱ استان کشور، مدیران ۲۱ استان این دانشگاه تغییر کردند که همه این افراد از نظر علمی و اخلاقی بسیار قابل قبول هستند.\n\n<strong>توضیح درباره اساتید دو شغله </strong>\n\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد در خصوص اساتید دوشغله نیز گفت: فردی که در دانشگاه تهران کار می‌کند و تمام‌وقت به شمار می‌رود، باید تمام فعالیت خود را معطوف به این دانشگاه کند، چرا که باید در طول ماه ۱۶۰ ساعت در دانشگاه فعالیت کند، بنابراین دیگر نمی‌تواند در مکان دیگری مشغول به فعالیت شود.\n\nوی افزود: استادی که به صورت تمام‌وقت کار می‌کند، حقوق تمام‌وقت نیز از دانشگاه دریافت می‌کند، بنابراین این افراد نمی‌توانند در مکان دیگری مشغول به فعالیت شوند و آموزش عالی کشور نیز این موضوع را تائید می‌کند.\n\nولایتی ادامه داد: برخی‌ها این موضوع را سیاسی کردند و آنها باید حساب و کتاب دریافت‌هایی که طی سال‌های قبل داشته‌اند را پَس دهند.\n\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد گفت: وقتی استادی تمام‌وقت است، نمی‌تواند دیگر در دانشگاه دیگری فعالیت کند، اما برخی‌ها به دلیل روابط غیراداری که داشتند، هفته‌ای یک یا دو روز در دانشگاه آزاد نیز درس می‌دادند.\n\nوی در خصوص بودجه فرهنگی دانشگاه آزاد افزود: این بودجه برای سال ۹۷ رشد داشته و با توجه به اینکه فعالیت‌های فرهنگی و انقلابی نیز در معاونت فرهنگی دانشگاه تعریف می‌شود، بنابراین در سال آینده به برنامه‌های فرهنگی و ارزشی و اسلامی در این دانشگاه توجه بیشتری خواهد شد.\n\nولایتی تأکید کرد: علت حضور ما در دانشگاه آزاد این است که به وظیفه ملی، دینی و انقلابی خود عمل کنیم.\n\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد عنوان کرد: دانشگاه آزاد رویکردی اسلامی و انقلابی خواهد داشت؛ همان‌گونه که طی یک سال گذشته نیز این رویکرد دنبال شده است.\n\n</div>","حقوق مدیران فعلی دانشگاه آزاد/موضوع اساتید دو شغله را سیاسی کردند","","inherit","closed","closed","","42-autosave-v1","","","2018-03-30 09:55:41","2018-03-30 05:25:41","","42","http://islamic.demo-qaleb.ir/42-autosave-v1/","0","revision","","0"),
("29","1","2018-03-29 19:56:41","2018-03-29 16:26:41","<span class=\"intro-text\">دیدار تیم های فوتبال پرسپولیس و سایپا درشرایطی با شکست سرخپوشان به پایان رسید که شاگردان برانکو با یک تساوی می توانستند قهرمانی فصل گذشته را تکرار کنند. </span>\r\n<div class=\"full-text\">\r\n\r\nبه گزارش خبرنگار مهر، تیم فوتبال پرسپولیس در هفته بیست و ششم لیگ برتر فوتبال امروز پنجشنبه و از ساعت ۱۸:۴۵ در ورزشگاه آزادی به مصاف سایپا رفت که این بازی با نتیجه ۲ بر یک به سود سایپا به اتمام رسید. آرمان رمضانی(۲۲) و امید خالدی(۲۵) برای سایپا و علی علیپور(۷۵ - پنالتی) برای پرسپولیس گل زدند.\r\n\r\nپرسپولیس در غیاب ملی پوشانش به این مسابقه پای گذاشته بود و غیبت نفرات اصلی خودش را در نیمه اول به شدت احساس کرد.\r\n\r\nابتدا آرمان رمضانی در دقیقه ۲۲ گل اول را در صحنه ای مشکوک به آفساید برای سایپا به ثمر رساند. شاگردان برانکو که عملکرد ضعیفی در دقایق میانی نیمه اول داشتند، در دقیقه ۲۶ روی ضربه سر امید خالدی گل دوم را دریافت کردند.\r\n\r\nپرسپولیس بعد از این دو گل بر شدت حملاتش افزود. در دقیقه  ۳۰ علی علیپور با ضربه سر تیرک دروازه سایپا را به لرزه درآورد ولی موقعیت های این تیم از دست رفت تا نیمه اول با همان دو گل به پایان برسد.\r\n\r\nدر نیمه دوم سرخپوشان تلاش زیادی کردند تا گل های خورده را جبران کنند. شاگردان برانکو صاحب فرصت های زیادی هم شدند اما دفاع چند لایه سایپا اجازه رسیدن به گل را نداد تا اینکه دقیقه ۷۵ علی علیپور از روی نقطه پنالتی یکی از گل ها را جبران کرد.\r\n\r\nدر دقایق باقی مانده پرسپولیس بر فشار حملاتش اضافه کرد تا با کسب یک امتیاز قهرمانی اش را مسجل کند اما سایپایی ها اجازه باز شدن دروازه شان برای بار دوم را ندادند تا با کسب سه امتیاز ارزشمند این بازی، قهرمانی سرخپوشان را هم به تعویق بیندازند.\r\n\r\n</div>","شکست پرسپولیس برابر سایپا/ دایی اجازه نداد برانکو قهرمان شود","","inherit","closed","closed","","27-revision-v1","","","2018-03-29 19:56:41","2018-03-29 16:26:41","","27","http://islamic.demo-qaleb.ir/?p=29","0","revision","","0"),
("30","1","2018-03-29 19:58:52","2018-03-29 16:28:52","<span class=\"intro-text\">اراک- فرمانده انتظامی استان مرکزی گفت: طی سال ۹۶ حدود ۷.۵ تن انواع مواد مخدر در استان مرکزی توسط پلیس کشف و توقیف شده است.</span>\r\n<div class=\"full-text\">\r\n\r\nسردار کیومرث عزیزی روز پنجشنبه در گفت و گو با خبرنگار مهر اظهار داشت: هفت هزار و ۴۲۳ کیلوگرم انواع مواد مخدر طی سال گذشته در نقاط مختلف استان مرکزی توسط نیروهای انتظامی از قاچاقچیان و یا خرده فروشان مواد مخدر و معتادان کشف و توقیف شده است.\r\n\r\nفرمانده انتظامی استان مرکزی افزود: طی مدت ذکرشده ۳۱ باند قاچاق مواد مخدر نیز در استان مرکزی توسط پلیس شناسایی و مورد تعقیب قرار گرفته و منهدم شده است.\r\n\r\nعزیزی بیان کرد: همچنین در جریان فعالیت های پلیس استان مرکزی در مقابله با مواد مخدر طی سال ۹۶، بیش از ۱۴ هزار نفر قاچاقچی، توزیع کننده و خرده فروش و همچنین مصرف کننده مواد مخدر در این استان دستگیر و پس از تشکیل پرونده به دست قانون سپرده شده اند.\r\n\r\nفرمانده انتظامی استان مرکزی خاطرنشان ساخت: مبارزه با قاچاق و توزیع موادمخدر از برنامه های اولویت دار ستاد فرماندهی انتظامی استان مرکزی است که همواره با جدیت و به صورت شبانه روزی دنبال می شود.\r\n\r\nوی ضمن بیان اینکه تحقق امنیت اجتماعی پایدار که در سرلوحه برنامه های نیروهای انتظامی قرار دارد، مستلزم همکاری و مشارکت از سوی آحاد جامعه است، عنوان کرد: وجود امنیت بسترساز هرگونه فعالیت دیگر در عرصه اجتماع بوده و ایجاد امنیت اجتماعی و حفظ و ارتقای آن یکی از مسئولیت های خطیر نیروی انتظامی است که با مشارکت همگانی محقق می‌شود.\r\n\r\n</div>","کشف و توقیف ۷.۵ تن مواد مخدر در استان مرکزی طی سال ۹۶","","publish","open","open","","%da%a9%d8%b4%d9%81-%d9%88-%d8%aa%d9%88%d9%82%db%8c%d9%81-%db%b7-%db%b5-%d8%aa%d9%86-%d9%85%d9%88%d8%a7%d8%af-%d9%85%d8%ae%d8%af%d8%b1-%d8%af%d8%b1-%d8%a7%d8%b3%d8%aa%d8%a7%d9%86-%d9%85%d8%b1%da%a9","","","2018-03-30 10:01:14","2018-03-30 05:31:14","","0","http://islamic.demo-qaleb.ir/?p=30","0","post","","0"),
("194","1","2018-03-30 10:01:11","2018-03-30 05:31:11","","868 (2)","","inherit","open","closed","","868-2","","","2018-03-30 10:01:11","2018-03-30 05:31:11","","30","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/868-2.jpg","0","attachment","image/jpeg","0"),
("32","1","2018-03-29 19:58:52","2018-03-29 16:28:52","<span class=\"intro-text\">اراک- فرمانده انتظامی استان مرکزی گفت: طی سال ۹۶ حدود ۷.۵ تن انواع مواد مخدر در استان مرکزی توسط پلیس کشف و توقیف شده است.</span>\r\n<div class=\"full-text\">\r\n\r\nسردار کیومرث عزیزی روز پنجشنبه در گفت و گو با خبرنگار مهر اظهار داشت: هفت هزار و ۴۲۳ کیلوگرم انواع مواد مخدر طی سال گذشته در نقاط مختلف استان مرکزی توسط نیروهای انتظامی از قاچاقچیان و یا خرده فروشان مواد مخدر و معتادان کشف و توقیف شده است.\r\n\r\nفرمانده انتظامی استان مرکزی افزود: طی مدت ذکرشده ۳۱ باند قاچاق مواد مخدر نیز در استان مرکزی توسط پلیس شناسایی و مورد تعقیب قرار گرفته و منهدم شده است.\r\n\r\nعزیزی بیان کرد: همچنین در جریان فعالیت های پلیس استان مرکزی در مقابله با مواد مخدر طی سال ۹۶، بیش از ۱۴ هزار نفر قاچاقچی، توزیع کننده و خرده فروش و همچنین مصرف کننده مواد مخدر در این استان دستگیر و پس از تشکیل پرونده به دست قانون سپرده شده اند.\r\n\r\nفرمانده انتظامی استان مرکزی خاطرنشان ساخت: مبارزه با قاچاق و توزیع موادمخدر از برنامه های اولویت دار ستاد فرماندهی انتظامی استان مرکزی است که همواره با جدیت و به صورت شبانه روزی دنبال می شود.\r\n\r\nوی ضمن بیان اینکه تحقق امنیت اجتماعی پایدار که در سرلوحه برنامه های نیروهای انتظامی قرار دارد، مستلزم همکاری و مشارکت از سوی آحاد جامعه است، عنوان کرد: وجود امنیت بسترساز هرگونه فعالیت دیگر در عرصه اجتماع بوده و ایجاد امنیت اجتماعی و حفظ و ارتقای آن یکی از مسئولیت های خطیر نیروی انتظامی است که با مشارکت همگانی محقق می‌شود.\r\n\r\n</div>","کشف و توقیف ۷.۵ تن مواد مخدر در استان مرکزی طی سال ۹۶","","inherit","closed","closed","","30-revision-v1","","","2018-03-29 19:58:52","2018-03-29 16:28:52","","30","http://islamic.demo-qaleb.ir/?p=32","0","revision","","0"),
("33","2","2018-03-29 20:01:25","2018-03-29 16:31:25","<a href=\"http://islamic.demo-qaleb.ir/\"><span style=\"color: #ff0000;\">محمد عجمی مشاور</span></a> استاندار و مدیرکل امور اتباع و مهاجرین خارجی استان خراسان رضوی در گفت و گو با خبرنگار مهر اعلام کرد: بر اساس این بند که در سال 1396 مصوب شده به اتباع خارجی که دارای کارت آمایش معتبر هستند طبق ضوابطی گواهینامه راهنمایی و رانندگی اعطا می شود.\r\n<div class=\"full-text\">\r\n\r\nوی افزود: در حال حاضر دستورالعمل اجرایی که این امر چگونه و با چه کم و کیف و به چه گروه‌هایی ارائه شود هنوز ابلاغ نشده و به محض ابلاغ آن بلافاصله اطلاع‌رسانی خواهد شد تا اتباع خارجی که با کارت آمایش معتبر مقیم ایران هستند بتوانند برای اخذ گواهینامه رانندگی اقدام کرده و تشکیل پرونده بدهند.\r\n\r\nعجمی گفت: موضوع اعطای گواهینامه رانندگی به اتباع خارجی دارای کارت آمایش معتبر در سال 1397 همچون سال گذشته توسط اداره کل اتباع وزارت کشور پیگیری خواهد شد و امیدواریم که در سال جاری نوید بخش اجرایی شدن این موضوع باشیم.\r\n\r\nمشاور استاندار خراسان رضوی خاطرنشان کرد: خروج و مراجعت اتباع خارجی دارای کارت آمایش در اواخر سال 1396 به تصویب رسیده و به دلیل پایان سال و تعطیلات نوروزی دستورالعمل اجرایی آن اعلام نشد و به محض ابلاغ جزئیات اجرای آن به استان‌ها اطلاع‌رسانی خواهد شد.\r\n\r\nمدیرکل امور اتباع خارجی خراسان رضوی در ادامه گفت: ما نیز مشتاق هستیم تا خروج و مراجعت اتباع خارجی دارای کارت آمایش در چارچوب ضوابط و مقرراتی که اعلام خواهد شد عملیاتی شود.\r\n\r\nوی تأکید کرد: موضوعات مرتبط با مهاجرین افغانستانی مقیم ایران همواره در جلسات مقامات و دیپلمات‌های دو کشور مورد بحث و تبادل نظر قرار می‌گیرد.\r\n\r\nعجمی خاطرنشان کرد: چنانچه در مذاکرات مقامات جمهوری اسلامی ایران و جمهوری اسلامی افغانستان توافقاتی انجام پذیرد توافقات به اداره کل اتباع وزارت کشور اعلام می‌شود.\r\n\r\n</div>","اعطای گواهینامه رانندگی به اتباع خارجی دارای کارت آمایش","","publish","open","open","","%d8%a7%d8%b9%d8%b7%d8%a7%db%8c-%da%af%d9%88%d8%a7%d9%87%db%8c%d9%86%d8%a7%d9%85%d9%87-%d8%b1%d8%a7%d9%86%d9%86%d8%af%da%af%db%8c-%d8%a8%d9%87-%d8%a7%d8%aa%d8%a8%d8%a7%d8%b9-%d8%ae%d8%a7%d8%b1%d8%ac","","","2020-06-22 16:42:59","2020-06-22 12:12:59","","0","http://islamic.demo-qaleb.ir/?p=33","0","post","","0"),
("190","1","2018-03-30 09:56:13","2018-03-30 05:26:13","","868","","inherit","open","closed","","868","","","2018-03-30 09:56:13","2018-03-30 05:26:13","","33","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/868.jpg","0","attachment","image/jpeg","0"),
("35","1","2018-03-29 20:01:25","2018-03-29 16:31:25","محمد عجمی مشاور استاندار و مدیرکل امور اتباع و مهاجرین خارجی استان خراسان رضوی در گفت و گو با خبرنگار مهر اعلام کرد: بر اساس این بند که در سال 1396 مصوب شده به اتباع خارجی که دارای کارت آمایش معتبر هستند طبق ضوابطی گواهینامه راهنمایی و رانندگی اعطا می شود.\r\n<div class=\"full-text\">\r\n\r\nوی افزود: در حال حاضر دستورالعمل اجرایی که این امر چگونه و با چه کم و کیف و به چه گروه‌هایی ارائه شود هنوز ابلاغ نشده و به محض ابلاغ آن بلافاصله اطلاع‌رسانی خواهد شد تا اتباع خارجی که با کارت آمایش معتبر مقیم ایران هستند بتوانند برای اخذ گواهینامه رانندگی اقدام کرده و تشکیل پرونده بدهند.\r\n\r\nعجمی گفت: موضوع اعطای گواهینامه رانندگی به اتباع خارجی دارای کارت آمایش معتبر در سال 1397 همچون سال گذشته توسط اداره کل اتباع وزارت کشور پیگیری خواهد شد و امیدواریم که در سال جاری نوید بخش اجرایی شدن این موضوع باشیم.\r\n\r\nمشاور استاندار خراسان رضوی خاطرنشان کرد: خروج و مراجعت اتباع خارجی دارای کارت آمایش در اواخر سال 1396 به تصویب رسیده و به دلیل پایان سال و تعطیلات نوروزی دستورالعمل اجرایی آن اعلام نشد و به محض ابلاغ جزئیات اجرای آن به استان‌ها اطلاع‌رسانی خواهد شد.\r\n\r\nمدیرکل امور اتباع خارجی خراسان رضوی در ادامه گفت: ما نیز مشتاق هستیم تا خروج و مراجعت اتباع خارجی دارای کارت آمایش در چارچوب ضوابط و مقرراتی که اعلام خواهد شد عملیاتی شود.\r\n\r\nوی تأکید کرد: موضوعات مرتبط با مهاجرین افغانستانی مقیم ایران همواره در جلسات مقامات و دیپلمات‌های دو کشور مورد بحث و تبادل نظر قرار می‌گیرد.\r\n\r\nعجمی خاطرنشان کرد: چنانچه در مذاکرات مقامات جمهوری اسلامی ایران و جمهوری اسلامی افغانستان توافقاتی انجام پذیرد توافقات به اداره کل اتباع وزارت کشور اعلام می‌شود.\r\n\r\n</div>","اعطای گواهینامه رانندگی به اتباع خارجی دارای کارت آمایش","","inherit","closed","closed","","33-revision-v1","","","2018-03-29 20:01:25","2018-03-29 16:31:25","","33","http://islamic.demo-qaleb.ir/33-revision-v1/","0","revision","","0"),
("36","1","2018-03-29 20:06:42","2018-03-29 16:36:42","<div class=\"item-body\">\r\n\r\nبه گزارش خبرگزاری مهر به نقل از وزارت علوم، در این یادداشت آمده است: «بی شک تحقق چنین شعاری منجر به بی نیازی کشور به محصولات خارجی و افزایش توان داخلی خواهد شد. البته استعدادها و ظرفیت های فراوانی در کشور برای تحقق چنین امری موجود است اما هنوز نتوانسته ایم این ظرفیت ها را به حالت بالفعل درآورده و به جایگاه واقعی خود در جهان با توجه به نیروهای متخصصی که داریم برسیم.\r\n<div class=\"full-text\">\r\n\r\nهمان گونه که رهبر معظم انقلاب در سخنان خود در ابتدای سال فرمودند، یکی از مهم ترین ظرفیت های کشور، جوانان دانش آموخته و دانشجویان و دانشگاهیان کشور هستند و این جمعیت فعال و مستعد می تواند کشور را در عرصه کار و تلاش و تولید سرآمد کند.\r\n\r\nیکی از بنیان های حمایت از کالای ایرانی، تولید کالای با کیفیت و استفاده از دانش روز در عرصه تولید است که متاسفانه در سالیان گذشته نتوانسته ایم عرصه صنعتی کشور را با جامعه دانشگاهی به صورت درست و هدفمند گره بزنیم و از رهگذر آن تولید داخلی را در بازار رقابتی موفق کنیم.\r\n\r\nمگر همین دانشجویان ایرانی نیستند که وقتی به کشورهای دیگر می روند، در مهمترین صنایع آنها تولید دانش و خلاقیت می کنند و ما در واقع وارد کننده محصولات دانش آموختگان هم وطن خود می شویم، پس اعتماد و باور به جامعه دانشگاهی کشور که تاکنون آنگونه که باید محقق نشده، می تواند زمینه ساز افزایش کیفیت کالا و تولیدات داخل کشور باشد.\r\n\r\nیکی از ایرادات وارده بر دانشگاه های کشور در سال های اخیر تکیه بر علم تئوری بوده که در چندماه گذشته دو اقدام اساسی را برای رفع این ایراد انجام دادیم.\r\n\r\nطرح مهارت آموزی دانشجویان دانشگاه‌های دولتی و الزام دانشگاه ها به اجرای این طرح با هدف پرورش روحیه کارآفرینی و همچنین آموزش سربازان طی خدمت نظام با همکاری دانشگاه های فنی حرفه ای و علمی کاربردی برای نیل به همین هدف که بتوانیم دانشجویان را به بازار کار نزدیک کنیم انجام گرفت.\r\n\r\nدستگاه های دولتی و بخش خصوصی و صنعتی کشور باید به دانشگاه ها اعتماد کرده و برای افزایش اقبال مردم نسبت به کالای ایرانی کیفیت آنها را بالا ببرند و این امر مستلزم استفاده از دانش روز و توان متخصصان و دانشمندان ایرانی است و همان گونه که در دست آوردهای هسته ای با وجود تمام تحریم ها توانستیم در سایر عرصه ها نیز موفقیت دور از انتظار نیست.\r\n\r\nبارها اعلام کرده ام که دستگاه ها و سازمان های مختلف کشور خود را بی نیاز از جامعه دانشگاهی ندانند و باور داشته باشند تنها راه افزایش کیفیت محصولات و رقابت پذیر کردن آنها در عرصه داخلی و بین المللی، همکاری و همراهی با جامعه عظیم دانشگاهی کشور است.\r\n\r\nگام مهم دیگری که برای تحقق شعار سال لازم است برداشته شود اینکه بتوانیم خرید و استفاده از کالای ایرانی را به یک فرهنگ تبدیل کنیم.\r\n\r\nدر این زمینه نیز مجموعه وزارت علوم و دانشگاه های کشور می توانند پیشقدم شده و زمینه فرهنگ پذیری چنین امری در سطح جامعه را فراهم کرده و در نشست های علمی، پایان نامه ها، سمینارها، کارگاه ها و با همراهی رسانه ها خصوصاً رسانه ملی تعصب کالای ملی را در مردم بالا ببرند.\r\n\r\nامید است تا با تلاش جمعی به روزی برسیم که نه تنها مردم ایران با افتخار کالای ایرانی مصرف کنند بلکه کالای ایرانی زینت بخش ویترین بازار کشورهای خارجی باشد.»\r\n\r\n</div>\r\n</div>\r\n<div class=\"item-sharing\"></div>","نقش دانشگاه و نخبگان کشور در تحقق شعار «حمایت از کالای ایرانی»","","publish","open","open","","%d9%86%d9%82%d8%b4-%d8%af%d8%a7%d9%86%d8%b4%da%af%d8%a7%d9%87-%d9%88-%d9%86%d8%ae%d8%a8%da%af%d8%a7%d9%86-%da%a9%d8%b4%d9%88%d8%b1-%d8%af%d8%b1-%d8%aa%d8%ad%d9%82%d9%82-%d8%b4%d8%b9%d8%a7%d8%b1","","","2018-03-30 08:39:31","2018-03-30 04:09:31","","0","http://islamic.demo-qaleb.ir/?p=36","0","post","","0"),
("37","1","2018-03-29 20:06:38","2018-03-29 16:36:38","","2658388","","inherit","open","closed","","2658388","","","2018-03-29 20:06:38","2018-03-29 16:36:38","","36","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/2658388.jpg","0","attachment","image/jpeg","0"),
("185","1","2018-03-30 08:39:31","2018-03-30 04:09:31","<div class=\"item-body\">\r\n\r\nبه گزارش خبرگزاری مهر به نقل از وزارت علوم، در این یادداشت آمده است: «بی شک تحقق چنین شعاری منجر به بی نیازی کشور به محصولات خارجی و افزایش توان داخلی خواهد شد. البته استعدادها و ظرفیت های فراوانی در کشور برای تحقق چنین امری موجود است اما هنوز نتوانسته ایم این ظرفیت ها را به حالت بالفعل درآورده و به جایگاه واقعی خود در جهان با توجه به نیروهای متخصصی که داریم برسیم.\r\n<div class=\"full-text\">\r\n\r\nهمان گونه که رهبر معظم انقلاب در سخنان خود در ابتدای سال فرمودند، یکی از مهم ترین ظرفیت های کشور، جوانان دانش آموخته و دانشجویان و دانشگاهیان کشور هستند و این جمعیت فعال و مستعد می تواند کشور را در عرصه کار و تلاش و تولید سرآمد کند.\r\n\r\nیکی از بنیان های حمایت از کالای ایرانی، تولید کالای با کیفیت و استفاده از دانش روز در عرصه تولید است که متاسفانه در سالیان گذشته نتوانسته ایم عرصه صنعتی کشور را با جامعه دانشگاهی به صورت درست و هدفمند گره بزنیم و از رهگذر آن تولید داخلی را در بازار رقابتی موفق کنیم.\r\n\r\nمگر همین دانشجویان ایرانی نیستند که وقتی به کشورهای دیگر می روند، در مهمترین صنایع آنها تولید دانش و خلاقیت می کنند و ما در واقع وارد کننده محصولات دانش آموختگان هم وطن خود می شویم، پس اعتماد و باور به جامعه دانشگاهی کشور که تاکنون آنگونه که باید محقق نشده، می تواند زمینه ساز افزایش کیفیت کالا و تولیدات داخل کشور باشد.\r\n\r\nیکی از ایرادات وارده بر دانشگاه های کشور در سال های اخیر تکیه بر علم تئوری بوده که در چندماه گذشته دو اقدام اساسی را برای رفع این ایراد انجام دادیم.\r\n\r\nطرح مهارت آموزی دانشجویان دانشگاه‌های دولتی و الزام دانشگاه ها به اجرای این طرح با هدف پرورش روحیه کارآفرینی و همچنین آموزش سربازان طی خدمت نظام با همکاری دانشگاه های فنی حرفه ای و علمی کاربردی برای نیل به همین هدف که بتوانیم دانشجویان را به بازار کار نزدیک کنیم انجام گرفت.\r\n\r\nدستگاه های دولتی و بخش خصوصی و صنعتی کشور باید به دانشگاه ها اعتماد کرده و برای افزایش اقبال مردم نسبت به کالای ایرانی کیفیت آنها را بالا ببرند و این امر مستلزم استفاده از دانش روز و توان متخصصان و دانشمندان ایرانی است و همان گونه که در دست آوردهای هسته ای با وجود تمام تحریم ها توانستیم در سایر عرصه ها نیز موفقیت دور از انتظار نیست.\r\n\r\nبارها اعلام کرده ام که دستگاه ها و سازمان های مختلف کشور خود را بی نیاز از جامعه دانشگاهی ندانند و باور داشته باشند تنها راه افزایش کیفیت محصولات و رقابت پذیر کردن آنها در عرصه داخلی و بین المللی، همکاری و همراهی با جامعه عظیم دانشگاهی کشور است.\r\n\r\nگام مهم دیگری که برای تحقق شعار سال لازم است برداشته شود اینکه بتوانیم خرید و استفاده از کالای ایرانی را به یک فرهنگ تبدیل کنیم.\r\n\r\nدر این زمینه نیز مجموعه وزارت علوم و دانشگاه های کشور می توانند پیشقدم شده و زمینه فرهنگ پذیری چنین امری در سطح جامعه را فراهم کرده و در نشست های علمی، پایان نامه ها، سمینارها، کارگاه ها و با همراهی رسانه ها خصوصاً رسانه ملی تعصب کالای ملی را در مردم بالا ببرند.\r\n\r\nامید است تا با تلاش جمعی به روزی برسیم که نه تنها مردم ایران با افتخار کالای ایرانی مصرف کنند بلکه کالای ایرانی زینت بخش ویترین بازار کشورهای خارجی باشد.»\r\n\r\n</div>\r\n</div>\r\n<div class=\"item-sharing\"></div>","نقش دانشگاه و نخبگان کشور در تحقق شعار «حمایت از کالای ایرانی»","","inherit","closed","closed","","36-revision-v1","","","2018-03-30 08:39:31","2018-03-30 04:09:31","","36","http://islamic.demo-qaleb.ir/36-revision-v1/","0","revision","","0"),
("38","1","2018-03-29 20:06:42","2018-03-29 16:36:42","<div class=\"item-body\">به گزارش خبرگزاری مهر به نقل از وزارت علوم، در این یادداشت آمده است: «بی شک تحقق چنین شعاری منجر به بی نیازی کشور به محصولات خارجی و افزایش توان داخلی خواهد شد. البته استعدادها و ظرفیت های فراوانی در کشور برای تحقق چنین امری موجود است اما هنوز نتوانسته ایم این ظرفیت ها را به حالت بالفعل درآورده و به جایگاه واقعی خود در جهان با توجه به نیروهای متخصصی که داریم برسیم.\r\n<div class=\"full-text\">\r\n\r\nهمان گونه که رهبر معظم انقلاب در سخنان خود در ابتدای سال فرمودند، یکی از مهم ترین ظرفیت های کشور، جوانان دانش آموخته و دانشجویان و دانشگاهیان کشور هستند و این جمعیت فعال و مستعد می تواند کشور را در عرصه کار و تلاش و تولید سرآمد کند.\r\n\r\nیکی از بنیان های حمایت از کالای ایرانی، تولید کالای با کیفیت و استفاده از دانش روز در عرصه تولید است که متاسفانه در سالیان گذشته نتوانسته ایم عرصه صنعتی کشور را با جامعه دانشگاهی به صورت درست و هدفمند گره بزنیم و از رهگذر آن تولید داخلی را در بازار رقابتی موفق کنیم.\r\n\r\nمگر همین دانشجویان ایرانی نیستند که وقتی به کشورهای دیگر می روند، در مهمترین صنایع آنها تولید دانش و خلاقیت می کنند و ما در واقع وارد کننده محصولات دانش آموختگان هم وطن خود می شویم، پس اعتماد و باور به جامعه دانشگاهی کشور که تاکنون آنگونه که باید محقق نشده، می تواند زمینه ساز افزایش کیفیت کالا و تولیدات داخل کشور باشد.\r\n\r\nیکی از ایرادات وارده بر دانشگاه های کشور در سال های اخیر تکیه بر علم تئوری بوده که در چندماه گذشته دو اقدام اساسی را برای رفع این ایراد انجام دادیم.\r\n\r\nطرح مهارت آموزی دانشجویان دانشگاه‌های دولتی و الزام دانشگاه ها به اجرای این طرح با هدف پرورش روحیه کارآفرینی و همچنین آموزش سربازان طی خدمت نظام با همکاری دانشگاه های فنی حرفه ای و علمی کاربردی برای نیل به همین هدف که بتوانیم دانشجویان را به بازار کار نزدیک کنیم انجام گرفت.\r\n\r\nدستگاه های دولتی و بخش خصوصی و صنعتی کشور باید به دانشگاه ها اعتماد کرده و برای افزایش اقبال مردم نسبت به کالای ایرانی کیفیت آنها را بالا ببرند و این امر مستلزم استفاده از دانش روز و توان متخصصان و دانشمندان ایرانی است و همان گونه که در دست آوردهای هسته ای با وجود تمام تحریم ها توانستیم در سایر عرصه ها نیز موفقیت دور از انتظار نیست.\r\n\r\nبارها اعلام کرده ام که دستگاه ها و سازمان های مختلف کشور خود را بی نیاز از جامعه دانشگاهی ندانند و باور داشته باشند تنها راه افزایش کیفیت محصولات و رقابت پذیر کردن آنها در عرصه داخلی و بین المللی، همکاری و همراهی با جامعه عظیم دانشگاهی کشور است.\r\n\r\nگام مهم دیگری که برای تحقق شعار سال لازم است برداشته شود اینکه بتوانیم خرید و استفاده از کالای ایرانی را به یک فرهنگ تبدیل کنیم.\r\n\r\nدر این زمینه نیز مجموعه وزارت علوم و دانشگاه های کشور می توانند پیشقدم شده و زمینه فرهنگ پذیری چنین امری در سطح جامعه را فراهم کرده و در نشست های علمی، پایان نامه ها، سمینارها، کارگاه ها و با همراهی رسانه ها خصوصاً رسانه ملی تعصب کالای ملی را در مردم بالا ببرند.\r\n\r\nامید است تا با تلاش جمعی به روزی برسیم که نه تنها مردم ایران با افتخار کالای ایرانی مصرف کنند بلکه کالای ایرانی زینت بخش ویترین بازار کشورهای خارجی باشد.»\r\n\r\n</div>\r\n</div>\r\n<div class=\"item-sharing\">\r\n<div class=\"pull-left\">\r\n<div>\r\n<div class=\"a2a_kit a2a_default_style\">\r\n<div class=\"short-link-container\"></div>\r\n<div></div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"clearfix\"></div>\r\n</div>","نقش دانشگاه و نخبگان کشور در تحقق شعار «حمایت از کالای ایرانی»","","inherit","closed","closed","","36-revision-v1","","","2018-03-29 20:06:42","2018-03-29 16:36:42","","36","http://islamic.demo-qaleb.ir/36-revision-v1/","0","revision","","0"),
("39","1","2018-03-29 20:09:28","2018-03-29 16:39:28","<p dir=\"RTL\">وی با تاکید بر لزوم اصلاح فرایندها با هدف افزایش سرعت، کاهش هزینه و همچنین افزایش سطح رضایت دانشجویان، کارکنان و اعضای هیات علمی گفت: دانشگاه پیام نور در سال ۹۷ با اجرای برنامه ای منسجم و هدفمند در راستای تحقق اهداف نظام آموزش عالی و رشد و تعالی بیشتر اهتمام می ورزد<span dir=\"LTR\">.</span></p>\r\n\r\n<div class=\"full-text\">\r\n<p dir=\"RTL\"><strong>گسترش رشته های تحصیلات تکمیلی </strong></p>\r\n<p dir=\"RTL\">رئیس دانشگاه پیام نور با اشاره به مهمترین برنامه های آموزشی دانشگاه پیام نور در سال ۹۷ گفت: آمایش رشته محل ها و همچنین گسترش رشته های تحصیلات تکمیلی با تاکید بر رشته های کاربردی و مورد نیاز جامعه و رشته های میان رشته ای منطبق با ماموریت های دانشگاه قطعا یکی از مهمترین برنامه های آموزشی دانشگاه است که در سال ۹۷ با تمرکز بیشتری دنبال می شود<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>بازنگری منابع آموزشی و نیازسنجی </strong></p>\r\n<p dir=\"RTL\">وی تصحیح و بازنگری منابع آموزشی و همچنین نیازسنجی و برنامه ریزی توسعه رشته های دانشگاه را برای تحقق اهداف آموزشی ضروری دانست<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>گسترش شیوه آموزش الکترونیکی</strong></p>\r\n<p dir=\"RTL\">زمانی گسترش شیوه آموزش الکترونیکی را یکی دیگر از برنامه های مهم این دانشگاه عنوان کرد و افزود: بومی سازی و ایجاد سامانه آموزش یادگیری<span dir=\"LTR\"> (LMS) </span>جدید مطابق با نیازهای دانشگاه، افزایش ظرفیت آموزش الکترونیکی با قطب بندی جدید و ایجاد گروه های درسی و همچنین ارائه آموزش الکترونیکی برای دانشجویان مراکز بین الملل از جمله زیرساخت های لازم برای این منظور است که در سال ۹۷ تحقق خواهد یافت<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>تصویب شیوه نامه تولید محتوای الکترونیکی</strong></p>\r\n<p dir=\"RTL\">وی همچنین به تولید محتوای الکترونیکی اشاره کرد ویادآور شد: تصویب شیوه نامه تولید محتوای الکترونیکی همراه با استانداردهای تولید محتوا، طراحی و راه اندازی سامانه مدیریت محتوای الکترونیکی <span dir=\"LTR\"> LCMS)</span>، برنامه ریزی برای تولید محتوا و<span dir=\"LTR\"> Ebook </span>منابع درسی از جمله مواردی است که برای تولید محتوا و غنی سازی آن در دست انجام است<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>برگزاری تمام آزمون های دانشجویان بین الملل به صورت آنلاین</strong></p>\r\n<p dir=\"RTL\">وی با اشاره به آزمون های متمرکز در دانشگاه پیام نور گفت: برگزاری متمرکز آزمون های هر نیمسال در دانشگاه پیام نور ویژگی منحصر به فرد این دانشگاه است که تصمیم داریم در سال ۹۷ ضمن ارتقای نرم افزار طرح سئوال استادان، تمام آزمون های دانشجویان بین المللی دانشگاه به صورت آنلاین انجام شود و با افزایش آزمون های الکترونیکی برای تولید نمره سریع میزان رضایتمندی دانشجویان را نیز افزایش دهیم<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\">رئیس دانشگاه پیام نور ثبت سیستمی پروپوزال های دانشجویان مقطع تحصیلات تکمیلی، پیاده سازی و برنامه نویسی درخواست های دانشجویی در سامانه آموزشی گلستان، تغییر فرمت دانشنامه ها و تسریع در صدور دانشنامه های معوق را از دیگر برنامه های مهم آموزشی دانشگاه عنوان کرد<span dir=\"LTR\"> .</span></p>\r\n<p dir=\"RTL\"><strong>توسعه و بهسازی نشریات پژوهشی دانشگاه</strong></p>\r\n<p dir=\"RTL\">زمانی در خصوص برنامه های پژوهش و فناوری دانشگاه در سال جدید نیز گفت: توسعه و بهسازی نشریات پژوهشی دانشگاه، از اولویت های این حوزه است<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>برگزاری دومین استارت آپ تدوین محتوای دیجیتال</strong></p>\r\n<p dir=\"RTL\">وی همچنین از برگزاری دومین استارت آپ تدوین محتوای دیجیتال در اردیبهشت ۱۳۹۷ در سازمان مرکزی دانشگاه و کشور ارمنستان خبر داد و افزود: برنامه ریزی در راستای تداوم برگزاری رویدادهای استارت آپی در سطح ملی و بین المللی با هدف حمایت از ایده پردازان، نخبگان و کارآفرینان دانشگاه انجام شده است<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>راه اندازی شبکه مرکز نوآوری دانشگاه</strong></p>\r\n<p dir=\"RTL\">وی از راه اندازی شبکه مرکز نوآوری دانشگاه خبر داد و گفت: در سال ۹۷، فاز اول برای ۱۰ مرکز استان راه اندازی خواهد شد<span dir=\"LTR\"> .</span></p>\r\n<p dir=\"RTL\"><strong>راه اندازی آزمایشگاه ملی دانشگاه پیام نور</strong></p>\r\n<p dir=\"RTL\">رئیس دانشگاه پیام نور با اشاره به بررسی مقدماتی برای راه اندازی آزمایشگاه ملی دانشگاه پیام نور گفت: بررسی های مقدماتی برای تبدیل ساختار شبکه آزمایشگاه های دانشگاه پیام نور از وضعیت استانی به منطقه بر اساس اساسنامه دانشگاه و ایجاد مقدمات برای استقرار نظام ایز، HSE و استاندارد در آزمایشگاه های مرجع استان‌ها و همچنین تولید محتوای چند رسانه ای برای دروس آزمایشگاهی و کارگاهی در حال انجام است که در سال ۹۷ اجرایی خواهد شد<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>تبدیل ۴۰۰ عنوان کتب چاپی دانشگاه به نسخه همراه (موبایلی) </strong></p>\r\n<p dir=\"RTL\">زمانی با اشاره به برنامه‌ریزی برای تولید حدود ۱۰۰ تا ۱۵۰ عنوان کتاب خودآموز درسی در مدیریت تدوین و تولید محتوای آموزشی دانشگاه پیام نور گفت: تبدیل حدود ۴۰۰ عنوان کتاب از کتب چاپی دانشگاه به نسخه همراه (موبایلی) و برگزاری فراخوان هفتم تولید کتاب در صورت تصویب هیات رئیسه دانشگاه از دیگر اقداماتی است که در این زمینه در سال آینده انجام خواهد شد<span dir=\"LTR\"> .</span></p>\r\n<p dir=\"RTL\">وی ضمن تاکید بر لزوم درآمدزایی از طریق امکانات موجود در حوزه مدیریت آمار و فناوری گفت: برنامه ریزی هایی در این زمینه انجام شده است که امید است با اجرای آن در سال ۹۷ بتوانیم منابعی برای کسب درآمد دانشگاه ایجاد کنیم<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>ایجاد کتابخانه دیجیتال و نرم افزار پیام مشرق</strong></p>\r\n<p dir=\"RTL\">رئیس دانشگاه پیام نور ایجاد وب سرویس جامع بین سامانه های گلستان، کتابخانه دیجیتال و نرم افزار پیام مشرق، تاسیس و راه اندازی بخش اسناد و مدارک علمی در کتابخانه، راه اندازی بخش تصویر برداری و صحافی، ایجاد بانک اطلاعات علمی، غنی سازی منابع دیجیتال و منابع فیزیکی را از دیگر برنامه های حوزه پژوهشی دانشگاه دانست که در سال ۹۷ اجرایی خواهد شد</p>\r\n\r\n</div>","گسترش رشته های کاربردی دانشگاه پیام نور/ راه اندازی شبکه نوآوری","","publish","open","open","","%da%af%d8%b3%d8%aa%d8%b1%d8%b4-%d8%b1%d8%b4%d8%aa%d9%87-%d9%87%d8%a7%db%8c-%da%a9%d8%a7%d8%b1%d8%a8%d8%b1%d8%af%db%8c-%d8%af%d8%a7%d9%86%d8%b4%da%af%d8%a7%d9%87-%d9%be%db%8c%d8%a7%d9%85-%d9%86%d9%88","","","2018-03-29 20:09:28","2018-03-29 16:39:28","","0","http://islamic.demo-qaleb.ir/?p=39","0","post","","0"),
("40","1","2018-03-29 20:08:52","2018-03-29 16:38:52","","2184306","","inherit","open","closed","","2184306","","","2018-03-29 20:08:52","2018-03-29 16:38:52","","39","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/2184306.jpg","0","attachment","image/jpeg","0"),
("41","1","2018-03-29 20:09:28","2018-03-29 16:39:28","<p dir=\"RTL\">وی با تاکید بر لزوم اصلاح فرایندها با هدف افزایش سرعت، کاهش هزینه و همچنین افزایش سطح رضایت دانشجویان، کارکنان و اعضای هیات علمی گفت: دانشگاه پیام نور در سال ۹۷ با اجرای برنامه ای منسجم و هدفمند در راستای تحقق اهداف نظام آموزش عالی و رشد و تعالی بیشتر اهتمام می ورزد<span dir=\"LTR\">.</span></p>\r\n\r\n<div class=\"full-text\">\r\n<p dir=\"RTL\"><strong>گسترش رشته های تحصیلات تکمیلی </strong></p>\r\n<p dir=\"RTL\">رئیس دانشگاه پیام نور با اشاره به مهمترین برنامه های آموزشی دانشگاه پیام نور در سال ۹۷ گفت: آمایش رشته محل ها و همچنین گسترش رشته های تحصیلات تکمیلی با تاکید بر رشته های کاربردی و مورد نیاز جامعه و رشته های میان رشته ای منطبق با ماموریت های دانشگاه قطعا یکی از مهمترین برنامه های آموزشی دانشگاه است که در سال ۹۷ با تمرکز بیشتری دنبال می شود<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>بازنگری منابع آموزشی و نیازسنجی </strong></p>\r\n<p dir=\"RTL\">وی تصحیح و بازنگری منابع آموزشی و همچنین نیازسنجی و برنامه ریزی توسعه رشته های دانشگاه را برای تحقق اهداف آموزشی ضروری دانست<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>گسترش شیوه آموزش الکترونیکی</strong></p>\r\n<p dir=\"RTL\">زمانی گسترش شیوه آموزش الکترونیکی را یکی دیگر از برنامه های مهم این دانشگاه عنوان کرد و افزود: بومی سازی و ایجاد سامانه آموزش یادگیری<span dir=\"LTR\"> (LMS) </span>جدید مطابق با نیازهای دانشگاه، افزایش ظرفیت آموزش الکترونیکی با قطب بندی جدید و ایجاد گروه های درسی و همچنین ارائه آموزش الکترونیکی برای دانشجویان مراکز بین الملل از جمله زیرساخت های لازم برای این منظور است که در سال ۹۷ تحقق خواهد یافت<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>تصویب شیوه نامه تولید محتوای الکترونیکی</strong></p>\r\n<p dir=\"RTL\">وی همچنین به تولید محتوای الکترونیکی اشاره کرد ویادآور شد: تصویب شیوه نامه تولید محتوای الکترونیکی همراه با استانداردهای تولید محتوا، طراحی و راه اندازی سامانه مدیریت محتوای الکترونیکی <span dir=\"LTR\"> LCMS)</span>، برنامه ریزی برای تولید محتوا و<span dir=\"LTR\"> Ebook </span>منابع درسی از جمله مواردی است که برای تولید محتوا و غنی سازی آن در دست انجام است<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>برگزاری تمام آزمون های دانشجویان بین الملل به صورت آنلاین</strong></p>\r\n<p dir=\"RTL\">وی با اشاره به آزمون های متمرکز در دانشگاه پیام نور گفت: برگزاری متمرکز آزمون های هر نیمسال در دانشگاه پیام نور ویژگی منحصر به فرد این دانشگاه است که تصمیم داریم در سال ۹۷ ضمن ارتقای نرم افزار طرح سئوال استادان، تمام آزمون های دانشجویان بین المللی دانشگاه به صورت آنلاین انجام شود و با افزایش آزمون های الکترونیکی برای تولید نمره سریع میزان رضایتمندی دانشجویان را نیز افزایش دهیم<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\">رئیس دانشگاه پیام نور ثبت سیستمی پروپوزال های دانشجویان مقطع تحصیلات تکمیلی، پیاده سازی و برنامه نویسی درخواست های دانشجویی در سامانه آموزشی گلستان، تغییر فرمت دانشنامه ها و تسریع در صدور دانشنامه های معوق را از دیگر برنامه های مهم آموزشی دانشگاه عنوان کرد<span dir=\"LTR\"> .</span></p>\r\n<p dir=\"RTL\"><strong>توسعه و بهسازی نشریات پژوهشی دانشگاه</strong></p>\r\n<p dir=\"RTL\">زمانی در خصوص برنامه های پژوهش و فناوری دانشگاه در سال جدید نیز گفت: توسعه و بهسازی نشریات پژوهشی دانشگاه، از اولویت های این حوزه است<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>برگزاری دومین استارت آپ تدوین محتوای دیجیتال</strong></p>\r\n<p dir=\"RTL\">وی همچنین از برگزاری دومین استارت آپ تدوین محتوای دیجیتال در اردیبهشت ۱۳۹۷ در سازمان مرکزی دانشگاه و کشور ارمنستان خبر داد و افزود: برنامه ریزی در راستای تداوم برگزاری رویدادهای استارت آپی در سطح ملی و بین المللی با هدف حمایت از ایده پردازان، نخبگان و کارآفرینان دانشگاه انجام شده است<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>راه اندازی شبکه مرکز نوآوری دانشگاه</strong></p>\r\n<p dir=\"RTL\">وی از راه اندازی شبکه مرکز نوآوری دانشگاه خبر داد و گفت: در سال ۹۷، فاز اول برای ۱۰ مرکز استان راه اندازی خواهد شد<span dir=\"LTR\"> .</span></p>\r\n<p dir=\"RTL\"><strong>راه اندازی آزمایشگاه ملی دانشگاه پیام نور</strong></p>\r\n<p dir=\"RTL\">رئیس دانشگاه پیام نور با اشاره به بررسی مقدماتی برای راه اندازی آزمایشگاه ملی دانشگاه پیام نور گفت: بررسی های مقدماتی برای تبدیل ساختار شبکه آزمایشگاه های دانشگاه پیام نور از وضعیت استانی به منطقه بر اساس اساسنامه دانشگاه و ایجاد مقدمات برای استقرار نظام ایز، HSE و استاندارد در آزمایشگاه های مرجع استان‌ها و همچنین تولید محتوای چند رسانه ای برای دروس آزمایشگاهی و کارگاهی در حال انجام است که در سال ۹۷ اجرایی خواهد شد<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>تبدیل ۴۰۰ عنوان کتب چاپی دانشگاه به نسخه همراه (موبایلی) </strong></p>\r\n<p dir=\"RTL\">زمانی با اشاره به برنامه‌ریزی برای تولید حدود ۱۰۰ تا ۱۵۰ عنوان کتاب خودآموز درسی در مدیریت تدوین و تولید محتوای آموزشی دانشگاه پیام نور گفت: تبدیل حدود ۴۰۰ عنوان کتاب از کتب چاپی دانشگاه به نسخه همراه (موبایلی) و برگزاری فراخوان هفتم تولید کتاب در صورت تصویب هیات رئیسه دانشگاه از دیگر اقداماتی است که در این زمینه در سال آینده انجام خواهد شد<span dir=\"LTR\"> .</span></p>\r\n<p dir=\"RTL\">وی ضمن تاکید بر لزوم درآمدزایی از طریق امکانات موجود در حوزه مدیریت آمار و فناوری گفت: برنامه ریزی هایی در این زمینه انجام شده است که امید است با اجرای آن در سال ۹۷ بتوانیم منابعی برای کسب درآمد دانشگاه ایجاد کنیم<span dir=\"LTR\">.</span></p>\r\n<p dir=\"RTL\"><strong>ایجاد کتابخانه دیجیتال و نرم افزار پیام مشرق</strong></p>\r\n<p dir=\"RTL\">رئیس دانشگاه پیام نور ایجاد وب سرویس جامع بین سامانه های گلستان، کتابخانه دیجیتال و نرم افزار پیام مشرق، تاسیس و راه اندازی بخش اسناد و مدارک علمی در کتابخانه، راه اندازی بخش تصویر برداری و صحافی، ایجاد بانک اطلاعات علمی، غنی سازی منابع دیجیتال و منابع فیزیکی را از دیگر برنامه های حوزه پژوهشی دانشگاه دانست که در سال ۹۷ اجرایی خواهد شد</p>\r\n\r\n</div>","گسترش رشته های کاربردی دانشگاه پیام نور/ راه اندازی شبکه نوآوری","","inherit","closed","closed","","39-revision-v1","","","2018-03-29 20:09:28","2018-03-29 16:39:28","","39","http://islamic.demo-qaleb.ir/39-revision-v1/","0","revision","","0"),
("42","1","2018-03-29 20:13:54","2018-03-29 16:43:54","<div class=\"full-text\">\r\n\r\nبه گزارش خبرنگار مهر، علی اکبر ولایتی رئیس هیأت امنای دانشگاه آزاد اسلامی در نشست خبری امروز خاطر نشان کرد: روز گذشته بودجه سال ۹۷ دانشگاه آزاد در جلسه هیات امنا دانشگاه تصویب شد و ۵ درصد وابستگی بودجه دانشگاه به شهریه نسبت به سال گذشته کاهش یافت.\r\n\r\nوی با بیان اینکه در مناطق محروم افزایش شهریه نداریم، افزود: ۲ هزار میلیارد ریال از شهریه این دانشگاه به جذب هیات علمی جوان اختصاص داده  شد.\r\n\r\n<span dir=\"RTL\">ولایتی افزود: فیش های حقوقی که از مسئولین قبلی دانشگاه آزاد اعلام شد واقعیتی بود که دیگر اینگونه نیست. اکنون حقوق ها براساس‌مصوبات دولت است و میزان حقوق ها بسیار کم است.</span>\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد گفت: ۱۰.۵ درصد بودجه سال آینده دانشگاه آزاد به فعالیت‌های پژوهشی اختصاص می‌یابد.\r\n\r\nوی با اشاره به اختصاص ۲۰۰۰ میلیارد ریال برای جذب عضو هیأت علمی جوان در این دانشگاه افزود: کشور فارغ‌التحصیلان جوان زیادی دارد که دانشگاه آزاد برنامه دارد از این افراد استفاده کند.\r\n\r\nولایتی اظهار داشت: میزان بودجه فرهنگی دانشگاه آزاد نسبت به سال گذشته افزایش یافته که بودجه فعالیت‌های ورزشی نیز بر این اساس افزایش خواهد یافت.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد خاطرنشان کرد: ۱۴ هزار نخبه جذب دانشگاه آزاد شده‌اند که از این تعداد ۶۰ درصد آنها از بدنه دانشگاه آزاد و ۴۰ درصد مربوط به دانشگاه‌های دولتی بوده است.\r\n\r\nوی گفت: فعال‌ کردن برخی از باغ‌های این دانشگاه‌ که در شهرستان‌های مختلف وجود دارد و وقف شده‌اند نیز از برنامه‌های این دانشگاه برای سال آینده است.\r\n\r\n<strong>حجم قراردادهای دانشگاه آزاد با دستگاههای اجرایی</strong>\r\n\r\nولایتی با بیان اینکه دانشگاه آزاد قراردادهای مختلفی با مؤسسات و دستگاه‌های مختلف از جمله مؤسسه استاندارد دارد، تأکید کرد: تاکنون این دانشگاه ۵۰۰ میلیارد ریال قرارداد با دستگاه‌ها و مؤسسات مختلف با محوریت اقتصاد دانش‌بنیان منعقد کرده است.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد تصریح کرد: دانشگاه آزاد آزمایشگاه‌های پیشرفته بسیاری دارد که ۳۰۰ آزمایشگاه آن در مناطق مرزی وجود دارد؛ بنابراین این آزمایشگاه‌ها می‌توانند محلی برای کنترل کیفی محصولات صادراتی و وارداتی باشد.\r\n\r\nبه گفته وی، در این راستا با مؤسسه استاندارد تفاهمنامه‌ای منعقد شده است.\r\n\r\n<strong>رقم بودجه دانشگاه آزاد برای سال آینده</strong>\r\n\r\nولایتی تأکید کرد: بودجه دانشگاه آزاد برای سال ۹۷، ۷۲ هزار و ۸۰۷ میلیارد ریال است که از درآمدهای این دانشگاه تأمین می‌شود و در سال آینده وابستگی بودجه به شهریه حدود پنج درصد کاهش یافته است.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد اظهار داشت: از این میزان ۶۶ هزار و ۴۶۵‌ میلیارد ریال مربوط به هزینه‌های پرسنلی و بیش از ۵۰۰۰ میلیارد ریال هزینه‌های سرمایه‌ای است.\r\n\r\nوی خاطرنشان کرد: روز گذشته خبری در برخی رسانه‌ها منتشر شد که در دوره مدیریت قبلی رئیس یک واحد به دلیل قبول نکردن ساختن یک ساختمان تغییر کرده است.\r\n\r\nولایتی ادامه داد: در دوره قبل از سوی مدیریت دانشگاه به رئیس یک واحد تکلیف شده بود که ساختمانی را بسازد که آن مدیر قبول نکرد و بنابراین وی تغییر کرد و فرد جدیدی برای این واحد انتخاب شد.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد عنوان کرد: رئیس جدید واحد پذیرفت که ساختمانی را احداث کند که این ساختمان حدود ۳۰ میلیارد تومان هزینه داشته و همچنان نیز بخشی از آن بلااستفاده است.\r\n\r\nوی افزود: این موضوع در مدیریت جدید پیگیری شد و پرونده به مراجع قضایی ارسال شده است.\r\n\r\n<strong>میزان حقوق مدیران فعلی دانشگاه آزاد</strong>\r\n\r\nولایتی در خصوص حقوق مدیران فعلی دانشگاه آزاد گفت: میزان حقوق مدیران بر اساس مصوبات دولت است و هر چه دولت تعیین کرده باشد، آن میزان رعایت می‌شود، اما اکنون میزان حقوق مدیران بسیار کمتر است.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد درباره شایعاتی مبنی بر استعفای فرهاد رهبر رئیس دانشگاه آزاد افزود: برخی‌ها نمی‌خواهند پیشرفت دانشگاه آزاد را ببینند؛ بنابراین این نوع شایعات را مطرح می‌کنند.\r\n\r\nوی گفت: افرادی که اکنون در رده‌های مدیریتی این دانشگاه مشغول به فعالیت هستند، افرادی باسابقه در بخش‌های مختلف جامعه از جمله آموزش عالی به شمار می‌روند؛ به طور مثال دکتر رهبر در رزومه کاری خود، ریاست سازمان برنامه و ریاست دانشگاه تهران را داشته است.\r\n\r\nولایتی تأکید کرد: همچنین دیگر مدیران این دانشگاه نیز سِمَت‌های مدیریتی در دانشگاه‌های بزرگ کشور داشته‌اند.\r\n\r\n<strong>در حال مبارزه با ولنگاری مالی هستیم</strong>\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد خاطرنشان کرد: با توجه به اینکه اکنون در دانشگاه آزاد به دنبال مبارزه با ولنگاری مالی، ریخت و پاش‌ها و ساخت و سازهای بی‌اثر هستیم، برخی آرزو دارند مدیریت این دانشگاه که راه دیگری را دنبال می‌کند، موفق نشود.\r\n\r\nوی ادامه داد: برخی از ساخت و سازهایی که در مدیریت قبلی این دانشگاه انجام شده، همچنان بدون کاربرد است.\r\n\r\nولایتی گفت: از ۳۱ استان کشور، مدیران ۲۱ استان این دانشگاه تغییر کردند که همه این افراد از نظر علمی و اخلاقی بسیار قابل قبول هستند.\r\n\r\n<strong>توضیح درباره اساتید دو شغله </strong>\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد در خصوص اساتید دوشغله نیز گفت: فردی که در دانشگاه تهران کار می‌کند و تمام‌وقت به شمار می‌رود، باید تمام فعالیت خود را معطوف به این دانشگاه کند، چرا که باید در طول ماه ۱۶۰ ساعت در دانشگاه فعالیت کند، بنابراین دیگر نمی‌تواند در مکان دیگری مشغول به فعالیت شود.\r\n\r\nوی افزود: استادی که به صورت تمام‌وقت کار می‌کند، حقوق تمام‌وقت نیز از دانشگاه دریافت می‌کند، بنابراین این افراد نمی‌توانند در مکان دیگری مشغول به فعالیت شوند و آموزش عالی کشور نیز این موضوع را تائید می‌کند.\r\n\r\nولایتی ادامه داد: برخی‌ها این موضوع را سیاسی کردند و آنها باید حساب و کتاب دریافت‌هایی که طی سال‌های قبل داشته‌اند را پَس دهند.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد گفت: وقتی استادی تمام‌وقت است، نمی‌تواند دیگر در دانشگاه دیگری فعالیت کند، اما برخی‌ها به دلیل روابط غیراداری که داشتند، هفته‌ای یک یا دو روز در دانشگاه آزاد نیز درس می‌دادند.\r\n\r\nوی در خصوص بودجه فرهنگی دانشگاه آزاد افزود: این بودجه برای سال ۹۷ رشد داشته و با توجه به اینکه فعالیت‌های فرهنگی و انقلابی نیز در معاونت فرهنگی دانشگاه تعریف می‌شود، بنابراین در سال آینده به برنامه‌های فرهنگی و ارزشی و اسلامی در این دانشگاه توجه بیشتری خواهد شد.\r\n\r\nولایتی تأکید کرد: علت حضور ما در دانشگاه آزاد این است که به وظیفه ملی، دینی و انقلابی خود عمل کنیم.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد عنوان کرد: دانشگاه آزاد رویکردی اسلامی و انقلابی خواهد داشت؛ همان‌گونه که طی یک سال گذشته نیز این رویکرد دنبال شده است.\r\n\r\n</div>","حقوق مدیران فعلی دانشگاه آزاد/موضوع اساتید دو شغله را سیاسی کردند","","publish","open","open","","%d8%ad%d9%82%d9%88%d9%82-%d9%85%d8%af%db%8c%d8%b1%d8%a7%d9%86-%d9%81%d8%b9%d9%84%db%8c-%d8%af%d8%a7%d9%86%d8%b4%da%af%d8%a7%d9%87-%d8%a2%d8%b2%d8%a7%d8%af%d9%85%d9%88%d8%b6%d9%88%d8%b9-%d8%a7%d8%b3","","","2018-03-30 08:38:20","2018-03-30 04:08:20","","0","http://islamic.demo-qaleb.ir/?p=42","0","post","","0"),
("43","1","2018-03-29 20:13:45","2018-03-29 16:43:45","","2700894","","inherit","open","closed","","2700894","","","2018-03-29 20:13:45","2018-03-29 16:43:45","","42","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/2700894.jpg","0","attachment","image/jpeg","0"),
("44","1","2018-03-29 20:13:54","2018-03-29 16:43:54","<div class=\"full-text\">\r\n\r\nبه گزارش خبرنگار مهر، علی اکبر ولایتی رئیس هیأت امنای دانشگاه آزاد اسلامی در نشست خبری امروز خاطر نشان کرد: روز گذشته بودجه سال ۹۷ دانشگاه آزاد در جلسه هیات امنا دانشگاه تصویب شد و ۵ درصد وابستگی بودجه دانشگاه به شهریه نسبت به سال گذشته کاهش یافت.\r\n\r\nوی با بیان اینکه در مناطق محروم افزایش شهریه نداریم، افزود: ۲ هزار میلیارد ریال از شهریه این دانشگاه به جذب هیات علمی جوان اختصاص داده  شد.\r\n\r\n<span dir=\"RTL\">ولایتی افزود: فیش های حقوقی که از مسئولین قبلی دانشگاه آزاد اعلام شد واقعیتی بود که دیگر اینگونه نیست. اکنون حقوق ها براساس‌مصوبات دولت است و میزان حقوق ها بسیار کم است.</span>\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد گفت: ۱۰.۵ درصد بودجه سال آینده دانشگاه آزاد به فعالیت‌های پژوهشی اختصاص می‌یابد.\r\n\r\nوی با اشاره به اختصاص ۲۰۰۰ میلیارد ریال برای جذب عضو هیأت علمی جوان در این دانشگاه افزود: کشور فارغ‌التحصیلان جوان زیادی دارد که دانشگاه آزاد برنامه دارد از این افراد استفاده کند.\r\n\r\nولایتی اظهار داشت: میزان بودجه فرهنگی دانشگاه آزاد نسبت به سال گذشته افزایش یافته که بودجه فعالیت‌های ورزشی نیز بر این اساس افزایش خواهد یافت.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد خاطرنشان کرد: ۱۴ هزار نخبه جذب دانشگاه آزاد شده‌اند که از این تعداد ۶۰ درصد آنها از بدنه دانشگاه آزاد و ۴۰ درصد مربوط به دانشگاه‌های دولتی بوده است.\r\n\r\nوی گفت: فعال‌ کردن برخی از باغ‌های این دانشگاه‌ که در شهرستان‌های مختلف وجود دارد و وقف شده‌اند نیز از برنامه‌های این دانشگاه برای سال آینده است.\r\n\r\n<strong>حجم قراردادهای دانشگاه آزاد با دستگاههای اجرایی</strong>\r\n\r\nولایتی با بیان اینکه دانشگاه آزاد قراردادهای مختلفی با مؤسسات و دستگاه‌های مختلف از جمله مؤسسه استاندارد دارد، تأکید کرد: تاکنون این دانشگاه ۵۰۰ میلیارد ریال قرارداد با دستگاه‌ها و مؤسسات مختلف با محوریت اقتصاد دانش‌بنیان منعقد کرده است.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد تصریح کرد: دانشگاه آزاد آزمایشگاه‌های پیشرفته بسیاری دارد که ۳۰۰ آزمایشگاه آن در مناطق مرزی وجود دارد؛ بنابراین این آزمایشگاه‌ها می‌توانند محلی برای کنترل کیفی محصولات صادراتی و وارداتی باشد.\r\n\r\nبه گفته وی، در این راستا با مؤسسه استاندارد تفاهمنامه‌ای منعقد شده است.\r\n\r\n<strong>رقم بودجه دانشگاه آزاد برای سال آینده</strong>\r\n\r\nولایتی تأکید کرد: بودجه دانشگاه آزاد برای سال ۹۷، ۷۲ هزار و ۸۰۷ میلیارد ریال است که از درآمدهای این دانشگاه تأمین می‌شود و در سال آینده وابستگی بودجه به شهریه حدود پنج درصد کاهش یافته است.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد اظهار داشت: از این میزان ۶۶ هزار و ۴۶۵‌ میلیارد ریال مربوط به هزینه‌های پرسنلی و بیش از ۵۰۰۰ میلیارد ریال هزینه‌های سرمایه‌ای است.\r\n\r\nوی خاطرنشان کرد: روز گذشته خبری در برخی رسانه‌ها منتشر شد که در دوره مدیریت قبلی رئیس یک واحد به دلیل قبول نکردن ساختن یک ساختمان تغییر کرده است.\r\n\r\nولایتی ادامه داد: در دوره قبل از سوی مدیریت دانشگاه به رئیس یک واحد تکلیف شده بود که ساختمانی را بسازد که آن مدیر قبول نکرد و بنابراین وی تغییر کرد و فرد جدیدی برای این واحد انتخاب شد.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد عنوان کرد: رئیس جدید واحد پذیرفت که ساختمانی را احداث کند که این ساختمان حدود ۳۰ میلیارد تومان هزینه داشته و همچنان نیز بخشی از آن بلااستفاده است.\r\n\r\nوی افزود: این موضوع در مدیریت جدید پیگیری شد و پرونده به مراجع قضایی ارسال شده است.\r\n\r\n<strong>میزان حقوق مدیران فعلی دانشگاه آزاد</strong>\r\n\r\nولایتی در خصوص حقوق مدیران فعلی دانشگاه آزاد گفت: میزان حقوق مدیران بر اساس مصوبات دولت است و هر چه دولت تعیین کرده باشد، آن میزان رعایت می‌شود، اما اکنون میزان حقوق مدیران بسیار کمتر است.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد درباره شایعاتی مبنی بر استعفای فرهاد رهبر رئیس دانشگاه آزاد افزود: برخی‌ها نمی‌خواهند پیشرفت دانشگاه آزاد را ببینند؛ بنابراین این نوع شایعات را مطرح می‌کنند.\r\n\r\nوی گفت: افرادی که اکنون در رده‌های مدیریتی این دانشگاه مشغول به فعالیت هستند، افرادی باسابقه در بخش‌های مختلف جامعه از جمله آموزش عالی به شمار می‌روند؛ به طور مثال دکتر رهبر در رزومه کاری خود، ریاست سازمان برنامه و ریاست دانشگاه تهران را داشته است.\r\n\r\nولایتی تأکید کرد: همچنین دیگر مدیران این دانشگاه نیز سِمَت‌های مدیریتی در دانشگاه‌های بزرگ کشور داشته‌اند.\r\n\r\n<strong>در حال مبارزه با ولنگاری مالی هستیم</strong>\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد خاطرنشان کرد: با توجه به اینکه اکنون در دانشگاه آزاد به دنبال مبارزه با ولنگاری مالی، ریخت و پاش‌ها و ساخت و سازهای بی‌اثر هستیم، برخی آرزو دارند مدیریت این دانشگاه که راه دیگری را دنبال می‌کند، موفق نشود.\r\n\r\nوی ادامه داد: برخی از ساخت و سازهایی که در مدیریت قبلی این دانشگاه انجام شده، همچنان بدون کاربرد است.\r\n\r\nولایتی گفت: از ۳۱ استان کشور، مدیران ۲۱ استان این دانشگاه تغییر کردند که همه این افراد از نظر علمی و اخلاقی بسیار قابل قبول هستند.\r\n\r\n<strong>توضیح درباره اساتید دو شغله </strong>\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد در خصوص اساتید دوشغله نیز گفت: فردی که در دانشگاه تهران کار می‌کند و تمام‌وقت به شمار می‌رود، باید تمام فعالیت خود را معطوف به این دانشگاه کند، چرا که باید در طول ماه ۱۶۰ ساعت در دانشگاه فعالیت کند، بنابراین دیگر نمی‌تواند در مکان دیگری مشغول به فعالیت شود.\r\n\r\nوی افزود: استادی که به صورت تمام‌وقت کار می‌کند، حقوق تمام‌وقت نیز از دانشگاه دریافت می‌کند، بنابراین این افراد نمی‌توانند در مکان دیگری مشغول به فعالیت شوند و آموزش عالی کشور نیز این موضوع را تائید می‌کند.\r\n\r\nولایتی ادامه داد: برخی‌ها این موضوع را سیاسی کردند و آنها باید حساب و کتاب دریافت‌هایی که طی سال‌های قبل داشته‌اند را پَس دهند.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد گفت: وقتی استادی تمام‌وقت است، نمی‌تواند دیگر در دانشگاه دیگری فعالیت کند، اما برخی‌ها به دلیل روابط غیراداری که داشتند، هفته‌ای یک یا دو روز در دانشگاه آزاد نیز درس می‌دادند.\r\n\r\nوی در خصوص بودجه فرهنگی دانشگاه آزاد افزود: این بودجه برای سال ۹۷ رشد داشته و با توجه به اینکه فعالیت‌های فرهنگی و انقلابی نیز در معاونت فرهنگی دانشگاه تعریف می‌شود، بنابراین در سال آینده به برنامه‌های فرهنگی و ارزشی و اسلامی در این دانشگاه توجه بیشتری خواهد شد.\r\n\r\nولایتی تأکید کرد: علت حضور ما در دانشگاه آزاد این است که به وظیفه ملی، دینی و انقلابی خود عمل کنیم.\r\n\r\nرئیس هیأت مؤسس و هیأت امنای دانشگاه آزاد عنوان کرد: دانشگاه آزاد رویکردی اسلامی و انقلابی خواهد داشت؛ همان‌گونه که طی یک سال گذشته نیز این رویکرد دنبال شده است.\r\n\r\n</div>","حقوق مدیران فعلی دانشگاه آزاد/موضوع اساتید دو شغله را سیاسی کردند","","inherit","closed","closed","","42-revision-v1","","","2018-03-29 20:13:54","2018-03-29 16:43:54","","42","http://islamic.demo-qaleb.ir/42-revision-v1/","0","revision","","0"),
("45","1","2018-03-29 20:15:58","2018-03-29 16:45:58","<span class=\"intro-text\">قم - یکی از مراجع تقلید شیعیان با بیان اینکه دشمن از طریق فضای مجازی روی خانواده ها تاثیر می گذارد گفت: این فضا باید ساماندهی شود.</span>\r\n<div class=\"full-text\">\r\n\r\nبه گزارش <a class=\"saba-backlink\" href=\"http://www.mehrnews.com\">خبرنگار مهر</a>، آیت الله العظمی جعفر سبحانی شامگاه سه‌شنبه در دیدار با حجت‌الاسلام‌ حاجی صادقی نماینده ولی‌فقیه در سپاه پاسداران و رئیس سازمان بسیج اساتید، طلاب و روحانیون، اظهار داشت: هدف سپاه پاسداران از ابتدا این بود که دارای معنویت خاصی باشد و با دیگر گروه‌ها فرق کند و به خاطر معنویتی که دارد حافظ نظام باشد.\r\n\r\nوی گفت: سپاه پاسداران علاوه بر این‌که مسلح است از سلاح قوی دین نیز برخوردار است و نمی‌توان این معنویت را که سپاه دارد از آن گرفت.\r\n\r\nاین استاد سطوح عالی حوزه با تأکید بر این که اساس و ذات سپاه ایمان، اخلاق و معنویت است، تصریح کرد: سپاهی حافظ نظام است که مؤمن به نظام باشد چه از نظر عقیده و چه از نظر عمل.\r\n\r\n<strong>دشمن از طریق فضای مجازی وارد خانه‌های ما شده است</strong>\r\n\r\nوی در ادامه به فضای مجازی پرداخت و ابراز داشت: دشمن از طریق این فضا وارد خانه‌های ما شده است لذا باید برای آن تدبیری اندیشید و گرچه ما مخالف فضای مجازی و بسته شدن آن و دیوار کشیدن به دور کشور نیستیم اما نباید اجازه دهیم هر میکروبی وارد خانواده‌های ما شود.\r\n\r\nآیت الله سبحانی در بخش دیگری از سخنان خود به سفرهای نوروزی اشاره کرد و گفت: هرساله تعداد بسیاری از هموطنان در این مسافرت‌ها جان خود را از دست می‌دهند یا مجروح از کار افتاده می‌شوند که باید برای این موضوع هم چاره‌ای شود این درحالی است که نه خودروهای ما استاندارد هستند، نه رانندگان مقید به قوانین‌ هستند و نه جاده‌ها ظرفیت این همه خودرو را دارند.\r\n\r\n<strong>تأکید بر تقویت ارتباط سپاه با روحانیت</strong>\r\n\r\nحجت الاسلام عبدالله حاجی صادقی نیز در این دیدار، اظهار داشت: مقام معظم رهبری سه مأموریت به روحانیت سپاه واگذار کرده است که عبارت‌ است از ارتقای معنویت، بصیرت دینی و روحیه جهادی انقلابی.\r\n\r\nوی با بیان اینکه حدود ۲ هزار روحانی رسمی در سپاه وجود دارد، افزود: مراجع تقلید سرچشمه روحانیت هستند و سپاه برای این که ماندگار باشد باید ارتباطش با روحانیت تقویت شود.\r\n\r\nنماینده ولی‌فقیه در سپاه پاسداران، گفت: ما اعزامی‌های حوزه در نهاد سنگر نشین انقلاب هستیم که شما مراجع باید ما را تغذیه کنید تا ماندگار باشیم.\r\n\r\n</div>","دشمن از طریق فضای مجازی وارد خانه های ما شده است","","publish","open","open","","%d8%af%d8%b4%d9%85%d9%86-%d8%a7%d8%b2-%d8%b7%d8%b1%db%8c%d9%82-%d9%81%d8%b6%d8%a7%db%8c-%d9%85%d8%ac%d8%a7%d8%b2%db%8c-%d9%88%d8%a7%d8%b1%d8%af-%d8%ae%d8%a7%d9%86%d9%87-%d9%87%d8%a7%db%8c-%d9%85%d8%a7","","","2018-03-29 20:15:58","2018-03-29 16:45:58","","0","http://islamic.demo-qaleb.ir/?p=45","0","post","","0"),
("46","1","2018-03-29 20:15:54","2018-03-29 16:45:54","","2355570","","inherit","open","closed","","2355570","","","2018-03-29 20:15:54","2018-03-29 16:45:54","","45","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/2355570.jpg","0","attachment","image/jpeg","0"),
("47","1","2018-03-29 20:15:58","2018-03-29 16:45:58","<span class=\"intro-text\">قم - یکی از مراجع تقلید شیعیان با بیان اینکه دشمن از طریق فضای مجازی روی خانواده ها تاثیر می گذارد گفت: این فضا باید ساماندهی شود.</span>\r\n<div class=\"full-text\">\r\n\r\nبه گزارش <a class=\"saba-backlink\" href=\"http://www.mehrnews.com\">خبرنگار مهر</a>، آیت الله العظمی جعفر سبحانی شامگاه سه‌شنبه در دیدار با حجت‌الاسلام‌ حاجی صادقی نماینده ولی‌فقیه در سپاه پاسداران و رئیس سازمان بسیج اساتید، طلاب و روحانیون، اظهار داشت: هدف سپاه پاسداران از ابتدا این بود که دارای معنویت خاصی باشد و با دیگر گروه‌ها فرق کند و به خاطر معنویتی که دارد حافظ نظام باشد.\r\n\r\nوی گفت: سپاه پاسداران علاوه بر این‌که مسلح است از سلاح قوی دین نیز برخوردار است و نمی‌توان این معنویت را که سپاه دارد از آن گرفت.\r\n\r\nاین استاد سطوح عالی حوزه با تأکید بر این که اساس و ذات سپاه ایمان، اخلاق و معنویت است، تصریح کرد: سپاهی حافظ نظام است که مؤمن به نظام باشد چه از نظر عقیده و چه از نظر عمل.\r\n\r\n<strong>دشمن از طریق فضای مجازی وارد خانه‌های ما شده است</strong>\r\n\r\nوی در ادامه به فضای مجازی پرداخت و ابراز داشت: دشمن از طریق این فضا وارد خانه‌های ما شده است لذا باید برای آن تدبیری اندیشید و گرچه ما مخالف فضای مجازی و بسته شدن آن و دیوار کشیدن به دور کشور نیستیم اما نباید اجازه دهیم هر میکروبی وارد خانواده‌های ما شود.\r\n\r\nآیت الله سبحانی در بخش دیگری از سخنان خود به سفرهای نوروزی اشاره کرد و گفت: هرساله تعداد بسیاری از هموطنان در این مسافرت‌ها جان خود را از دست می‌دهند یا مجروح از کار افتاده می‌شوند که باید برای این موضوع هم چاره‌ای شود این درحالی است که نه خودروهای ما استاندارد هستند، نه رانندگان مقید به قوانین‌ هستند و نه جاده‌ها ظرفیت این همه خودرو را دارند.\r\n\r\n<strong>تأکید بر تقویت ارتباط سپاه با روحانیت</strong>\r\n\r\nحجت الاسلام عبدالله حاجی صادقی نیز در این دیدار، اظهار داشت: مقام معظم رهبری سه مأموریت به روحانیت سپاه واگذار کرده است که عبارت‌ است از ارتقای معنویت، بصیرت دینی و روحیه جهادی انقلابی.\r\n\r\nوی با بیان اینکه حدود ۲ هزار روحانی رسمی در سپاه وجود دارد، افزود: مراجع تقلید سرچشمه روحانیت هستند و سپاه برای این که ماندگار باشد باید ارتباطش با روحانیت تقویت شود.\r\n\r\nنماینده ولی‌فقیه در سپاه پاسداران، گفت: ما اعزامی‌های حوزه در نهاد سنگر نشین انقلاب هستیم که شما مراجع باید ما را تغذیه کنید تا ماندگار باشیم.\r\n\r\n</div>","دشمن از طریق فضای مجازی وارد خانه های ما شده است","","inherit","closed","closed","","45-revision-v1","","","2018-03-29 20:15:58","2018-03-29 16:45:58","","45","http://islamic.demo-qaleb.ir/45-revision-v1/","0","revision","","0"),
("48","1","2018-03-29 20:18:06","2018-03-29 15:48:06","<strong>زائران و مجاوران حریم رضوی مطابق معمول سال‌های گذشته</strong> استقبالی بی نظیر و باشکوه از این سخنرانی نوروزی داشته‌اند و می‌توان گفت مشهدمقدس از حدود ۱۰ روز قبل در تدارک این سخنرانی باشکوه است و دستگاه‌ها و نهادهای مختلف و همچنین گروه‌های مختلف مردمی به انحای مختلف خود را مهیای حضور و استماع سخنانی می‌کنند که نقشه راه یکساله آنها را تعیین می‌کند.\r\n\r\nامروز نیز از ساعت ۱۵ مقام معظم رهبری در حرم منور رضوی در جمع پرشور مردم سخنرانی خواهد کرد و در حال حاضر تمامی صحن و سراهای حرم منور رضوی مملو از حضور زائران است.\r\n\r\nمردم برای دیدار یار و سخنرانی نوروزی مقام معظم رهبری در سالی که به نام سال حمایت از کالای ایرانی نامگذاری شده است لحظه شماری می‌کنند.\r\n\r\nانتهای پیام/ش","زائران و مجاوران آماده استماع سخنرانی نوروزی مقام معظم رهبری","","publish","open","open","","%d9%85%d8%b4%d9%87%d8%af%d9%84%d8%ad%d8%b8%d9%87-%d8%af%db%8c%d8%af%d8%a7%d8%b1-%db%8c%d8%a7%d8%b1-%d9%86%d8%b2%d8%af%db%8c%da%a9-%d8%a7%d8%b3%d8%aa%d8%9b-%d8%b2%d8%a7%d8%a6%d8%b1%d8%a7%d9%86-%d9%88","","","2018-09-11 12:14:24","2018-09-11 07:44:24","","0","http://islamic.demo-qaleb.ir/?p=48","0","post","","0"),
("201","1","2018-03-30 11:03:29","2018-03-30 06:33:29","","668","","inherit","open","closed","","668","","","2018-03-30 11:03:29","2018-03-30 06:33:29","","48","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/668.jpg","0","attachment","image/jpeg","0"),
("50","1","2018-03-29 20:18:06","2018-03-29 16:48:06","<strong>زائران و مجاوران حریم رضوی مطابق معمول سال‌های گذشته</strong> استقبالی بی نظیر و باشکوه از این سخنرانی نوروزی داشته‌اند و می‌توان گفت مشهدمقدس از حدود ۱۰ روز قبل در تدارک این سخنرانی باشکوه است و دستگاه‌ها و نهادهای مختلف و همچنین گروه‌های مختلف مردمی به انحای مختلف خود را مهیای حضور و استماع سخنانی می‌کنند که نقشه راه یکساله آنها را تعیین می‌کند.\r\n\r\nامروز نیز از ساعت ۱۵ مقام معظم رهبری در حرم منور رضوی در جمع پرشور مردم سخنرانی خواهد کرد و در حال حاضر تمامی صحن و سراهای حرم منور رضوی مملو از حضور زائران است.\r\n\r\nمردم برای دیدار یار و سخنرانی نوروزی مقام معظم رهبری در سالی که به نام سال حمایت از کالای ایرانی نامگذاری شده است لحظه شماری می‌کنند.\r\n\r\nانتهای پیام/ش","مشهد|لحظه دیدار یار نزدیک است؛ زائران و مجاوران آماده استماع سخنرانی نوروزی مقام معظم رهبری","","inherit","closed","closed","","48-revision-v1","","","2018-03-29 20:18:06","2018-03-29 16:48:06","","48","http://islamic.demo-qaleb.ir/48-revision-v1/","0","revision","","0"),
("51","1","2018-03-29 20:20:02","2018-03-29 15:50:02","<div class=\"story\">\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nظریف همراه با معاون پارلمانی خود حسن قشقاوی وارد مجلس شد.\r\n\r\nهمزمان با ورود وزیر امور خارجه حجت‌الاسلام علیرضا سلیمی نماینده محلات و دلیجان در نطق میان د‌ستورش صحبت‌های خود را درباره تحریم و محدودیت ویزا توسط دولت آمریکا علیه ایران ایراد کرد.\r\n\r\nقبل از صحبت‌های وزیر امور خارجه نطق میان‌دستور نمایندگان تحت تأثیر ورود ظریف به مجلس قرار گرفت و توجهات نمایندگان به سمت وزیر امور خارجه رفت.\r\n\r\nدر صحن علنی مجلس نماهنگی از صحبت‌های مقام معظم رهبری  در جمع مسئولان وزارت خارجه و رئیس جمهور برای هماهنگی بیشتر این وزارتخانه با سیاستهای اقتصاد مقاومتی پخش شد.\r\n\r\nظریف در بخشی از سخنان خود ضمن توهین به نمایندگان مجلس گفت: من اجازه سوال از معاونین خود را به نمایندگان مجلس نمی‌دهم.\r\n\r\nاین سخن ظریف با واکنش نمایندگان مجلس مواجه شد و جمعی از آنها در واکنش خطاب به وی تأکید کردند که شأن مجلس پایین بیاید.\r\n\r\nعبدالله سامری نماینده خرمشهر و جواد کریمی قدوسی از نمایندگان معترض به سخنان وزیر امور خارجه بودند. عبدالله سامری گفت: مگر توهین به نمایندگان چگونه است؟\r\n\r\nعلی مطهری که ریاست مجلس را به‌عهده داشت، خطاب به وزیر امور خارجه گفت: صحبت‌های وزیر امور خارجه در صحن علنی شاید تحقیر مجلس و نمایندگان تلقی شود بنابراین کلماتی نباید گفته شود که از اقتدار مجلس بکاهد.\r\n\r\nوزیر خارجه با دادن نامه‌ای به ریاست مجلس از نمایندگان عذرخواهی کرد و گفت: اگر به عرایض بنده توجه کنید، متوجه می‌شوید که من قصد توهین به نمایندگان را نداشتم.\r\n\r\nعلی مطهری درباره سوال نمایندگان از وزرا تصریح کرد: نمایندگان آزادند، در مورد همه مسائل کشور سوال کنند اما نباید طوری بپرسند که تلقی داشتن نیات سیاسی شود.\r\n<div class=\"story\">\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nظریف همراه با معاون پارلمانی خود حسن قشقاوی وارد مجلس شد.\r\n\r\nهمزمان با ورود وزیر امور خارجه حجت‌الاسلام علیرضا سلیمی نماینده محلات و دلیجان در نطق میان د‌ستورش صحبت‌های خود را درباره تحریم و محدودیت ویزا توسط دولت آمریکا علیه ایران ایراد کرد.\r\n\r\nقبل از صحبت‌های وزیر امور خارجه نطق میان‌دستور نمایندگان تحت تأثیر ورود ظریف به مجلس قرار گرفت و توجهات نمایندگان به سمت وزیر امور خارجه رفت.\r\n\r\nدر صحن علنی مجلس نماهنگی از صحبت‌های مقام معظم رهبری  در جمع مسئولان وزارت خارجه و رئیس جمهور برای هماهنگی بیشتر این وزارتخانه با سیاستهای اقتصاد مقاومتی پخش شد.\r\n\r\nظریف در بخشی از سخنان خود ضمن توهین به نمایندگان مجلس گفت: من اجازه سوال از معاونین خود را به نمایندگان مجلس نمی‌دهم.\r\n\r\nاین سخن ظریف با واکنش نمایندگان مجلس مواجه شد و جمعی از آنها در واکنش خطاب به وی تأکید کردند که شأن مجلس پایین بیاید.\r\n\r\nعبدالله سامری نماینده خرمشهر و جواد کریمی قدوسی از نمایندگان معترض به سخنان وزیر امور خارجه بودند. عبدالله سامری گفت: مگر توهین به نمایندگان چگونه است؟\r\n\r\nعلی مطهری که ریاست مجلس را به‌عهده داشت، خطاب به وزیر امور خارجه گفت: صحبت‌های وزیر امور خارجه در صحن علنی شاید تحقیر مجلس و نمایندگان تلقی شود بنابراین کلماتی نباید گفته شود که از اقتدار مجلس بکاهد.\r\n\r\nوزیر خارجه با دادن نامه‌ای به ریاست مجلس از نمایندگان عذرخواهی کرد و گفت: اگر به عرایض بنده توجه کنید، متوجه می‌شوید که من قصد توهین به نمایندگان را نداشتم.\r\n\r\nعلی مطهری درباره سوال نمایندگان از وزرا تصریح کرد: نمایندگان آزادند، در مورد همه مسائل کشور سوال کنند اما نباید طوری بپرسند که تلقی داشتن نیات سیاسی شود.\r\n<div class=\"story\">\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nظریف همراه با معاون پارلمانی خود حسن قشقاوی وارد مجلس شد.\r\n\r\nهمزمان با ورود وزیر امور خارجه حجت‌الاسلام علیرضا سلیمی نماینده محلات و دلیجان در نطق میان د‌ستورش صحبت‌های خود را درباره تحریم و محدودیت ویزا توسط دولت آمریکا علیه ایران ایراد کرد.\r\n\r\nقبل از صحبت‌های وزیر امور خارجه نطق میان‌دستور نمایندگان تحت تأثیر ورود ظریف به مجلس قرار گرفت و توجهات نمایندگان به سمت وزیر امور خارجه رفت.\r\n\r\nدر صحن علنی مجلس نماهنگی از صحبت‌های مقام معظم رهبری  در جمع مسئولان وزارت خارجه و رئیس جمهور برای هماهنگی بیشتر این وزارتخانه با سیاستهای اقتصاد مقاومتی پخش شد.\r\n\r\nظریف در بخشی از سخنان خود ضمن توهین به نمایندگان مجلس گفت: من اجازه سوال از معاونین خود را به نمایندگان مجلس نمی‌دهم.\r\n\r\nاین سخن ظریف با واکنش نمایندگان مجلس مواجه شد و جمعی از آنها در واکنش خطاب به وی تأکید کردند که شأن مجلس پایین بیاید.\r\n\r\nعبدالله سامری نماینده خرمشهر و جواد کریمی قدوسی از نمایندگان معترض به سخنان وزیر امور خارجه بودند. عبدالله سامری گفت: مگر توهین به نمایندگان چگونه است؟\r\n\r\nعلی مطهری که ریاست مجلس را به‌عهده داشت، خطاب به وزیر امور خارجه گفت: صحبت‌های وزیر امور خارجه در صحن علنی شاید تحقیر مجلس و نمایندگان تلقی شود بنابراین کلماتی نباید گفته شود که از اقتدار مجلس بکاهد.\r\n\r\nوزیر خارجه با دادن نامه‌ای به ریاست مجلس از نمایندگان عذرخواهی کرد و گفت: اگر به عرایض بنده توجه کنید، متوجه می‌شوید که من قصد توهین به نمایندگان را نداشتم.\r\n\r\nعلی مطهری درباره سوال نمایندگان از وزرا تصریح کرد: نمایندگان آزادند، در مورد همه مسائل کشور سوال کنند اما نباید طوری بپرسند که تلقی داشتن نیات سیاسی شود.\r\n\r\nانتهای پیام/\r\n\r\n</div>\r\n</div>\r\n</div>","وزیر امور خارجه کشور: قصد توهین نداشتم؛عذرخواهی می‌کنم","","publish","open","open","","%d9%82%d8%b5%d8%af-%d8%aa%d9%88%d9%87%db%8c%d9%86-%d9%86%d8%af%d8%a7%d8%b4%d8%aa%d9%85%d8%9b%d8%b9%d8%b0%d8%b1%d8%ae%d9%88%d8%a7%d9%87%db%8c-%d9%85%db%8c%e2%80%8c%da%a9%d9%86%d9%85","","","2018-09-11 12:15:26","2018-09-11 07:45:26","","0","http://islamic.demo-qaleb.ir/?p=51","0","post","","0"),
("52","1","2018-03-29 20:19:57","2018-03-29 16:49:57","","147253950390490800","","inherit","open","closed","","147253950390490800","","","2018-03-29 20:19:57","2018-03-29 16:49:57","","51","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/147253950390490800.jpg","0","attachment","image/jpeg","0"),
("53","1","2018-03-29 20:20:02","2018-03-29 16:50:02","<div class=\"story\">\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nظریف همراه با معاون پارلمانی خود حسن قشقاوی وارد مجلس شد.\r\n\r\nهمزمان با ورود وزیر امور خارجه حجت‌الاسلام علیرضا سلیمی نماینده محلات و دلیجان در نطق میان د‌ستورش صحبت‌های خود را درباره تحریم و محدودیت ویزا توسط دولت آمریکا علیه ایران ایراد کرد.\r\n\r\nقبل از صحبت‌های وزیر امور خارجه نطق میان‌دستور نمایندگان تحت تأثیر ورود ظریف به مجلس قرار گرفت و توجهات نمایندگان به سمت وزیر امور خارجه رفت.\r\n\r\nدر صحن علنی مجلس نماهنگی از صحبت‌های مقام معظم رهبری  در جمع مسئولان وزارت خارجه و رئیس جمهور برای هماهنگی بیشتر این وزارتخانه با سیاستهای اقتصاد مقاومتی پخش شد.\r\n\r\nظریف در بخشی از سخنان خود ضمن توهین به نمایندگان مجلس گفت: من اجازه سوال از معاونین خود را به نمایندگان مجلس نمی‌دهم.\r\n\r\nاین سخن ظریف با واکنش نمایندگان مجلس مواجه شد و جمعی از آنها در واکنش خطاب به وی تأکید کردند که شأن مجلس پایین بیاید.\r\n\r\nعبدالله سامری نماینده خرمشهر و جواد کریمی قدوسی از نمایندگان معترض به سخنان وزیر امور خارجه بودند. عبدالله سامری گفت: مگر توهین به نمایندگان چگونه است؟\r\n\r\nعلی مطهری که ریاست مجلس را به‌عهده داشت، خطاب به وزیر امور خارجه گفت: صحبت‌های وزیر امور خارجه در صحن علنی شاید تحقیر مجلس و نمایندگان تلقی شود بنابراین کلماتی نباید گفته شود که از اقتدار مجلس بکاهد.\r\n\r\nوزیر خارجه با دادن نامه‌ای به ریاست مجلس از نمایندگان عذرخواهی کرد و گفت: اگر به عرایض بنده توجه کنید، متوجه می‌شوید که من قصد توهین به نمایندگان را نداشتم.\r\n\r\nعلی مطهری درباره سوال نمایندگان از وزرا تصریح کرد: نمایندگان آزادند، در مورد همه مسائل کشور سوال کنند اما نباید طوری بپرسند که تلقی داشتن نیات سیاسی شود.\r\n<div class=\"story\">\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nظریف همراه با معاون پارلمانی خود حسن قشقاوی وارد مجلس شد.\r\n\r\nهمزمان با ورود وزیر امور خارجه حجت‌الاسلام علیرضا سلیمی نماینده محلات و دلیجان در نطق میان د‌ستورش صحبت‌های خود را درباره تحریم و محدودیت ویزا توسط دولت آمریکا علیه ایران ایراد کرد.\r\n\r\nقبل از صحبت‌های وزیر امور خارجه نطق میان‌دستور نمایندگان تحت تأثیر ورود ظریف به مجلس قرار گرفت و توجهات نمایندگان به سمت وزیر امور خارجه رفت.\r\n\r\nدر صحن علنی مجلس نماهنگی از صحبت‌های مقام معظم رهبری  در جمع مسئولان وزارت خارجه و رئیس جمهور برای هماهنگی بیشتر این وزارتخانه با سیاستهای اقتصاد مقاومتی پخش شد.\r\n\r\nظریف در بخشی از سخنان خود ضمن توهین به نمایندگان مجلس گفت: من اجازه سوال از معاونین خود را به نمایندگان مجلس نمی‌دهم.\r\n\r\nاین سخن ظریف با واکنش نمایندگان مجلس مواجه شد و جمعی از آنها در واکنش خطاب به وی تأکید کردند که شأن مجلس پایین بیاید.\r\n\r\nعبدالله سامری نماینده خرمشهر و جواد کریمی قدوسی از نمایندگان معترض به سخنان وزیر امور خارجه بودند. عبدالله سامری گفت: مگر توهین به نمایندگان چگونه است؟\r\n\r\nعلی مطهری که ریاست مجلس را به‌عهده داشت، خطاب به وزیر امور خارجه گفت: صحبت‌های وزیر امور خارجه در صحن علنی شاید تحقیر مجلس و نمایندگان تلقی شود بنابراین کلماتی نباید گفته شود که از اقتدار مجلس بکاهد.\r\n\r\nوزیر خارجه با دادن نامه‌ای به ریاست مجلس از نمایندگان عذرخواهی کرد و گفت: اگر به عرایض بنده توجه کنید، متوجه می‌شوید که من قصد توهین به نمایندگان را نداشتم.\r\n\r\nعلی مطهری درباره سوال نمایندگان از وزرا تصریح کرد: نمایندگان آزادند، در مورد همه مسائل کشور سوال کنند اما نباید طوری بپرسند که تلقی داشتن نیات سیاسی شود.\r\n<div class=\"story\">\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nظریف همراه با معاون پارلمانی خود حسن قشقاوی وارد مجلس شد.\r\n\r\nهمزمان با ورود وزیر امور خارجه حجت‌الاسلام علیرضا سلیمی نماینده محلات و دلیجان در نطق میان د‌ستورش صحبت‌های خود را درباره تحریم و محدودیت ویزا توسط دولت آمریکا علیه ایران ایراد کرد.\r\n\r\nقبل از صحبت‌های وزیر امور خارجه نطق میان‌دستور نمایندگان تحت تأثیر ورود ظریف به مجلس قرار گرفت و توجهات نمایندگان به سمت وزیر امور خارجه رفت.\r\n\r\nدر صحن علنی مجلس نماهنگی از صحبت‌های مقام معظم رهبری  در جمع مسئولان وزارت خارجه و رئیس جمهور برای هماهنگی بیشتر این وزارتخانه با سیاستهای اقتصاد مقاومتی پخش شد.\r\n\r\nظریف در بخشی از سخنان خود ضمن توهین به نمایندگان مجلس گفت: من اجازه سوال از معاونین خود را به نمایندگان مجلس نمی‌دهم.\r\n\r\nاین سخن ظریف با واکنش نمایندگان مجلس مواجه شد و جمعی از آنها در واکنش خطاب به وی تأکید کردند که شأن مجلس پایین بیاید.\r\n\r\nعبدالله سامری نماینده خرمشهر و جواد کریمی قدوسی از نمایندگان معترض به سخنان وزیر امور خارجه بودند. عبدالله سامری گفت: مگر توهین به نمایندگان چگونه است؟\r\n\r\nعلی مطهری که ریاست مجلس را به‌عهده داشت، خطاب به وزیر امور خارجه گفت: صحبت‌های وزیر امور خارجه در صحن علنی شاید تحقیر مجلس و نمایندگان تلقی شود بنابراین کلماتی نباید گفته شود که از اقتدار مجلس بکاهد.\r\n\r\nوزیر خارجه با دادن نامه‌ای به ریاست مجلس از نمایندگان عذرخواهی کرد و گفت: اگر به عرایض بنده توجه کنید، متوجه می‌شوید که من قصد توهین به نمایندگان را نداشتم.\r\n\r\nعلی مطهری درباره سوال نمایندگان از وزرا تصریح کرد: نمایندگان آزادند، در مورد همه مسائل کشور سوال کنند اما نباید طوری بپرسند که تلقی داشتن نیات سیاسی شود.\r\n\r\nانتهای پیام/\r\n\r\n</div>\r\n</div>\r\n</div>","قصد توهین نداشتم؛عذرخواهی می‌کنم","","inherit","closed","closed","","51-revision-v1","","","2018-03-29 20:20:02","2018-03-29 16:50:02","","51","http://islamic.demo-qaleb.ir/51-revision-v1/","0","revision","","0"),
("54","1","2018-03-29 20:22:03","2018-03-29 16:52:03","<div class=\"story\">\r\n\r\nبه گزارش خبرنگارفرهنگی خبرگزاری تسنیم، جشن سینما و کتاب عصر روز شنبه ۲۱ شهریور و به مناسبت روز سینما با حضور هنرمندان و اهالی رسانه در خانه هنرمندان برگزار شد.\r\n\r\nجشن سینما و کتاب عصر روز ۲۱ شهریورماه و به مناسبت روز سینما با حضور فرخ نعمتی، مسعود رایگان، رویا تیموریان، سیروس ابراهیم زاده، کاظم هژیر آزاد، سهیلا رضوی، بهاره رهنما، نرگس آبیار، سیروس الوند، شمس لنگرودی، پدرام اکبری،بهروز افخمی، مرجان شیرمحمدی، کیوان کثیریان، اندیشه فولادوند و لیلا اوتادی در خانه هنرمندان ایران برگزار شد.\r\n\r\nدر ابتدای این مراسم مجید سرسنگی مدیرعامل خانه هنرمندان ایران در ابتدای برنامه گفت: بسیار خوشحالم که با همکاری آقای جلیسه رئیس خانه کتاب توانستیم جشن سینما و کتاب را در روزهایی که متعلق به سینما است، برگزار کنیم. این برنامه به سینماگرانی اختصاص دارد که در کنار حرفه سینماگری دست به قلم هم هستند و در حوزه های مختلف کتاب هایی را نیز نوشته اند.\r\n\r\nسرسنگی افزود: بدون هیچ اغراقی ادبیات را باید روح یک ملت خواند. روحی که لابلای کلمات و جملات می‌ماند و از نسلی به نسل دیگر منتقل می شود. باید اقرار کرد متاسفانه امروز عادت کتاب خوانی ما جایگاه خود را در کشور از دست داده است. حتی اگر خیلی خوشبینانه هم بگوییم، جایگاهش تنزل پیدا کرده است و مانند گذشته نیست.\r\n\r\nمدیرعامل خانه هنرمندان ایران عنوان کرد: از مدتی قبل و بر اساس تفاهم نامه ای که بین خانه هنرمندان ایران و خانه کتاب منعقد شد، بنا را بر این گذاشتیم که در حوزه ادبیات و کتاب کار بیشتری را انجام دهیم. زیرا اعتقاد داریم که ملت توسعه یافته و پیشرفته، ملتی است که با کتاب انس داشته باشد. این درحالی است که وقتی به شرایط نشر کتاب، خواندن کتاب و ارزش نهادن به کتاب نگاه می کنیم، فاصله بسیاری بین وضع موجود و آن چیزی که از یک کشور متمدن، صاحب فرهنگ و صاحب مفاخر ادبی انتظار می رود، می بینیم.\r\n\r\nسرسنگی ادامه داد: جشن سینما و کتاب یک حرکت نمادین برای قدرشناسی از هنرمندانی است که در کنار حرفه اصلی خود، نوشتن را هم از یاد نبرده اند. گاهی اوقات هنرمندان در رشته ای که کار می کنند ترجیح می دهند در رشته خود فعالیت کنند اما انس آنها با کتاب و نوشتن کتاب، نه تنها مخاطبان را با ارزش های بیشتری از فرهنگ و هنر این افراد آشنا می کند بلکه بر هنر اصلی آنها هم تاثیر می گذارد.\r\n\r\nوی افزود: بسیار خوشحالیم که امروز و در این مناسبت از تعدادی از سینماگران بزرگ کشور که در سال های ۹۳ و ۹۴ در کنار کار سینما، نوشتن را هم ادامه دادند و آثار ارزشمندی را خلق کردند، تجلیل و تقدیر کنیم. امیدواریم که فرهنگ کتاب و کتابخوانی در کشور ما بیش از آن چیزی که امروز هست، جای خود را در جامعه باز کند.\r\nمدیرعامل خانه هنرمندان ایران بیان کرد: یکی از متفکران معاصر ایرانی می گوید:”فقر نداشتن است اما این نداشتن لزوما پول نیست. فقر روزنامه های برگشتی یک شهر است. فقر کتاب هایی است که در یک کتابخانه و یا در یک کتاب فروشی خاک می خورد.” اضافه می کنم که فقر تبدیل شدن یک کتاب فروشی به یک فلافل فروشی در خیابان انقلاب است.\r\n\r\n<strong>سینماگران مسئولیت مهمی در گسترش فرهنگ کتابخوانی دارند</strong>\r\n\r\nپس از آن مجید غلامی جلیسه رئیس خانه کتاب به روی صحنه آمد و گفت: باعث افتخار ماست که در نخستین جشن کتاب و سینما در خدمت شما اساتید سینما هستیم. ما در سال ۹۳ و ابتدای سال ۹۴ سعی کردیم پیوند مبارک و بسیار خوب سینما و کتاب را بیش از پیش مبارک بدانیم. شخصا اعتقاد دارم که سینما نقش بسیار مهمی در توسعه فرهنگ کتاب و کتاب خوانی در کشور دارد.\r\n\r\nوی افزود: در این بین و در رأس آنها سینماگران و عوامل سینمایی نقش مثبت و بسیار خوبی در رشد و گسترش این فرهنگ در سطح جامعه دارند. این جشن در اصل بهانه ای است برای اینکه به سینماگران یادآوری کنیم که چه مسئولیت مهم و بزرگی را در جهت گسترش فرهنگ کتاب و کتاب خوانی برعهده دارند.\r\n\r\nرئیس خانه کتاب ادامه داد: از شما درخواست می کنیم که بیشتر از قبل درمورد کتاب نوشته و سخن بگویید و بیشتر از قبل در کلام، بازی و فیلم های خود به کتاب بپردازید. همچنین سعی کنید تا با هر بهانه ای به کتاب اشاره ای داشته باشید چون مردم سینما و سینماگران را دوست دارند و قطعا این ظرفیت را برای کتاب ما که امروز آنچنان حال و روز خوبی ندارد، می تواند در بین مردم ایجاد کند.\r\n\r\nغلامی جلیسه در پایان گفت: امیدوارم این جشن زمینه ای برای پیوند هرچه بیشتر سینما و کتاب باشد. همچنین در تشویق مردم به مطالعه کتاب و ترویج فرهنگ کتاب خوانی موثر باشد.\r\n\r\nپس از آن فرخ نعمتی با اهدای لوح تقدیر و کتاب نفیسی از استاد فرشچیان به مسعود رایگان از او تقدیر کرد و مسعود رایگان گفت: از خانه کتاب و خانه هنرمندان تشکر می کنم که تلاش بی وقفه ای برای ترویج فرهنگ کتاب و کتابخوانی آغاز کردند. تصور می کنم که این تلاش کافی نیست.\r\n\r\nرایگان خاطرنشان کرد: شما فکر کنید در یک جامعه ۷۰ الی ۸۰ میلیونی کتابی با ۱۲۰۰ نسخه چاپ می شود. بر اساس این آمار، هر ایرانی ۲۰ دقیقه برای خواندن کتاب یا روزنامه وقت می گذارد. بر این اساس باعث تاسف است که رسانه ملی می تواند نقش بسیار فعالی در این زمینه داشته باشد. این رسانه می تواند فرهنگ کتاب خوانی را در سراسر ایران زمین جا بیاندازد. در این راستا طرحی دارم که از طریق رسانه ملی و شبکه دیجیتال کاری کنیم تا هر ایرانی ۵ کتاب را مطالعه کند و این قول را همین جا به شما می دهم که این اتفاق می افتد.\r\n\r\nدر ادامه برنامه غلامحسین امیرخانی استاد خوش نویسی به روی صحنه آمد و پیش از اهدای لوح تقدیر و کتاب نفیسی از استاد فرشچیان به سیروس ابراهیم زاده گفت: آماری که در مورد مطالعه ۲۰ دقیقه ای کتاب توسط هر ایرانی اعلام شد. فکر نمی کنم که این آمار حتی همین ۲۰ دقیقه هم باشد زیرا آمار باید به دقت گرفته شود تا واقعیت ماجرا مشخص شود.\r\n\r\nوی افزود: بر اساس آماری خانم های کتاب خوان ۹ کشور اروپایی بررسی شده بود و حداقل تعداد کتاب خوانده شده در آن کشورها ۹ کتاب و حداکثر ۵۲ کتاب بود. آمار ۵۲ کتاب مطالعه شده برای کشورهای شمال اروپا و آمار ۹ کتاب برای کشور ایتالیا بود. ما در انجمن خوش نویسان ایران معتقدیم که با نوشتن به نوعی خود را در حلقه کتابت و نشر قرار می دهیم.\r\n\r\nامیرخانی افزود: در انجمن خوشنویسان برای جبران این مسأله که شرایط و روزگار ما شاید امکان آن را کم کرده که یک انسان با این مشغله بتواند با کتاب های بزرگی مثل شاهنامه، مثنوی، حافظ و مولوی آشنا شود، به گزیده ها پناه بردیم؛ یعنی کتاب های ارزشمند را در خلاصه ای در حدود ۱۰۰ صفحه با آرایه های مناسبی که جذابیت و زیبایی آن خواننده را به مطالعه آن تشویق کند، گردآوری کردیم و تا حدودی هم موفق بوده ایم.\r\n\r\nاین استاد خوش نویس تصریح کرد: بد نیست به این موضوع اشاره کنم که کشور ما از نظر کتابت و کتاب آرایی در مقام نخست در دنیا قرار دارد. البته ملت های دیگر هم در این حوزه زحمت کشیده و آثار قابل توجهی را خلق کرده اند اما مقام نخست دنیا را ما در اختیار داریم.\r\n\r\nبعد از آن غلامحسین امیرخانی با اهدای لوح تقدیر و کتاب نفیسی از استاد فرشچیان به سیروس ابراهیم زاده از او تجلیل کرد و سیروس ابراهیم زاده نیز گفت: نخستین جشن سینما و کتاب در حقیقت قدم های اولیه تفکرهای بسیار ارزشمند جوانان و هنرمندان ما در این جهت است که بتوانند خود را با دنیای متغیر و متمدن امروز بیشتر هماهنگ کنند.\r\n\r\nابراهیم زاده افزود: کتاب یکی از رسانه های بسیار قدیمی است که ما هم در میراث فرهنگی افتخار داریم که کتاب داریم، کتاب نوشته ایم و در این عرصه فعالیت های فراوانی انجام داده ایم. از طرف دیگر سینما یکی از ستون های ارزشمند مدرنیته است. بر این اساس تلفیق این دو حوزه بسیار مبارک است. ما نوعی آگاهی پیدا کردیم که با این سوابق درخشان فرهنگی، ادبی و هنری نیاز داریم تا خود را به جهان امروز نزدیک تر کنیم.\r\n\r\nاین بازیگر پیش کسوت ادامه داد: ما نباید فراموش کنیم که در دنیایی زندگی می کنیم که به شدت در حال تغییر و تحول است. در بسیاری از زمینه ها از جمله فرهنگی و هنری که آگاهی هایی پیدا کردیم هنوز نتوانستیم خود را به دهکده بزرگ جهانی امروز برسانیم. از این جهت این جشن را بسیار مبارک می دانم که تاثیرات بیشتری در زمینه های دیگری هنر خواهد داشت.\r\n\r\nابراهیم زاده گفت: جای خوشحالی است دوستانی که در زمینه سینما فعالیت می کنند در حوزه انتشار کتاب هم فعال هستند. در حقیقت یکی از ابعاد وجودی یک هنرمند این است که به هنرهای دیگر هم وارد شود. در واقع وقتی یک هنرمند در زمینه های دیگر هم وارد می شود بیشتر و بهتر با مخاطبان خود ارتباط برقرار می کند.\r\n\r\nدر بخش دیگر برنامه مجید سرسنگی مدیرعامل خانه هنرمندان روی صحنه آمد و با اهدای لوح تقدیر و کتاب نفیسی از استاد فرشچیان به کاظم هژیرآزاد از او تجلیل کرد و هژیرآزاد گفت: زمانی که ۱۸ سال داشتم از طریق سینما با بازیگری آشنا شدم. سپس خدمت مصطفی اسکویی رفتم و با پیش کسوتانی چون سیروس ابراهیم زاده، ابراهیم فتحی، دولت آبادی، شیراندامی و سلطان پور آشنا شدم و به خواندن و نوشتن کتاب علاقه پیدا کردم.\r\n\r\nوی افزود: نوشتن را از طریق نوشتن بیوگرافی آموختم. چیزی که آقای اسکویی بسیار بر روی آن تاکید داشت. برای هر نقش باید یک بیوگرافی می نوشتم و همان موجب شد که زیاد کتاب بخوانم. توصیه او این بود که بخوانید، بخوانید، و بخوانید و قدری هم بنویسید.\r\n\r\nدر ادامه برنامه سهیلا رضوی روی صحنه آمد و با اهدای لوح تقدیر و کتاب نفیسی از استاد فرشچیان به بهاره رهنما از او تجلیل کرد و بهاره رهنما در ادامه گفت: می دانم که نمی توانم رقیب شما باشم. از خانه کتاب و خانه هنرمندان تشکر می کنم که از من حمایت کردند. اولین ناشرم نشر چشمه، ناشر دوم نشر نگاه و از نشر مروارید به عنوان ناشری که خطرپذیر بود و نمایشنامه های من در طول ۱۵ سال را منتشر کرد، تشکر و قدردانی می کنم.\r\n\r\nدر بخش دیگر این برنامه مجید غلامی جلیسه رئیس خانه کتاب روی صحنه آمد و با اهدای لوح تقدیر و کتاب نفیسی از استاد فرشچیان به نرگس آبیار از او تجلیل کرد. آبیار نیز گفت: نخستین کتابم در سال ۷۸ منتشر شد. پیش از این سالها ویراستاری کتاب می کردم. ویراستاری کار خیلی سختی بود و ذهن آماده ای نیاز داشت و متن های بهم ریخته و درهم دیگران را باید همیشه تصحیح می کردم، بی آنکه اسمی از من در کار باشد. برخی مواقع حتی متن را بازنویسی می‌کردم.\r\n\r\nآبیار ادامه داد: زمانی که نخستین رمان خود را نوشتم آن قدر راحت و روان این کار را انجام دادم که از اینکه این قدر نثرم پخته و روان شده، شگفت زده شدم. این اتفاق در حوزه فیلمسازی و مستندسازی نیز برایم افتاد. زمانی که نخستین فیلم خود را ساختم احساس کردم که خیلی راحت و روان آن را به سرانجام رساندم. روزهای سختی که چه در دوره ویراستاری و چه در دوره مستند سازی سپری کردم برایم بسیار مبارک و خوب بود و اتفاق های خوبی را برای آینده ام رقم زد.\r\n\r\nکارگردان فیلم شیار ۱۴۳ گفت: امیدوارم در حوزه کتاب هم یک آشتی خوبی بین نویسنده ها و سینماگران اتفاق بیافتد و اقتباس های بیشتری از آثار ادبی صورت گیرد. در این بین نویسنده ها مقداری کوتاه بیایند و کمتر سخت بگیرند و فیلم سازان هم آن قدر نخواهند که خود مولف باشند و فیلمنامه بنویسند. تا هرچه بیشتر شاهد اقتباس آثار از کتاب ها با کمک سینماگران باشیم.\r\n\r\nدر ادامه این مراسم سیروس الوند برای اهدای لوح تقدیر به شمس لنگرودی روی صحنه آمد و قبل از اهدا گفت: ژاپن رفته ها می دانند ژاپنی ها در اتوبوس و تراموا کتاب می خوانند. تصور می کنم میان مردم ژاپن دانستن و آگاهی یک ارزش است و اگر این در کشور ما حل شود، رسانه ها نیز به کتابخوانی می پردازند.\r\n\r\nشمس لنگرودی نیز با صحبت هایی طنز در ادامه عنوان کرد: یکی از دوستان کارگردانم زنگ زد و گفت نمایشگاه نقاشی برگزار کردم و اوضاع خوب نیست. گفتم ببین چقدر اوضاع شعر بد است که من به سینما آمدم!\r\n\r\n<strong>کتابخوانی باید از مدرسه ها شروع شود</strong>\r\n\r\nپدرام اکبری نیز لوح بعدی را به مرجان شیرمحمدی تقدیم کرد و او در صحبت هایی عنوان کرد:کتابخوانی باید از مدرسه ها شروع شود و از آموزش و پرورش می خواهم یک زنگ کتابخوانی برای بچه ها بگذارد. این بهترین زمان عمر بچه هاست که در دنیای تخیل غوطه ور شوند. بچه ها در این شرایط می توانند کتابخوان باشند اما این بزرگترها هستند که شخصیت آنها را شکل می دهند. فرهنگ کتابخوانی باید از مدارس ابتدایی شروع شود.\r\n\r\nدر ادامه برنامه کیوان کثیریان لوح بعدی را به اندیشه فولادوند تقدیم کرد و گفت: در زمینه کتاب نیازمند کمک حوزه های مدیریتی و کلان کشور هستیم. شرایط کنونی و اقتصادی جامعه بسیار بد است و به گونه ای نیست که سبد کتاب در خانوار جایگاه ویژه ای داشته باشد. امیدوارم مدیرانی از این دست، قیمت کالاها و محصولات فرهنگی را کاهش دهند.\r\n\r\nرؤیا تیموریان نیز لوح بعدی را به لیلا اوتادی تقدیم کرد و او نیز بیان کرد: با دوستم در دوران راهنمایی قرار می گذاشتیم رمان بخوانیم و هر هفته درباره آن صحبت می کردیم اما الان جای آن را ثروت خواهی گرفته است.\r\n\r\nرؤیا تیموریان نیز تأکید کرد: به غیر از دبستان این مسأله مربوط به والدین و خودمان می شود و پس از آن همه چیز از لحاظ مدیریتی به دولت باز می گردد.\r\n\r\nامیرحاج رضایی(فعال ورزشی و فوتبالی) نیز برای اهدای لوح بعدی به اشکان خطیبی روی صحنه آمد و گفت: با سینمای شما آموختم، دردمند شدم و شاگردی کردم. سالهاست به سینما علاقه مندم. می خواستم تحصیلاتم را ادامه دهم اما از ادامه آن باز ماندم و به صورت غریزی خواندن را ادامه دادم. هتریک من در زندگی کتاب، سینما و فوتبال بود. خلأهای زندگی را با فوتبال پر می کنم.\r\n\r\nوی افزود: متأسفم که آمار مطالعه پایین است و شخصا چشم انتظاری از حوزه خودم ندارم چون بعد از این همه سال خدمت ۶۰۳ هزارتومان عیدی دریافت کردم.\r\n\r\nحاج رضایی در رابطه با درگذشت ایرج کریمی منتقد یادآور شد: ما به تکثیر این افراد نیازمندیم. فوتبال زندگی من است چون معلم بزرگی برایم بوده و به کمک فوتبال درد از دست دادن همسرم را تحمل کردم. فوتبال کرامت انسانی را به من آموخت.\r\n\r\nاشکان خطیبی نیز بعد از دریافت لوح گفت: کیندل، کتاب اینترنتی و گوگل ریدر در همه گوشی های تلفن همراه بچه ها نصب است. این می تواند در سبد کتاب باشد. زندگی الان اجازه داشتن کتاب های قطور را نمی دهد. لزومی ندارد این کتاب ها به فروش گذاشته شود تا عواید آن خرج امور خیریه شود بلکه می توانند این کتاب را برای دانشجویان خریداری کنند. باید در این رابطه دیدگاهمان را تغییر دهیم.\r\n\r\nسیروس الوند برای دومین بار روی صحنه آمد و لوح را به بهروز افخمی تقدیم کرد و بهروز افخمی نیز گفت: به عنوان خدمتگزار ادبیات و عاشق کلمات اینجا هستم. نشر ساقی اولین ناشر مجموعه مقالاتم است. از بچگی گرفتار کلمات بودم و مادربزرگم قصه می گفت تا اینکه به کلمات خوب رسیدیم.\r\n\r\nانتهای‌پیام/\r\n\r\n</div>","امیدوار به آشتی سینما و ادبیات هستیم","","publish","open","open","","%d8%a7%d9%85%db%8c%d8%af%d9%88%d8%a7%d8%b1-%d8%a8%d9%87-%d8%a2%d8%b4%d8%aa%db%8c-%d8%b3%db%8c%d9%86%d9%85%d8%a7-%d9%88-%d8%a7%d8%af%d8%a8%db%8c%d8%a7%d8%aa-%d9%87%d8%b3%d8%aa%db%8c%d9%85","","","2018-03-29 20:22:03","2018-03-29 16:52:03","","0","http://islamic.demo-qaleb.ir/?p=54","0","post","","0"),
("55","1","2018-03-29 20:21:58","2018-03-29 16:51:58","","85632","","inherit","open","closed","","85632","","","2018-03-29 20:21:58","2018-03-29 16:51:58","","54","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/85632.jpg","0","attachment","image/jpeg","0"),
("56","1","2018-03-29 20:22:03","2018-03-29 16:52:03","<div class=\"story\">\r\n\r\nبه گزارش خبرنگارفرهنگی خبرگزاری تسنیم، جشن سینما و کتاب عصر روز شنبه ۲۱ شهریور و به مناسبت روز سینما با حضور هنرمندان و اهالی رسانه در خانه هنرمندان برگزار شد.\r\n\r\nجشن سینما و کتاب عصر روز ۲۱ شهریورماه و به مناسبت روز سینما با حضور فرخ نعمتی، مسعود رایگان، رویا تیموریان، سیروس ابراهیم زاده، کاظم هژیر آزاد، سهیلا رضوی، بهاره رهنما، نرگس آبیار، سیروس الوند، شمس لنگرودی، پدرام اکبری،بهروز افخمی، مرجان شیرمحمدی، کیوان کثیریان، اندیشه فولادوند و لیلا اوتادی در خانه هنرمندان ایران برگزار شد.\r\n\r\nدر ابتدای این مراسم مجید سرسنگی مدیرعامل خانه هنرمندان ایران در ابتدای برنامه گفت: بسیار خوشحالم که با همکاری آقای جلیسه رئیس خانه کتاب توانستیم جشن سینما و کتاب را در روزهایی که متعلق به سینما است، برگزار کنیم. این برنامه به سینماگرانی اختصاص دارد که در کنار حرفه سینماگری دست به قلم هم هستند و در حوزه های مختلف کتاب هایی را نیز نوشته اند.\r\n\r\nسرسنگی افزود: بدون هیچ اغراقی ادبیات را باید روح یک ملت خواند. روحی که لابلای کلمات و جملات می‌ماند و از نسلی به نسل دیگر منتقل می شود. باید اقرار کرد متاسفانه امروز عادت کتاب خوانی ما جایگاه خود را در کشور از دست داده است. حتی اگر خیلی خوشبینانه هم بگوییم، جایگاهش تنزل پیدا کرده است و مانند گذشته نیست.\r\n\r\nمدیرعامل خانه هنرمندان ایران عنوان کرد: از مدتی قبل و بر اساس تفاهم نامه ای که بین خانه هنرمندان ایران و خانه کتاب منعقد شد، بنا را بر این گذاشتیم که در حوزه ادبیات و کتاب کار بیشتری را انجام دهیم. زیرا اعتقاد داریم که ملت توسعه یافته و پیشرفته، ملتی است که با کتاب انس داشته باشد. این درحالی است که وقتی به شرایط نشر کتاب، خواندن کتاب و ارزش نهادن به کتاب نگاه می کنیم، فاصله بسیاری بین وضع موجود و آن چیزی که از یک کشور متمدن، صاحب فرهنگ و صاحب مفاخر ادبی انتظار می رود، می بینیم.\r\n\r\nسرسنگی ادامه داد: جشن سینما و کتاب یک حرکت نمادین برای قدرشناسی از هنرمندانی است که در کنار حرفه اصلی خود، نوشتن را هم از یاد نبرده اند. گاهی اوقات هنرمندان در رشته ای که کار می کنند ترجیح می دهند در رشته خود فعالیت کنند اما انس آنها با کتاب و نوشتن کتاب، نه تنها مخاطبان را با ارزش های بیشتری از فرهنگ و هنر این افراد آشنا می کند بلکه بر هنر اصلی آنها هم تاثیر می گذارد.\r\n\r\nوی افزود: بسیار خوشحالیم که امروز و در این مناسبت از تعدادی از سینماگران بزرگ کشور که در سال های ۹۳ و ۹۴ در کنار کار سینما، نوشتن را هم ادامه دادند و آثار ارزشمندی را خلق کردند، تجلیل و تقدیر کنیم. امیدواریم که فرهنگ کتاب و کتابخوانی در کشور ما بیش از آن چیزی که امروز هست، جای خود را در جامعه باز کند.\r\nمدیرعامل خانه هنرمندان ایران بیان کرد: یکی از متفکران معاصر ایرانی می گوید:”فقر نداشتن است اما این نداشتن لزوما پول نیست. فقر روزنامه های برگشتی یک شهر است. فقر کتاب هایی است که در یک کتابخانه و یا در یک کتاب فروشی خاک می خورد.” اضافه می کنم که فقر تبدیل شدن یک کتاب فروشی به یک فلافل فروشی در خیابان انقلاب است.\r\n\r\n<strong>سینماگران مسئولیت مهمی در گسترش فرهنگ کتابخوانی دارند</strong>\r\n\r\nپس از آن مجید غلامی جلیسه رئیس خانه کتاب به روی صحنه آمد و گفت: باعث افتخار ماست که در نخستین جشن کتاب و سینما در خدمت شما اساتید سینما هستیم. ما در سال ۹۳ و ابتدای سال ۹۴ سعی کردیم پیوند مبارک و بسیار خوب سینما و کتاب را بیش از پیش مبارک بدانیم. شخصا اعتقاد دارم که سینما نقش بسیار مهمی در توسعه فرهنگ کتاب و کتاب خوانی در کشور دارد.\r\n\r\nوی افزود: در این بین و در رأس آنها سینماگران و عوامل سینمایی نقش مثبت و بسیار خوبی در رشد و گسترش این فرهنگ در سطح جامعه دارند. این جشن در اصل بهانه ای است برای اینکه به سینماگران یادآوری کنیم که چه مسئولیت مهم و بزرگی را در جهت گسترش فرهنگ کتاب و کتاب خوانی برعهده دارند.\r\n\r\nرئیس خانه کتاب ادامه داد: از شما درخواست می کنیم که بیشتر از قبل درمورد کتاب نوشته و سخن بگویید و بیشتر از قبل در کلام، بازی و فیلم های خود به کتاب بپردازید. همچنین سعی کنید تا با هر بهانه ای به کتاب اشاره ای داشته باشید چون مردم سینما و سینماگران را دوست دارند و قطعا این ظرفیت را برای کتاب ما که امروز آنچنان حال و روز خوبی ندارد، می تواند در بین مردم ایجاد کند.\r\n\r\nغلامی جلیسه در پایان گفت: امیدوارم این جشن زمینه ای برای پیوند هرچه بیشتر سینما و کتاب باشد. همچنین در تشویق مردم به مطالعه کتاب و ترویج فرهنگ کتاب خوانی موثر باشد.\r\n\r\nپس از آن فرخ نعمتی با اهدای لوح تقدیر و کتاب نفیسی از استاد فرشچیان به مسعود رایگان از او تقدیر کرد و مسعود رایگان گفت: از خانه کتاب و خانه هنرمندان تشکر می کنم که تلاش بی وقفه ای برای ترویج فرهنگ کتاب و کتابخوانی آغاز کردند. تصور می کنم که این تلاش کافی نیست.\r\n\r\nرایگان خاطرنشان کرد: شما فکر کنید در یک جامعه ۷۰ الی ۸۰ میلیونی کتابی با ۱۲۰۰ نسخه چاپ می شود. بر اساس این آمار، هر ایرانی ۲۰ دقیقه برای خواندن کتاب یا روزنامه وقت می گذارد. بر این اساس باعث تاسف است که رسانه ملی می تواند نقش بسیار فعالی در این زمینه داشته باشد. این رسانه می تواند فرهنگ کتاب خوانی را در سراسر ایران زمین جا بیاندازد. در این راستا طرحی دارم که از طریق رسانه ملی و شبکه دیجیتال کاری کنیم تا هر ایرانی ۵ کتاب را مطالعه کند و این قول را همین جا به شما می دهم که این اتفاق می افتد.\r\n\r\nدر ادامه برنامه غلامحسین امیرخانی استاد خوش نویسی به روی صحنه آمد و پیش از اهدای لوح تقدیر و کتاب نفیسی از استاد فرشچیان به سیروس ابراهیم زاده گفت: آماری که در مورد مطالعه ۲۰ دقیقه ای کتاب توسط هر ایرانی اعلام شد. فکر نمی کنم که این آمار حتی همین ۲۰ دقیقه هم باشد زیرا آمار باید به دقت گرفته شود تا واقعیت ماجرا مشخص شود.\r\n\r\nوی افزود: بر اساس آماری خانم های کتاب خوان ۹ کشور اروپایی بررسی شده بود و حداقل تعداد کتاب خوانده شده در آن کشورها ۹ کتاب و حداکثر ۵۲ کتاب بود. آمار ۵۲ کتاب مطالعه شده برای کشورهای شمال اروپا و آمار ۹ کتاب برای کشور ایتالیا بود. ما در انجمن خوش نویسان ایران معتقدیم که با نوشتن به نوعی خود را در حلقه کتابت و نشر قرار می دهیم.\r\n\r\nامیرخانی افزود: در انجمن خوشنویسان برای جبران این مسأله که شرایط و روزگار ما شاید امکان آن را کم کرده که یک انسان با این مشغله بتواند با کتاب های بزرگی مثل شاهنامه، مثنوی، حافظ و مولوی آشنا شود، به گزیده ها پناه بردیم؛ یعنی کتاب های ارزشمند را در خلاصه ای در حدود ۱۰۰ صفحه با آرایه های مناسبی که جذابیت و زیبایی آن خواننده را به مطالعه آن تشویق کند، گردآوری کردیم و تا حدودی هم موفق بوده ایم.\r\n\r\nاین استاد خوش نویس تصریح کرد: بد نیست به این موضوع اشاره کنم که کشور ما از نظر کتابت و کتاب آرایی در مقام نخست در دنیا قرار دارد. البته ملت های دیگر هم در این حوزه زحمت کشیده و آثار قابل توجهی را خلق کرده اند اما مقام نخست دنیا را ما در اختیار داریم.\r\n\r\nبعد از آن غلامحسین امیرخانی با اهدای لوح تقدیر و کتاب نفیسی از استاد فرشچیان به سیروس ابراهیم زاده از او تجلیل کرد و سیروس ابراهیم زاده نیز گفت: نخستین جشن سینما و کتاب در حقیقت قدم های اولیه تفکرهای بسیار ارزشمند جوانان و هنرمندان ما در این جهت است که بتوانند خود را با دنیای متغیر و متمدن امروز بیشتر هماهنگ کنند.\r\n\r\nابراهیم زاده افزود: کتاب یکی از رسانه های بسیار قدیمی است که ما هم در میراث فرهنگی افتخار داریم که کتاب داریم، کتاب نوشته ایم و در این عرصه فعالیت های فراوانی انجام داده ایم. از طرف دیگر سینما یکی از ستون های ارزشمند مدرنیته است. بر این اساس تلفیق این دو حوزه بسیار مبارک است. ما نوعی آگاهی پیدا کردیم که با این سوابق درخشان فرهنگی، ادبی و هنری نیاز داریم تا خود را به جهان امروز نزدیک تر کنیم.\r\n\r\nاین بازیگر پیش کسوت ادامه داد: ما نباید فراموش کنیم که در دنیایی زندگی می کنیم که به شدت در حال تغییر و تحول است. در بسیاری از زمینه ها از جمله فرهنگی و هنری که آگاهی هایی پیدا کردیم هنوز نتوانستیم خود را به دهکده بزرگ جهانی امروز برسانیم. از این جهت این جشن را بسیار مبارک می دانم که تاثیرات بیشتری در زمینه های دیگری هنر خواهد داشت.\r\n\r\nابراهیم زاده گفت: جای خوشحالی است دوستانی که در زمینه سینما فعالیت می کنند در حوزه انتشار کتاب هم فعال هستند. در حقیقت یکی از ابعاد وجودی یک هنرمند این است که به هنرهای دیگر هم وارد شود. در واقع وقتی یک هنرمند در زمینه های دیگر هم وارد می شود بیشتر و بهتر با مخاطبان خود ارتباط برقرار می کند.\r\n\r\nدر بخش دیگر برنامه مجید سرسنگی مدیرعامل خانه هنرمندان روی صحنه آمد و با اهدای لوح تقدیر و کتاب نفیسی از استاد فرشچیان به کاظم هژیرآزاد از او تجلیل کرد و هژیرآزاد گفت: زمانی که ۱۸ سال داشتم از طریق سینما با بازیگری آشنا شدم. سپس خدمت مصطفی اسکویی رفتم و با پیش کسوتانی چون سیروس ابراهیم زاده، ابراهیم فتحی، دولت آبادی، شیراندامی و سلطان پور آشنا شدم و به خواندن و نوشتن کتاب علاقه پیدا کردم.\r\n\r\nوی افزود: نوشتن را از طریق نوشتن بیوگرافی آموختم. چیزی که آقای اسکویی بسیار بر روی آن تاکید داشت. برای هر نقش باید یک بیوگرافی می نوشتم و همان موجب شد که زیاد کتاب بخوانم. توصیه او این بود که بخوانید، بخوانید، و بخوانید و قدری هم بنویسید.\r\n\r\nدر ادامه برنامه سهیلا رضوی روی صحنه آمد و با اهدای لوح تقدیر و کتاب نفیسی از استاد فرشچیان به بهاره رهنما از او تجلیل کرد و بهاره رهنما در ادامه گفت: می دانم که نمی توانم رقیب شما باشم. از خانه کتاب و خانه هنرمندان تشکر می کنم که از من حمایت کردند. اولین ناشرم نشر چشمه، ناشر دوم نشر نگاه و از نشر مروارید به عنوان ناشری که خطرپذیر بود و نمایشنامه های من در طول ۱۵ سال را منتشر کرد، تشکر و قدردانی می کنم.\r\n\r\nدر بخش دیگر این برنامه مجید غلامی جلیسه رئیس خانه کتاب روی صحنه آمد و با اهدای لوح تقدیر و کتاب نفیسی از استاد فرشچیان به نرگس آبیار از او تجلیل کرد. آبیار نیز گفت: نخستین کتابم در سال ۷۸ منتشر شد. پیش از این سالها ویراستاری کتاب می کردم. ویراستاری کار خیلی سختی بود و ذهن آماده ای نیاز داشت و متن های بهم ریخته و درهم دیگران را باید همیشه تصحیح می کردم، بی آنکه اسمی از من در کار باشد. برخی مواقع حتی متن را بازنویسی می‌کردم.\r\n\r\nآبیار ادامه داد: زمانی که نخستین رمان خود را نوشتم آن قدر راحت و روان این کار را انجام دادم که از اینکه این قدر نثرم پخته و روان شده، شگفت زده شدم. این اتفاق در حوزه فیلمسازی و مستندسازی نیز برایم افتاد. زمانی که نخستین فیلم خود را ساختم احساس کردم که خیلی راحت و روان آن را به سرانجام رساندم. روزهای سختی که چه در دوره ویراستاری و چه در دوره مستند سازی سپری کردم برایم بسیار مبارک و خوب بود و اتفاق های خوبی را برای آینده ام رقم زد.\r\n\r\nکارگردان فیلم شیار ۱۴۳ گفت: امیدوارم در حوزه کتاب هم یک آشتی خوبی بین نویسنده ها و سینماگران اتفاق بیافتد و اقتباس های بیشتری از آثار ادبی صورت گیرد. در این بین نویسنده ها مقداری کوتاه بیایند و کمتر سخت بگیرند و فیلم سازان هم آن قدر نخواهند که خود مولف باشند و فیلمنامه بنویسند. تا هرچه بیشتر شاهد اقتباس آثار از کتاب ها با کمک سینماگران باشیم.\r\n\r\nدر ادامه این مراسم سیروس الوند برای اهدای لوح تقدیر به شمس لنگرودی روی صحنه آمد و قبل از اهدا گفت: ژاپن رفته ها می دانند ژاپنی ها در اتوبوس و تراموا کتاب می خوانند. تصور می کنم میان مردم ژاپن دانستن و آگاهی یک ارزش است و اگر این در کشور ما حل شود، رسانه ها نیز به کتابخوانی می پردازند.\r\n\r\nشمس لنگرودی نیز با صحبت هایی طنز در ادامه عنوان کرد: یکی از دوستان کارگردانم زنگ زد و گفت نمایشگاه نقاشی برگزار کردم و اوضاع خوب نیست. گفتم ببین چقدر اوضاع شعر بد است که من به سینما آمدم!\r\n\r\n<strong>کتابخوانی باید از مدرسه ها شروع شود</strong>\r\n\r\nپدرام اکبری نیز لوح بعدی را به مرجان شیرمحمدی تقدیم کرد و او در صحبت هایی عنوان کرد:کتابخوانی باید از مدرسه ها شروع شود و از آموزش و پرورش می خواهم یک زنگ کتابخوانی برای بچه ها بگذارد. این بهترین زمان عمر بچه هاست که در دنیای تخیل غوطه ور شوند. بچه ها در این شرایط می توانند کتابخوان باشند اما این بزرگترها هستند که شخصیت آنها را شکل می دهند. فرهنگ کتابخوانی باید از مدارس ابتدایی شروع شود.\r\n\r\nدر ادامه برنامه کیوان کثیریان لوح بعدی را به اندیشه فولادوند تقدیم کرد و گفت: در زمینه کتاب نیازمند کمک حوزه های مدیریتی و کلان کشور هستیم. شرایط کنونی و اقتصادی جامعه بسیار بد است و به گونه ای نیست که سبد کتاب در خانوار جایگاه ویژه ای داشته باشد. امیدوارم مدیرانی از این دست، قیمت کالاها و محصولات فرهنگی را کاهش دهند.\r\n\r\nرؤیا تیموریان نیز لوح بعدی را به لیلا اوتادی تقدیم کرد و او نیز بیان کرد: با دوستم در دوران راهنمایی قرار می گذاشتیم رمان بخوانیم و هر هفته درباره آن صحبت می کردیم اما الان جای آن را ثروت خواهی گرفته است.\r\n\r\nرؤیا تیموریان نیز تأکید کرد: به غیر از دبستان این مسأله مربوط به والدین و خودمان می شود و پس از آن همه چیز از لحاظ مدیریتی به دولت باز می گردد.\r\n\r\nامیرحاج رضایی(فعال ورزشی و فوتبالی) نیز برای اهدای لوح بعدی به اشکان خطیبی روی صحنه آمد و گفت: با سینمای شما آموختم، دردمند شدم و شاگردی کردم. سالهاست به سینما علاقه مندم. می خواستم تحصیلاتم را ادامه دهم اما از ادامه آن باز ماندم و به صورت غریزی خواندن را ادامه دادم. هتریک من در زندگی کتاب، سینما و فوتبال بود. خلأهای زندگی را با فوتبال پر می کنم.\r\n\r\nوی افزود: متأسفم که آمار مطالعه پایین است و شخصا چشم انتظاری از حوزه خودم ندارم چون بعد از این همه سال خدمت ۶۰۳ هزارتومان عیدی دریافت کردم.\r\n\r\nحاج رضایی در رابطه با درگذشت ایرج کریمی منتقد یادآور شد: ما به تکثیر این افراد نیازمندیم. فوتبال زندگی من است چون معلم بزرگی برایم بوده و به کمک فوتبال درد از دست دادن همسرم را تحمل کردم. فوتبال کرامت انسانی را به من آموخت.\r\n\r\nاشکان خطیبی نیز بعد از دریافت لوح گفت: کیندل، کتاب اینترنتی و گوگل ریدر در همه گوشی های تلفن همراه بچه ها نصب است. این می تواند در سبد کتاب باشد. زندگی الان اجازه داشتن کتاب های قطور را نمی دهد. لزومی ندارد این کتاب ها به فروش گذاشته شود تا عواید آن خرج امور خیریه شود بلکه می توانند این کتاب را برای دانشجویان خریداری کنند. باید در این رابطه دیدگاهمان را تغییر دهیم.\r\n\r\nسیروس الوند برای دومین بار روی صحنه آمد و لوح را به بهروز افخمی تقدیم کرد و بهروز افخمی نیز گفت: به عنوان خدمتگزار ادبیات و عاشق کلمات اینجا هستم. نشر ساقی اولین ناشر مجموعه مقالاتم است. از بچگی گرفتار کلمات بودم و مادربزرگم قصه می گفت تا اینکه به کلمات خوب رسیدیم.\r\n\r\nانتهای‌پیام/\r\n\r\n</div>","امیدوار به آشتی سینما و ادبیات هستیم","","inherit","closed","closed","","54-revision-v1","","","2018-03-29 20:22:03","2018-03-29 16:52:03","","54","http://islamic.demo-qaleb.ir/54-revision-v1/","0","revision","","0"),
("57","2","2018-03-29 21:09:04","2018-03-29 17:39:04","<p class=\"rtejustify\">به گزارش خبرنگار اقتصادی وزیر راه و شهرسازی و فرمانده قرارگاه خاتم‌الانبیاء امروز پس از بازدید از آزادراه کنارگذر جنوبی تهران از عملیات اجرایی پیشرفت پروژه راه‌آهن سریع‌السیر تهران-قم-اصفهان بازدید کردند.</p>\r\n<p class=\"rtejustify\">این پروژه که برای اولین بار در کشور اجرا می‌شود به پیمانکاری قرارگاه خاتم‌الانبیاء و کارفرمایی دولت اجرا می‌شود.</p>\r\n<p class=\"rtejustify\">بنابراین گزارش، سردار عبادالله عبداللهی در حاشیه بازدید از عملیات اجرایی این پروژه بیان کرد: پروژه راه‌آهن سریع السیر تهران-قم-اصفهان به عنوان یک ابرپروژه مطرح است و باید به عنوان یک ابرپروژه باشد اما ما از روند این پروژه، مطالعات و همه موارد آن فعلاً رضایت خاصی نداریم.</p>\r\n<p class=\"rtejustify\">سردار عبداللهی افزود: این پروژه در دو قطعه تهران تا قم و قم تا اصفهان اجرا خواهد شد که روسازی قم تا اصفهان ۷۵ درصد پیشرفت فیزیکی دارد.</p>\r\n<p class=\"rtejustify\">بنابراین گزارش مدیرعامل شرکت ساخت و توسعه زیربناهای کشور در حاشیه این بازدید درباره راه‌آهن سریع‌السیر تهران – قم – اصفهان بیان کرد: اعتبارات اسنادی راه‌آ‌هن تهران- قم- اصفهان گشایش یافت و هم‌اکنون این پروژه در ۲ فاز تهران – قم – اصفهان فعال است.</p>\r\n<img class=\"size-medium aligncenter\" src=\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/Placko-new-building-plan-03.jpg\" width=\"1200\" height=\"646\" />\r\n<p class=\"rtejustify\">وی با بیان اینکه این پروژه اولین پروژه قطار سریع‌السیر در کشور است، گفت: پیمانکار در محل اجرا مستقر شده است.</p>\r\n<p class=\"rtejustify\">معاون وزیر راه و شهرسازی افزود: قرارگاه سازندگی خاتم‌الانبیاء به عنوان پیمانکار این پروژه با جونیت چینی که LC را آورده است در این پروژه فعال هستند.</p>\r\n<p class=\"rtejustify\">وی ادامه داد: در بخش قم تا اصفهان زیرسازی ۷۰ درصد پیشرفت فیزیکی دارد و در بخش تهران تا قم در مرحله فاز صفر مطالعاتی است.</p>\r\n<p class=\"rtejustify\">نورزاد با بیان اینکه شرکت آزمایشگاه‌ها در این پروژه مستقر شده است، بیان کرد: برنامه‌ریزی می‌کنیم که در فرودگاه امام خمینی (ره) ایستگاه قطار وجود داشته باشد.</p>\r\n<p class=\"rtejustify\">وی بیان کرد: در بخشی از این مسیر از کیلومتر ۲۰۹ به بعد در ۳۵ کیلومتر مشکل تملک اراضی در منطقه اصفهان داریم که ۹ کیلومتر آن منابع طبیعی است.</p>\r\n<p class=\"rtejustify\">معاون وزیر راه و شهرسازی گفت:‌در تعیین موقعیت ایستگاه اصفهان و عبور به سمت شیراز مطالعاتی قبلاً در شرکت ساخت و توسعه زیربناهای حمل‌ونقل انجام شده بود.</p>","بررسی جزئیات اجرای راه‌آهن سریع‌السیر تهران-قم-اصفهان","","publish","open","open","","rile","","","2019-01-26 21:41:23","2019-01-26 18:11:23","","0","http://islamic.demo-qaleb.ir/?p=57","0","post","","0"),
("188","1","2018-03-30 09:55:23","2018-03-30 05:25:23","","58","","inherit","open","closed","","58","","","2018-03-30 09:55:23","2018-03-30 05:25:23","","57","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/58.jpg","0","attachment","image/jpeg","0"),
("59","1","2018-03-29 21:09:04","2018-03-29 17:39:04","<p class=\"rtejustify\">به گزارش خبرنگار اقتصادی وزیر راه و شهرسازی و فرمانده قرارگاه خاتم‌الانبیاء امروز پس از بازدید از آزادراه کنارگذر جنوبی تهران از عملیات اجرایی پیشرفت پروژه راه‌آهن سریع‌السیر تهران-قم-اصفهان بازدید کردند.</p>\r\n<p class=\"rtejustify\">این پروژه که برای اولین بار در کشور اجرا می‌شود به پیمانکاری قرارگاه خاتم‌الانبیاء و کارفرمایی دولت اجرا می‌شود.</p>\r\n<p class=\"rtejustify\">بنابراین گزارش، سردار عبادالله عبداللهی در حاشیه بازدید از عملیات اجرایی این پروژه بیان کرد: پروژه راه‌آهن سریع السیر تهران-قم-اصفهان به عنوان یک ابرپروژه مطرح است و باید به عنوان یک ابرپروژه باشد اما ما از روند این پروژه، مطالعات و همه موارد آن فعلاً رضایت خاصی نداریم.</p>\r\n<p class=\"rtejustify\">سردار عبداللهی افزود: این پروژه در دو قطعه تهران تا قم و قم تا اصفهان اجرا خواهد شد که روسازی قم تا اصفهان ۷۵ درصد پیشرفت فیزیکی دارد.</p>\r\n<p class=\"rtejustify\">بنابراین گزارش مدیرعامل شرکت ساخت و توسعه زیربناهای کشور در حاشیه این بازدید درباره راه‌آهن سریع‌السیر تهران – قم – اصفهان بیان کرد: اعتبارات اسنادی راه‌آ‌هن تهران- قم- اصفهان گشایش یافت و هم‌اکنون این پروژه در ۲ فاز تهران – قم – اصفهان فعال است.</p>\r\n<p class=\"rtejustify\">وی با بیان اینکه این پروژه اولین پروژه قطار سریع‌السیر در کشور است، گفت: پیمانکار در محل اجرا مستقر شده است.</p>\r\n<p class=\"rtejustify\">معاون وزیر راه و شهرسازی افزود: قرارگاه سازندگی خاتم‌الانبیاء به عنوان پیمانکار این پروژه با جونیت چینی که LC را آورده است در این پروژه فعال هستند.</p>\r\n<p class=\"rtejustify\">وی ادامه داد: در بخش قم تا اصفهان زیرسازی ۷۰ درصد پیشرفت فیزیکی دارد و در بخش تهران تا قم در مرحله فاز صفر مطالعاتی است.</p>\r\n<p class=\"rtejustify\">نورزاد با بیان اینکه شرکت آزمایشگاه‌ها در این پروژه مستقر شده است، بیان کرد: برنامه‌ریزی می‌کنیم که در فرودگاه امام خمینی (ره) ایستگاه قطار وجود داشته باشد.</p>\r\n<p class=\"rtejustify\">وی بیان کرد: در بخشی از این مسیر از کیلومتر ۲۰۹ به بعد در ۳۵ کیلومتر مشکل تملک اراضی در منطقه اصفهان داریم که ۹ کیلومتر آن منابع طبیعی است.</p>\r\n<p class=\"rtejustify\">معاون وزیر راه و شهرسازی گفت:‌در تعیین موقعیت ایستگاه اصفهان و عبور به سمت شیراز مطالعاتی قبلاً در شرکت ساخت و توسعه زیربناهای حمل‌ونقل انجام شده بود.</p>","بررسی جزئیات اجرای راه‌آهن سریع‌السیر تهران-قم-اصفهان","","inherit","closed","closed","","57-revision-v1","","","2018-03-29 21:09:04","2018-03-29 17:39:04","","57","http://islamic.demo-qaleb.ir/57-revision-v1/","0","revision","","0"),
("60","1","2018-03-29 21:11:03","2018-03-29 17:41:03","<article id=\"k2Container\" class=\"itemView\">\r\n<div class=\"itemBody StoryBody\">\r\n<div class=\"itemFullText\">\r\n\r\nبه گزارش خبرنگار اقتصادی خبرگزاری نسیم، علی ربیعی وزیر تعاون کار و رفاه اجتماعی امروز با حضور در پنل تخصصی که در همایش ملی ارتقای سلامت اداری و مبارزه با فساد برگزار شده بود با اشاره به اینکه ۱۳ سال پیش چنین همایشی در کشور برگزار شده بود و بنده دبیر آن بودم، اظهار داشت: موضوع فساد مختص کشور ما نیست بلکه این معضل در کشورهای توسعه یافته و در حال توسعه به اشکال  مختلفی وجود دارد.\r\n\r\nوی با بیان اینکه هر چه نظارت بر قدرت کمتر باشد فساد در جامعه بیشتر اتفاق می افتد، افزود: لازمه مبارزه با فساد تدوین برنامه بلند مدت است و نباید به شعارهای سیاسی اکتفاء کنیم.\r\n\r\nوزیر تعاون، کار و رفاه اجتماعی اضافه کرد: مبارزه با فساد را باید از حالت سیاسی خارج کنیم به نحوی که اسم ها باید از جیب بیرون آمده و برخورد جدی با آنها صورت گیرد.\r\n\r\nربیعی با اعتقاد بر اینکه باید برای مبارزه با فساد به فکر شایسته سالاری و اصلاح ساختارها به همراه تقویت نظارت ها باشم، گفت: با برگزاری همایش مقابله با فساد و همکاری دستگاه ها اجرایی می توانیم در مقابله با فساد اقدامات کارآمدی را انجام دهیم.\r\n\r\nوزیر تعاون کار و رفاه اجتماعی در ادامه به ارائه آمارهایی از تخلفات مالی در حوزه مسئولیت خود پرداخت و افزود: هم اکنون پرونده این تخلفات در مراجع قضایی در حال پیگیری است اما به عنوان نمونه می گویم زمینی به ارزش ۱۰۶ میلیارد با استفاده از روابط به ارزش ۳۰ میلیارد تومان به فروش رسیده است. همچنین ۱۷ هزار میلیارد تومان در قالب ۱۳۶ شرکت به فروش رسیده، این امر در حالی است که فروش این سهام شرکت ها بدون مصوبه هیأت مدیره آنها شکل گرفته است.\r\n\r\nوی با تأکید بر اینکه نباید به معضل فساد به صورت مقطعی و غیر علمی نگاه شود، تصریح کرد: وضع قوانین متعدد خود بستر را برای افزایش فساد در جوامع مهیا می کند باید با برنامه ریزی درست سیاست های کارامد را برای مقابله با فساد بکار ببریم.\r\n\r\nانتهای پیام/\r\n\r\n</div>\r\n</div>\r\n</article>","ربیعی: اسم‌ها باید از جیب خارج شده و با مفسدان برخورد جدی شود","","publish","open","open","","%d8%b1%d8%a8%db%8c%d8%b9%db%8c-%d8%a7%d8%b3%d9%85%e2%80%8c%d9%87%d8%a7-%d8%a8%d8%a7%db%8c%d8%af-%d8%a7%d8%b2-%d8%ac%db%8c%d8%a8-%d8%ae%d8%a7%d8%b1%d8%ac-%d8%b4%d8%af%d9%87-%d9%88-%d8%a8%d8%a7-%d9%85","","","2018-03-30 11:16:07","2018-03-30 06:46:07","","0","http://islamic.demo-qaleb.ir/?p=60","0","post","","0"),
("205","1","2018-03-30 11:15:33","2018-03-30 06:45:33","","9876","","inherit","open","closed","","9876","","","2018-03-30 11:15:33","2018-03-30 06:45:33","","60","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/9876.jpg","0","attachment","image/jpeg","0"),
("62","1","2018-03-29 21:11:03","2018-03-29 17:41:03","<article id=\"k2Container\" class=\"itemView\">\r\n<div class=\"itemBody StoryBody\">\r\n<div class=\"itemFullText\">\r\n\r\nبه گزارش خبرنگار اقتصادی خبرگزاری نسیم، علی ربیعی وزیر تعاون کار و رفاه اجتماعی امروز با حضور در پنل تخصصی که در همایش ملی ارتقای سلامت اداری و مبارزه با فساد برگزار شده بود با اشاره به اینکه ۱۳ سال پیش چنین همایشی در کشور برگزار شده بود و بنده دبیر آن بودم، اظهار داشت: موضوع فساد مختص کشور ما نیست بلکه این معضل در کشورهای توسعه یافته و در حال توسعه به اشکال  مختلفی وجود دارد.\r\n\r\nوی با بیان اینکه هر چه نظارت بر قدرت کمتر باشد فساد در جامعه بیشتر اتفاق می افتد، افزود: لازمه مبارزه با فساد تدوین برنامه بلند مدت است و نباید به شعارهای سیاسی اکتفاء کنیم.\r\n\r\nوزیر تعاون، کار و رفاه اجتماعی اضافه کرد: مبارزه با فساد را باید از حالت سیاسی خارج کنیم به نحوی که اسم ها باید از جیب بیرون آمده و برخورد جدی با آنها صورت گیرد.\r\n\r\nربیعی با اعتقاد بر اینکه باید برای مبارزه با فساد به فکر شایسته سالاری و اصلاح ساختارها به همراه تقویت نظارت ها باشم، گفت: با برگزاری همایش مقابله با فساد و همکاری دستگاه ها اجرایی می توانیم در مقابله با فساد اقدامات کارآمدی را انجام دهیم.\r\n\r\nوزیر تعاون کار و رفاه اجتماعی در ادامه به ارائه آمارهایی از تخلفات مالی در حوزه مسئولیت خود پرداخت و افزود: هم اکنون پرونده این تخلفات در مراجع قضایی در حال پیگیری است اما به عنوان نمونه می گویم زمینی به ارزش ۱۰۶ میلیارد با استفاده از روابط به ارزش ۳۰ میلیارد تومان به فروش رسیده است. همچنین ۱۷ هزار میلیارد تومان در قالب ۱۳۶ شرکت به فروش رسیده، این امر در حالی است که فروش این سهام شرکت ها بدون مصوبه هیأت مدیره آنها شکل گرفته است.\r\n\r\nوی با تأکید بر اینکه نباید به معضل فساد به صورت مقطعی و غیر علمی نگاه شود، تصریح کرد: وضع قوانین متعدد خود بستر را برای افزایش فساد در جوامع مهیا می کند باید با برنامه ریزی درست سیاست های کارامد را برای مقابله با فساد بکار ببریم.\r\n\r\nانتهای پیام/\r\n\r\n</div>\r\n</div>\r\n</article>","ربیعی: اسم‌ها باید از جیب خارج شده و با مفسدان برخورد جدی شود","","inherit","closed","closed","","60-revision-v1","","","2018-03-29 21:11:03","2018-03-29 17:41:03","","60","http://islamic.demo-qaleb.ir/60-revision-v1/","0","revision","","0"),
("63","1","2018-03-29 21:13:06","2018-03-29 16:43:06","«اعوذ بالله من الشیطان الرجیم»\r\n\r\nبسم الله الرحمن الرحیم\r\n\r\nوَ قالَ مُوسى‏ لِأَخیهِ هارُونَ اخْلُفْنی‏ فی‏ قَوْمی‏ وَ أَصْلِحْ وَ لاتَتَّبِعْ سَبیلَ الْمُفْسِدینَ\r\n\r\nدر گذر بیش از سه دهه از عمر پربرکت نظام مقدس جمهوری اسلامی ایران، اقدامات فراوان و مؤثری در خصوص مقابله با فساد اداری صورت گرفته است. لیکن فرمان هشت ماده‌ای مقام معظم رهبری (مد ظله العالی) خطاب به سران قوای سه‌گانه کشور که در آن نقشه راه و خط‌مشی مبارزه با فساد، ترسیم شده، به‌عنوان منشور مبارزه با فساد اقتصادی و مالی و چراغ راه مسئولین نظام شناخته می‌شود.\r\nبانک مرکزی نیز به‌عنوان یکی از اجزای نظام مقدس جمهوری اسلامی ایران و سیاست‌گذار اصلی نظام پولی کشور که مسئولیت برقراری ثبات مالی، رشد اقتصادی مستمر و حفظ نظم و انضباط در بازار پول را بره‌عهده دارد، در راستای منویات مقام معظم رهبری از یک سو و حرکت در جهت دستیابی به نظام بانکی مبتنی بر استانداردهای بین المللی از سوی دیگر، مصمم است با تلاش هدفمند، گامهایی مؤثر در جهت شفاف سازی و سالم سازی اقتصاد، جلوگیری از اقدامات، فعالیت‌ها و زمینه‌های فسادزا به‌خصوص در حوزه پولی و ارزی بردارد.\r\n\r\nاین بانک با اعتقاد به این حقیقت که امروزه فساد در صور گوناگون آن نظیر رشوه، پول‌شویی، تقلب، اختلاس، تبانی و کسب امتیازات خاص، به‌صورت سیستمی در حال شکل‌گیری است، با ملحوظ نظر داشتن چهار حوزه اصلی تأثیرگذار در ایجاد و گسترش فساد در نظام بانکی کشور شامل «عدم شفافیت در مراودات مالی و تبادلات بانکی»، «نظارت بانکی و چالش‌های آن»، «چالش‌های پیش‌روی بازار غیرمتشکل پولی» و «ناکارآمدی سیستم‌های اطلاعاتی بین دستگاه‌ها»، با به‌کارگیری فناوری‌های نوین و توسعه زیرساخت‌های اطلاعاتی و نظارتی در راستای نظارت دقیق و همه‌جانبه بر عملیات بانکی، حصول اطمینان از رعایت استانداردها و ضوابط، تطبیق عملیات بانک‌داری با ضوابط مبارزه با پول‌شویی و پرهیز از اقدامات بازارشکنانه، اهتمام ویژه‌ای در مبارزه با عوامل مؤثر در مفاسد اقتصادی در حوزه پولی و مالی داشته است که موفقیت در این مسئولیت خطیر، تلاش بی‌شائبه و همه‌جانبه‌ای را برای ایجاد اشراف و حاکمیت مناسب در بانک مرکزی، ایجاب می‌نماید.\r\nدر راستای تحقق این مهم، راهبرد بانک مرکزی جمهوری اسلامی ایران در حوزه ارتقای سلامت اداری و مبارزه با پول‌شویی را می‌توان در سه رکن اساسی ساختار، روش‌ها و فناوری طبقه بندی نمود:\r\nدر رکن ساختار، بانک مرکزی نیازمند حصول اطمینان از بهره‌مندی از سازوکاری سازمانی است که بتواند این بانک را از نظر عملیات، ساختار مالی و رعایت قوانین و مقررات، مورد پایش و کنترل قرار داده و با آگاهی به‌موقع مقامات ارشد از تنگناها و مشکلات، یاری رسان آنان در بهبود عملکرد سازمان باشند که این مهم به حوزه بازرسی، پی‌گیری ویژه و نظارت بر امور اجرایی ــ با محوریت حسابرسی داخلی، ارزیابی عملکرد و پاسخگویی و رسیدگی به شکایات، محول شده است.\r\nدر رکن روش‌ها و فرآیندها، بانک مرکزی تحولات شگرف محیطی و شیوه‌های انجام کار را مد نظر قرار داده است. یکی از چالش‌های مهم نظام پولی و بانکی کشور، بروز شکاف و فاصله میان واقعیت روزمره در حال تحول و روش‌های اجرایی ناظر بر ممیزی، حسابرسی و کنترل بر روندهای کاری است که همچنان بر مدار روابط سنتی پیشین می‌چرخد.\r\nدر سال‌های گذشته ورود همه‌جانبه فناوری به حیطه فعالیت‌های بانکی، مجموعه نظارتی بانک مرکزی را با چالش‌های مربوط به افزایش سرعت عملیات و نیز حجم انبوه داده‌ها، مواجه نموده است. لذا بازنگری در روش‌های کنترلی و نظارتی و تمرکز بر نوسازی فرایندهای انجام کار و لحاظ نقاط رسیدگی و بازبینی به‌صورت سیستمی یکی از الزامات مهم است. از این رو بانک مرکزی جمهوری اسلامی ایران با آغاز دو طرح هم‌راستای بانک مرکزی ۱۴۰۰ و نیز نقشه راه و نوسازی نظام بانکی در صدد است تا با تعریف مجدد و روزآمد نمودن فرآیندها و روش‌های عملیاتی در نظام بانکی و بازتعریف نقش‌های نظارتی بانک مرکزی و واحدهای بازرسی و نظارتی در بانک‌ها، همگامی با تحولات محیطی را طراحی نماید.\r\nساختار مناسب و روش‌های انجام کار در زمینه تحول نگرش به داده‌ها و اطلاعات، توسط بانک مرکزی و نظام بانکی صورت می‌پذیرد. نظام بانکی کشور در این حوزه، از دو دهه گذشته، پیشگام و فعال بوده و تقریباً تمامی فعالیت‌های خود را با تکیه بر فناوری راهبری می‌کند. تکیه بر فناوری‌های جدید، گرچه مزایای غیرقابل انکاری برای نظام پولی و مردم داشته، اما حجم انبوهی از داده‌ها و اطلاعات را در پایگاه‌های داده مختلف، انباشته کرده که با توجه به افزایش چشمگیر حجم مبادلات، پردازش و تحلیل آنها به‌عنوان یک چالش مهم مقابل نظام بانکی قرار گرفته است. اقدامات بانک مرکزی در حوزه فناوری در سه شاخه به هم پیوسته دنبال می‌شود، اولاً، جامعیت و پیوستگی سامانه‌های الکترونیکی پردازش بانکی ،باید در تمامی انواع ابزارها و خدمات حاصل شود، ثانیاً، ماهیت داده‌ها و اطلاعات، باید به‌صورت استاندارد تعریف، پردازش و نگه‌داری شود و ثالثاً، سازوکارهای پردازش انبوه اطلاعات به‌منظور حصول اطمینان از اجرای قوانین و مقررات، کشف سریع و دقیق تخلفات و موارد مشکوک و اتخاذ اقدامات اصلاحی و تأمینی در زمان مناسب ایجاد شود.\r\nپیوستگی میان ساختار، فرایند و فناوری در بانک مرکزی جمهوری اسلامی ایران، در قالب سامانه‌هایی برنامه‌ریزی شده است که هریک به‌صورت نظام‌مند و همزمان، ابعاد کارکردی مبارزه با فساد در نظام پولی را مورد هدف قرار می‌دهد که شایسته است با توجه به ضیق وقت در اینجا به‌صورت خلاصه به برخی از این سامانه‌ها، اشاره کنم:\r\n۱٫ نسیم، Core banking یا بانک‌داری متمرکز الکترونیکی بانک مرکزی سامانه‌ای است که به‌منظور همگامی این بانک با تحولات فناوری و پوشش وظایف ذاتی آن در قانون پولی و بانکی کشور به‌عنوان بانک‌دار دولت پیاده سازی شده است که با استفاده از امکانات آن می‌توان تمامی عملیات مربوط به مدیریت حساب‌های دولتی را که بنا به دلایل متعددی از جمله نبود زیرساخت‌های لازم در زمینه بانک‌داری الکترونیک و سامانه‌های نوین بانک‌داری، به بانک‌های تجاری واگذار شده بود، مجدداً به بانک مرکزی بازگرداند. لازم به ذکر است که بیش از دویست هزار حساب در شبکه بانکی متعلق به وجوه دولت بوده و نظارت لازم و کافی بر آنها وجود نداشته است.\r\nهمان‌گونه که در تصویر مشاهده می‌فرمایید، ایجاد تمرکز و یک‌پارچگی در حساب‌های دولتی و امکان رصد و پایش دقیق منابع و مصارف دولت و به‌دنبال آن احصای صحیح و به‌هنگام درآمدهای دولت از جمله مزایایی است که با راه‌اندازی این سامانه از آن بهره‌مند خواهیم شد.\r\n۲٫ سامانه پیام‌رسانی مالی الکترونیکی یا «سپام»\r\nزیرساختی است که تمامی مراودات بین بانک‌ها را از طریق پروتکل‌های استاندارد مبادلات مالی، تحت پوشش قرار می‌دهد. با استفاده از این زیرساخت، تمامی مراودات مالی عمده بانک‌ها از قبیل اعتبارات اسنادی و ضمانت‌نامه‌های ارزی و ریالی و حوالجات ارزی از طریق یک شبکه واحد پیام‌رسانی قابل انجام بوده و ابزارهای نظارتی بانک مرکزی به‌منظور رصد و پایش این مراودات، روی آن قابل پیاده‌سازی است. شایان ذکر است که طرح پایلوت سامانه پیش‌گفت از ۱۳۹۳/۰۹/۲۰ در سراسر کشور راه‌اندازی می‌شود و امید است از بهمن ماه سال جاری به‌صورت رسمی آغاز به کار نماید.\r\n۳٫ فرآیند اجرایی و پردازشی فعلی چک، منجر به ایجاد اوضاع نابسامان تبادل چک اشخاص با ارقام برگشتی با مبالغ بالا و تعداد چشمگیر آن ( چیزی در حدود ۲۶میلیون قطعه طی سالهای۹۳-۸۹ )، گردش طولانی و غیر نظام‌مند و غیر ضرور فیزیک چک، صدور دسته‌چک‌های متنوع با ابعاد و محتوای متفاوت چک‌ها در بانک‌های مختلف، محدودیت در پایش و نیز کندی پردازش آن‌ها و در نهایت بی‌اعتمادی عامه مردم و بازارهای مبادله به این ابزار موثر پرداخت در بازار سنتی شده است.\r\nسامانه مدیریت الکترونیکی چک ( چکاوک) که با هدف حذف گردش فیزیکی چک‌ها بین شعب و واحد‌های بانکی و اعمال نظارت متمرکز بر جریان گردش وجوه و اعمال کنترل‌های قانونی و مقرراتی؛ براساس‌ مصوبه شورای پول و اعتبار، مراحل اجرایی خود را طی می کند، اعتماد را به چک بازگردانده و با امکان برخورداری ذینفع به حداقل اطلاعات واگذارنده چک،‌اطمینان نسبی را برای ایفای تعهد ایجاد می کند.\r\nاین سامانه مطابق با برنامه‌ریزی‌های به عمل آمده تا کنون در استانهای قم، قزوین، زنجان، سمنان، کرمانشاه، همدان، مرکزی، ایلام، البرز، کردستان، لرستان و گلستان عملیاتی شده و نهایتاً تا اسفند ماه سال جاری به طور کامل در سراسر کشور به اجرا درخواهد آمد.\r\n۴٫ پورتال ارزی اَبَرسامانه‌ای است که سامانه‌های ثبتارش (بازرگانی)، آسیکودا (گمرک) و ارزی (بانک مرکزی) را به یکدیگر متصل نموده فرآیندهای بین‌دستگاهی را میان این سامانه‌ها مدیریت می‌کند و از طریق شفاف‌سازی، یک‌پارچگی و نظارت دقیق و همه‌جانبه بر عملیات مرتبط با واردات و صادرات، فرصت هرگونه تبانی در جهت ارزان نمایی و گران نمایی کالا، خروج ارز از کشور از طریق جعل مدارک، اسناد گمرکی و پیمان‌نامه‌های ارزی و گریز از حقوق گمرکی را به حداقل می‌رساند.\r\n\r\n۵٫ فناوری اطلاعات در سال‌های گذشته با تعمیق نفوذ خود، تحولات عظیمی را در حوزه ارتباطات بین افراد و سازمان‌ها ایجاد و علاوه بر ایجاد اسناد الکترونیکی، با تحول در فرایندهای سنتی، موجبات تسریع، تدقیق و ردیابی مراودات با ابزارهای متنوع و سهل‌الوصول را فراهم کرده است.\r\nبا توجه به پیشرفت‌های حاصل شده در حوزه خدمت‌رسانی به مشتریان، اینک قوه قضائیه و بانک مرکزی جمهوری اسلامی ایران در صددند تا مراودات و مکاتبات فی‌مابین را نیز از مواهب پیشرفت‌های فناوری برخوردار سازند.\r\nاز این رو به‌منظور برقراری ارتباط الکترونیکی بین نظام بانکی کشور و قوه قضائیه که یکی از حساس‌ترین و مهمترین ارتباطات بین دستگاهی است، بستری مناسب به‌لحاظ اجرایی و مدیریتی با در نظر گرفتن ملاحظات ویژه (با عنایت به ماهیت اسناد و مکاتبات)، برقراری اطمینان از محرمانگی، انکار ناپذیری و اصالت مکاتبات و داده‌های تبادل شده ایجاد گردیده است.\r\n۶٫ مرکز امنیتی، تخصصی «کاشف» با نظارت بانک مرکزی جمهوری اسلامی ایران به‌منظور تأمین امنیت اطلاعات بانکی کشور از طریق تدوین الزامات و ایجاد چارچوب‌های امنیتی، مدیریت متمرکز امنیت، مدیریت رخدادهای امنیتی و به اشتراک گذاری اطلاعات و تجارب امنیتی بانک‌ها و مؤسسات مالی و اعتباری پیاده‌سازی شده است. این مرکز به‌عنوان نقطه تماس واحد، در تعامل با سایر نهادهای انتظامی، امنیتی و قضایی کشور، وظیفه جمع‌آوری و اشتراک‌گذاری اطلاعات و هماهنگی بین بانک‌ها در مواقع بروز رخدادهای امنیتی و بحران‌های سایبری را عهده‌دار است.\r\n۷٫ نظارت الکترونیکی بانک‌ها (سناب) سامانه‌ای است که استانداردسازی، یک‌پارچه کردن داده‌ها و اطلاعات بانکی و ایجاد یک ساختار منسجم گزارش‌گیری برخط، امکان نظارت الکترونیکی به‌هنگام و جامع بر عملیات بانک‌ها، ایجاد بانک اطلاعاتی یک‌پارچه از داده‌های پالایش شده بانکی، پایش و مانیتورینگ سیستم بانکی به‌لحاظ شناسایی تخلفات و سوء‌استفاده‌های مالی و … را مهیا می‌کند.\r\n۸٫ پس از گذشت حدود یک دهه از تصویب راهبرد نظام جامع پرداخت و با توجه به نظام‌های جدید پرداخت و تسویه و ابزارها و فناوری‌های نوین به‌وجود‌ آمده در جهان، بانک مرکزی جمهوری اسلامی ایران بر‌ آن شد تا نقشه راه ده سال آینده شبکه بانکی کشور را با کمک مشاوران خبره تدوین نماید. در این نقشه زیرساخت‌های اطلاعاتی مورد نیاز در حوزه‌های مختلف مأموریتی بانک مرکزی که طی ده سال آینده به‌طور تدریجی تکمیل و یا مستقر خواهند شد، شناسایی می‌شوند.\r\nاهداف اصلی نقشه راه ۱۴۰۰ بانک مرکزی، شامل تجزیه و تحلیل وضعیت موجود و رفع موانع، جهت نیل به یک نظام بانکی نوین بر پایه استانداردهای جهانی،‌ تعیین مسیرهای آتی نظام بانکی کشور، شناسایی و تعریف اهداف بلندمدت و استراتژیک، به‌کارگیری فناوری‌های نوین بانکی براساس استانداردهای جهانی، شناسایی ریسک‌های متفاوت و تدوین مدیریت ریسک است.\r\nنگاه بانک مرکزی به مبارزه با فساد، رویکردی راهبردی و بلندمدت است؛ باید توجه داشت که بروز فساد بیش از هرچیز ناشی از ضعف در ساختارها، فرایندها و مناسباتی است که طی زمان شکل گرفته و حفره‌های مقرراتی و زمینه‌های فساد در آن برای کسانی که در صدد سوء‌استفاده هستند روشن شده است. از این رو مبارزه جدی با فساد نیازمند تحول در حوزه‌های ساختاری و بنیادین است. فناوری و امکانات آن، فرصت مناسبی را برای بازنگری در این مناسبات و کشف نقاط آسیب‌پذیر و پوشش آنها فراهم کرده است و بانک مرکزی جمهوری اسلامی ایران در صدد است با اتخاذ راهبرد یادشده و بهره‌گیری کامل از امکانات فناوری، تحولی جدی در مقوله مبارزه با فساد را آغاز کند و به‌فضل الهی به انجام برساند.\r\nدر کوتاه‌مدت نیز ساماندهی بازار غیرمتشکل که فعالیت نهادهای پولی و بانکی بدون مجوز را شامل می‌شود، به‌صورت ویژه در دستور کار این بانک قرار دارد.\r\nمؤسسات پیش‌گفت قبلاً با داشتن سهمی تقریباً ۳۰درصدی از بازار پولی کشور، بدون نظارت بانک مرکزی سهم قابل توجهی در نوسانات ناخوشایند بازارهای مختلف ایفا ‌نموده و با ورود به فعالیت‌های سوداگرانه نظیر خرید و فروش مسکن، ارز، طلا و حتی احتکار ارزاق عمومی مردم و … کنار سایر عوامل، این بازارها را با تلاطم مواجه می‌ساختند.\r\nخوشبختانه با پیگیری‌های مستمر بانک مرکزی در جهت اجرای قانون تنظیم بازار غیرمتشکل پولی و قانون برنامه پنجم توسعه، علی‌رغم چالش‌های متعدد، بخشی از این مؤسسات فاقد مجوز؛ ساماندهی و منابع این مؤسسات در راستای اهداف نظام بانکی کشور هدایت گردیده است و در ادامه ضمناً انتظام بخشی سایر مؤسسات عمده بازار مزبور، در دستور کار قرار دارد و مراحل اجرایی را طی می‌کند.\r\nامید است به‌یاری حضرت حق و مساعدت کلیه دستگاه‌های اجرایی و نظارتی، شاهد مبارزه‌ای فراگیر و سیستمی با فساد باشیم. بدیهی است که طی این راه طولانی و توفیق در این مهم و ریشه‌کن کردن فساد و تحقق اراده مقام عظمای ولایت و مطالبات ملت در برخورد با مفسدین اقتصادی و سوءاستفاده گران، تعامل، همفکری، همراهی و همکاری همه‌جانبه دست اندر کاران نظام مقدس جمهوری اسلامی ایران را می‌طلبد.\r\n\r\nهمتم بدرقه راه کن ای طایر قدس ‌ که دراز است ره مقصد و من نوسفرم","امروز اختلاس، تبانی  به‌ صورت سیستمی در حال شکل‌گیری است","","publish","open","open","","%d8%a7%d9%85%d8%b1%d9%88%d8%b2-%d8%a7%d8%ae%d8%aa%d9%84%d8%a7%d8%b3%d8%8c-%d8%aa%d8%a8%d8%a7%d9%86%db%8c-%d9%88-%da%a9%d8%b3%d8%a8-%d8%a7%d9%85%d8%aa%db%8c%d8%a7%d8%b2%d8%a7%d8%aa-%d8%ae%d8%a7%d8%b5","","","2018-09-11 12:14:11","2018-09-11 07:44:11","","0","http://islamic.demo-qaleb.ir/?p=63","0","post","","0"),
("204","1","2018-03-30 11:14:34","2018-03-30 06:44:34","","7607","","inherit","open","closed","","7607","","","2018-03-30 11:14:34","2018-03-30 06:44:34","","63","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/7607.jpg","0","attachment","image/jpeg","0"),
("65","1","2018-03-29 21:13:06","2018-03-29 17:43:06","«اعوذ بالله من الشیطان الرجیم»\r\n\r\nبسم الله الرحمن الرحیم\r\n\r\nوَ قالَ مُوسى‏ لِأَخیهِ هارُونَ اخْلُفْنی‏ فی‏ قَوْمی‏ وَ أَصْلِحْ وَ لاتَتَّبِعْ سَبیلَ الْمُفْسِدینَ\r\n\r\nدر گذر بیش از سه دهه از عمر پربرکت نظام مقدس جمهوری اسلامی ایران، اقدامات فراوان و مؤثری در خصوص مقابله با فساد اداری صورت گرفته است. لیکن فرمان هشت ماده‌ای مقام معظم رهبری (مد ظله العالی) خطاب به سران قوای سه‌گانه کشور که در آن نقشه راه و خط‌مشی مبارزه با فساد، ترسیم شده، به‌عنوان منشور مبارزه با فساد اقتصادی و مالی و چراغ راه مسئولین نظام شناخته می‌شود.\r\nبانک مرکزی نیز به‌عنوان یکی از اجزای نظام مقدس جمهوری اسلامی ایران و سیاست‌گذار اصلی نظام پولی کشور که مسئولیت برقراری ثبات مالی، رشد اقتصادی مستمر و حفظ نظم و انضباط در بازار پول را بره‌عهده دارد، در راستای منویات مقام معظم رهبری از یک سو و حرکت در جهت دستیابی به نظام بانکی مبتنی بر استانداردهای بین المللی از سوی دیگر، مصمم است با تلاش هدفمند، گامهایی مؤثر در جهت شفاف سازی و سالم سازی اقتصاد، جلوگیری از اقدامات، فعالیت‌ها و زمینه‌های فسادزا به‌خصوص در حوزه پولی و ارزی بردارد.\r\n\r\nاین بانک با اعتقاد به این حقیقت که امروزه فساد در صور گوناگون آن نظیر رشوه، پول‌شویی، تقلب، اختلاس، تبانی و کسب امتیازات خاص، به‌صورت سیستمی در حال شکل‌گیری است، با ملحوظ نظر داشتن چهار حوزه اصلی تأثیرگذار در ایجاد و گسترش فساد در نظام بانکی کشور شامل «عدم شفافیت در مراودات مالی و تبادلات بانکی»، «نظارت بانکی و چالش‌های آن»، «چالش‌های پیش‌روی بازار غیرمتشکل پولی» و «ناکارآمدی سیستم‌های اطلاعاتی بین دستگاه‌ها»، با به‌کارگیری فناوری‌های نوین و توسعه زیرساخت‌های اطلاعاتی و نظارتی در راستای نظارت دقیق و همه‌جانبه بر عملیات بانکی، حصول اطمینان از رعایت استانداردها و ضوابط، تطبیق عملیات بانک‌داری با ضوابط مبارزه با پول‌شویی و پرهیز از اقدامات بازارشکنانه، اهتمام ویژه‌ای در مبارزه با عوامل مؤثر در مفاسد اقتصادی در حوزه پولی و مالی داشته است که موفقیت در این مسئولیت خطیر، تلاش بی‌شائبه و همه‌جانبه‌ای را برای ایجاد اشراف و حاکمیت مناسب در بانک مرکزی، ایجاب می‌نماید.\r\nدر راستای تحقق این مهم، راهبرد بانک مرکزی جمهوری اسلامی ایران در حوزه ارتقای سلامت اداری و مبارزه با پول‌شویی را می‌توان در سه رکن اساسی ساختار، روش‌ها و فناوری طبقه بندی نمود:\r\nدر رکن ساختار، بانک مرکزی نیازمند حصول اطمینان از بهره‌مندی از سازوکاری سازمانی است که بتواند این بانک را از نظر عملیات، ساختار مالی و رعایت قوانین و مقررات، مورد پایش و کنترل قرار داده و با آگاهی به‌موقع مقامات ارشد از تنگناها و مشکلات، یاری رسان آنان در بهبود عملکرد سازمان باشند که این مهم به حوزه بازرسی، پی‌گیری ویژه و نظارت بر امور اجرایی ــ با محوریت حسابرسی داخلی، ارزیابی عملکرد و پاسخگویی و رسیدگی به شکایات، محول شده است.\r\nدر رکن روش‌ها و فرآیندها، بانک مرکزی تحولات شگرف محیطی و شیوه‌های انجام کار را مد نظر قرار داده است. یکی از چالش‌های مهم نظام پولی و بانکی کشور، بروز شکاف و فاصله میان واقعیت روزمره در حال تحول و روش‌های اجرایی ناظر بر ممیزی، حسابرسی و کنترل بر روندهای کاری است که همچنان بر مدار روابط سنتی پیشین می‌چرخد.\r\nدر سال‌های گذشته ورود همه‌جانبه فناوری به حیطه فعالیت‌های بانکی، مجموعه نظارتی بانک مرکزی را با چالش‌های مربوط به افزایش سرعت عملیات و نیز حجم انبوه داده‌ها، مواجه نموده است. لذا بازنگری در روش‌های کنترلی و نظارتی و تمرکز بر نوسازی فرایندهای انجام کار و لحاظ نقاط رسیدگی و بازبینی به‌صورت سیستمی یکی از الزامات مهم است. از این رو بانک مرکزی جمهوری اسلامی ایران با آغاز دو طرح هم‌راستای بانک مرکزی ۱۴۰۰ و نیز نقشه راه و نوسازی نظام بانکی در صدد است تا با تعریف مجدد و روزآمد نمودن فرآیندها و روش‌های عملیاتی در نظام بانکی و بازتعریف نقش‌های نظارتی بانک مرکزی و واحدهای بازرسی و نظارتی در بانک‌ها، همگامی با تحولات محیطی را طراحی نماید.\r\nساختار مناسب و روش‌های انجام کار در زمینه تحول نگرش به داده‌ها و اطلاعات، توسط بانک مرکزی و نظام بانکی صورت می‌پذیرد. نظام بانکی کشور در این حوزه، از دو دهه گذشته، پیشگام و فعال بوده و تقریباً تمامی فعالیت‌های خود را با تکیه بر فناوری راهبری می‌کند. تکیه بر فناوری‌های جدید، گرچه مزایای غیرقابل انکاری برای نظام پولی و مردم داشته، اما حجم انبوهی از داده‌ها و اطلاعات را در پایگاه‌های داده مختلف، انباشته کرده که با توجه به افزایش چشمگیر حجم مبادلات، پردازش و تحلیل آنها به‌عنوان یک چالش مهم مقابل نظام بانکی قرار گرفته است. اقدامات بانک مرکزی در حوزه فناوری در سه شاخه به هم پیوسته دنبال می‌شود، اولاً، جامعیت و پیوستگی سامانه‌های الکترونیکی پردازش بانکی ،باید در تمامی انواع ابزارها و خدمات حاصل شود، ثانیاً، ماهیت داده‌ها و اطلاعات، باید به‌صورت استاندارد تعریف، پردازش و نگه‌داری شود و ثالثاً، سازوکارهای پردازش انبوه اطلاعات به‌منظور حصول اطمینان از اجرای قوانین و مقررات، کشف سریع و دقیق تخلفات و موارد مشکوک و اتخاذ اقدامات اصلاحی و تأمینی در زمان مناسب ایجاد شود.\r\nپیوستگی میان ساختار، فرایند و فناوری در بانک مرکزی جمهوری اسلامی ایران، در قالب سامانه‌هایی برنامه‌ریزی شده است که هریک به‌صورت نظام‌مند و همزمان، ابعاد کارکردی مبارزه با فساد در نظام پولی را مورد هدف قرار می‌دهد که شایسته است با توجه به ضیق وقت در اینجا به‌صورت خلاصه به برخی از این سامانه‌ها، اشاره کنم:\r\n۱٫ نسیم، Core banking یا بانک‌داری متمرکز الکترونیکی بانک مرکزی سامانه‌ای است که به‌منظور همگامی این بانک با تحولات فناوری و پوشش وظایف ذاتی آن در قانون پولی و بانکی کشور به‌عنوان بانک‌دار دولت پیاده سازی شده است که با استفاده از امکانات آن می‌توان تمامی عملیات مربوط به مدیریت حساب‌های دولتی را که بنا به دلایل متعددی از جمله نبود زیرساخت‌های لازم در زمینه بانک‌داری الکترونیک و سامانه‌های نوین بانک‌داری، به بانک‌های تجاری واگذار شده بود، مجدداً به بانک مرکزی بازگرداند. لازم به ذکر است که بیش از دویست هزار حساب در شبکه بانکی متعلق به وجوه دولت بوده و نظارت لازم و کافی بر آنها وجود نداشته است.\r\nهمان‌گونه که در تصویر مشاهده می‌فرمایید، ایجاد تمرکز و یک‌پارچگی در حساب‌های دولتی و امکان رصد و پایش دقیق منابع و مصارف دولت و به‌دنبال آن احصای صحیح و به‌هنگام درآمدهای دولت از جمله مزایایی است که با راه‌اندازی این سامانه از آن بهره‌مند خواهیم شد.\r\n۲٫ سامانه پیام‌رسانی مالی الکترونیکی یا «سپام»\r\nزیرساختی است که تمامی مراودات بین بانک‌ها را از طریق پروتکل‌های استاندارد مبادلات مالی، تحت پوشش قرار می‌دهد. با استفاده از این زیرساخت، تمامی مراودات مالی عمده بانک‌ها از قبیل اعتبارات اسنادی و ضمانت‌نامه‌های ارزی و ریالی و حوالجات ارزی از طریق یک شبکه واحد پیام‌رسانی قابل انجام بوده و ابزارهای نظارتی بانک مرکزی به‌منظور رصد و پایش این مراودات، روی آن قابل پیاده‌سازی است. شایان ذکر است که طرح پایلوت سامانه پیش‌گفت از ۱۳۹۳/۰۹/۲۰ در سراسر کشور راه‌اندازی می‌شود و امید است از بهمن ماه سال جاری به‌صورت رسمی آغاز به کار نماید.\r\n۳٫ فرآیند اجرایی و پردازشی فعلی چک، منجر به ایجاد اوضاع نابسامان تبادل چک اشخاص با ارقام برگشتی با مبالغ بالا و تعداد چشمگیر آن ( چیزی در حدود ۲۶میلیون قطعه طی سالهای۹۳-۸۹ )، گردش طولانی و غیر نظام‌مند و غیر ضرور فیزیک چک، صدور دسته‌چک‌های متنوع با ابعاد و محتوای متفاوت چک‌ها در بانک‌های مختلف، محدودیت در پایش و نیز کندی پردازش آن‌ها و در نهایت بی‌اعتمادی عامه مردم و بازارهای مبادله به این ابزار موثر پرداخت در بازار سنتی شده است.\r\nسامانه مدیریت الکترونیکی چک ( چکاوک) که با هدف حذف گردش فیزیکی چک‌ها بین شعب و واحد‌های بانکی و اعمال نظارت متمرکز بر جریان گردش وجوه و اعمال کنترل‌های قانونی و مقرراتی؛ براساس‌ مصوبه شورای پول و اعتبار، مراحل اجرایی خود را طی می کند، اعتماد را به چک بازگردانده و با امکان برخورداری ذینفع به حداقل اطلاعات واگذارنده چک،‌اطمینان نسبی را برای ایفای تعهد ایجاد می کند.\r\nاین سامانه مطابق با برنامه‌ریزی‌های به عمل آمده تا کنون در استانهای قم، قزوین، زنجان، سمنان، کرمانشاه، همدان، مرکزی، ایلام، البرز، کردستان، لرستان و گلستان عملیاتی شده و نهایتاً تا اسفند ماه سال جاری به طور کامل در سراسر کشور به اجرا درخواهد آمد.\r\n۴٫ پورتال ارزی اَبَرسامانه‌ای است که سامانه‌های ثبتارش (بازرگانی)، آسیکودا (گمرک) و ارزی (بانک مرکزی) را به یکدیگر متصل نموده فرآیندهای بین‌دستگاهی را میان این سامانه‌ها مدیریت می‌کند و از طریق شفاف‌سازی، یک‌پارچگی و نظارت دقیق و همه‌جانبه بر عملیات مرتبط با واردات و صادرات، فرصت هرگونه تبانی در جهت ارزان نمایی و گران نمایی کالا، خروج ارز از کشور از طریق جعل مدارک، اسناد گمرکی و پیمان‌نامه‌های ارزی و گریز از حقوق گمرکی را به حداقل می‌رساند.\r\n\r\n۵٫ فناوری اطلاعات در سال‌های گذشته با تعمیق نفوذ خود، تحولات عظیمی را در حوزه ارتباطات بین افراد و سازمان‌ها ایجاد و علاوه بر ایجاد اسناد الکترونیکی، با تحول در فرایندهای سنتی، موجبات تسریع، تدقیق و ردیابی مراودات با ابزارهای متنوع و سهل‌الوصول را فراهم کرده است.\r\nبا توجه به پیشرفت‌های حاصل شده در حوزه خدمت‌رسانی به مشتریان، اینک قوه قضائیه و بانک مرکزی جمهوری اسلامی ایران در صددند تا مراودات و مکاتبات فی‌مابین را نیز از مواهب پیشرفت‌های فناوری برخوردار سازند.\r\nاز این رو به‌منظور برقراری ارتباط الکترونیکی بین نظام بانکی کشور و قوه قضائیه که یکی از حساس‌ترین و مهمترین ارتباطات بین دستگاهی است، بستری مناسب به‌لحاظ اجرایی و مدیریتی با در نظر گرفتن ملاحظات ویژه (با عنایت به ماهیت اسناد و مکاتبات)، برقراری اطمینان از محرمانگی، انکار ناپذیری و اصالت مکاتبات و داده‌های تبادل شده ایجاد گردیده است.\r\n۶٫ مرکز امنیتی، تخصصی «کاشف» با نظارت بانک مرکزی جمهوری اسلامی ایران به‌منظور تأمین امنیت اطلاعات بانکی کشور از طریق تدوین الزامات و ایجاد چارچوب‌های امنیتی، مدیریت متمرکز امنیت، مدیریت رخدادهای امنیتی و به اشتراک گذاری اطلاعات و تجارب امنیتی بانک‌ها و مؤسسات مالی و اعتباری پیاده‌سازی شده است. این مرکز به‌عنوان نقطه تماس واحد، در تعامل با سایر نهادهای انتظامی، امنیتی و قضایی کشور، وظیفه جمع‌آوری و اشتراک‌گذاری اطلاعات و هماهنگی بین بانک‌ها در مواقع بروز رخدادهای امنیتی و بحران‌های سایبری را عهده‌دار است.\r\n۷٫ نظارت الکترونیکی بانک‌ها (سناب) سامانه‌ای است که استانداردسازی، یک‌پارچه کردن داده‌ها و اطلاعات بانکی و ایجاد یک ساختار منسجم گزارش‌گیری برخط، امکان نظارت الکترونیکی به‌هنگام و جامع بر عملیات بانک‌ها، ایجاد بانک اطلاعاتی یک‌پارچه از داده‌های پالایش شده بانکی، پایش و مانیتورینگ سیستم بانکی به‌لحاظ شناسایی تخلفات و سوء‌استفاده‌های مالی و … را مهیا می‌کند.\r\n۸٫ پس از گذشت حدود یک دهه از تصویب راهبرد نظام جامع پرداخت و با توجه به نظام‌های جدید پرداخت و تسویه و ابزارها و فناوری‌های نوین به‌وجود‌ آمده در جهان، بانک مرکزی جمهوری اسلامی ایران بر‌ آن شد تا نقشه راه ده سال آینده شبکه بانکی کشور را با کمک مشاوران خبره تدوین نماید. در این نقشه زیرساخت‌های اطلاعاتی مورد نیاز در حوزه‌های مختلف مأموریتی بانک مرکزی که طی ده سال آینده به‌طور تدریجی تکمیل و یا مستقر خواهند شد، شناسایی می‌شوند.\r\nاهداف اصلی نقشه راه ۱۴۰۰ بانک مرکزی، شامل تجزیه و تحلیل وضعیت موجود و رفع موانع، جهت نیل به یک نظام بانکی نوین بر پایه استانداردهای جهانی،‌ تعیین مسیرهای آتی نظام بانکی کشور، شناسایی و تعریف اهداف بلندمدت و استراتژیک، به‌کارگیری فناوری‌های نوین بانکی براساس استانداردهای جهانی، شناسایی ریسک‌های متفاوت و تدوین مدیریت ریسک است.\r\nنگاه بانک مرکزی به مبارزه با فساد، رویکردی راهبردی و بلندمدت است؛ باید توجه داشت که بروز فساد بیش از هرچیز ناشی از ضعف در ساختارها، فرایندها و مناسباتی است که طی زمان شکل گرفته و حفره‌های مقرراتی و زمینه‌های فساد در آن برای کسانی که در صدد سوء‌استفاده هستند روشن شده است. از این رو مبارزه جدی با فساد نیازمند تحول در حوزه‌های ساختاری و بنیادین است. فناوری و امکانات آن، فرصت مناسبی را برای بازنگری در این مناسبات و کشف نقاط آسیب‌پذیر و پوشش آنها فراهم کرده است و بانک مرکزی جمهوری اسلامی ایران در صدد است با اتخاذ راهبرد یادشده و بهره‌گیری کامل از امکانات فناوری، تحولی جدی در مقوله مبارزه با فساد را آغاز کند و به‌فضل الهی به انجام برساند.\r\nدر کوتاه‌مدت نیز ساماندهی بازار غیرمتشکل که فعالیت نهادهای پولی و بانکی بدون مجوز را شامل می‌شود، به‌صورت ویژه در دستور کار این بانک قرار دارد.\r\nمؤسسات پیش‌گفت قبلاً با داشتن سهمی تقریباً ۳۰درصدی از بازار پولی کشور، بدون نظارت بانک مرکزی سهم قابل توجهی در نوسانات ناخوشایند بازارهای مختلف ایفا ‌نموده و با ورود به فعالیت‌های سوداگرانه نظیر خرید و فروش مسکن، ارز، طلا و حتی احتکار ارزاق عمومی مردم و … کنار سایر عوامل، این بازارها را با تلاطم مواجه می‌ساختند.\r\nخوشبختانه با پیگیری‌های مستمر بانک مرکزی در جهت اجرای قانون تنظیم بازار غیرمتشکل پولی و قانون برنامه پنجم توسعه، علی‌رغم چالش‌های متعدد، بخشی از این مؤسسات فاقد مجوز؛ ساماندهی و منابع این مؤسسات در راستای اهداف نظام بانکی کشور هدایت گردیده است و در ادامه ضمناً انتظام بخشی سایر مؤسسات عمده بازار مزبور، در دستور کار قرار دارد و مراحل اجرایی را طی می‌کند.\r\nامید است به‌یاری حضرت حق و مساعدت کلیه دستگاه‌های اجرایی و نظارتی، شاهد مبارزه‌ای فراگیر و سیستمی با فساد باشیم. بدیهی است که طی این راه طولانی و توفیق در این مهم و ریشه‌کن کردن فساد و تحقق اراده مقام عظمای ولایت و مطالبات ملت در برخورد با مفسدین اقتصادی و سوءاستفاده گران، تعامل، همفکری، همراهی و همکاری همه‌جانبه دست اندر کاران نظام مقدس جمهوری اسلامی ایران را می‌طلبد.\r\n\r\nهمتم بدرقه راه کن ای طایر قدس ‌ که دراز است ره مقصد و من نوسفرم","امروز اختلاس، تبانی و کسب امتیازات خاص به‌صورت سیستمی در حال شکل‌گیری است","","inherit","closed","closed","","63-revision-v1","","","2018-03-29 21:13:06","2018-03-29 17:43:06","","63","http://islamic.demo-qaleb.ir/63-revision-v1/","0","revision","","0"),
("66","1","2018-03-29 21:17:35","2018-03-29 17:47:35","","\"آخرکار\" آخوندی در آستانه چهارشنبه‌سوری","","publish","open","open","","%da%a9%d8%a7%d8%b1%db%8c%da%a9%d8%a7%d8%aa%d9%88%d8%b1-%d8%a2%d8%ae%d8%b1%da%a9%d8%a7%d8%b1-%d8%a2%d8%ae%d9%88%d9%86%d8%af%db%8c-%d8%af%d8%b1-%d8%a2%d8%b3%d8%aa%d8%a7%d9%86%d9%87-%da%86%d9%87","","","2018-03-30 11:19:51","2018-03-30 06:49:51","","0","http://islamic.demo-qaleb.ir/?p=66","0","post","","0"),
("210","1","2018-03-30 11:19:48","2018-03-30 06:49:48","","8h6","","inherit","open","closed","","8h6","","","2018-03-30 11:19:48","2018-03-30 06:49:48","","66","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/8h6.jpg","0","attachment","image/jpeg","0"),
("211","1","2018-03-30 11:19:51","2018-03-30 06:49:51","","\"آخرکار\" آخوندی در آستانه چهارشنبه‌سوری","","inherit","closed","closed","","66-revision-v1","","","2018-03-30 11:19:51","2018-03-30 06:49:51","","66","http://islamic.demo-qaleb.ir/66-revision-v1/","0","revision","","0"),
("68","1","2018-03-29 21:17:35","2018-03-29 17:47:35","\"آخر کار\" آخوندی در آستانه چهارشنبه سوری / در حالی قرار است امروز وزیر راه و شهرسازی برای سومین بار استیضاح شود که پیش‌بینی فرجام این داستان با توجه به اتفاقات پشت‌پرده پیچیده و سخت است.\r\n\r\n&nbsp;","کاریکاتور/ \"آخرکار\" آخوندی در آستانه چهارشنبه‌سوری","","inherit","closed","closed","","66-revision-v1","","","2018-03-29 21:17:35","2018-03-29 17:47:35","","66","http://islamic.demo-qaleb.ir/66-revision-v1/","0","revision","","0"),
("69","1","2018-03-29 21:17:43","2018-03-29 17:47:43","\"آخر کار\" آخوندی در آستانه چهارشنبه سوری / در حالی قرار است امروز وزیر راه و شهرسازی برای سومین بار استیضاح شود که پیش‌بینی فرجام این داستان با توجه به اتفاقات پشت‌پرده پیچیده و سخت است.\r\n\r\n&nbsp;","\"آخرکار\" آخوندی در آستانه چهارشنبه‌سوری","","inherit","closed","closed","","66-revision-v1","","","2018-03-29 21:17:43","2018-03-29 17:47:43","","66","http://islamic.demo-qaleb.ir/66-revision-v1/","0","revision","","0"),
("70","1","2018-03-29 21:19:37","2018-03-29 17:49:37","","معضلی به نام \"شاخ‌های مجازی\"!","","publish","open","open","","%d9%85%d8%b9%d8%b6%d9%84%db%8c-%d8%a8%d9%87-%d9%86%d8%a7%d9%85-%d8%b4%d8%a7%d8%ae%e2%80%8c%d9%87%d8%a7%db%8c-%d9%85%d8%ac%d8%a7%d8%b2%db%8c","","","2018-03-30 11:19:16","2018-03-30 06:49:16","","0","http://islamic.demo-qaleb.ir/?p=70","0","post","","0"),
("208","1","2018-03-30 11:18:39","2018-03-30 06:48:39","","hh","","inherit","open","closed","","hh","","","2018-03-30 11:18:39","2018-03-30 06:48:39","","73","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/hh.jpg","0","attachment","image/jpeg","0"),
("72","1","2018-03-29 21:19:37","2018-03-29 17:49:37","","معضلی به نام \"شاخ‌های مجازی\"!","","inherit","closed","closed","","70-revision-v1","","","2018-03-29 21:19:37","2018-03-29 17:49:37","","70","http://islamic.demo-qaleb.ir/70-revision-v1/","0","revision","","0"),
("73","1","2018-03-29 21:21:03","2018-03-29 17:51:03","","اعتماد مردم با اعاده‌اموال‌نامشروع‌مسئولان بازمی‌گردد","","publish","open","open","","%d8%a7%d8%b9%d8%aa%d9%85%d8%a7%d8%af-%d9%85%d8%b1%d8%af%d9%85-%d8%a8%d8%a7-%d8%a7%d8%b9%d8%a7%d8%af%d9%87%e2%80%8c%d8%a7%d9%85%d9%88%d8%a7%d9%84%e2%80%8c%d9%86%d8%a7%d9%85%d8%b4%d8%b1%d9%88%d8%b9","","","2018-03-30 11:18:44","2018-03-30 06:48:44","","0","http://islamic.demo-qaleb.ir/?p=73","0","post","","0"),
("75","1","2018-03-29 21:21:03","2018-03-29 17:51:03","","اعتماد مردم با اعاده‌اموال‌نامشروع‌مسئولان بازمی‌گردد","","inherit","closed","closed","","73-revision-v1","","","2018-03-29 21:21:03","2018-03-29 17:51:03","","73","http://islamic.demo-qaleb.ir/73-revision-v1/","0","revision","","0"),
("209","1","2018-03-30 11:19:11","2018-03-30 06:49:11","","88j","","inherit","open","closed","","88j","","","2018-03-30 11:19:11","2018-03-30 06:49:11","","70","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/88j.jpg","0","attachment","image/jpeg","0"),
("77","1","2018-03-29 21:23:06","2018-03-29 17:53:06","","مردم گله‌مندند !!!","","publish","open","open","","%d9%85%d8%b1%d8%af%d9%85-%da%af%d9%84%d9%87%e2%80%8c%d9%85%d9%86%d8%af%d9%86%d8%af","","","2018-03-30 11:17:00","2018-03-30 06:47:00","","0","http://islamic.demo-qaleb.ir/?p=77","0","post","","0"),
("79","1","2018-03-29 21:23:06","2018-03-29 17:53:06","","مردم گله‌مندند !!!","","inherit","closed","closed","","77-revision-v1","","","2018-03-29 21:23:06","2018-03-29 17:53:06","","77","http://islamic.demo-qaleb.ir/77-revision-v1/","0","revision","","0"),
("80","1","2018-03-29 21:24:05","2018-03-29 17:54:05","","دولت ترامپ در ایستگاه یک‌سالگی!","","publish","open","open","","%d8%af%d9%88%d9%84%d8%aa-%d8%aa%d8%b1%d8%a7%d9%85%d9%be-%d8%af%d8%b1-%d8%a7%db%8c%d8%b3%d8%aa%da%af%d8%a7%d9%87-%db%8c%da%a9%e2%80%8c%d8%b3%d8%a7%d9%84%da%af%db%8c","","","2018-03-30 11:18:03","2018-03-30 06:48:03","","0","http://islamic.demo-qaleb.ir/?p=80","0","post","","0"),
("206","1","2018-03-30 11:16:55","2018-03-30 06:46:55","","987654","","inherit","open","closed","","987654","","","2018-03-30 11:16:55","2018-03-30 06:46:55","","77","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/987654.jpg","0","attachment","image/jpeg","0"),
("355","2","2019-08-03 15:30:02","2019-08-03 11:00:02","","sliderm","","inherit","open","closed","","sliderm","","","2019-08-03 15:30:02","2019-08-03 11:00:02","","0","http://islamic.demo-qaleb.ir/wp-content/uploads/2019/08/sliderm.html","0","attachment","text/html","0"),
("207","1","2018-03-30 11:17:58","2018-03-30 06:47:58","","987654678","","inherit","open","closed","","987654678","","","2018-03-30 11:17:58","2018-03-30 06:47:58","","80","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/987654678.jpg","0","attachment","image/jpeg","0"),
("82","1","2018-03-29 21:24:05","2018-03-29 17:54:05","","دولت ترامپ در ایستگاه یک‌سالگی!","","inherit","closed","closed","","80-revision-v1","","","2018-03-29 21:24:05","2018-03-29 17:54:05","","80","http://islamic.demo-qaleb.ir/80-revision-v1/","0","revision","","0"),
("84","1","2018-03-29 21:38:45","2018-03-29 18:08:45","[gallery size=\"medium\" ids=\"86,87,88,90,91,92\"]","غبارروبی مرقد امام رضا (ع) – مشهد","","publish","open","closed","","%d8%ba%d8%a8%d8%a7%d8%b1%d8%b1%d9%88%d8%a8%db%8c-%d9%85%d8%b1%d9%82%d8%af-%d8%a7%d9%85%d8%a7%d9%85-%d8%b1%d8%b6%d8%a7-%d8%b9-%d9%85%d8%b4%d9%87%d8%af","","","2018-03-29 21:38:45","2018-03-29 18:08:45","","0","http://islamic.demo-qaleb.ir/?post_type=gallery&#038;p=84","0","gallery","","0"),
("85","1","2018-03-29 21:37:23","2018-03-29 18:07:23","","13950823165007209195654","","inherit","open","closed","","13950823165007209195654","","","2018-03-29 21:37:23","2018-03-29 18:07:23","","84","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/13950823165007209195654.jpg","0","attachment","image/jpeg","0"),
("86","1","2018-03-29 21:37:37","2018-03-29 18:07:37","","7","","inherit","open","closed","","7","","","2018-03-29 21:37:37","2018-03-29 18:07:37","","84","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/7.jpg","0","attachment","image/jpeg","0"),
("87","1","2018-03-29 21:38:01","2018-03-29 18:08:01","","139508231650066929195654","","inherit","open","closed","","139508231650066929195654","","","2018-03-29 21:38:01","2018-03-29 18:08:01","","84","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139508231650066929195654.jpg","0","attachment","image/jpeg","0"),
("88","1","2018-03-29 21:38:05","2018-03-29 18:08:05","","139508231650074269195654","","inherit","open","closed","","139508231650074269195654","","","2018-03-29 21:38:05","2018-03-29 18:08:05","","84","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139508231650074269195654.jpg","0","attachment","image/jpeg","0"),
("90","1","2018-03-29 21:38:15","2018-03-29 18:08:15","","139508231650089109195654","","inherit","open","closed","","139508231650089109195654","","","2018-03-29 21:38:15","2018-03-29 18:08:15","","84","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139508231650089109195654.jpg","0","attachment","image/jpeg","0"),
("91","1","2018-03-29 21:38:19","2018-03-29 18:08:19","","13950823165010049195664","","inherit","open","closed","","13950823165010049195664","","","2018-03-29 21:38:19","2018-03-29 18:08:19","","84","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/13950823165010049195664.jpg","0","attachment","image/jpeg","0"),
("92","1","2018-03-29 21:38:21","2018-03-29 18:08:21","","139508231650104109195664","","inherit","open","closed","","139508231650104109195664","","","2018-03-29 21:38:21","2018-03-29 18:08:21","","84","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139508231650104109195664.jpg","0","attachment","image/jpeg","0"),
("93","1","2018-03-29 21:38:45","2018-03-29 18:08:45","[gallery size=\"medium\" ids=\"86,87,88,90,91,92\"]","غبارروبی مرقد امام رضا (ع) – مشهد","","inherit","closed","closed","","84-revision-v1","","","2018-03-29 21:38:45","2018-03-29 18:08:45","","84","http://islamic.demo-qaleb.ir/84-revision-v1/","0","revision","","0"),
("94","2","2018-03-29 21:41:33","2018-03-29 17:11:33","علی خسروی داور بین المللی فوتبال، مدرس دانشگاه و کارشناس برنامه های ورزشی صدا وسیما با انتقداد از بازی های المپیک در اینستاگرام خود نوشت:\r\n<div align=\"center\">فعلا كه فقط اين سه سوپر داور ايراني در المپيك ميدرخشند و كاروان ما در ريو كماكان در حسرت مدال المپيك ميباشند؟؟؟؟؟؟!!!!! بازي برزيل و دانمارك هم امروز صبح بدون اشتباه توسط فغاني سخندان و منصوري قضاوت شد و حالا منتظريم قضاوت يك چهارم نهايي نيمه نهايي وانشالله فينال به اين گروه و تيم سرافراز ايراني ابلاغ گردد. به احترامشان بپا خاسته و احترام نظامي ميگذاريم</div>\r\nاین مطالب در حالی در اینستاگرام علی خسروی منتشر می شود که روز پنجم سی و یکمین دوره مسابقات المپیک ۲۰۱۶ ریو در  به پایان رسید که چینی‌ها با کسب مدال طلا در تنیس روی میز بانوان تعداد مدال‌های طلای خود را با آمریکا برابر کردند، اما به دلیل پایین بودن مدال‌های نقره و برنز در همان مکان دوم باقی ماندند.\r\n\r\nقزاقستان با کسب دو طلای شنا و وزنه برداری در این روز به رتبه یازدهم صعود کرد و اسپانیا نیز نخستین طلای خود را امروز در رشته شنا کسب کرد.\r\nدر جدول رده بندی مدالی تاکنون بیش از ۵۰ کشور کسب مدال کرده‌اند و ایران هم در شمشیربازی می‌توانست صاحب نخستین مدال خود شود که با بدشانسی این اتفاق نیفتاد. مدال نماینده کویت هم به دلیل تعلیق بودن این کشور به نامش ثبت نشد و با پرچم کمیته بین المللی المپیک بود.\r\n\r\nدر جدول رده بندی آمریکا با ۱۰ طلا، ۱۱ نقره و ۱۰ برنز و مجموع ۳۱ در رده اول قرار دارد، چین با ۱۰ طلا، ۵ نقره و ۸ برنز و مجموع ۲۳ در رده دوم و ژاپن با ۶ طلا، یک نقره و ۱۱ برنز در مکان سوم جدول توزیع مدال‌ها قرار دارند.\r\n\r\nبرابر آخرین جدولی که در زیر آمده ایران تا کنون مدالی به دست نیاورده است.","انتقاد خسروی داور و کارشناس از بازی های المپیک ریو","","publish","open","open","","%d8%a7%d9%86%d8%aa%d9%82%d8%a7%d8%af-%d8%b9%d9%84%db%8c-%d8%ae%d8%b3%d8%b1%d9%88%db%8c-%d8%af%d8%a7%d9%88%d8%b1-%d9%88-%da%a9%d8%a7%d8%b1%d8%b4%d9%86%d8%a7%d8%b3-%d8%a7%d8%b2-%d8%a8%d8%a7%d8%b2%db%8c","","","2018-09-11 12:18:24","2018-09-11 07:48:24","","0","http://islamic.demo-qaleb.ir/?p=94","0","post","","0"),
("96","1","2018-03-29 21:41:33","2018-03-29 18:11:33","علی خسروی داور بین المللی فوتبال، مدرس دانشگاه و کارشناس برنامه های ورزشی صدا وسیما با انتقداد از بازی های المپیک در اینستاگرام خود نوشت:\r\n<div align=\"center\">فعلا كه فقط اين سه سوپر داور ايراني در المپيك ميدرخشند و كاروان ما در ريو كماكان در حسرت مدال المپيك ميباشند؟؟؟؟؟؟!!!!! بازي برزيل و دانمارك هم امروز صبح بدون اشتباه توسط فغاني سخندان و منصوري قضاوت شد و حالا منتظريم قضاوت يك چهارم نهايي نيمه نهايي وانشالله فينال به اين گروه و تيم سرافراز ايراني ابلاغ گردد. به احترامشان بپا خاسته و احترام نظامي ميگذاريم</div>\r\nاین مطالب در حالی در اینستاگرام علی خسروی منتشر می شود که روز پنجم سی و یکمین دوره مسابقات المپیک ۲۰۱۶ ریو در  به پایان رسید که چینی‌ها با کسب مدال طلا در تنیس روی میز بانوان تعداد مدال‌های طلای خود را با آمریکا برابر کردند، اما به دلیل پایین بودن مدال‌های نقره و برنز در همان مکان دوم باقی ماندند.\r\n\r\nقزاقستان با کسب دو طلای شنا و وزنه برداری در این روز به رتبه یازدهم صعود کرد و اسپانیا نیز نخستین طلای خود را امروز در رشته شنا کسب کرد.\r\nدر جدول رده بندی مدالی تاکنون بیش از ۵۰ کشور کسب مدال کرده‌اند و ایران هم در شمشیربازی می‌توانست صاحب نخستین مدال خود شود که با بدشانسی این اتفاق نیفتاد. مدال نماینده کویت هم به دلیل تعلیق بودن این کشور به نامش ثبت نشد و با پرچم کمیته بین المللی المپیک بود.\r\n\r\nدر جدول رده بندی آمریکا با ۱۰ طلا، ۱۱ نقره و ۱۰ برنز و مجموع ۳۱ در رده اول قرار دارد، چین با ۱۰ طلا، ۵ نقره و ۸ برنز و مجموع ۲۳ در رده دوم و ژاپن با ۶ طلا، یک نقره و ۱۱ برنز در مکان سوم جدول توزیع مدال‌ها قرار دارند.\r\n\r\nبرابر آخرین جدولی که در زیر آمده ایران تا کنون مدالی به دست نیاورده است.","انتقاد علی خسروی داور و کارشناس از بازی های المپیک ریو","","inherit","closed","closed","","94-revision-v1","","","2018-03-29 21:41:33","2018-03-29 18:11:33","","94","http://islamic.demo-qaleb.ir/94-revision-v1/","0","revision","","0"),
("97","1","2018-03-29 21:44:03","2018-03-29 18:14:03","<p class=\"rtejustify\">به گزارش گروه سیاسی به نقل از پایگاه اطلاع‌رسانی دفتر حفظ و نشر آثار حضرت آیت‌الله خامنه‌ای، جمعی از شاعران آئینی و مداحان اهل‌بیت (علیهم‌السلام) خراسان در حرم مطهر رضوی با حضرت آیت‌الله خامنه‌ای رهبر انقلاب اسلامی دیدار کردند.</p>\r\n<p class=\"rtejustify\">متن بیانات مقام معظم رهبری در این دیدار که پایگاه اطلاع‌رسانی دفتر حفظ و نشر آثار حضرت آیت‌الله خامنه‌ای منتشر کرده است، بدین شرح است:</p>\r\n<p class=\"rtejustify\">«بسم‌الله‌الرّحمن‌الرّحیم‌ (۱)</p>\r\n<p class=\"rtejustify\"> خیلی‌ مایل بودم که از یکایک شعرائی‌ که در اینجا تشریف دارند شعر بشنوم و از یکایک نغمه‌سرایان مذهبی‌ و مدّاحان، نغمه‌هایشان را گوش کنم. متأسّفانه مثل همیشه آنچه میل دل ما است، در عمل اتّفاق نمی‌‌افتد ولی‌ همان مقداری‌ که شنفتیم، هم حقیقتاً بهره بردیم و استفاده کردیم، و هم بنده خوشحال شدم.</p>\r\n<p class=\"rtejustify\">واقعاً من خوشحال شدم از اینکه مشاهده کردم در مشهد همچنان -بلکه بهتر از گذشته- هم ذوقهای‌ فراوان و لطافتهای‌ شعری‌ و ریزه‌کاری‌‌های‌ زیبای‌ ادبی‌ در شعرها وجود دارد، و هم حنجره‌های‌ مخملین و مطلوب و شیرین الحمدلله در مشهد زیاد است؛ من خیلی‌ خوشحال شدم از این واقعیّتی‌ که انسان در مشهد ملاحظه میکند.</p>\r\n<p class=\"rtejustify\">خب، در گذشته هم کم‌وبیش همین‌جور بود. البتّه از لحاظ شعری، مشهد همیشه جلو بود از جاهای‌ دیگری‌ که ما می‌‌شناختیم -تا آن حدّی‌ که ما می‌دیدیم؛ در آن سالهای‌ دوران جوانی‌ِ ما، مشهد به‌طور مجموعی‌ و جمعی‌ جلوتر از خیلی‌ جاهای‌ دیگر بود- لکن از لحاظ مدّاحی‌ و خوش‌خوانی‌ و نغمه‌سرایی‌ دینی، نه؛ مشهد در این حدّی‌ که امروز انسان مشاهده میکند و می‌بیند، در زمان ما نبود. یک تعداد محدودی‌ بودند، شاید بشود گفت تعداد انگشت‌شماری‌ بودند که می‌توانستند شعر خوب را با آهنگ خوب و صدای‌ خوش بخوانند. خب، بنابراین جای‌ شکر دارد و خدای‌ متعال را شاکریم بر این نعمت.</p>\r\n<p class=\"rtejustify\">آنچه من تأکید می‌کنم، همان‌طور که در شعرهای‌ شعرای‌ عزیزمان مشاهده کردیم و همچنین در برخی‌ از اشعار مدّاحان عزیز شنیدیم، [این است:] امروز دنیای‌ اسلام نیازمندی‌‌هایی‌ دارد. دنیای‌ اسلام امروز در یک مرحله‌ی‌ حسّاس تاریخی‌ دارد به سَر می‌برد. اینهایی‌ که شما ملاحظه می‌کنید -آل‌سعود آن‌جوری، یمن آن‌جوری، عراق این‌جوری، سوریه آن‌جوری، مسائل مربوط به آمریکا، مسائل مربوط به رژیم صهیونیستی، کارهایی‌ که در منطقه می‌کنند، تصمیم‌هایی‌ که میگیرند، فشاری‌ که روی‌ جمهوری‌ اسلامی‌ می‌‌آورند- یک مجموعه‌ی‌ کار است، یک هدفی‌ دارد دنبال می‌شود.</p>\r\n<p class=\"rtejustify\">در یک‌چنین شرایطی‌ که دنیای‌ اسلام در واقع از یک پیچ تاریخی‌ دارد عبور می‌کند، ما وظایفی‌ داریم، ما تکالیفی‌ داریم؛ هرکداممان به یک نحوی، نمی‌توانیم غفلت کنیم از نیازهای‌ امروزِ دنیای‌ اسلام؛ در رأس این نیازها هم، نیازهای‌ جمهوری‌ اسلامی‌ است؛ چون جمهوری‌ اسلامی‌ میان‌دار این حادثه‌ی‌ عظیم است. بله، بازیگران بسیارند؛ کنندگان و کنش‌گران و فعّالان در دنیای‌ اسلام زیادند، از همه نوعش؛ امّا میان‌دار، جمهوری‌ اسلامی‌ است.</p>\r\n<p class=\"rtejustify\">مطمئنّاً اگر جمهوری‌ اسلامی‌ نبود، اگر امام بزرگوار نبود، اگر آن فریاد ملکوتی‌ متّکی‌ به سنّت‌های‌ الهی‌ در این کشور نبود، این حوادث در دنیای‌ اسلام نبود و استکبار بدون هیچ‌گونه مانعی‌ کار خودش را دنبال می‌کرد و هیچ احتیاجی‌ به این‌همه چالش هم نداشت، این همه مشکل هم برای‌ استکبار وجود نداشت. بنابراین جمهوری‌ اسلامی‌ امروز نیازمندی‌‌هایی‌ دارد که این نیازمندی‌‌ها را ماها باید تأمین کنیم.</p>\r\n<p class=\"rtejustify\">به اعتقاد بنده برترینِ این نیازمندی‌‌ها، نیازهای‌ تبیینی‌ و بصیرت‌افزایی‌ و تحکیم معارف انقلاب و اسلام [است]؛ اینها در رأس همه‌ی‌ این نیازها است. ما ابزارش را هم بحمدالله داریم. یکی‌ از ابزارهایی‌ که ما داریم و دیگران در دنیا معمولاً ندارند، همین مدّاحی‌ است، همین روضه‌خوانی‌ است، همین منبر است، همین مجالس مردمی‌ است؛ این در دنیا معمول نیست. در دنیا اینکه حالا یک نفر را یک جایی‌ دعوت کنند برود منبر، هزار نفر، دو هزار نفر، پنج هزار نفر، بدون دعوت، با شوق دل خودشان آنجا حاضر بشوند، بنشینند یک ساعت به حرف او گوش بدهند، چنین چیزی‌ در دنیا نیست.</p>","پایان نشست باکو/ آنچه در نشست روحانی، پوتین و علی اف گذشت","","publish","open","open","","%d9%be%d8%a7%db%8c%d8%a7%d9%86-%d9%86%d8%b4%d8%b3%d8%aa-%d8%a8%d8%a7%da%a9%d9%88-%d8%a2%d9%86%da%86%d9%87-%d8%af%d8%b1-%d9%86%d8%b4%d8%b3%d8%aa-%d8%b1%d9%88%d8%ad%d8%a7%d9%86%db%8c%d8%8c-%d9%be%d9%88","","","2018-03-29 21:44:03","2018-03-29 18:14:03","","0","http://islamic.demo-qaleb.ir/?p=97","0","post","","0"),
("98","1","2018-03-29 21:43:59","2018-03-29 18:13:59","","98","","inherit","open","closed","","98","","","2018-03-29 21:43:59","2018-03-29 18:13:59","","97","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/98.jpg","0","attachment","image/jpeg","0"),
("99","1","2018-03-29 21:44:03","2018-03-29 18:14:03","<p class=\"rtejustify\">به گزارش گروه سیاسی به نقل از پایگاه اطلاع‌رسانی دفتر حفظ و نشر آثار حضرت آیت‌الله خامنه‌ای، جمعی از شاعران آئینی و مداحان اهل‌بیت (علیهم‌السلام) خراسان در حرم مطهر رضوی با حضرت آیت‌الله خامنه‌ای رهبر انقلاب اسلامی دیدار کردند.</p>\r\n<p class=\"rtejustify\">متن بیانات مقام معظم رهبری در این دیدار که پایگاه اطلاع‌رسانی دفتر حفظ و نشر آثار حضرت آیت‌الله خامنه‌ای منتشر کرده است، بدین شرح است:</p>\r\n<p class=\"rtejustify\">«بسم‌الله‌الرّحمن‌الرّحیم‌ (۱)</p>\r\n<p class=\"rtejustify\"> خیلی‌ مایل بودم که از یکایک شعرائی‌ که در اینجا تشریف دارند شعر بشنوم و از یکایک نغمه‌سرایان مذهبی‌ و مدّاحان، نغمه‌هایشان را گوش کنم. متأسّفانه مثل همیشه آنچه میل دل ما است، در عمل اتّفاق نمی‌‌افتد ولی‌ همان مقداری‌ که شنفتیم، هم حقیقتاً بهره بردیم و استفاده کردیم، و هم بنده خوشحال شدم.</p>\r\n<p class=\"rtejustify\">واقعاً من خوشحال شدم از اینکه مشاهده کردم در مشهد همچنان -بلکه بهتر از گذشته- هم ذوقهای‌ فراوان و لطافتهای‌ شعری‌ و ریزه‌کاری‌‌های‌ زیبای‌ ادبی‌ در شعرها وجود دارد، و هم حنجره‌های‌ مخملین و مطلوب و شیرین الحمدلله در مشهد زیاد است؛ من خیلی‌ خوشحال شدم از این واقعیّتی‌ که انسان در مشهد ملاحظه میکند.</p>\r\n<p class=\"rtejustify\">خب، در گذشته هم کم‌وبیش همین‌جور بود. البتّه از لحاظ شعری، مشهد همیشه جلو بود از جاهای‌ دیگری‌ که ما می‌‌شناختیم -تا آن حدّی‌ که ما می‌دیدیم؛ در آن سالهای‌ دوران جوانی‌ِ ما، مشهد به‌طور مجموعی‌ و جمعی‌ جلوتر از خیلی‌ جاهای‌ دیگر بود- لکن از لحاظ مدّاحی‌ و خوش‌خوانی‌ و نغمه‌سرایی‌ دینی، نه؛ مشهد در این حدّی‌ که امروز انسان مشاهده میکند و می‌بیند، در زمان ما نبود. یک تعداد محدودی‌ بودند، شاید بشود گفت تعداد انگشت‌شماری‌ بودند که می‌توانستند شعر خوب را با آهنگ خوب و صدای‌ خوش بخوانند. خب، بنابراین جای‌ شکر دارد و خدای‌ متعال را شاکریم بر این نعمت.</p>\r\n<p class=\"rtejustify\">آنچه من تأکید می‌کنم، همان‌طور که در شعرهای‌ شعرای‌ عزیزمان مشاهده کردیم و همچنین در برخی‌ از اشعار مدّاحان عزیز شنیدیم، [این است:] امروز دنیای‌ اسلام نیازمندی‌‌هایی‌ دارد. دنیای‌ اسلام امروز در یک مرحله‌ی‌ حسّاس تاریخی‌ دارد به سَر می‌برد. اینهایی‌ که شما ملاحظه می‌کنید -آل‌سعود آن‌جوری، یمن آن‌جوری، عراق این‌جوری، سوریه آن‌جوری، مسائل مربوط به آمریکا، مسائل مربوط به رژیم صهیونیستی، کارهایی‌ که در منطقه می‌کنند، تصمیم‌هایی‌ که میگیرند، فشاری‌ که روی‌ جمهوری‌ اسلامی‌ می‌‌آورند- یک مجموعه‌ی‌ کار است، یک هدفی‌ دارد دنبال می‌شود.</p>\r\n<p class=\"rtejustify\">در یک‌چنین شرایطی‌ که دنیای‌ اسلام در واقع از یک پیچ تاریخی‌ دارد عبور می‌کند، ما وظایفی‌ داریم، ما تکالیفی‌ داریم؛ هرکداممان به یک نحوی، نمی‌توانیم غفلت کنیم از نیازهای‌ امروزِ دنیای‌ اسلام؛ در رأس این نیازها هم، نیازهای‌ جمهوری‌ اسلامی‌ است؛ چون جمهوری‌ اسلامی‌ میان‌دار این حادثه‌ی‌ عظیم است. بله، بازیگران بسیارند؛ کنندگان و کنش‌گران و فعّالان در دنیای‌ اسلام زیادند، از همه نوعش؛ امّا میان‌دار، جمهوری‌ اسلامی‌ است.</p>\r\n<p class=\"rtejustify\">مطمئنّاً اگر جمهوری‌ اسلامی‌ نبود، اگر امام بزرگوار نبود، اگر آن فریاد ملکوتی‌ متّکی‌ به سنّت‌های‌ الهی‌ در این کشور نبود، این حوادث در دنیای‌ اسلام نبود و استکبار بدون هیچ‌گونه مانعی‌ کار خودش را دنبال می‌کرد و هیچ احتیاجی‌ به این‌همه چالش هم نداشت، این همه مشکل هم برای‌ استکبار وجود نداشت. بنابراین جمهوری‌ اسلامی‌ امروز نیازمندی‌‌هایی‌ دارد که این نیازمندی‌‌ها را ماها باید تأمین کنیم.</p>\r\n<p class=\"rtejustify\">به اعتقاد بنده برترینِ این نیازمندی‌‌ها، نیازهای‌ تبیینی‌ و بصیرت‌افزایی‌ و تحکیم معارف انقلاب و اسلام [است]؛ اینها در رأس همه‌ی‌ این نیازها است. ما ابزارش را هم بحمدالله داریم. یکی‌ از ابزارهایی‌ که ما داریم و دیگران در دنیا معمولاً ندارند، همین مدّاحی‌ است، همین روضه‌خوانی‌ است، همین منبر است، همین مجالس مردمی‌ است؛ این در دنیا معمول نیست. در دنیا اینکه حالا یک نفر را یک جایی‌ دعوت کنند برود منبر، هزار نفر، دو هزار نفر، پنج هزار نفر، بدون دعوت، با شوق دل خودشان آنجا حاضر بشوند، بنشینند یک ساعت به حرف او گوش بدهند، چنین چیزی‌ در دنیا نیست.</p>","پایان نشست باکو/ آنچه در نشست روحانی، پوتین و علی اف گذشت","","inherit","closed","closed","","97-revision-v1","","","2018-03-29 21:44:03","2018-03-29 18:14:03","","97","http://islamic.demo-qaleb.ir/97-revision-v1/","0","revision","","0"),
("100","1","2018-03-29 21:46:09","2018-03-29 18:16:09","<article id=\"k2Container\" class=\"itemView\">\r\n<div class=\"itemBody StoryBody\">\r\n<div class=\"itemFullText\">\r\n\r\nبه گزارش خبرنگار قضایی خبرگزاری نسیم حجت الاسلام پورمحمدی وزیر دادگستری در حاشیه همایش ارتقای سلامت اداری و مبارزه با فساد، در پاسخ به سوال خبرنگار تسنیم مبنی بر اینکه برخی شنیده‌ها از انحلال شورای دستگاه‌های نظارتی حکایت دارد، اظهار داشت: یک مشکل قانونی در خصوص این شورا با شورای نگهبان و مجمع تشخیص مصلحت نظام مطرح شده است که امیدواریم مشکل قانونی حل شود.\r\n\r\nوی درباره اینکه آیا فعالیت شورای دستگاه‌های نظارتی مشکل قانونی دارد؟ گفت: مجمع تشخیص مصلحت نظام یک ایراد قانونی گرفته که امیدواریم این مشکل را حل کنیم.\r\n\r\nپورمحمدی در پاسخ به سوال دیگری مبنی بر اینکه با توجه به پیام مقام معظم رهبری آیا این همایش، سال آینده نیز برگزار می‌شود یا خیر گفت: پس از پایان همایش جمع‌بندی‌های لازم را انجام می‌دهیم و فکر می‌کنم فضای مناسب‌تری برای برگزاری مجدد این همایش فراهم شود زیرا ما همایش ارتقای سلامت اداری و مبارزه با فساد را با نگاه کاربردی، نقادانه و ارائه کارهای انجام شده برگزار کردیم.\r\n\r\nوزیر دادگستری افزود: دغدغه مقام معظم رهبری، دغدغه‌ای کاملا جدی است و خودمان نیز همین پیش‌بینی را داشتیم.\r\n\r\n<article id=\"k2Container\" class=\"itemView\">\r\n<div class=\"itemBody StoryBody\">\r\n<div class=\"itemFullText\">\r\n\r\nبه گزارش خبرنگار قضایی خبرگزاری نسیم حجت الاسلام پورمحمدی وزیر دادگستری در حاشیه همایش ارتقای سلامت اداری و مبارزه با فساد، در پاسخ به سوال خبرنگار تسنیم مبنی بر اینکه برخی شنیده‌ها از انحلال شورای دستگاه‌های نظارتی حکایت دارد، اظهار داشت: یک مشکل قانونی در خصوص این شورا با شورای نگهبان و مجمع تشخیص مصلحت نظام مطرح شده است که امیدواریم مشکل قانونی حل شود.\r\n\r\nوی درباره اینکه آیا فعالیت شورای دستگاه‌های نظارتی مشکل قانونی دارد؟ گفت: مجمع تشخیص مصلحت نظام یک ایراد قانونی گرفته که امیدواریم این مشکل را حل کنیم.\r\n\r\nپورمحمدی در پاسخ به سوال دیگری مبنی بر اینکه با توجه به پیام مقام معظم رهبری آیا این همایش، سال آینده نیز برگزار می‌شود یا خیر گفت: پس از پایان همایش جمع‌بندی‌های لازم را انجام می‌دهیم و فکر می‌کنم فضای مناسب‌تری برای برگزاری مجدد این همایش فراهم شود زیرا ما همایش ارتقای سلامت اداری و مبارزه با فساد را با نگاه کاربردی، نقادانه و ارائه کارهای انجام شده برگزار کردیم.\r\n\r\nوزیر دادگستری افزود: دغدغه مقام معظم رهبری، دغدغه‌ای کاملا جدی است و خودمان نیز همین پیش‌بینی را داشتیم.\r\n\r\nانتهای پیام/\r\n\r\n</div>\r\n</div>\r\n</article></div>\r\n</div>\r\n</article>","توضیح وزیر دادگستری درباره احتمال انحلال شورای دستگاه‌های نظارتی","","publish","open","open","","%d8%aa%d9%88%d8%b6%db%8c%d8%ad-%d9%88%d8%b2%db%8c%d8%b1-%d8%af%d8%a7%d8%af%da%af%d8%b3%d8%aa%d8%b1%db%8c-%d8%af%d8%b1%d8%a8%d8%a7%d8%b1%d9%87-%d8%a7%d8%ad%d8%aa%d9%85%d8%a7%d9%84-%d8%a7%d9%86%d8%ad","","","2018-03-29 21:46:09","2018-03-29 18:16:09","","0","http://islamic.demo-qaleb.ir/?p=100","0","post","","0"),
("101","1","2018-03-29 21:46:06","2018-03-29 18:16:06","","139309121707301214215833","","inherit","open","closed","","139309121707301214215833","","","2018-03-29 21:46:06","2018-03-29 18:16:06","","100","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139309121707301214215833.jpg","0","attachment","image/jpeg","0"),
("102","1","2018-03-29 21:46:09","2018-03-29 18:16:09","<article id=\"k2Container\" class=\"itemView\">\r\n<div class=\"itemBody StoryBody\">\r\n<div class=\"itemFullText\">\r\n\r\nبه گزارش خبرنگار قضایی خبرگزاری نسیم حجت الاسلام پورمحمدی وزیر دادگستری در حاشیه همایش ارتقای سلامت اداری و مبارزه با فساد، در پاسخ به سوال خبرنگار تسنیم مبنی بر اینکه برخی شنیده‌ها از انحلال شورای دستگاه‌های نظارتی حکایت دارد، اظهار داشت: یک مشکل قانونی در خصوص این شورا با شورای نگهبان و مجمع تشخیص مصلحت نظام مطرح شده است که امیدواریم مشکل قانونی حل شود.\r\n\r\nوی درباره اینکه آیا فعالیت شورای دستگاه‌های نظارتی مشکل قانونی دارد؟ گفت: مجمع تشخیص مصلحت نظام یک ایراد قانونی گرفته که امیدواریم این مشکل را حل کنیم.\r\n\r\nپورمحمدی در پاسخ به سوال دیگری مبنی بر اینکه با توجه به پیام مقام معظم رهبری آیا این همایش، سال آینده نیز برگزار می‌شود یا خیر گفت: پس از پایان همایش جمع‌بندی‌های لازم را انجام می‌دهیم و فکر می‌کنم فضای مناسب‌تری برای برگزاری مجدد این همایش فراهم شود زیرا ما همایش ارتقای سلامت اداری و مبارزه با فساد را با نگاه کاربردی، نقادانه و ارائه کارهای انجام شده برگزار کردیم.\r\n\r\nوزیر دادگستری افزود: دغدغه مقام معظم رهبری، دغدغه‌ای کاملا جدی است و خودمان نیز همین پیش‌بینی را داشتیم.\r\n\r\n<article id=\"k2Container\" class=\"itemView\">\r\n<div class=\"itemBody StoryBody\">\r\n<div class=\"itemFullText\">\r\n\r\nبه گزارش خبرنگار قضایی خبرگزاری نسیم حجت الاسلام پورمحمدی وزیر دادگستری در حاشیه همایش ارتقای سلامت اداری و مبارزه با فساد، در پاسخ به سوال خبرنگار تسنیم مبنی بر اینکه برخی شنیده‌ها از انحلال شورای دستگاه‌های نظارتی حکایت دارد، اظهار داشت: یک مشکل قانونی در خصوص این شورا با شورای نگهبان و مجمع تشخیص مصلحت نظام مطرح شده است که امیدواریم مشکل قانونی حل شود.\r\n\r\nوی درباره اینکه آیا فعالیت شورای دستگاه‌های نظارتی مشکل قانونی دارد؟ گفت: مجمع تشخیص مصلحت نظام یک ایراد قانونی گرفته که امیدواریم این مشکل را حل کنیم.\r\n\r\nپورمحمدی در پاسخ به سوال دیگری مبنی بر اینکه با توجه به پیام مقام معظم رهبری آیا این همایش، سال آینده نیز برگزار می‌شود یا خیر گفت: پس از پایان همایش جمع‌بندی‌های لازم را انجام می‌دهیم و فکر می‌کنم فضای مناسب‌تری برای برگزاری مجدد این همایش فراهم شود زیرا ما همایش ارتقای سلامت اداری و مبارزه با فساد را با نگاه کاربردی، نقادانه و ارائه کارهای انجام شده برگزار کردیم.\r\n\r\nوزیر دادگستری افزود: دغدغه مقام معظم رهبری، دغدغه‌ای کاملا جدی است و خودمان نیز همین پیش‌بینی را داشتیم.\r\n\r\nانتهای پیام/\r\n\r\n</div>\r\n</div>\r\n</article></div>\r\n</div>\r\n</article>","توضیح وزیر دادگستری درباره احتمال انحلال شورای دستگاه‌های نظارتی","","inherit","closed","closed","","100-revision-v1","","","2018-03-29 21:46:09","2018-03-29 18:16:09","","100","http://islamic.demo-qaleb.ir/100-revision-v1/","0","revision","","0"),
("257","2","2018-08-31 14:46:11","2018-08-31 10:16:11","","logo","","inherit","open","closed","","logo-2","","","2018-08-31 14:46:11","2018-08-31 10:16:11","","0","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/logo.png","0","attachment","image/png","0"),
("232","1","2018-04-04 15:28:14","2018-04-04 10:58:14"," ","","","publish","closed","closed","","232","","","2019-08-03 15:39:40","2019-08-03 11:09:40","","48","http://islamic.demo-qaleb.ir/?p=232","30","nav_menu_item","","0"),
("354","2","2019-08-03 15:29:58","2019-08-03 10:59:58","","slider","","inherit","open","closed","","slider","","","2019-08-03 15:29:58","2019-08-03 10:59:58","","0","http://islamic.demo-qaleb.ir/wp-content/uploads/2019/08/slider.html","0","attachment","text/html","0"),
("349","2","2019-08-03 15:27:39","2019-08-03 10:57:39","","صفحه نخست","","publish","closed","closed","","%d8%b5%d9%81%d8%ad%d9%87-%d9%86%d8%ae%d8%b3%d8%aa","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=349","1","nav_menu_item","","0"),
("106","1","2018-03-29 22:05:51","2018-03-29 18:35:51","<span class=\"intro-text\"> متاسفانه از ظرفیت های گردشگری شهر تهران غافیلم و باید تلاش کنیم با استفاده از این ظرفیتها،پسوند و قیدهای منفی را از تهران جدا کنیم.</span>\r\n<div class=\"full-text\">\r\n\r\nبه گزارش خبرگزاری مهر،\"سید محمود میر لوحی\" در بازدید از ستاد نوروزی شهرداری تهران اظهار داشت: از طریق فضای مجازی و سایت های خبری،شیوه و ساز و کار ستاد گردشگری را دنبال و بررسی اجمالی از روند فعالیت ستاد داشتم و امروز هم  به صورت سرزده به ستاد آمدم تا از نزدیک در جریان فعالیت دوستانمان باشم.\r\n\r\nوی افزود:فعالیت این ستاد لازم،مفید و موثر است گرچه کاستی هایی نیز وجود دارد که باید مرتفع شود.\r\n\r\nاین عضو شورای اسلامی شهر تهران بیان کرد: تهران به عنوان پایتخت کشور و با این وسعت و وجود ۲۲۰۰ساختمان فرهنگی و تاریخی،ظرفیت بی بدیلی از  جاذبه های دیدنی و گردشگری را داراست که معتقدم در معرفی این جاذبه ها و بهره مندی از ظرفیت های موجود،غفلت شده است.\r\n\r\nمیرلوحی خاطر نشان کرد: باید برای تقویت زیر ساخت های گردشگردی و  معرفی جاذبه های دیدنی شهر تهران اقدامات جدی تری انجام شود.\r\n\r\nاین عضو شورای اسلامی شهر تهران اضافه کرد: شورای اسلامی شهر و شهرداری تهران  باید در این زمینه  تلاش کند و پیرو تصویب طرح \"ایران ۱۴۰۰\"باید ببینیم چه باید کرد که در معرفی جاذبه های گردشگری و جذب گردشگر موفق باشیم.\r\n\r\nمیر لوحی مطرح کرد:باید به گونه ای عمل کنیم که بتوانیم یک گردشگر و یا توریست را در یک زمان بندی حداقلی و یک هفته ای،بجای \"سرگرمی\"،\"تامین \"کنیم که متاسفانه هنوز در تهران با این سطح فاصله داریم.\r\n\r\nوی اشاره کرد:به طور مثال؛ در اصفهان به مقوله گردشگردی به قدری خوب توجه شده و زیر ساخت ها و امکانات  آماده است که هر گردشگردی در مدت زمان حداقلی و یک هفته ای،از جاذبه های دیدنی نهایت بهره را می برد و با یک شناخت کاملی از فرهنگ و تاریخ به مبدا باز می گردد در حالی که این اتفاق هنوز در مورد تهران محقق نشده است.\r\n\r\nاین مقام مسئول تاکید کرد:تهران باید به شان خود در حوزه گردشگری برسد در حالی که امروز شاهدیم ظرفیت ها بالقوه است و باید بالفعل شود.\r\n\r\nوی افزود: متاسفانه همواره تهران با شلوغی،ترافیک،آلودگی و پسوندهای\"منفی\"شناخته شده است در حالی که باید با بهره مندی حداکثری از ظرفیت و جاذبه های دیدنی،تهران زیبا را به همگان معرفی و این شهر به مقصد گردشگری تبدیل شود و پسوند و قیدهای منفی از تهران جدا شود.\r\n\r\nمیر لوحی تاکید کرد: باید برای بهره مندی حداکثری از ظرفیت های گردشگری شهر تهران،از بخش خصوصی کمک گرفت و بخش خصوصی باید به این حس و جایگاه برسد که گردشگر داخلی و خارجی را با گشاده رویی و خدمات دهی مطلوب میزبانی کند.\r\n\r\nوی ادامه داد: احساس و نگاه  \"خود کم بینی\" در ارائه خدمات گردشگردی باید از شهر تهران جدا شود،متاسفانه امروز  در جایگاهی هستیم که احساس میکنیم اگر کسی را از شهر و کشوری به تهران دعوت کنیم خیلی \"دست پری\" نداریم و  نمی توانیم از نظر گردشگری میزبان خوبی باشیم در حالیکه که از ظرفیت تاریخی،فرهنگی و گردشگری تهران غافلیم و باید به سمت معرفی مزیت و ظرفیت های تهران برویم و در این زمینه به جد کار کنیم.\r\n\r\n</div>","پسوندهای منفی را از تهران جدا کنیم/از ظرفیت های گردشگری غافلیم","","publish","open","open","","%d9%be%d8%b3%d9%88%d9%86%d8%af%d9%87%d8%a7%db%8c-%d9%85%d9%86%d9%81%db%8c-%d8%b1%d8%a7-%d8%a7%d8%b2-%d8%aa%d9%87%d8%b1%d8%a7%d9%86-%d8%ac%d8%af%d8%a7-%da%a9%d9%86%db%8c%d9%85%d8%a7%d8%b2-%d8%b8%d8%b1","","","2018-04-27 00:25:14","2018-04-26 19:55:14","","0","http://islamic.demo-qaleb.ir/?p=106","0","post","","0"),
("250","1","2018-04-27 00:25:11","2018-04-26 19:55:11","","139307150821491843794434","","inherit","open","closed","","139307150821491843794434","","","2018-04-27 00:25:11","2018-04-26 19:55:11","","106","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139307150821491843794434.jpg","0","attachment","image/jpeg","0"),
("108","1","2018-03-29 22:05:51","2018-03-29 18:35:51","<span class=\"intro-text\"> متاسفانه از ظرفیت های گردشگری شهر تهران غافیلم و باید تلاش کنیم با استفاده از این ظرفیتها،پسوند و قیدهای منفی را از تهران جدا کنیم.</span>\r\n<div class=\"full-text\">\r\n\r\nبه گزارش خبرگزاری مهر،\"سید محمود میر لوحی\" در بازدید از ستاد نوروزی شهرداری تهران اظهار داشت: از طریق فضای مجازی و سایت های خبری،شیوه و ساز و کار ستاد گردشگری را دنبال و بررسی اجمالی از روند فعالیت ستاد داشتم و امروز هم  به صورت سرزده به ستاد آمدم تا از نزدیک در جریان فعالیت دوستانمان باشم.\r\n\r\nوی افزود:فعالیت این ستاد لازم،مفید و موثر است گرچه کاستی هایی نیز وجود دارد که باید مرتفع شود.\r\n\r\nاین عضو شورای اسلامی شهر تهران بیان کرد: تهران به عنوان پایتخت کشور و با این وسعت و وجود ۲۲۰۰ساختمان فرهنگی و تاریخی،ظرفیت بی بدیلی از  جاذبه های دیدنی و گردشگری را داراست که معتقدم در معرفی این جاذبه ها و بهره مندی از ظرفیت های موجود،غفلت شده است.\r\n\r\nمیرلوحی خاطر نشان کرد: باید برای تقویت زیر ساخت های گردشگردی و  معرفی جاذبه های دیدنی شهر تهران اقدامات جدی تری انجام شود.\r\n\r\nاین عضو شورای اسلامی شهر تهران اضافه کرد: شورای اسلامی شهر و شهرداری تهران  باید در این زمینه  تلاش کند و پیرو تصویب طرح \"ایران ۱۴۰۰\"باید ببینیم چه باید کرد که در معرفی جاذبه های گردشگری و جذب گردشگر موفق باشیم.\r\n\r\nمیر لوحی مطرح کرد:باید به گونه ای عمل کنیم که بتوانیم یک گردشگر و یا توریست را در یک زمان بندی حداقلی و یک هفته ای،بجای \"سرگرمی\"،\"تامین \"کنیم که متاسفانه هنوز در تهران با این سطح فاصله داریم.\r\n\r\nوی اشاره کرد:به طور مثال؛ در اصفهان به مقوله گردشگردی به قدری خوب توجه شده و زیر ساخت ها و امکانات  آماده است که هر گردشگردی در مدت زمان حداقلی و یک هفته ای،از جاذبه های دیدنی نهایت بهره را می برد و با یک شناخت کاملی از فرهنگ و تاریخ به مبدا باز می گردد در حالی که این اتفاق هنوز در مورد تهران محقق نشده است.\r\n\r\nاین مقام مسئول تاکید کرد:تهران باید به شان خود در حوزه گردشگری برسد در حالی که امروز شاهدیم ظرفیت ها بالقوه است و باید بالفعل شود.\r\n\r\nوی افزود: متاسفانه همواره تهران با شلوغی،ترافیک،آلودگی و پسوندهای\"منفی\"شناخته شده است در حالی که باید با بهره مندی حداکثری از ظرفیت و جاذبه های دیدنی،تهران زیبا را به همگان معرفی و این شهر به مقصد گردشگری تبدیل شود و پسوند و قیدهای منفی از تهران جدا شود.\r\n\r\nمیر لوحی تاکید کرد: باید برای بهره مندی حداکثری از ظرفیت های گردشگری شهر تهران،از بخش خصوصی کمک گرفت و بخش خصوصی باید به این حس و جایگاه برسد که گردشگر داخلی و خارجی را با گشاده رویی و خدمات دهی مطلوب میزبانی کند.\r\n\r\nوی ادامه داد: احساس و نگاه  \"خود کم بینی\" در ارائه خدمات گردشگردی باید از شهر تهران جدا شود،متاسفانه امروز  در جایگاهی هستیم که احساس میکنیم اگر کسی را از شهر و کشوری به تهران دعوت کنیم خیلی \"دست پری\" نداریم و  نمی توانیم از نظر گردشگری میزبان خوبی باشیم در حالیکه که از ظرفیت تاریخی،فرهنگی و گردشگری تهران غافلیم و باید به سمت معرفی مزیت و ظرفیت های تهران برویم و در این زمینه به جد کار کنیم.\r\n\r\n</div>","پسوندهای منفی را از تهران جدا کنیم/از ظرفیت های گردشگری غافلیم","","inherit","closed","closed","","106-revision-v1","","","2018-03-29 22:05:51","2018-03-29 18:35:51","","106","http://islamic.demo-qaleb.ir/106-revision-v1/","0","revision","","0"),
("109","1","2018-03-29 22:08:57","2018-03-29 18:38:57","لورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.","روایت رهبرانقلاب از شهادت حضرت قاسم بن الحسن(ع)","","publish","open","closed","","%d8%b1%d9%88%d8%a7%db%8c%d8%aa-%d8%b1%d9%87%d8%a8%d8%b1%d8%a7%d9%86%d9%82%d9%84%d8%a7%d8%a8-%d8%a7%d8%b2-%d8%b4%d9%87%d8%a7%d8%af%d8%aa-%d8%ad%d8%b6%d8%b1%d8%aa-%d9%82%d8%a7%d8%b3%d9%85-%d8%a8%d9%86","","","2018-03-29 22:08:57","2018-03-29 18:38:57","","0","http://islamic.demo-qaleb.ir/?post_type=media&#038;p=109","0","media","","0"),
("110","1","2018-03-29 22:08:50","2018-03-29 18:38:50","","139507180953311398885994","","inherit","open","closed","","139507180953311398885994","","","2018-03-29 22:08:50","2018-03-29 18:38:50","","109","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139507180953311398885994.jpg","0","attachment","image/jpeg","0"),
("111","1","2018-03-29 22:08:57","2018-03-29 18:38:57","لورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.","روایت رهبرانقلاب از شهادت حضرت قاسم بن الحسن(ع)","","inherit","closed","closed","","109-revision-v1","","","2018-03-29 22:08:57","2018-03-29 18:38:57","","109","http://islamic.demo-qaleb.ir/109-revision-v1/","0","revision","","0"),
("112","2","2018-03-29 22:11:02","2018-03-29 18:41:02","به گزارش خبرنگار گروه سیاسی خبرگزاری تسنیم، سیدمصطفی هاشمی‌طباء کاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری در برنامه رادیویی چهره به چهره در رادیو معارف درباره سند چشم‌انداز ۱۴۰۴ و تحقق اهداف پیش‌بینی شده آن، یادآور شد: سند چشم‌انداز ۱۴۰۴ مهمترین سند بالادستی نظام اسلامی است و همه دولت‌ها موظف به انجام برنامه‌های پیش‌بینی شده در آن هستند.\r\n\r\nوی با اشاره به بخش‌هایی از این سند در حوزه آموزش و پرورش و آموزش عالی، یادآور شد: سند چشم‌انداز در زمینه آموزش و پرورش و آموزش عالی جایگاه‌هایی را در نظر گرفته که این جایگاه برای آموزش و پرورش یکم و برای آموزش عالی دوم منطقه است. به نظر بنده مجموعه نظام اجرایی کشور نتوانسته اهداف سند را در همه زمینه‌ها تا سال ۱۴۰۴ فراهم کند که از جمله آنها آموزش و پرورش است.\r\n\r\nهاشمی‌طباء ادامه داد: اگر خود باوری و رساندن ستوه مختلف علی‌الخصوص در بخش‌های آموزشی منطبق بر مسائل جاری کشور باشد، از تحقق این سند می‌توان امیدوارتر بود.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری با اشاره به اینکه آموزش و پرورش در زمینه آموزش فعال است، اما در زمینه پرورش دچار کم تحرکی شده، گفت: بیشتر مسائل آموزش و پرورش در کشور ما حول مسئله معیشت معلمان می‌گردد و بحث پژوهش و تربیت در آن مورد غفلت قرار گرفته است. هر چند مسئله معیشت معلمین هم مهم است، اما نباید از بعد تربیت نیز غافل ماند.\r\n\r\nوی با تجربه خود در سازمان تربیت بدنی اشاره کرد و افزود: بنده معتقد بودم اگر در مدارس مان برای تدریس دانش‌آموزان معلمان برجسته تربیت بدنی داشته باشیم، دانش‌آموزان خود به خود جذب این مسئله شده و انگیزه‌های تربیت بدنی در آنها شکوفا می‌شود. در حوزه تربیت نیز معتقدم نقش معلمین در این زمینه مهم است و باید به گونه‌ای شود که مسائلی مانند تربیت و به خصوص تربیت دینی انگیزه‌های انقلابی و اعتقادی ملکه ذهن جوانان و نوجوانان شود.\r\n\r\nهاشمی‌طباء در ادامه این گفتگوی رادیویی درباره برنامه‌هایش برای تقویت و اثربخشی شورای عالی انقلاب فرهنگی، گفت: اصولا از ترکیب شورای عالی انقلاب فرهنگی نمی‌توان این انتظار را داشت که در زمینه فرهنگ حرکت فرهنگی جامع داشته باشد. وقتی شورای عالی انقلاب فرهنگی عبارت است از افراد مختلف القدرت و مختلف البیان نمی‌توان انتظار داشت این شورا شکل واقعی به خود برای رفع مشکلات فرهنگی را بگیرد.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری با بیان اینکه اکثر افراد حاضر در این شورا افرادی سیاسی و دارای مسئولیت در بخش‌های سیاسی کشور هستند، ادامه داد: مسئولان فرهنگی کمتر در این شورا جا دارند، قطعا هر انسانی در مقابل رئیس‌جمهور، رئیس قوه مقننه یا رئیس قوه قضائیه قرار گیرد نمی‌تواند حرف بزند، لذا لزوما باید ترکیب شورا فرهنگی شود و افراد فرهنگی فرهیخته عضو آن شوند. قطعا کسی که رئیس‌جمهور است وقت آن را ندارد درباره مسائل فرهنگی کشور بی‌اندیشد زیرا درگیر مسائل اجرایی است.\r\n\r\nوی درباره برنامه‌هایش برای حوزه‌های علمیه گفت: حوزه‌های علمیه باید چراغ راه جامعه و دولت‌ها باشند و دست‌آوردهای خود را در اختیار دولت‌ها قرار دهند.\r\n\r\nهاشمی‌طباء افزود: دولت‌ها صلاحیت این را ندارند تا درباره مسائل آنها تصمیم بگیرند، زیرا حوزه‌های علمیه از ابتدا مستقل و قائم به ذات بوده‌اند.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری افزود: باید از دست‌آوردهای حوزه‌های علمیه نظیر برنامه‌های اجرایی آنها به خصوص در مسائل اجتماعی و فرهنگی کمک گرفت. به این معنی که آنها با رصد مسائل اجتماعی و فرهنگی و تمرکز بر مشکلات این بخش برنامهها و راه‌کارهایی را به دولت‌ها ارائه دهند هر چند دولت‌ها موظفند به آنها کمک مادی کنند. اما فرایند کار باید به دست خود آنها ادامه یابد.\r\n\r\nوی درباره برنامه‌های در مقابل تهدیدات فضای مجازی یادآور شد: کار ممیزی و انتظامی در همه زمینه‌ها در کنار کار فرهنگی مورد نیاز است. فضای مجازی از جمله فضاهایی است که باید به دقت مورد رصد و توجه قرار گیرد.\r\n\r\nهاشمی‌طباء با بیان اینکه فضای مجازی وقت انسان‌ها را تلف می‌کند و در بسیاری از اوقات باعث می‌شود انسان‌ها وقت خود را در آن هدر دهند، گفت: برای کم کردن آسیب‌های این فضا باید راه کارهایی در نظر گرفت از جمله اینکه فضای مجازی داخل را فعال کرد، به شکلی که با جذاب کردن آنها و در اختیار داشتن اطلاعات دقیق اجتماعی جایگاه خود را به عنوان یک پایگاه خبری مطمئن در نزد مردم محکم کنند.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری با اشاره به آسیب‌های این فضا به خصوص برای کودکان و نوجوانان خاطر نشان کرد: باید ابزارهای کنترلی و انتظامی را برای این فضا در کشور فراهم کرد، به شکلی که کشورهای دیگر نیز فضایی را برای کنترل آن در نظر گرفتند، مثلا در ژاپن با ایجاد سیم‌کارتهایی مخصوص نوجوانان و کودکان آنها را در برابر این فضا کنترل و محدود کردند. لذا کار فرهنگی، کنترلی و انتظامی هر دو در فضای مجازی مورد نیاز است.\r\n\r\nوی درباره برنامه‌هایش در خصوص دانشگاه اسلامی گفت: در دانشگاه اسلامی هم اساتید فرهیخته و اسلامی و مسلمان هستند و هم دانشجویان در چنین فضایی فعالیت می‌کنند. اینگونه نیست که اسم دانشگاه هم اسلامی باشد، بلکه هویت دانشگاه باید در این راستا قرار گیرد.\r\n\r\nهاشمی‌طباء با بیان اینکه دانشگاه مرکز علم اندوزی و محدودیتی در این خصوص نباید داشته باشد گفت: نمی توان دور برخی علوم را خط قرمز کشید و بگوییم آنها علوم اسلامی نیستند و نباید به آن توجه کرد. بلکه دانشگاهی اسلامی است که همه علوم در آن مورد توجه قرار گیرند و به عنوان مرکز علم به دنبال تحلیل های دقیق علمی باشند نه تحلیل‌های جهت دار.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری افزود: بر خلاف آنچه که برخی معتقدند اساتید غیر مسلمان نیز می‌توانند در تدریس برخی دروس در دانشگاه اسلامی حضور داشته باشند زیرا هدف این دانشگاه معرفی دقیق اسلام و پاسخ گویی به شبهه‌هایی است که تنها دانشگاه می‌تواند به آن پاسخ دهد.\r\n\r\nوی درباره وحدت حوزه و دانشگاه نیز گفت: وحدت حوزه و دانشگاه یعنی این که آنها در سرنوشت انسان وحدت داشته باشند. حوزه بیشتر به مسائل و ابعاد دینی و دانشگاه به شکل عام‌تر در حوزه‌های فرهنگی و علمی نسبت به مشترکات انسان توجه می‌کند.\r\n\r\nهاشمی‌طباء درباره برنامه‌هایش برای هنر اسلامی وانقلابی با تعریفی از هنر گفت: هنر تبلور اراده انسان در بیان است، بنده پیش از انقلاب در زمینه عکاسی فعالیت‌هایی را داشتم لذا از هنر دور نیستم، معتقدم برخورد ما با هنرمندان باید ظریف‌تر باشد و آنها را بهتر درک کنیم.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری با بیان اینکه هنرمندان عمدتا در کشور ما آزرده خاطر هستند, گفت: این به این دلیل است که ما درک درستی از هنرمند نداریم، لذا نمی‌توانیم آنها را به خوبی درک کنیم.\r\n\r\nوی درباره هنر انقلابی نیز گفت: هنر انقلابی یعنی این که بتوانیم از ابزارهای هنر به محتوای هنر انقلابی برسیم. هنر انقلابی باید اغلب از درون هنرمند بجوشد و اینگونه نیست که ما تنها محتوا را انقلابی کنیم و از هنرمند بخواهیم آن را پیاده کند، بلکه باید این جوشش از درون خود هنرمند با تربیت دینی به عنوان مناسک دینی جوشش داشته باشد. اما متاسفانه در کشور ما چندان به جوهره دینی توجه نمی‌شود.\r\n\r\nهاشمی‌طباء درباره برنامه‌هایش برای استحکام بنیان خانواده در ایران گفت: بنده معتقدم مسئله ازدواج در کشور ما بیشتر دچار درد فرهنگی است، اینگونه نیست که دولت‌ها با دادن وام، تهیه مسکن بتواند کانون خانواده را تقویت کنند. کشور ما در این حوزه دچار درد فرهنگی است و باید با کنش‌ها و رفتارهای فرهنگی آن را درمان کرد.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری با اشاره به شعارهای برخی از کاندیداها در زمینه رفع موانع ازدواج گفت: برخی از کاندیداها در بیان وعده های خود ژست اپوزوسیونی می‌گیرند و سخنانی مطرح می‌کنند که علیه نظام جمهوری اسلامی است. مانند کسی که در واشنگتن و خارج از ایران نشسته و اظهاراتی را علیه جمهوری اسلامی ایران مطرح می‌کند، اما من معتقدم دولت در این خصوص به جز برخی حمایت‌ها نمی‌تواند اقداماتی را صورت دهد لذا برای حل این مشکل به حرکت فرهنگی نیازمندیم.\r\n\r\nوی ایجاد زمینه‌هایی برای ازدواج سهل وآسان را از جمله برنامه‌های فرهنگی دانست و گفت: باید زمینه ازدواج‌های آسان و به دور از تشریفات در کشور فراهم شود، زیرا هرچه تشریفات بیشتر شود فرصت و زمان ازدواج جوانان بیشتر به عقب می‌رود.\r\n\r\nهاشمی‌طباء درباره استفاه از پژوهش‌های کشور برای رفع مسائل اجتماعی و فرهنگی گفت: معتقدم پژوهشکده‌ها و پژوهشگاه‌های کشور به عنوان یک چهاردیواری تنها به انجام کارهای اداری خود می‌پردازند زیرا جامعه و دولت از آنها برای حل مشکلات استفاده نکرده است. مشکل پژوهش در کشور ما این است که به آن بها داده نمی‌شود و به دنبال حل مسائل از طریق آن نیستیم. لذا باید کمک کنیم تا پژوهشکده‌ها با انجام پژوهش‌های کاربردی به بتن جامعه نزدیک‌تر شود و از آنها در راستای حل مشکلات بهره گرفت.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری درباره مشکلات بانکداری اسلامی گفت: بنده معتقدم بانکداری پدیده جدیدی در اسلام بوده و در صدر اسلام وجود نداشته است.","هاشمی‌طباء: کار ممیزی و انتظامی در کنار کار فرهنگی مورد نیاز است","","publish","open","open","","%d9%87%d8%a7%d8%b4%d9%85%db%8c%e2%80%8c%d8%b7%d8%a8%d8%a7%d8%a1-%da%a9%d8%a7%d8%b1-%d9%85%d9%85%db%8c%d8%b2%db%8c-%d9%88-%d8%a7%d9%86%d8%aa%d8%b8%d8%a7%d9%85%db%8c-%d8%af%d8%b1-%da%a9%d9%86%d8%a7","","","2018-09-06 14:18:45","2018-09-06 09:48:45","","0","http://islamic.demo-qaleb.ir/?p=112","0","post","","0"),
("113","1","2018-03-29 22:17:06","2018-03-29 18:47:06","لورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\n&nbsp;\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.","عجیب ترین فرودگاه های جهان","","publish","open","closed","","%d8%b9%d8%ac%db%8c%d8%a8-%d8%aa%d8%b1%db%8c%d9%86-%d9%81%d8%b1%d9%88%d8%af%da%af%d8%a7%d9%87-%d9%87%d8%a7%db%8c-%d8%ac%d9%87%d8%a7%d9%86","","","2018-03-29 22:17:06","2018-03-29 18:47:06","","0","http://islamic.demo-qaleb.ir/?post_type=media&#038;p=113","0","media","","0"),
("114","1","2018-03-29 22:11:02","2018-03-29 18:41:02","به گزارش خبرنگار گروه سیاسی خبرگزاری تسنیم، سیدمصطفی هاشمی‌طباء کاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری در برنامه رادیویی چهره به چهره در رادیو معارف درباره سند چشم‌انداز ۱۴۰۴ و تحقق اهداف پیش‌بینی شده آن، یادآور شد: سند چشم‌انداز ۱۴۰۴ مهمترین سند بالادستی نظام اسلامی است و همه دولت‌ها موظف به انجام برنامه‌های پیش‌بینی شده در آن هستند.\r\n\r\nوی با اشاره به بخش‌هایی از این سند در حوزه آموزش و پرورش و آموزش عالی، یادآور شد: سند چشم‌انداز در زمینه آموزش و پرورش و آموزش عالی جایگاه‌هایی را در نظر گرفته که این جایگاه برای آموزش و پرورش یکم و برای آموزش عالی دوم منطقه است. به نظر بنده مجموعه نظام اجرایی کشور نتوانسته اهداف سند را در همه زمینه‌ها تا سال ۱۴۰۴ فراهم کند که از جمله آنها آموزش و پرورش است.\r\n\r\nهاشمی‌طباء ادامه داد: اگر خود باوری و رساندن ستوه مختلف علی‌الخصوص در بخش‌های آموزشی منطبق بر مسائل جاری کشور باشد، از تحقق این سند می‌توان امیدوارتر بود.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری با اشاره به اینکه آموزش و پرورش در زمینه آموزش فعال است، اما در زمینه پرورش دچار کم تحرکی شده، گفت: بیشتر مسائل آموزش و پرورش در کشور ما حول مسئله معیشت معلمان می‌گردد و بحث پژوهش و تربیت در آن مورد غفلت قرار گرفته است. هر چند مسئله معیشت معلمین هم مهم است، اما نباید از بعد تربیت نیز غافل ماند.\r\n\r\nوی با تجربه خود در سازمان تربیت بدنی اشاره کرد و افزود: بنده معتقد بودم اگر در مدارس مان برای تدریس دانش‌آموزان معلمان برجسته تربیت بدنی داشته باشیم، دانش‌آموزان خود به خود جذب این مسئله شده و انگیزه‌های تربیت بدنی در آنها شکوفا می‌شود. در حوزه تربیت نیز معتقدم نقش معلمین در این زمینه مهم است و باید به گونه‌ای شود که مسائلی مانند تربیت و به خصوص تربیت دینی انگیزه‌های انقلابی و اعتقادی ملکه ذهن جوانان و نوجوانان شود.\r\n\r\nهاشمی‌طباء در ادامه این گفتگوی رادیویی درباره برنامه‌هایش برای تقویت و اثربخشی شورای عالی انقلاب فرهنگی، گفت: اصولا از ترکیب شورای عالی انقلاب فرهنگی نمی‌توان این انتظار را داشت که در زمینه فرهنگ حرکت فرهنگی جامع داشته باشد. وقتی شورای عالی انقلاب فرهنگی عبارت است از افراد مختلف القدرت و مختلف البیان نمی‌توان انتظار داشت این شورا شکل واقعی به خود برای رفع مشکلات فرهنگی را بگیرد.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری با بیان اینکه اکثر افراد حاضر در این شورا افرادی سیاسی و دارای مسئولیت در بخش‌های سیاسی کشور هستند، ادامه داد: مسئولان فرهنگی کمتر در این شورا جا دارند، قطعا هر انسانی در مقابل رئیس‌جمهور، رئیس قوه مقننه یا رئیس قوه قضائیه قرار گیرد نمی‌تواند حرف بزند، لذا لزوما باید ترکیب شورا فرهنگی شود و افراد فرهنگی فرهیخته عضو آن شوند. قطعا کسی که رئیس‌جمهور است وقت آن را ندارد درباره مسائل فرهنگی کشور بی‌اندیشد زیرا درگیر مسائل اجرایی است.\r\n\r\nوی درباره برنامه‌هایش برای حوزه‌های علمیه گفت: حوزه‌های علمیه باید چراغ راه جامعه و دولت‌ها باشند و دست‌آوردهای خود را در اختیار دولت‌ها قرار دهند.\r\n\r\nهاشمی‌طباء افزود: دولت‌ها صلاحیت این را ندارند تا درباره مسائل آنها تصمیم بگیرند، زیرا حوزه‌های علمیه از ابتدا مستقل و قائم به ذات بوده‌اند.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری افزود: باید از دست‌آوردهای حوزه‌های علمیه نظیر برنامه‌های اجرایی آنها به خصوص در مسائل اجتماعی و فرهنگی کمک گرفت. به این معنی که آنها با رصد مسائل اجتماعی و فرهنگی و تمرکز بر مشکلات این بخش برنامهها و راه‌کارهایی را به دولت‌ها ارائه دهند هر چند دولت‌ها موظفند به آنها کمک مادی کنند. اما فرایند کار باید به دست خود آنها ادامه یابد.\r\n\r\nوی درباره برنامه‌های در مقابل تهدیدات فضای مجازی یادآور شد: کار ممیزی و انتظامی در همه زمینه‌ها در کنار کار فرهنگی مورد نیاز است. فضای مجازی از جمله فضاهایی است که باید به دقت مورد رصد و توجه قرار گیرد.\r\n\r\nهاشمی‌طباء با بیان اینکه فضای مجازی وقت انسان‌ها را تلف می‌کند و در بسیاری از اوقات باعث می‌شود انسان‌ها وقت خود را در آن هدر دهند، گفت: برای کم کردن آسیب‌های این فضا باید راه کارهایی در نظر گرفت از جمله اینکه فضای مجازی داخل را فعال کرد، به شکلی که با جذاب کردن آنها و در اختیار داشتن اطلاعات دقیق اجتماعی جایگاه خود را به عنوان یک پایگاه خبری مطمئن در نزد مردم محکم کنند.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری با اشاره به آسیب‌های این فضا به خصوص برای کودکان و نوجوانان خاطر نشان کرد: باید ابزارهای کنترلی و انتظامی را برای این فضا در کشور فراهم کرد، به شکلی که کشورهای دیگر نیز فضایی را برای کنترل آن در نظر گرفتند، مثلا در ژاپن با ایجاد سیم‌کارتهایی مخصوص نوجوانان و کودکان آنها را در برابر این فضا کنترل و محدود کردند. لذا کار فرهنگی، کنترلی و انتظامی هر دو در فضای مجازی مورد نیاز است.\r\n\r\nوی درباره برنامه‌هایش در خصوص دانشگاه اسلامی گفت: در دانشگاه اسلامی هم اساتید فرهیخته و اسلامی و مسلمان هستند و هم دانشجویان در چنین فضایی فعالیت می‌کنند. اینگونه نیست که اسم دانشگاه هم اسلامی باشد، بلکه هویت دانشگاه باید در این راستا قرار گیرد.\r\n\r\nهاشمی‌طباء با بیان اینکه دانشگاه مرکز علم اندوزی و محدودیتی در این خصوص نباید داشته باشد گفت: نمی توان دور برخی علوم را خط قرمز کشید و بگوییم آنها علوم اسلامی نیستند و نباید به آن توجه کرد. بلکه دانشگاهی اسلامی است که همه علوم در آن مورد توجه قرار گیرند و به عنوان مرکز علم به دنبال تحلیل های دقیق علمی باشند نه تحلیل‌های جهت دار.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری افزود: بر خلاف آنچه که برخی معتقدند اساتید غیر مسلمان نیز می‌توانند در تدریس برخی دروس در دانشگاه اسلامی حضور داشته باشند زیرا هدف این دانشگاه معرفی دقیق اسلام و پاسخ گویی به شبهه‌هایی است که تنها دانشگاه می‌تواند به آن پاسخ دهد.\r\n\r\nوی درباره وحدت حوزه و دانشگاه نیز گفت: وحدت حوزه و دانشگاه یعنی این که آنها در سرنوشت انسان وحدت داشته باشند. حوزه بیشتر به مسائل و ابعاد دینی و دانشگاه به شکل عام‌تر در حوزه‌های فرهنگی و علمی نسبت به مشترکات انسان توجه می‌کند.\r\n\r\nهاشمی‌طباء درباره برنامه‌هایش برای هنر اسلامی وانقلابی با تعریفی از هنر گفت: هنر تبلور اراده انسان در بیان است، بنده پیش از انقلاب در زمینه عکاسی فعالیت‌هایی را داشتم لذا از هنر دور نیستم، معتقدم برخورد ما با هنرمندان باید ظریف‌تر باشد و آنها را بهتر درک کنیم.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری با بیان اینکه هنرمندان عمدتا در کشور ما آزرده خاطر هستند, گفت: این به این دلیل است که ما درک درستی از هنرمند نداریم، لذا نمی‌توانیم آنها را به خوبی درک کنیم.\r\n\r\nوی درباره هنر انقلابی نیز گفت: هنر انقلابی یعنی این که بتوانیم از ابزارهای هنر به محتوای هنر انقلابی برسیم. هنر انقلابی باید اغلب از درون هنرمند بجوشد و اینگونه نیست که ما تنها محتوا را انقلابی کنیم و از هنرمند بخواهیم آن را پیاده کند، بلکه باید این جوشش از درون خود هنرمند با تربیت دینی به عنوان مناسک دینی جوشش داشته باشد. اما متاسفانه در کشور ما چندان به جوهره دینی توجه نمی‌شود.\r\n\r\nهاشمی‌طباء درباره برنامه‌هایش برای استحکام بنیان خانواده در ایران گفت: بنده معتقدم مسئله ازدواج در کشور ما بیشتر دچار درد فرهنگی است، اینگونه نیست که دولت‌ها با دادن وام، تهیه مسکن بتواند کانون خانواده را تقویت کنند. کشور ما در این حوزه دچار درد فرهنگی است و باید با کنش‌ها و رفتارهای فرهنگی آن را درمان کرد.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری با اشاره به شعارهای برخی از کاندیداها در زمینه رفع موانع ازدواج گفت: برخی از کاندیداها در بیان وعده های خود ژست اپوزوسیونی می‌گیرند و سخنانی مطرح می‌کنند که علیه نظام جمهوری اسلامی است. مانند کسی که در واشنگتن و خارج از ایران نشسته و اظهاراتی را علیه جمهوری اسلامی ایران مطرح می‌کند، اما من معتقدم دولت در این خصوص به جز برخی حمایت‌ها نمی‌تواند اقداماتی را صورت دهد لذا برای حل این مشکل به حرکت فرهنگی نیازمندیم.\r\n\r\nوی ایجاد زمینه‌هایی برای ازدواج سهل وآسان را از جمله برنامه‌های فرهنگی دانست و گفت: باید زمینه ازدواج‌های آسان و به دور از تشریفات در کشور فراهم شود، زیرا هرچه تشریفات بیشتر شود فرصت و زمان ازدواج جوانان بیشتر به عقب می‌رود.\r\n\r\nهاشمی‌طباء درباره استفاه از پژوهش‌های کشور برای رفع مسائل اجتماعی و فرهنگی گفت: معتقدم پژوهشکده‌ها و پژوهشگاه‌های کشور به عنوان یک چهاردیواری تنها به انجام کارهای اداری خود می‌پردازند زیرا جامعه و دولت از آنها برای حل مشکلات استفاده نکرده است. مشکل پژوهش در کشور ما این است که به آن بها داده نمی‌شود و به دنبال حل مسائل از طریق آن نیستیم. لذا باید کمک کنیم تا پژوهشکده‌ها با انجام پژوهش‌های کاربردی به بتن جامعه نزدیک‌تر شود و از آنها در راستای حل مشکلات بهره گرفت.\r\n\r\nکاندیدای دوازدهمین دوره انتخابات ریاست‌جمهوری درباره مشکلات بانکداری اسلامی گفت: بنده معتقدم بانکداری پدیده جدیدی در اسلام بوده و در صدر اسلام وجود نداشته است.","هاشمی‌طباء: کار ممیزی و انتظامی در کنار کار فرهنگی مورد نیاز است","","inherit","closed","closed","","112-revision-v1","","","2018-03-29 22:11:02","2018-03-29 18:41:02","","112","http://islamic.demo-qaleb.ir/112-revision-v1/","0","revision","","0"),
("116","1","2018-03-29 22:14:47","2018-03-29 18:44:47","[gallery size=\"medium\" ids=\"117,118,119,120,121,122\"]","حضور رهبر انقلاب در جمع مداحان","","publish","open","closed","","%d8%ad%d8%b6%d9%88%d8%b1-%d8%b1%d9%87%d8%a8%d8%b1-%d8%a7%d9%86%d9%82%d9%84%d8%a7%d8%a8-%d8%af%d8%b1-%d8%ac%d9%85%d8%b9-%d9%85%d8%af%d8%a7%d8%ad%d8%a7%d9%86","","","2018-03-29 22:14:47","2018-03-29 18:44:47","","0","http://islamic.demo-qaleb.ir/?post_type=gallery&#038;p=116","0","gallery","","0"),
("117","1","2018-03-29 22:13:53","2018-03-29 18:43:53","","3-1","","inherit","open","closed","","3-1","","","2018-03-29 22:13:53","2018-03-29 18:43:53","","116","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/3-1.jpg","0","attachment","image/jpeg","0"),
("118","1","2018-03-29 22:14:10","2018-03-29 18:44:10","","3-3","","inherit","open","closed","","3-3","","","2018-03-29 22:14:10","2018-03-29 18:44:10","","116","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/3-3.jpg","0","attachment","image/jpeg","0"),
("119","1","2018-03-29 22:14:15","2018-03-29 18:44:15","","3-5","","inherit","open","closed","","3-5","","","2018-03-29 22:14:15","2018-03-29 18:44:15","","116","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/3-5.jpg","0","attachment","image/jpeg","0"),
("120","1","2018-03-29 22:14:23","2018-03-29 18:44:23","","IMG12580183","","inherit","open","closed","","img12580183","","","2018-03-29 22:14:23","2018-03-29 18:44:23","","116","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/IMG12580183.jpg","0","attachment","image/jpeg","0"),
("121","1","2018-03-29 22:14:25","2018-03-29 18:44:25","","3-2","","inherit","open","closed","","3-2","","","2018-03-29 22:14:25","2018-03-29 18:44:25","","116","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/3-2.jpg","0","attachment","image/jpeg","0"),
("122","1","2018-03-29 22:14:32","2018-03-29 18:44:32","","3-4","","inherit","open","closed","","3-4","","","2018-03-29 22:14:32","2018-03-29 18:44:32","","116","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/3-4.jpg","0","attachment","image/jpeg","0"),
("123","1","2018-03-29 22:14:47","2018-03-29 18:44:47","[gallery size=\"medium\" ids=\"117,118,119,120,121,122\"]","حضور رهبر انقلاب در جمع مداحان","","inherit","closed","closed","","116-revision-v1","","","2018-03-29 22:14:47","2018-03-29 18:44:47","","116","http://islamic.demo-qaleb.ir/116-revision-v1/","0","revision","","0"),
("124","1","2018-03-29 22:16:25","2018-03-29 18:46:25","","139507171249242728877264","","inherit","open","closed","","139507171249242728877264","","","2018-03-29 22:16:25","2018-03-29 18:46:25","","113","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139507171249242728877264.jpg","0","attachment","image/jpeg","0"),
("125","1","2018-03-29 22:17:06","2018-03-29 18:47:06","لورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\n&nbsp;\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.","عجیب ترین فرودگاه های جهان","","inherit","closed","closed","","113-revision-v1","","","2018-03-29 22:17:06","2018-03-29 18:47:06","","113","http://islamic.demo-qaleb.ir/113-revision-v1/","0","revision","","0"),
("260","2","2018-08-31 17:29:27","2018-08-31 12:59:27","[gallery size=\"medium\" ids=\"261,262,263,264,265,266\"]","عناوین روزنامه های امروز ۹7/3/۱۱","","publish","open","closed","","%d8%b9%d9%86%d8%a7%d9%88%db%8c%d9%86-%d8%b1%d9%88%d8%b2%d9%86%d8%a7%d9%85%d9%87-%d9%87%d8%a7%db%8c-%d8%a7%d9%85%d8%b1%d9%88%d8%b2-%db%b97-3-%db%b1%db%b1","","","2018-08-31 17:29:27","2018-08-31 12:59:27","","0","http://islamic.demo-qaleb.ir/?post_type=newspaper&#038;p=260","0","newspaper","","0"),
("261","2","2018-08-31 17:28:46","2018-08-31 12:58:46","","wwww.wp-qaleb.ir (1)","","inherit","open","closed","","wwww-wp-qaleb-ir-1","","","2018-08-31 17:28:46","2018-08-31 12:58:46","","260","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/wwww.wp-qaleb.ir-1.jpg","0","attachment","image/jpeg","0"),
("129","2","2018-03-29 22:23:18","2018-03-29 18:53:18","[gallery size=\"medium\" ids=\"130,131,132,133,134,135\"]","شبهای قدر در سراسر کشور","","publish","open","closed","","%d8%b4%d8%a8%d9%87%d8%a7%db%8c-%d9%82%d8%af%d8%b1-%d8%af%d8%b1-%d8%b3%d8%b1%d8%a7%d8%b3%d8%b1-%da%a9%d8%b4%d9%88%d8%b1","","","2018-09-06 14:20:22","2018-09-06 09:50:22","","0","http://islamic.demo-qaleb.ir/?post_type=gallery&#038;p=129","0","gallery","","0"),
("130","1","2018-03-29 22:22:32","2018-03-29 18:52:32","","139507171343121718878494","","inherit","open","closed","","139507171343121718878494","","","2018-03-29 22:22:32","2018-03-29 18:52:32","","129","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139507171343121718878494.jpg","0","attachment","image/jpeg","0"),
("131","1","2018-03-29 22:22:50","2018-03-29 18:52:50","","139507171343157968878494","","inherit","open","closed","","139507171343157968878494","","","2018-03-29 22:22:50","2018-03-29 18:52:50","","129","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139507171343157968878494.jpg","0","attachment","image/jpeg","0"),
("132","1","2018-03-29 22:22:52","2018-03-29 18:52:52","","13950717134319148878494","","inherit","open","closed","","13950717134319148878494","","","2018-03-29 22:22:52","2018-03-29 18:52:52","","129","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/13950717134319148878494.jpg","0","attachment","image/jpeg","0"),
("133","1","2018-03-29 22:22:54","2018-03-29 18:52:54","","139507171343191558878494","","inherit","open","closed","","139507171343191558878494","","","2018-03-29 22:22:54","2018-03-29 18:52:54","","129","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139507171343191558878494.jpg","0","attachment","image/jpeg","0"),
("134","1","2018-03-29 22:22:57","2018-03-29 18:52:57","","139507180953393588885994","","inherit","open","closed","","139507180953393588885994","","","2018-03-29 22:22:57","2018-03-29 18:52:57","","129","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139507180953393588885994.jpg","0","attachment","image/jpeg","0"),
("135","1","2018-03-29 22:22:59","2018-03-29 18:52:59","","139508231650081139195654","","inherit","open","closed","","139508231650081139195654","","","2018-03-29 22:22:59","2018-03-29 18:52:59","","129","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139508231650081139195654.jpg","0","attachment","image/jpeg","0"),
("136","1","2018-03-29 22:23:18","2018-03-29 18:53:18","[gallery size=\"medium\" ids=\"130,131,132,133,134,135\"]","شبهای قدر در سراسر کشور","","inherit","closed","closed","","129-revision-v1","","","2018-03-29 22:23:18","2018-03-29 18:53:18","","129","http://islamic.demo-qaleb.ir/129-revision-v1/","0","revision","","0"),
("137","1","2018-03-29 22:25:33","2018-03-29 18:55:33"," ","","","publish","closed","closed","","137","","","2018-04-04 15:26:53","2018-04-04 10:56:53","","0","http://islamic.demo-qaleb.ir/?p=137","1","nav_menu_item","","0"),
("138","1","2018-03-29 22:25:33","2018-03-29 18:55:33"," ","","","publish","closed","closed","","138","","","2018-04-04 15:26:53","2018-04-04 10:56:53","","45","http://islamic.demo-qaleb.ir/?p=138","3","nav_menu_item","","0"),
("139","1","2018-03-29 22:25:33","2018-03-29 18:55:33"," ","","","publish","closed","closed","","139","","","2018-04-04 15:26:53","2018-04-04 10:56:53","","45","http://islamic.demo-qaleb.ir/?p=139","2","nav_menu_item","","0"),
("140","1","2018-03-29 22:25:33","2018-03-29 18:55:33"," ","","","publish","closed","closed","","140","","","2018-04-04 15:26:53","2018-04-04 10:56:53","","45","http://islamic.demo-qaleb.ir/?p=140","4","nav_menu_item","","0"),
("142","1","2018-03-29 22:26:17","2018-03-29 18:56:17"," ","","","publish","closed","closed","","142","","","2018-04-04 15:26:53","2018-04-04 10:56:53","","0","http://islamic.demo-qaleb.ir/?p=142","5","nav_menu_item","","0"),
("143","1","2018-03-29 22:26:17","2018-03-29 18:56:17"," ","","","publish","closed","closed","","143","","","2018-04-04 15:26:53","2018-04-04 10:56:53","","48","http://islamic.demo-qaleb.ir/?p=143","6","nav_menu_item","","0"),
("144","1","2018-03-29 22:26:17","2018-03-29 18:56:17"," ","","","publish","closed","closed","","144","","","2018-04-04 15:26:53","2018-04-04 10:56:53","","48","http://islamic.demo-qaleb.ir/?p=144","7","nav_menu_item","","0"),
("145","1","2018-03-29 22:30:28","2018-03-29 19:00:28","لورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\n&nbsp;\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.","خط آزاد – اشتغال جوان ایرانی یا خرید ایرباس","","publish","open","closed","","%d8%ae%d8%b7-%d8%a2%d8%b2%d8%a7%d8%af-%d8%a7%d8%b4%d8%aa%d8%ba%d8%a7%d9%84-%d8%ac%d9%88%d8%a7%d9%86-%d8%a7%db%8c%d8%b1%d8%a7%d9%86%db%8c-%db%8c%d8%a7-%d8%ae%d8%b1%db%8c%d8%af-%d8%a7%db%8c","","","2018-03-29 22:30:28","2018-03-29 19:00:28","","0","http://islamic.demo-qaleb.ir/?post_type=media&#038;p=145","0","media","","0"),
("146","1","2018-03-29 22:29:12","2018-03-29 18:59:12","","6875_m","","inherit","open","closed","","6875_m","","","2018-03-29 22:29:12","2018-03-29 18:59:12","","145","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/6875_m.jpg","0","attachment","image/jpeg","0"),
("148","1","2018-03-29 22:30:28","2018-03-29 19:00:28","لورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\n&nbsp;\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.","خط آزاد – اشتغال جوان ایرانی یا خرید ایرباس","","inherit","closed","closed","","145-revision-v1","","","2018-03-29 22:30:28","2018-03-29 19:00:28","","145","http://islamic.demo-qaleb.ir/145-revision-v1/","0","revision","","0"),
("149","1","2018-03-29 22:32:53","2018-03-29 19:02:53","لورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\n&nbsp;\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.","فیلمی که آمریکایی ها را به جان هم انداخت","","publish","open","closed","","%d9%81%db%8c%d9%84%d9%85%db%8c-%da%a9%d9%87-%d8%a2%d9%85%d8%b1%db%8c%da%a9%d8%a7%db%8c%db%8c-%d9%87%d8%a7-%d8%b1%d8%a7-%d8%a8%d9%87-%d8%ac%d8%a7%d9%86-%d9%87%d9%85-%d8%a7%d9%86%d8%af%d8%a7%d8%ae%d8%aa","","","2018-03-29 22:55:37","2018-03-29 19:25:37","","0","http://islamic.demo-qaleb.ir/?post_type=media&#038;p=149","0","media","","0"),
("152","1","2018-03-29 22:55:34","2018-03-29 19:25:34","","trump-e-netayauh-01","","inherit","open","closed","","trump-e-netayauh-01","","","2018-03-29 22:55:34","2018-03-29 19:25:34","","149","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/trump-e-netayauh-01.jpg","0","attachment","image/jpeg","0"),
("151","1","2018-03-29 22:32:53","2018-03-29 19:02:53","لورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\n&nbsp;\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.","فیلمی که آمریکایی ها را به جان هم انداخت","","inherit","closed","closed","","149-revision-v1","","","2018-03-29 22:32:53","2018-03-29 19:02:53","","149","http://islamic.demo-qaleb.ir/149-revision-v1/","0","revision","","0"),
("153","2","2018-03-29 22:57:02","2018-03-29 19:27:02","لورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\n&nbsp;\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.","تصاویر دیده نشده از اقامه نماز توسط رهبر معظم انقلاب","","publish","open","closed","","%d8%aa%d8%b5%d8%a7%d9%88%db%8c%d8%b1-%d8%af%db%8c%d8%af%d9%87-%d9%86%d8%b4%d8%af%d9%87-%d8%a7%d8%b2-%d8%a7%d9%82%d8%a7%d9%85%d9%87-%d9%86%d9%85%d8%a7%d8%b2-%d8%aa%d9%88%d8%b3%d8%b7-%d8%b1%d9%87%d8%a8","","","2018-09-02 10:23:06","2018-09-02 05:53:06","","0","http://islamic.demo-qaleb.ir/?post_type=media&#038;p=153","0","media","","1"),
("155","1","2018-03-29 22:57:02","2018-03-29 19:27:02","لورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.\r\n\r\n&nbsp;\r\n\r\nلورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد. معمولا طراحان گرافیک برای صفحه‌آرایی، نخست از متن‌های آزمایشی و بی‌معنی استفاده می‌کنند تا صرفا به مشتری یا صاحب کار خود نشان دهند که صفحه طراحی یا صفحه بندی شده بعد از اینکه متن در آن قرار گیرد چگونه به نظر می‌رسد و قلم‌ها و اندازه‌بندی‌ها چگونه در نظر گرفته شده‌است.","تصاویر دیده نشده از اقامه نماز توسط رهبر معظم انقلاب","","inherit","closed","closed","","153-revision-v1","","","2018-03-29 22:57:02","2018-03-29 19:27:02","","153","http://islamic.demo-qaleb.ir/153-revision-v1/","0","revision","","0"),
("156","1","2018-03-29 23:00:38","2018-03-29 19:30:38","به گزارش خبرنگار گروه دانشگاه خبرگزاری تسنیم، جمعی از دانشجویان و فارغ‌التحصیلان دانشگاه صنعت نفت در نامه‌ای خطاب به مردم و مسئولان کشور نکاتی را درباره وضعیت خود اعلام کردند.\r\n\r\nدر بخشی از این نامه خطاب به مردم آمده است: ما دانشجویان و فارغ‌التحصیلان دانشگاه صنعت نفت، جوانی خود را در بدترین شرایط آب و هوایی و به امید خدمت در صنعت اول کشور، در دانشگاهی سپری کردیم که تحت مدیریت وزارت نفت بوده است. ما رتبه‌های برتر کنکور سراسری فرصت تحصیل در بهترین دانشگاه‌های کشور را به پشتوانه امتیازات دانشگاه و تعهد وزارت نفت مبنی بر استخدام فارغ‌التحصیلان ممتاز گروه الف از دست دادیم.\r\n\r\nاین نامه می‌افزاید: تمام برنامه و امیدمان یک شبه توسط گروهبان‌ تکنوکرات نفت بر باد رفت. قربانی سیاست‌ها و تصمیم‌های دولتی شدیم که وعده‌اش ایجاد زندگی بهتر و اشتغال بیشتر برای جوانان بود.در طول دوران تحصیل و با توجه به محیط آموزشی قوی، نزدیکی به مناطق عملیاتی و وجود رقابت و انگیزه بالا توانستیم امتیاز گروه الف را برای خود کسب کنیم؛ اما به یکباره با ابلاغیه و دستورالعمل وزیری که فرزندانش در آسودگی کامل و خارج از کشور زندگی می‌کنند،حقمان پایمال شد و توسط افرادی که با افاضاتشان درباره مخازن نفتی ایران، نداشتن کم‌ترین شناخت و دانش در این زمینه را به رخ همه کشیده‌اند، ناعادلانه بی‌سواد خوانده شدیم.\r\n\r\nدر ادامه این نامه خطاب به نمایندگان مجلس نیز تاکید شده است: باوجود جواب‌های غیراصولی وزیر و فرار ایشان از مسئولیت و تعهد در قبال فارغ‌التحصیلان دانشگاه نفت، با کمال تعجب، با رأی برخی روبرو شدیم که جناح سیاسی و قدرت برایشان از همه چیز حتی حق‌الناس نیز مهم‌تر و اولی‌تر بود. تنها با رأی ۸ نماینده دیگر می‌توانستیم راه را برای گرفتن حقمان هموارتر کنیم که نشد.\r\n\r\nاین نامه می‌افزاید: وزیری که در دوره صدارتش بدترین توهین‌ها را به ما کرده و به زبان خود در صحن علنی اعلام می‌کند که با ابلاغیه خودش روند استخدام ما ملغی کرده است، دلایلی را مطرح می‌کند که هیچ عقل سلیم و فرد منصفی آن را نمی‌پذیرد. ایشان در حالی از نبود نیاز و تورم نیرو صحبت می‌کند که مطابق اسناد معتبر، مناطق عملیاتی به دلیل عدم جذب مناسب و بازنشستگی بالا، چند سالی است با مشکلات فراوانی دست و پنجه نرم می‌کنند.\r\n\r\nدانشجویان دانشگاه صنعت نفت در این نامه یادآور شدند: ایشان در حالی از موانع قانونی برای جذب سخن می‌گوید که همین موانع را خودشان تدوین و مرقوم کرده‌اند.در حالی با فرافکنی مقصر را سازمان استخدامی کشور می‌داند که همین سازمان برای سایر وزارتخانه‌ها و دستگاه‌های اجرایی مجوز استخدام چند ده هزار نفری صادر می‌کند.\r\n\r\nدر بخش پایانی این نامه دانشجویان خطاب به رئیس جمهور خاطرنشان کردند: شرح تمام مصائب و مشکلات روحی و معیشتی ما و خانواده‌هایمان در اینجا نمی‌گنجد ولی لازم است موردی را نیز به شما گوشزد کنیم. شما در نشست خبری هفته پیش خود گفتید که مردم با صدای رسا و آزادانه به نحوی فریاد بزنند که بقیه بدانند آن چیز باب میلشان نیست.\r\n\r\nاین نامه می‌افزاید: باید بگوییم ما در این ۲ سال و در پی بی‌قانونی وزیر همین دولت، در برودت سوزناک زمستان و زیر آفتاب سوزان تابستان اعتراض کردیم و بارها به مسئولین دولتی و حتی خود شما نامه نوشتیم؛ اما توسط عوامل دولت شما در دانشگاه، وزارت و مجلس تهدید و تحقیر شدیم. ویدیو مشهور انتخاباتیتان در سال ۹۲ را همه دیده‌اند؛ شما درآمد سرشار را به ملت وعده می‌دهید اما به نظر می‌آید، سهم دولت افزایش فروش نفت خام و تدارک فیش‌های نجومی و سهم ملت بیکاری بوده است.\r\n\r\nدر ادامه نامه آمده است: ریاست محترم حقوقدان جمهور؛ ما از هر راه حقوقی برای دفع ظلمی که به ما شد اقدام کردیم، ولی متأسفانه ژنرال!!! نفتی شما، هر بار حمله گازانبری جدیدی علیه ما را طراحی نمود. مگر جوانانی که قطعاً سطح دانش‌شان در حوزه نفت بیشتر از وزیرتان است چه کرده‌اند که پیران خسته و فرتوت بعد از سال‌ها بازنشستگی، به وزارت نفت بازگشته و اجازه خدمت به جوانان متخصص نمی‌دهند؟\r\n\r\nدر پایان این نامه تاکید شده است: همانطور که حضرتعالی وعده ۱۰۰ روزه زمان انتخابات را دروغ بزرگ می‌نامید، وزیر نفتتان تعهد وزارت در قبال فارغ‌التحصیلان دانشگاه نفت را بی‌اساس می‌خواند. امید ما برای حل مشکل، با تدبیر شما از بین رفته است و اکنون چشممان به رئیسی است که خود را خادم مردم بداند. مطمئن باشید که در انتخابات آتی حمایت ما دانشجویان و فارغ‌التحصیلان دانشگاه نفت به همراه خانواده‌هایمان را همانند خیل عظیمی از کارمندان و کارگران خدوم وزارت نفت و به علت عملکرد نادرست، غیرقابل قبول و افراطی وزیرتان از دست خواهید داد.","آقای روحانی! ژنرال نفتی‌تان با حمله‌های گازانبری حق‌مان را پایمال کرد","","publish","open","open","","%d8%a2%d9%82%d8%a7%db%8c-%d8%b1%d9%88%d8%ad%d8%a7%d9%86%db%8c-%da%98%d9%86%d8%b1%d8%a7%d9%84-%d9%86%d9%81%d8%aa%db%8c%e2%80%8c%d8%aa%d8%a7%d9%86-%d8%a8%d8%a7-%d8%ad%d9%85%d9%84%d9%87%e2%80%8c%d9%87","","","2018-03-30 11:40:42","2018-03-30 07:10:42","","0","http://islamic.demo-qaleb.ir/?p=156","0","post","","0"),
("157","1","2018-03-29 23:00:32","2018-03-29 19:30:32","","1396021400472221110723224","","inherit","open","closed","","1396021400472221110723224","","","2018-03-29 23:00:32","2018-03-29 19:30:32","","156","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/1396021400472221110723224.jpg","0","attachment","image/jpeg","0"),
("158","1","2018-03-29 23:00:38","2018-03-29 19:30:38","به گزارش خبرنگار گروه دانشگاه خبرگزاری تسنیم، جمعی از دانشجویان و فارغ‌التحصیلان دانشگاه صنعت نفت در نامه‌ای خطاب به مردم و مسئولان کشور نکاتی را درباره وضعیت خود اعلام کردند.\r\n\r\nدر بخشی از این نامه خطاب به مردم آمده است: ما دانشجویان و فارغ‌التحصیلان دانشگاه صنعت نفت، جوانی خود را در بدترین شرایط آب و هوایی و به امید خدمت در صنعت اول کشور، در دانشگاهی سپری کردیم که تحت مدیریت وزارت نفت بوده است. ما رتبه‌های برتر کنکور سراسری فرصت تحصیل در بهترین دانشگاه‌های کشور را به پشتوانه امتیازات دانشگاه و تعهد وزارت نفت مبنی بر استخدام فارغ‌التحصیلان ممتاز گروه الف از دست دادیم.\r\n\r\nاین نامه می‌افزاید: تمام برنامه و امیدمان یک شبه توسط گروهبان‌ تکنوکرات نفت بر باد رفت. قربانی سیاست‌ها و تصمیم‌های دولتی شدیم که وعده‌اش ایجاد زندگی بهتر و اشتغال بیشتر برای جوانان بود.در طول دوران تحصیل و با توجه به محیط آموزشی قوی، نزدیکی به مناطق عملیاتی و وجود رقابت و انگیزه بالا توانستیم امتیاز گروه الف را برای خود کسب کنیم؛ اما به یکباره با ابلاغیه و دستورالعمل وزیری که فرزندانش در آسودگی کامل و خارج از کشور زندگی می‌کنند،حقمان پایمال شد و توسط افرادی که با افاضاتشان درباره مخازن نفتی ایران، نداشتن کم‌ترین شناخت و دانش در این زمینه را به رخ همه کشیده‌اند، ناعادلانه بی‌سواد خوانده شدیم.\r\n\r\nدر ادامه این نامه خطاب به نمایندگان مجلس نیز تاکید شده است: باوجود جواب‌های غیراصولی وزیر و فرار ایشان از مسئولیت و تعهد در قبال فارغ‌التحصیلان دانشگاه نفت، با کمال تعجب، با رأی برخی روبرو شدیم که جناح سیاسی و قدرت برایشان از همه چیز حتی حق‌الناس نیز مهم‌تر و اولی‌تر بود. تنها با رأی ۸ نماینده دیگر می‌توانستیم راه را برای گرفتن حقمان هموارتر کنیم که نشد.\r\n\r\nاین نامه می‌افزاید: وزیری که در دوره صدارتش بدترین توهین‌ها را به ما کرده و به زبان خود در صحن علنی اعلام می‌کند که با ابلاغیه خودش روند استخدام ما ملغی کرده است، دلایلی را مطرح می‌کند که هیچ عقل سلیم و فرد منصفی آن را نمی‌پذیرد. ایشان در حالی از نبود نیاز و تورم نیرو صحبت می‌کند که مطابق اسناد معتبر، مناطق عملیاتی به دلیل عدم جذب مناسب و بازنشستگی بالا، چند سالی است با مشکلات فراوانی دست و پنجه نرم می‌کنند.\r\n\r\nدانشجویان دانشگاه صنعت نفت در این نامه یادآور شدند: ایشان در حالی از موانع قانونی برای جذب سخن می‌گوید که همین موانع را خودشان تدوین و مرقوم کرده‌اند.در حالی با فرافکنی مقصر را سازمان استخدامی کشور می‌داند که همین سازمان برای سایر وزارتخانه‌ها و دستگاه‌های اجرایی مجوز استخدام چند ده هزار نفری صادر می‌کند.\r\n\r\nدر بخش پایانی این نامه دانشجویان خطاب به رئیس جمهور خاطرنشان کردند: شرح تمام مصائب و مشکلات روحی و معیشتی ما و خانواده‌هایمان در اینجا نمی‌گنجد ولی لازم است موردی را نیز به شما گوشزد کنیم. شما در نشست خبری هفته پیش خود گفتید که مردم با صدای رسا و آزادانه به نحوی فریاد بزنند که بقیه بدانند آن چیز باب میلشان نیست.\r\n\r\nاین نامه می‌افزاید: باید بگوییم ما در این ۲ سال و در پی بی‌قانونی وزیر همین دولت، در برودت سوزناک زمستان و زیر آفتاب سوزان تابستان اعتراض کردیم و بارها به مسئولین دولتی و حتی خود شما نامه نوشتیم؛ اما توسط عوامل دولت شما در دانشگاه، وزارت و مجلس تهدید و تحقیر شدیم. ویدیو مشهور انتخاباتیتان در سال ۹۲ را همه دیده‌اند؛ شما درآمد سرشار را به ملت وعده می‌دهید اما به نظر می‌آید، سهم دولت افزایش فروش نفت خام و تدارک فیش‌های نجومی و سهم ملت بیکاری بوده است.\r\n\r\nدر ادامه نامه آمده است: ریاست محترم حقوقدان جمهور؛ ما از هر راه حقوقی برای دفع ظلمی که به ما شد اقدام کردیم، ولی متأسفانه ژنرال!!! نفتی شما، هر بار حمله گازانبری جدیدی علیه ما را طراحی نمود. مگر جوانانی که قطعاً سطح دانش‌شان در حوزه نفت بیشتر از وزیرتان است چه کرده‌اند که پیران خسته و فرتوت بعد از سال‌ها بازنشستگی، به وزارت نفت بازگشته و اجازه خدمت به جوانان متخصص نمی‌دهند؟\r\n\r\nدر پایان این نامه تاکید شده است: همانطور که حضرتعالی وعده ۱۰۰ روزه زمان انتخابات را دروغ بزرگ می‌نامید، وزیر نفتتان تعهد وزارت در قبال فارغ‌التحصیلان دانشگاه نفت را بی‌اساس می‌خواند. امید ما برای حل مشکل، با تدبیر شما از بین رفته است و اکنون چشممان به رئیسی است که خود را خادم مردم بداند. مطمئن باشید که در انتخابات آتی حمایت ما دانشجویان و فارغ‌التحصیلان دانشگاه نفت به همراه خانواده‌هایمان را همانند خیل عظیمی از کارمندان و کارگران خدوم وزارت نفت و به علت عملکرد نادرست، غیرقابل قبول و افراطی وزیرتان از دست خواهید داد.","آقای روحانی! ژنرال نفتی‌تان با حمله‌های گازانبری حق‌مان را پایمال کرد","","inherit","closed","closed","","156-revision-v1","","","2018-03-29 23:00:38","2018-03-29 19:30:38","","156","http://islamic.demo-qaleb.ir/156-revision-v1/","0","revision","","0"),
("159","2","2018-03-29 23:02:27","2018-03-29 19:32:27","[gallery size=\"medium\" ids=\"160,161,162,163,90,86\"]","پخش غذای نذری در بین مردم جنوب","","publish","open","closed","","%d9%be%d8%ae%d8%b4-%d8%ba%d8%b0%d8%a7%db%8c-%d9%86%d8%b0%d8%b1%db%8c-%d8%af%d8%b1-%d8%a8%db%8c%d9%86-%d9%85%d8%b1%d8%af%d9%85-%d8%ac%d9%86%d9%88%d8%a8","","","2018-09-02 10:19:28","2018-09-02 05:49:28","","0","http://islamic.demo-qaleb.ir/?post_type=gallery&#038;p=159","0","gallery","","0"),
("160","1","2018-03-29 23:01:32","2018-03-29 19:31:32","","139507171900058878882764","","inherit","open","closed","","139507171900058878882764","","","2018-03-29 23:01:32","2018-03-29 19:31:32","","159","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139507171900058878882764.jpg","0","attachment","image/jpeg","0"),
("161","1","2018-03-29 23:01:36","2018-03-29 19:31:36","","139507171900048878882764","","inherit","open","closed","","139507171900048878882764","","","2018-03-29 23:01:36","2018-03-29 19:31:36","","159","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139507171900048878882764.jpg","0","attachment","image/jpeg","0"),
("162","1","2018-03-29 23:01:40","2018-03-29 19:31:40","","139507171900069348882764","","inherit","open","closed","","139507171900069348882764","","","2018-03-29 23:01:40","2018-03-29 19:31:40","","159","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139507171900069348882764.jpg","0","attachment","image/jpeg","0"),
("163","1","2018-03-29 23:01:43","2018-03-29 19:31:43","","139507171900074818882764","","inherit","open","closed","","139507171900074818882764","","","2018-03-29 23:01:43","2018-03-29 19:31:43","","159","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/139507171900074818882764.jpg","0","attachment","image/jpeg","0"),
("164","1","2018-03-29 23:02:27","2018-03-29 19:32:27","[gallery size=\"medium\" ids=\"160,161,162,163,90,86\"]","پخش غذای نذری در بین مردم جنوب","","inherit","closed","closed","","159-revision-v1","","","2018-03-29 23:02:27","2018-03-29 19:32:27","","159","http://islamic.demo-qaleb.ir/159-revision-v1/","0","revision","","0"),
("165","1","2018-03-29 23:06:42","2018-03-29 19:36:42","","خوراک","","publish","closed","closed","","%d8%ae%d9%88%d8%b1%d8%a7%da%a9","","","2018-08-31 14:59:24","2018-08-31 10:29:24","","0","http://islamic.demo-qaleb.ir/?p=165","1","nav_menu_item","","0"),
("166","1","2018-03-29 23:06:42","2018-03-29 19:36:42","","آب و هوا","","publish","closed","closed","","%d8%a2%d8%a8-%d9%88-%d9%87%d9%88%d8%a7","","","2018-08-31 14:59:24","2018-08-31 10:29:24","","0","http://islamic.demo-qaleb.ir/?p=166","2","nav_menu_item","","0"),
("167","1","2018-03-29 23:06:42","2018-03-29 19:36:42","","قیمت ها","","publish","closed","closed","","%d9%82%db%8c%d9%85%d8%aa-%d9%87%d8%a7","","","2018-08-31 14:59:24","2018-08-31 10:29:24","","0","http://islamic.demo-qaleb.ir/?p=167","3","nav_menu_item","","0"),
("168","1","2018-03-29 23:06:42","2018-03-29 19:36:42","","اوقات شرعی","","publish","closed","closed","","%d8%a7%d9%88%d9%82%d8%a7%d8%aa-%d8%b4%d8%b1%d8%b9%db%8c","","","2018-08-31 14:59:24","2018-08-31 10:29:24","","0","http://islamic.demo-qaleb.ir/?p=168","4","nav_menu_item","","0"),
("169","1","2018-03-29 23:07:34","2018-03-29 19:37:34","این یک برگه‌ی نمونه است که با یک نوشته در وبلاگ تفاوت دارد زیرا برگه‌ها در یک مکان ثابت می‌مانند و معمولاً در فهرست پیوندهای درونی سایت شما نمایش داده می‌شوند (در بیشتر پوسته‌ها). بیشتر افراد کار کردن با برگه‌ها را از یک برگه‌ی «درباره من» که آن‌ها را به خوانندگان سایت معرفی می‌کند، شروع می‌کنند. برای مثال این‌چنین می‌گویند:\r\n<blockquote>سلام دوستان، من روزها یک کارمند اداری هستم و شب‌ها یک راننده تاکسی، این وبلاگ من است. من در اهواز زندگی می‌کنم که شهری در جنوب غربی ایران است.</blockquote>\r\nیا چیزی شبیه این:\r\n<blockquote>شرکت XYZ در سال ۱۳۶۵ تاسیس شد و ارائه‌دهنده محصولات صنعتی است. این شرکت ۲۰۰۰ کارگر و کارمند دارد. امیدواریم از محصولات ما راضی باشید.</blockquote>\r\nبه‌عنوان یک کاربر تازه‌ی وردپرس فارسی شما برای پاک کردن این برگه و ساختن برگه‌های تازه می‌توانید به <a href=\"http://islamic.demo-qaleb.ir/wp-admin/\">پیشخوان خود</a> مراجعه کنید. موفق باشید!","تماس با ما","","inherit","closed","closed","","2-revision-v1","","","2018-03-29 23:07:34","2018-03-29 19:37:34","","2","http://islamic.demo-qaleb.ir/2-revision-v1/","0","revision","","0"),
("170","2","2018-03-29 23:08:12","2018-03-29 19:38:12","این یک برگه‌ی نمونه است که با یک نوشته در وبلاگ تفاوت دارد زیرا برگه‌ها در یک مکان ثابت می‌مانند و معمولاً در فهرست پیوندهای درونی سایت شما نمایش داده می‌شوند (در بیشتر پوسته‌ها). بیشتر افراد کار کردن با برگه‌ها را از یک برگه‌ی «درباره من» که آن‌ها را به خوانندگان سایت معرفی می‌کند، شروع می‌کنند. برای مثال این‌چنین می‌گویند:\r\n<blockquote>سلام دوستان، من روزها یک کارمند اداری هستم و شب‌ها یک راننده تاکسی، این وبلاگ من است. من در اهواز زندگی می‌کنم که شهری در جنوب غربی ایران است.</blockquote>\r\nیا چیزی شبیه این:\r\n<blockquote>شرکت XYZ در سال ۱۳۶۵ تاسیس شد و ارائه‌دهنده محصولات صنعتی است. این شرکت ۲۰۰۰ کارگر و کارمند دارد. امیدواریم از محصولات ما راضی باشید.</blockquote>\r\nبه‌عنوان یک کاربر تازه‌ی وردپرس فارسی شما برای پاک کردن این برگه و ساختن برگه‌های تازه می‌توانید به پیشخوان خود مراجعه کنید. موفق باشید","درباره ما","","publish","closed","closed","","abuot","","","2019-09-28 15:43:45","2019-09-28 12:13:45","","0","http://islamic.demo-qaleb.ir/?page_id=170","0","page","","0"),
("171","1","2018-03-29 23:08:12","2018-03-29 19:38:12","این یک برگه‌ی نمونه است که با یک نوشته در وبلاگ تفاوت دارد زیرا برگه‌ها در یک مکان ثابت می‌مانند و معمولاً در فهرست پیوندهای درونی سایت شما نمایش داده می‌شوند (در بیشتر پوسته‌ها). بیشتر افراد کار کردن با برگه‌ها را از یک برگه‌ی «درباره من» که آن‌ها را به خوانندگان سایت معرفی می‌کند، شروع می‌کنند. برای مثال این‌چنین می‌گویند:\r\n<blockquote>سلام دوستان، من روزها یک کارمند اداری هستم و شب‌ها یک راننده تاکسی، این وبلاگ من است. من در اهواز زندگی می‌کنم که شهری در جنوب غربی ایران است.</blockquote>\r\nیا چیزی شبیه این:\r\n<blockquote>شرکت XYZ در سال ۱۳۶۵ تاسیس شد و ارائه‌دهنده محصولات صنعتی است. این شرکت ۲۰۰۰ کارگر و کارمند دارد. امیدواریم از محصولات ما راضی باشید.</blockquote>\r\nبه‌عنوان یک کاربر تازه‌ی وردپرس فارسی شما برای پاک کردن این برگه و ساختن برگه‌های تازه می‌توانید به <a href=\"http://islamic.demo-qaleb.ir/wp-admin/\">پیشخوان خود</a> مراجعه کنید. موفق باشید!","درباره ما","","inherit","closed","closed","","170-revision-v1","","","2018-03-29 23:08:12","2018-03-29 19:38:12","","170","http://islamic.demo-qaleb.ir/170-revision-v1/","0","revision","","0"),
("172","1","2018-03-29 23:08:22","2018-03-29 19:38:22"," ","","","publish","closed","closed","","172","","","2018-04-04 15:26:53","2018-04-04 10:56:53","","0","http://islamic.demo-qaleb.ir/?p=172","8","nav_menu_item","","0"),
("173","1","2018-03-29 23:08:22","2018-03-29 19:38:22"," ","","","publish","closed","closed","","173","","","2018-04-04 15:26:53","2018-04-04 10:56:53","","0","http://islamic.demo-qaleb.ir/?p=173","9","nav_menu_item","","0"),
("174","1","2018-03-29 23:11:01","2018-03-29 19:41:01","","تهران","","publish","closed","closed","","%d8%aa%d9%87%d8%b1%d8%a7%d9%86","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=174","15","nav_menu_item","","0"),
("175","1","2018-03-29 23:11:01","2018-03-29 19:41:01","","همدان","","publish","closed","closed","","%d9%87%d9%85%d8%af%d8%a7%d9%86","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=175","16","nav_menu_item","","0"),
("176","1","2018-03-29 23:11:01","2018-03-29 19:41:01","","مشهد","","publish","closed","closed","","%d9%85%d8%b4%d9%87%d8%af","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=176","17","nav_menu_item","","0"),
("177","1","2018-03-29 23:11:01","2018-03-29 19:41:01","","اصفهان","","publish","closed","closed","","%d8%a7%d8%b5%d9%81%d9%87%d8%a7%d9%86","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=177","18","nav_menu_item","","0"),
("178","1","2018-03-29 23:11:01","2018-03-29 19:41:01","","شیراز","","publish","closed","closed","","%d8%b4%db%8c%d8%b1%d8%a7%d8%b2","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=178","19","nav_menu_item","","0"),
("179","1","2018-03-29 23:11:01","2018-03-29 19:41:01","","تبریز","","publish","closed","closed","","%d8%aa%d8%a8%d8%b1%db%8c%d8%b2","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=179","20","nav_menu_item","","0"),
("180","1","2018-03-29 23:11:01","2018-03-29 19:41:01","","مرکزی","","publish","closed","closed","","%d9%85%d8%b1%da%a9%d8%b2%db%8c","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=180","21","nav_menu_item","","0"),
("181","1","2018-03-29 23:11:01","2018-03-29 19:41:01","","گیلان","","publish","closed","closed","","%da%af%db%8c%d9%84%d8%a7%d9%86","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=181","22","nav_menu_item","","0"),
("182","1","2018-03-29 23:11:01","2018-03-29 19:41:01","","کردستان","","publish","closed","closed","","%da%a9%d8%b1%d8%af%d8%b3%d8%aa%d8%a7%d9%86","","","2019-08-03 15:39:40","2019-08-03 11:09:40","","0","http://islamic.demo-qaleb.ir/?p=182","23","nav_menu_item","","0"),
("183","1","2018-03-29 23:11:01","2018-03-29 19:41:01","","کرمانشاه","","publish","closed","closed","","%da%a9%d8%b1%d9%85%d8%a7%d9%86%d8%b4%d8%a7%d9%87","","","2019-08-03 15:39:40","2019-08-03 11:09:40","","0","http://islamic.demo-qaleb.ir/?p=183","24","nav_menu_item","","0"),
("184","1","2018-03-29 23:11:01","2018-03-29 19:41:01","","یاسوج","","publish","closed","closed","","%db%8c%d8%a7%d8%b3%d9%88%d8%ac","","","2019-08-03 15:39:40","2019-08-03 11:09:40","","0","http://islamic.demo-qaleb.ir/?p=184","25","nav_menu_item","","0"),
("231","1","2018-04-04 15:28:14","2018-04-04 10:58:14"," ","","","publish","closed","closed","","231","","","2019-08-03 15:39:40","2019-08-03 11:09:40","","0","http://islamic.demo-qaleb.ir/?p=231","29","nav_menu_item","","0"),
("230","1","2018-04-04 15:28:14","2018-04-04 10:58:14"," ","","","publish","closed","closed","","230","","","2019-08-03 15:39:40","2019-08-03 11:09:40","","0","http://islamic.demo-qaleb.ir/?p=230","26","nav_menu_item","","0"),
("353","2","2019-08-03 15:27:39","2019-08-03 10:57:39","","صفحه نخست 1","","publish","closed","closed","","%d8%b5%d9%81%d8%ad%d9%87-%d9%86%d8%ae%d8%b3%d8%aa-1","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=353","2","nav_menu_item","","0"),
("351","2","2019-08-03 15:27:39","2019-08-03 10:57:39","","صفحه نخست 3","","publish","closed","closed","","%d8%b5%d9%81%d8%ad%d9%87-%d9%86%d8%ae%d8%b3%d8%aa-3","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=351","4","nav_menu_item","","0"),
("233","1","2018-04-04 15:28:14","2018-04-04 10:58:14"," ","","","publish","closed","closed","","233","","","2019-08-03 15:39:40","2019-08-03 11:09:40","","48","http://islamic.demo-qaleb.ir/?p=233","31","nav_menu_item","","0"),
("234","1","2018-04-04 15:28:14","2018-04-04 10:58:14"," ","","","publish","closed","closed","","234","","","2019-08-03 15:39:40","2019-08-03 11:09:40","","45","http://islamic.demo-qaleb.ir/?p=234","27","nav_menu_item","","0"),
("235","1","2018-04-04 15:28:14","2018-04-04 10:58:14"," ","","","publish","closed","closed","","235","","","2019-08-03 15:39:40","2019-08-03 11:09:40","","45","http://islamic.demo-qaleb.ir/?p=235","28","nav_menu_item","","0"),
("262","2","2018-08-31 17:28:47","2018-08-31 12:58:47","","wwww.wp-qaleb.ir (2)","","inherit","open","closed","","wwww-wp-qaleb-ir-2","","","2018-08-31 17:28:47","2018-08-31 12:58:47","","260","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/wwww.wp-qaleb.ir-2.jpg","0","attachment","image/jpeg","0"),
("325","2","2018-11-27 07:48:29","2018-11-27 04:18:29","این یک برگه‌ی نمونه است که با یک نوشته در وبلاگ تفاوت دارد زیرا برگه‌ها در یک مکان ثابت می‌مانند و معمولاً در فهرست پیوندهای درونی سایت شما نمایش داده می‌شوند (در بیشتر پوسته‌ها). بیشتر افراد کار کردن با برگه‌ها را از یک برگه‌ی «درباره من» که آن‌ها را به خوانندگان سایت معرفی می‌کند، شروع می‌کنند. برای مثال این‌چنین می‌گویند:\r\n<blockquote>سلام دوستان، من روزها یک کارمند اداری هستم و شب‌ها یک راننده تاکسی، این وبلاگ من است. من در اهواز زندگی می‌کنم که شهری در جنوب غربی ایران است.</blockquote>\r\nیا چیزی شبیه این:\r\n<blockquote>شرکت XYZ در سال ۱۳۶۵ تاسیس شد و ارائه‌دهنده محصولات صنعتی است. این شرکت ۲۰۰۰ کارگر و کارمند دارد. امیدواریم از محصولات ما راضی باشید.</blockquote>\r\nبه‌عنوان یک کاربر تازه‌ی وردپرس فارسی شما برای پاک کردن این برگه و ساختن برگه‌های تازه می‌توانید به پیشخوان خود مراجعه کنید. موفق باشید!","تماس با ما","","inherit","closed","closed","","2-revision-v1","","","2018-11-27 07:48:29","2018-11-27 04:18:29","","2","http://islamic.demo-qaleb.ir/2-revision-v1/","0","revision","","0"),
("356","2","2019-08-03 15:33:07","2019-08-03 11:03:07","","1","","inherit","open","closed","","1","","","2019-08-03 15:33:07","2019-08-03 11:03:07","","0","http://islamic.demo-qaleb.ir/wp-content/uploads/2019/08/1.png","0","attachment","image/png","0"),
("315","2","2018-09-11 12:14:24","2018-09-11 07:44:24","<strong>زائران و مجاوران حریم رضوی مطابق معمول سال‌های گذشته</strong> استقبالی بی نظیر و باشکوه از این سخنرانی نوروزی داشته‌اند و می‌توان گفت مشهدمقدس از حدود ۱۰ روز قبل در تدارک این سخنرانی باشکوه است و دستگاه‌ها و نهادهای مختلف و همچنین گروه‌های مختلف مردمی به انحای مختلف خود را مهیای حضور و استماع سخنانی می‌کنند که نقشه راه یکساله آنها را تعیین می‌کند.\r\n\r\nامروز نیز از ساعت ۱۵ مقام معظم رهبری در حرم منور رضوی در جمع پرشور مردم سخنرانی خواهد کرد و در حال حاضر تمامی صحن و سراهای حرم منور رضوی مملو از حضور زائران است.\r\n\r\nمردم برای دیدار یار و سخنرانی نوروزی مقام معظم رهبری در سالی که به نام سال حمایت از کالای ایرانی نامگذاری شده است لحظه شماری می‌کنند.\r\n\r\nانتهای پیام/ش","زائران و مجاوران آماده استماع سخنرانی نوروزی مقام معظم رهبری","","inherit","closed","closed","","48-revision-v1","","","2018-09-11 12:14:24","2018-09-11 07:44:24","","48","http://islamic.demo-qaleb.ir/48-revision-v1/","0","revision","","0"),
("308","2","2018-09-02 18:30:49","2018-09-02 14:00:49","متن پیام به این شرح است:\r\n\r\nباسمه تعالی\r\n\r\nمدال‌آوران عزیز کاروان ورزشی:\r\n\r\nبه همه شما تبریک <span style=\"color: #ff0000;\">می‌گویم</span> و از همه شما تشکر می‌کنم.\r\nملت ایران را شاد کردید و پرچم سرافراز ما را عزت بخشیدید.\r\n\r\nسید علی خامنه‌ای\r\n11 شهریور 1397\r\n\r\nانتهای پیام/*","پیام امام خامنه‌ای به مدال‌آوران آسیایی؛ ملت ایران را شاد کردید","","publish","open","open","","%d9%be%db%8c%d8%a7%d9%85-%d8%a7%d9%85%d8%a7%d9%85-%d8%ae%d8%a7%d9%85%d9%86%d9%87%e2%80%8c%d8%a7%db%8c-%d8%a8%d9%87-%d9%85%d8%af%d8%a7%d9%84%e2%80%8c%d8%a2%d9%88%d8%b1%d8%a7%d9%86-%d8%a8%d8%a7%d8%b2","","","2018-12-10 13:59:47","2018-12-10 10:29:47","","0","http://islamic.demo-qaleb.ir/?p=308","0","post","","0"),
("312","2","2018-09-06 14:18:34","2018-09-06 09:48:34","","1396021812323520710768794","","inherit","open","closed","","1396021812323520710768794","","","2018-09-06 14:18:34","2018-09-06 09:48:34","","112","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/1396021812323520710768794.jpg","0","attachment","image/jpeg","0"),
("258","2","2018-08-31 14:48:38","2018-08-31 10:18:38","","footer-logo","","inherit","open","closed","","footer-logo","","","2018-08-31 14:48:38","2018-08-31 10:18:38","","0","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/footer-logo.png","0","attachment","image/png","0"),
("287","2","2018-09-02 10:23:02","2018-09-02 05:53:02","","1693305_800","","inherit","open","closed","","1693305_800-2","","","2018-09-02 10:23:02","2018-09-02 05:53:02","","153","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/1693305_800.jpg","0","attachment","image/jpeg","0"),
("352","2","2019-08-03 15:27:00","0000-00-00 00:00:00","","صفحه نخست 1","","draft","closed","closed","","","","","2019-08-03 15:27:00","0000-00-00 00:00:00","","0","http://islamic.demo-qaleb.ir/?p=352","1","nav_menu_item","","0"),
("263","2","2018-08-31 17:28:48","2018-08-31 12:58:48","","wwww.wp-qaleb.ir (3)","","inherit","open","closed","","wwww-wp-qaleb-ir-3","","","2018-08-31 17:28:48","2018-08-31 12:58:48","","260","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/wwww.wp-qaleb.ir-3.jpg","0","attachment","image/jpeg","0"),
("264","2","2018-08-31 17:28:49","2018-08-31 12:58:49","","wwww.wp-qaleb.ir (4)","","inherit","open","closed","","wwww-wp-qaleb-ir-4","","","2018-08-31 17:28:49","2018-08-31 12:58:49","","260","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/wwww.wp-qaleb.ir-4.jpg","0","attachment","image/jpeg","0"),
("265","2","2018-08-31 17:28:50","2018-08-31 12:58:50","","wwww.wp-qaleb.ir (5)","","inherit","open","closed","","wwww-wp-qaleb-ir-5","","","2018-08-31 17:28:50","2018-08-31 12:58:50","","260","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/wwww.wp-qaleb.ir-5.jpg","0","attachment","image/jpeg","0"),
("266","2","2018-08-31 17:28:51","2018-08-31 12:58:51","","wwww.wp-qaleb.ir (6)","","inherit","open","closed","","wwww-wp-qaleb-ir-6","","","2018-08-31 17:28:51","2018-08-31 12:58:51","","260","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/wwww.wp-qaleb.ir-6.jpg","0","attachment","image/jpeg","0"),
("267","2","2018-08-31 17:29:27","2018-08-31 12:59:27","[gallery size=\"medium\" ids=\"261,262,263,264,265,266\"]","عناوین روزنامه های امروز ۹7/3/۱۱","","inherit","closed","closed","","260-revision-v1","","","2018-08-31 17:29:27","2018-08-31 12:59:27","","260","http://islamic.demo-qaleb.ir/260-revision-v1/","0","revision","","0"),
("268","2","2018-08-31 17:33:19","2018-08-31 13:03:19","[gallery size=\"medium\" ids=\"261,262,263,264,265,266\"]","عناوین روزنامه های امروز ۹۷/۳/۱2","","publish","open","closed","","%d8%b9%d9%86%d8%a7%d9%88%db%8c%d9%86-%d8%b1%d9%88%d8%b2%d9%86%d8%a7%d9%85%d9%87-%d9%87%d8%a7%db%8c-%d8%a7%d9%85%d8%b1%d9%88%d8%b2-%db%b9%db%b7-%db%b3-%db%b12","","","2018-08-31 17:34:19","2018-08-31 13:04:19","","0","http://islamic.demo-qaleb.ir/?post_type=newspaper&#038;p=268","0","newspaper","","0"),
("269","2","2018-08-31 17:33:19","2018-08-31 13:03:19","[gallery size=\"medium\" ids=\"261,262,263,264,265,266\"]","عناوین روزنامه های امروز ۹۷/۳/۱2","","inherit","closed","closed","","268-revision-v1","","","2018-08-31 17:33:19","2018-08-31 13:03:19","","268","http://islamic.demo-qaleb.ir/268-revision-v1/","0","revision","","0"),
("270","2","2018-08-31 17:34:55","2018-08-31 13:04:55","[gallery size=\"medium\" ids=\"261,262,263,264,265,266\"]","عناوین روزنامه های امروز ۹۷/۳/۱3","","publish","open","closed","","%d8%b9%d9%86%d8%a7%d9%88%db%8c%d9%86-%d8%b1%d9%88%d8%b2%d9%86%d8%a7%d9%85%d9%87-%d9%87%d8%a7%db%8c-%d8%a7%d9%85%d8%b1%d9%88%d8%b2-%db%b9%db%b7-%db%b3-%db%b13","","","2018-08-31 17:34:55","2018-08-31 13:04:55","","0","http://islamic.demo-qaleb.ir/?post_type=newspaper&#038;p=270","0","newspaper","","0"),
("271","2","2018-08-31 17:34:27","2018-08-31 13:04:27","[gallery size=\"medium\" ids=\"261,262,263,264,265,266\"]","عناوین روزنامه های امروز ۹۷/۳/۱6","","publish","open","closed","","%d8%b9%d9%86%d8%a7%d9%88%db%8c%d9%86-%d8%b1%d9%88%d8%b2%d9%86%d8%a7%d9%85%d9%87-%d9%87%d8%a7%db%8c-%d8%a7%d9%85%d8%b1%d9%88%d8%b2-%db%b9%db%b7-%db%b3-%db%b16","","","2018-08-31 17:34:27","2018-08-31 13:04:27","","0","http://islamic.demo-qaleb.ir/?post_type=newspaper&#038;p=271","0","newspaper","","0"),
("272","2","2018-08-31 17:34:36","2018-08-31 13:04:36","[gallery size=\"medium\" ids=\"261,262,263,264,265,266\"]","عناوین روزنامه های امروز ۹۷/۳/۱5","","publish","open","closed","","%d8%b9%d9%86%d8%a7%d9%88%db%8c%d9%86-%d8%b1%d9%88%d8%b2%d9%86%d8%a7%d9%85%d9%87-%d9%87%d8%a7%db%8c-%d8%a7%d9%85%d8%b1%d9%88%d8%b2-%db%b9%db%b7-%db%b3-%db%b15","","","2018-08-31 17:34:36","2018-08-31 13:04:36","","0","http://islamic.demo-qaleb.ir/?post_type=newspaper&#038;p=272","0","newspaper","","0"),
("273","2","2018-08-31 17:34:46","2018-08-31 13:04:46","[gallery size=\"medium\" ids=\"261,262,263,264,265,266\"]","عناوین روزنامه های امروز ۹۷/۳/۱4","","publish","open","closed","","%d8%b9%d9%86%d8%a7%d9%88%db%8c%d9%86-%d8%b1%d9%88%d8%b2%d9%86%d8%a7%d9%85%d9%87-%d9%87%d8%a7%db%8c-%d8%a7%d9%85%d8%b1%d9%88%d8%b2-%db%b9%db%b7-%db%b3-%db%b14","","","2018-08-31 17:34:46","2018-08-31 13:04:46","","0","http://islamic.demo-qaleb.ir/?post_type=newspaper&#038;p=273","0","newspaper","","0"),
("274","2","2018-08-31 17:34:27","2018-08-31 13:04:27","[gallery size=\"medium\" ids=\"261,262,263,264,265,266\"]","عناوین روزنامه های امروز ۹۷/۳/۱6","","inherit","closed","closed","","271-revision-v1","","","2018-08-31 17:34:27","2018-08-31 13:04:27","","271","http://islamic.demo-qaleb.ir/271-revision-v1/","0","revision","","0"),
("275","2","2018-08-31 17:34:36","2018-08-31 13:04:36","[gallery size=\"medium\" ids=\"261,262,263,264,265,266\"]","عناوین روزنامه های امروز ۹۷/۳/۱5","","inherit","closed","closed","","272-revision-v1","","","2018-08-31 17:34:36","2018-08-31 13:04:36","","272","http://islamic.demo-qaleb.ir/272-revision-v1/","0","revision","","0"),
("276","2","2018-08-31 17:34:46","2018-08-31 13:04:46","[gallery size=\"medium\" ids=\"261,262,263,264,265,266\"]","عناوین روزنامه های امروز ۹۷/۳/۱4","","inherit","closed","closed","","273-revision-v1","","","2018-08-31 17:34:46","2018-08-31 13:04:46","","273","http://islamic.demo-qaleb.ir/273-revision-v1/","0","revision","","0"),
("277","2","2018-08-31 17:34:55","2018-08-31 13:04:55","[gallery size=\"medium\" ids=\"261,262,263,264,265,266\"]","عناوین روزنامه های امروز ۹۷/۳/۱3","","inherit","closed","closed","","270-revision-v1","","","2018-08-31 17:34:55","2018-08-31 13:04:55","","270","http://islamic.demo-qaleb.ir/270-revision-v1/","0","revision","","0"),
("278","2","2018-08-31 17:38:05","2018-08-31 13:08:05","وی به هفته دولت و سالروز شهادت شهیدان رجایی و باهنر اشاره کرد و اظهارداشت: این شهیدان، دولتمردانی مخلص، مردمی، ولایتی و ولایتمدار بودند، شهید رجایی هویت خویش را در مجلس با این جمله که \"من مقلد امام هستم\"، نشان داد.\r\n\r\nخطیب نماز جمعه این هفته تهران با اشاره به دیدار اخیر اعضای هیئت دولت با مقام معظم رهبری، افزود: سیره امام(ره) و مقام معظّم رهبری این بوده و هست که از دولت‌های پس پیروزی انقلاب حمایت کرد‌ه‌اند، این حمایت، پشتوانه منطقی و برهانی دارد؛  دولت، منتخب مردم است و حمایت از آنها احترام به مردم است.\r\n\r\nآیت‌الله خاتمی وجه دیگر حمایت رهبر انقلاب از دولت‌های پس از انقلاب را در این دانست که اداره کشور 80 میلیونی کار آسانی نیست و همه باید کمک کنند تا دولتمردان که در وسط میدان هستند، گره کار مردم را باز کنند.\r\n<blockquote><strong>بیشتر بخوانید:</strong>\r\n\r\n<strong>سؤال از رئیس‌جمهور| فرهنگی: تورم کنونی بی‌سابقه است</strong></blockquote>\r\nوی با بیان اینکه یکی از راه‌های حمایت از دولت را حمایت ناصحانه است، گفت: دیدن خوبی‌ها و تکریم و تشویق آنها از یک طرف و اینکه اگر نارسایی و نقاط ضعف دیده شد، نقد منصفانه داشته باشیم و اگر طرحی برای حل مشکلات وجود دارد نیز عرضه کنیم و از طرفی دیگر این راهکارها به‌کار گرفته شود، شامل حمایت ناصحانه است.\r\n\r\nخطیب نماز جمعه این هفته تهران اضافه کرد: دولتمردان بایستی در تراز انقلاب اسلامی عمل کنند. یکی از ویژگی‌های دولتمردان تراز انقلاب اسلامی این است که  مسئولیت را امانت و نه لقمه چرب می‌دانند؛ چنین کسی، اختلاس و حقوق نجومی و پارتی‌بازی در کارش نیست، اگر آنها خوب و یا بد عمل کنند، پای سبد نظام ریخته می‌شود.\r\n\r\n<strong>آیت‌الله خاتمی</strong> یکی دیگر از ویژگی‌های دولتمردان تراز انقلاب اسلامی در این دانست که خود را خادم و مردم را مخدوم می‌دانند و اظهار داشت: دولتمرد اسلامی، دغدغه گسترش دین دارد و اصلاً مأموریت حکومت دینی، صاف کردن جاده دین و ارزش‌های دینی است.\r\n\r\nوی با بیان اینکه دولتمرد تراز انقلاب اسلامی، دغدغه تحقق عدالت اجتماعی را دارد، گفت: دولتمرد نظام اسلامی، قانونمدارانه عمل می‌کند و خودش در خط مقدم عمل به قانون است؛ چنین فردی، شایسته‌سالار و نه قبیله‌سالار، فرزندسالار، حزب‌سالار و باندسالار است، در نزد او هر کسی که شایسته است، جایگاه دارد.\r\n\r\nخطیب نماز جمعه این هفته تهران یکی دیگر از ویژگی‌های دولتمرد تراز انقلاب اسلامی در این عنوان کرد که زندگی‌اش همسان محرومین است.\r\n\r\nبه گزارش تسنیم، آیت‌اللعه خاتمی با اشاره به جلسه مجلس برای طرح سؤال از رئیس‌جمهور که سه‌شنبه گذشته برگزار شد، اظهار داشت: این جلسه، نمایش زیبای مردمسالاری بود، آنچه در مجلس رخ داد، جدی و نه نمایشی بود، نمایندگان واقعا سؤال کردند و رئیس جمهور هم جدی وارد صحنه شد و پاسخ داد و متانت در گفتار و رفتار نمایندگان و رئیس‌جمهور بود.\r\n\r\nوی با بیان اینکه جلسه مجلس برای سؤال از رئیس‌جمهور نشان داد که مشکل واقعی مردم، مشکل معیشتی است، تصریح کرد: این مسئله، اصلی است، نباید حاشیه‌سازی‌ها، این مسئله اصلی را تحت‌الشعاع قرار دهد.\r\n\r\nخطیب نماز جمعه این هفته تهران ادامه داد: دشمن به دنبال دعوا در نشست سؤال از رئیس‌‌جمهور در مجلس بود و می‌خواست روز سه‌شنبه، دعوای نمایندگان را ببیند، اما رفتار متین نمایندگان و رئیس‌جمهور آنها را ناکام گذاشت.\r\n\r\nآیت‌الله خاتمی با اشاره به قانع نشدن نمایندگان از 4 سؤال از میان 5 سؤال از رئیس‌جمهور، گفت: از این جهت معلوم می‌شود که بین انتظارات نمایندگان و واقعیت‌های موجود، خلاء وجود دارد و دولت باید با تلاش شبانه‌روزی این خلاء را پُر کند.\r\n\r\nوی در بخش دیگری از سخنانش با اشاره به تأکیدات مکرر رهبر معظم انقلاب مبنی بر اینکه در هیچ سطحی با آمریکا مذاکر نخواهیم کرد، گفت: دولت آمریکا، عهدشکن است و ارزش‌های اخلاقی برای او معنایی ندارد.\r\n\r\nخطیب نماز جمعه این هفته تهران تصریح کرد: آمریکا و اتحادیه اروپا و همه دنیا بداند، نظام اسلامی از خطوط قرمزش که از جمله اقتدار موشکی است، سر سوزنی عقب‌نشینی نخواهد کرد.\r\n\r\nآیت‌الله خاتمی با اشاره به بخشی از سخنان رهبر انقلاب در دیدار اعضای هیئت دولت مبنی بر بلامانع بودن مذاکره با اروپا، گفت: اقتصاد و مسائل سیاسی خود را به آنها گره نمی‌زنیم، بلکه اعتماد ما، به خدا و ظرفیت‌های فراوان این مردم است.\r\n\r\nوی همچنین به تأکیدات مقام معظم رهبری مبنی بر مبارزه با فساد اشاره و تصریح کرد: قوه‌قضائیه که به این خوبی وارد میدان شده، با قاطعیت و عدالت تا آخر خط در صحنه باشد، راه‌حل برون‌رفت از این مشکلات، اقتصاد مقاومتی است.\r\n\r\nخطیب نماز جمعه این هفته تهران تأکید کرد: سیاست ما این است که با همسایگان، برادرانه رفتار کنیم، اما «چه خوش بی که محبت هر دو سر بی»؛ اگر آنها برادرانه رفتار کنند، مطمئن باشند که بهترین رفتار برادرانه را خواهند دید.\r\n\r\nآیت‌‌الله خاتمی در پایان خطاب به نمازگزاران، خاطرنشان کرد: ولایت فقیه ما، قطره‌ای از دریای ناپیداکرانه غدیر است که بحمدلله پشیبان آن بودید، هستید و خواهید بود و به بیان امام(ره) کشورتان آسیبی نخواهد دید.","جلسه سؤال از رئیس‌جمهور نشان داد که مشکل واقعی مردم معیشت است","","publish","open","open","","%d8%ac%d9%84%d8%b3%d9%87-%d8%b3%d8%a4%d8%a7%d9%84-%d8%a7%d8%b2-%d8%b1%d8%a6%db%8c%d8%b3%e2%80%8c%d8%ac%d9%85%d9%87%d9%88%d8%b1-%d9%86%d8%b4%d8%a7%d9%86-%d8%af%d8%a7%d8%af-%da%a9%d9%87-%d9%85%d8%b4","","","2018-09-16 15:04:40","2018-09-16 10:34:40","","0","http://islamic.demo-qaleb.ir/?p=278","0","post","","0"),
("284","2","2018-09-02 10:16:15","2018-09-02 05:46:15","وی به هفته دولت و سالروز شهادت شهیدان رجایی و باهنر اشاره کرد و اظهارداشت: این شهیدان، دولتمردانی مخلص، مردمی، ولایتی و ولایتمدار بودند، شهید رجایی هویت خویش را در مجلس با این جمله که \"من مقلد امام هستم\"، نشان داد.\r\n\r\nخطیب نماز جمعه این هفته تهران با اشاره به دیدار اخیر اعضای هیئت دولت با مقام معظم رهبری، افزود: سیره امام(ره) و مقام معظّم رهبری این بوده و هست که از دولت‌های پس پیروزی انقلاب حمایت کرد‌ه‌اند، این حمایت، پشتوانه منطقی و برهانی دارد؛  دولت، منتخب مردم است و حمایت از آنها احترام به مردم است.\r\n\r\nآیت‌الله خاتمی وجه دیگر حمایت رهبر انقلاب از دولت‌های پس از انقلاب را در این دانست که اداره کشور 80 میلیونی کار آسانی نیست و همه باید کمک کنند تا دولتمردان که در وسط میدان هستند، گره کار مردم را باز کنند.\r\n<blockquote><strong>بیشتر بخوانید:</strong>\r\n\r\n<strong>سؤال از رئیس‌جمهور| فرهنگی: تورم کنونی بی‌سابقه است</strong></blockquote>\r\nوی با بیان اینکه یکی از راه‌های حمایت از دولت را حمایت ناصحانه است، گفت: دیدن خوبی‌ها و تکریم و تشویق آنها از یک طرف و اینکه اگر نارسایی و نقاط ضعف دیده شد، نقد منصفانه داشته باشیم و اگر طرحی برای حل مشکلات وجود دارد نیز عرضه کنیم و از طرفی دیگر این راهکارها به‌کار گرفته شود، شامل حمایت ناصحانه است.\r\n\r\nخطیب نماز جمعه این هفته تهران اضافه کرد: دولتمردان بایستی در تراز انقلاب اسلامی عمل کنند. یکی از ویژگی‌های دولتمردان تراز انقلاب اسلامی این است که  مسئولیت را امانت و نه لقمه چرب می‌دانند؛ چنین کسی، اختلاس و حقوق نجومی و پارتی‌بازی در کارش نیست، اگر آنها خوب و یا بد عمل کنند، پای سبد نظام ریخته می‌شود.\r\n\r\nآیت‌الله خاتمی یکی دیگر از ویژگی‌های دولتمردان تراز انقلاب اسلامی در این دانست که خود را خادم و مردم را مخدوم می‌دانند و اظهار داشت: دولتمرد اسلامی، دغدغه گسترش دین دارد و اصلاً مأموریت حکومت دینی، صاف کردن جاده دین و ارزش‌های دینی است.\r\n\r\nوی با بیان اینکه دولتمرد تراز انقلاب اسلامی، دغدغه تحقق عدالت اجتماعی را دارد، گفت: دولتمرد نظام اسلامی، قانونمدارانه عمل می‌کند و خودش در خط مقدم عمل به قانون است؛ چنین فردی، شایسته‌سالار و نه قبیله‌سالار، فرزندسالار، حزب‌سالار و باندسالار است، در نزد او هر کسی که شایسته است، جایگاه دارد.\r\n\r\nخطیب نماز جمعه این هفته تهران یکی دیگر از ویژگی‌های دولتمرد تراز انقلاب اسلامی در این عنوان کرد که زندگی‌اش همسان محرومین است.\r\n\r\nبه گزارش تسنیم، آیت‌اللعه خاتمی با اشاره به جلسه مجلس برای طرح سؤال از رئیس‌جمهور که سه‌شنبه گذشته برگزار شد، اظهار داشت: این جلسه، نمایش زیبای مردمسالاری بود، آنچه در مجلس رخ داد، جدی و نه نمایشی بود، نمایندگان واقعا سؤال کردند و رئیس جمهور هم جدی وارد صحنه شد و پاسخ داد و متانت در گفتار و رفتار نمایندگان و رئیس‌جمهور بود.\r\n\r\nوی با بیان اینکه جلسه مجلس برای سؤال از رئیس‌جمهور نشان داد که مشکل واقعی مردم، مشکل معیشتی است، تصریح کرد: این مسئله، اصلی است، نباید حاشیه‌سازی‌ها، این مسئله اصلی را تحت‌الشعاع قرار دهد.\r\n\r\nخطیب نماز جمعه این هفته تهران ادامه داد: دشمن به دنبال دعوا در نشست سؤال از رئیس‌‌جمهور در مجلس بود و می‌خواست روز سه‌شنبه، دعوای نمایندگان را ببیند، اما رفتار متین نمایندگان و رئیس‌جمهور آنها را ناکام گذاشت.\r\n\r\nآیت‌الله خاتمی با اشاره به قانع نشدن نمایندگان از 4 سؤال از میان 5 سؤال از رئیس‌جمهور، گفت: از این جهت معلوم می‌شود که بین انتظارات نمایندگان و واقعیت‌های موجود، خلاء وجود دارد و دولت باید با تلاش شبانه‌روزی این خلاء را پُر کند.\r\n\r\nوی در بخش دیگری از سخنانش با اشاره به تأکیدات مکرر رهبر معظم انقلاب مبنی بر اینکه در هیچ سطحی با آمریکا مذاکر نخواهیم کرد، گفت: دولت آمریکا، عهدشکن است و ارزش‌های اخلاقی برای او معنایی ندارد.\r\n\r\nخطیب نماز جمعه این هفته تهران تصریح کرد: آمریکا و اتحادیه اروپا و همه دنیا بداند، نظام اسلامی از خطوط قرمزش که از جمله اقتدار موشکی است، سر سوزنی عقب‌نشینی نخواهد کرد.\r\n\r\nآیت‌الله خاتمی با اشاره به بخشی از سخنان رهبر انقلاب در دیدار اعضای هیئت دولت مبنی بر بلامانع بودن مذاکره با اروپا، گفت: اقتصاد و مسائل سیاسی خود را به آنها گره نمی‌زنیم، بلکه اعتماد ما، به خدا و ظرفیت‌های فراوان این مردم است.\r\n\r\nوی همچنین به تأکیدات مقام معظم رهبری مبنی بر مبارزه با فساد اشاره و تصریح کرد: قوه‌قضائیه که به این خوبی وارد میدان شده، با قاطعیت و عدالت تا آخر خط در صحنه باشد، راه‌حل برون‌رفت از این مشکلات، اقتصاد مقاومتی است.\r\n\r\nخطیب نماز جمعه این هفته تهران تأکید کرد: سیاست ما این است که با همسایگان، برادرانه رفتار کنیم، اما «چه خوش بی که محبت هر دو سر بی»؛ اگر آنها برادرانه رفتار کنند، مطمئن باشند که بهترین رفتار برادرانه را خواهند دید.\r\n\r\nآیت‌‌الله خاتمی در پایان خطاب به نمازگزاران، خاطرنشان کرد: ولایت فقیه ما، قطره‌ای از دریای ناپیداکرانه غدیر است که بحمدلله پشیبان آن بودید، هستید و خواهید بود و به بیان امام(ره) کشورتان آسیبی نخواهد دید.","جلسه سؤال از رئیس‌جمهور نشان داد که مشکل واقعی مردم معیشت است","","inherit","closed","closed","","278-revision-v1","","","2018-09-02 10:16:15","2018-09-02 05:46:15","","278","http://islamic.demo-qaleb.ir/278-revision-v1/","0","revision","","0"),
("280","2","2018-08-31 17:38:05","2018-08-31 13:08:05","وی به هفته دولت و سالروز شهادت شهیدان رجایی و باهنر اشاره کرد و اظهارداشت: این شهیدان، دولتمردانی مخلص، مردمی، ولایتی و ولایتمدار بودند، شهید رجایی هویت خویش را در مجلس با این جمله که \"من مقلد امام هستم\"، نشان داد.\r\n\r\nخطیب نماز جمعه این هفته تهران با اشاره به دیدار اخیر اعضای هیئت دولت با مقام معظم رهبری، افزود: سیره امام(ره) و مقام معظّم رهبری این بوده و هست که از دولت‌های پس پیروزی انقلاب حمایت کرد‌ه‌اند، این حمایت، پشتوانه منطقی و برهانی دارد؛  دولت، منتخب مردم است و حمایت از آنها احترام به مردم است.\r\n\r\nآیت‌الله خاتمی وجه دیگر حمایت رهبر انقلاب از دولت‌های پس از انقلاب را در این دانست که اداره کشور 80 میلیونی کار آسانی نیست و همه باید کمک کنند تا دولتمردان که در وسط میدان هستند، گره کار مردم را باز کنند.\r\n<blockquote><strong>بیشتر بخوانید:</strong>\r\n\r\n<strong>سؤال از رئیس‌جمهور| فرهنگی: تورم کنونی بی‌سابقه است</strong></blockquote>\r\nوی با بیان اینکه یکی از راه‌های حمایت از دولت را حمایت ناصحانه است، گفت: دیدن خوبی‌ها و تکریم و تشویق آنها از یک طرف و اینکه اگر نارسایی و نقاط ضعف دیده شد، نقد منصفانه داشته باشیم و اگر طرحی برای حل مشکلات وجود دارد نیز عرضه کنیم و از طرفی دیگر این راهکارها به‌کار گرفته شود، شامل حمایت ناصحانه است.\r\n\r\nخطیب نماز جمعه این هفته تهران اضافه کرد: دولتمردان بایستی در تراز انقلاب اسلامی عمل کنند. یکی از ویژگی‌های دولتمردان تراز انقلاب اسلامی این است که  مسئولیت را امانت و نه لقمه چرب می‌دانند؛ چنین کسی، اختلاس و حقوق نجومی و پارتی‌بازی در کارش نیست، اگر آنها خوب و یا بد عمل کنند، پای سبد نظام ریخته می‌شود.\r\n\r\nآیت‌الله خاتمی یکی دیگر از ویژگی‌های دولتمردان تراز انقلاب اسلامی در این دانست که خود را خادم و مردم را مخدوم می‌دانند و اظهار داشت: دولتمرد اسلامی، دغدغه گسترش دین دارد و اصلاً مأموریت حکومت دینی، صاف کردن جاده دین و ارزش‌های دینی است.\r\n\r\nوی با بیان اینکه دولتمرد تراز انقلاب اسلامی، دغدغه تحقق عدالت اجتماعی را دارد، گفت: دولتمرد نظام اسلامی، قانونمدارانه عمل می‌کند و خودش در خط مقدم عمل به قانون است؛ چنین فردی، شایسته‌سالار و نه قبیله‌سالار، فرزندسالار، حزب‌سالار و باندسالار است، در نزد او هر کسی که شایسته است، جایگاه دارد.\r\n\r\nخطیب نماز جمعه این هفته تهران یکی دیگر از ویژگی‌های دولتمرد تراز انقلاب اسلامی در این عنوان کرد که زندگی‌اش همسان محرومین است.\r\n\r\nبه گزارش تسنیم، آیت‌اللعه خاتمی با اشاره به جلسه مجلس برای طرح سؤال از رئیس‌جمهور که سه‌شنبه گذشته برگزار شد، اظهار داشت: این جلسه، نمایش زیبای مردمسالاری بود، آنچه در مجلس رخ داد، جدی و نه نمایشی بود، نمایندگان واقعا سؤال کردند و رئیس جمهور هم جدی وارد صحنه شد و پاسخ داد و متانت در گفتار و رفتار نمایندگان و رئیس‌جمهور بود.\r\n\r\nوی با بیان اینکه جلسه مجلس برای سؤال از رئیس‌جمهور نشان داد که مشکل واقعی مردم، مشکل معیشتی است، تصریح کرد: این مسئله، اصلی است، نباید حاشیه‌سازی‌ها، این مسئله اصلی را تحت‌الشعاع قرار دهد.\r\n\r\nخطیب نماز جمعه این هفته تهران ادامه داد: دشمن به دنبال دعوا در نشست سؤال از رئیس‌‌جمهور در مجلس بود و می‌خواست روز سه‌شنبه، دعوای نمایندگان را ببیند، اما رفتار متین نمایندگان و رئیس‌جمهور آنها را ناکام گذاشت.\r\n\r\nآیت‌الله خاتمی با اشاره به قانع نشدن نمایندگان از 4 سؤال از میان 5 سؤال از رئیس‌جمهور، گفت: از این جهت معلوم می‌شود که بین انتظارات نمایندگان و واقعیت‌های موجود، خلاء وجود دارد و دولت باید با تلاش شبانه‌روزی این خلاء را پُر کند.\r\n\r\nوی در بخش دیگری از سخنانش با اشاره به تأکیدات مکرر رهبر معظم انقلاب مبنی بر اینکه در هیچ سطحی با آمریکا مذاکر نخواهیم کرد، گفت: دولت آمریکا، عهدشکن است و ارزش‌های اخلاقی برای او معنایی ندارد.\r\n\r\nخطیب نماز جمعه این هفته تهران تصریح کرد: آمریکا و اتحادیه اروپا و همه دنیا بداند، نظام اسلامی از خطوط قرمزش که از جمله اقتدار موشکی است، سر سوزنی عقب‌نشینی نخواهد کرد.\r\n\r\nآیت‌الله خاتمی با اشاره به بخشی از سخنان رهبر انقلاب در دیدار اعضای هیئت دولت مبنی بر بلامانع بودن مذاکره با اروپا، گفت: اقتصاد و مسائل سیاسی خود را به آنها گره نمی‌زنیم، بلکه اعتماد ما، به خدا و ظرفیت‌های فراوان این مردم است.\r\n\r\nوی همچنین به تأکیدات مقام معظم رهبری مبنی بر مبارزه با فساد اشاره و تصریح کرد: قوه‌قضائیه که به این خوبی وارد میدان شده، با قاطعیت و عدالت تا آخر خط در صحنه باشد، راه‌حل برون‌رفت از این مشکلات، اقتصاد مقاومتی است.\r\n\r\nخطیب نماز جمعه این هفته تهران تأکید کرد: سیاست ما این است که با همسایگان، برادرانه رفتار کنیم، اما «چه خوش بی که محبت هر دو سر بی»؛ اگر آنها برادرانه رفتار کنند، مطمئن باشند که بهترین رفتار برادرانه را خواهند دید.\r\n\r\nآیت‌‌الله خاتمی در پایان خطاب به نمازگزاران، خاطرنشان کرد: ولایت فقیه ما، قطره‌ای از دریای ناپیداکرانه غدیر است که بحمدلله پشیبان آن بودید، هستید و خواهید بود و به بیان امام(ره) کشورتان آسیبی نخواهد دید.","\"جلسه سؤال از رئیس‌جمهور نشان داد که مشکل واقعی مردم معیشت است\"","","inherit","closed","closed","","278-revision-v1","","","2018-08-31 17:38:05","2018-08-31 13:08:05","","278","http://islamic.demo-qaleb.ir/278-revision-v1/","0","revision","","0"),
("374","2","2021-08-10 10:07:31","0000-00-00 00:00:00","","پیش‌نویس خودکار","","auto-draft","open","open","","","","","2021-08-10 10:07:31","0000-00-00 00:00:00","","0","http://islamic.demo-qaleb.ir/?p=374","0","post","","0"),
("288","2","2018-09-02 10:36:45","2018-09-02 06:06:45","","42040435_303","","inherit","open","closed","","42040435_303","","","2018-09-02 10:36:45","2018-09-02 06:06:45","","278","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/08/42040435_303.jpg","0","attachment","image/jpeg","0"),
("286","2","2018-09-02 10:19:24","2018-09-02 05:49:24","","جنوب","","inherit","open","closed","","%d8%ac%d9%86%d9%88%d8%a8","","","2018-09-02 10:19:24","2018-09-02 05:49:24","","159","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/جنوب.jpg","0","attachment","image/jpeg","0"),
("289","2","2018-09-02 18:17:45","2018-09-02 13:47:45","<p dir=\"RTL\">فهرست مشخصات یک گوشی سطح بالای سونی با شناسه <span dir=\"LTR\">H8526</span> توسط یک کاربر در تالار گفتگوی <span dir=\"LTR\">Reddit</span> به اشتراک گذاشته شد. این گوشی مرموز ظاهرا به تازگی توسط ابزار <span dir=\"LTR\">Geekbench</span> بنچمارک شده و برخی مشخصات کلیدی‌اش فاش شده است. نکته جالب توجه در این فهرست پردازنده کوالکام اسنپ‌دراگون 855 است چراکه این پردازنده سطح بالا هنوز رسما توسط سازنده آن کوالکام رونمایی نشده است.</p>\r\n<p dir=\"RTL\">در این فهرست شاهد هستیم که گوشی <span dir=\"LTR\">H8526</span> سونی توانسته است در آزمون‌های تک هسته‌ای و چند هسته‌ای به ترتیب امتیازهای 3033 و 10992 را کسب کند. این گوشی مرموز توانسته است امتیازهای جالب توجه مذکور را به کمک پردازنده کوالکام اسنپ‌دراگون 855 و 8 گیگابایت رم کسب کند. درواقع این گوشی ظاهرا اولین گوشی از برند سونی است که به 8 گیگابایت حافظه رم مجهز می‌شود. این گوشی همچنین به طور پیش فرض از سیستم عامل اندروید 9.0 بهره می‌برد.</p>","گزارشی از گوشی Sony Xperia XZ3","","publish","open","closed","","%da%af%d8%b2%d8%a7%d8%b1%d8%b4%db%8c-%d8%a7%d8%b2-%da%af%d9%88%d8%b4%db%8c-sony-xperia-xz3","","","2018-09-02 18:17:45","2018-09-02 13:47:45","","0","http://islamic.demo-qaleb.ir/?post_type=media&#038;p=289","0","media","","0"),
("290","2","2018-09-02 18:17:41","2018-09-02 13:47:41","","Sony-Xperia-Z3-4","","inherit","open","closed","","sony-xperia-z3-4","","","2018-09-02 18:17:41","2018-09-02 13:47:41","","289","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/Sony-Xperia-Z3-4.jpg","0","attachment","image/jpeg","0"),
("291","2","2018-09-02 18:17:45","2018-09-02 13:47:45","<p dir=\"RTL\">فهرست مشخصات یک گوشی سطح بالای سونی با شناسه <span dir=\"LTR\">H8526</span> توسط یک کاربر در تالار گفتگوی <span dir=\"LTR\">Reddit</span> به اشتراک گذاشته شد. این گوشی مرموز ظاهرا به تازگی توسط ابزار <span dir=\"LTR\">Geekbench</span> بنچمارک شده و برخی مشخصات کلیدی‌اش فاش شده است. نکته جالب توجه در این فهرست پردازنده کوالکام اسنپ‌دراگون 855 است چراکه این پردازنده سطح بالا هنوز رسما توسط سازنده آن کوالکام رونمایی نشده است.</p>\r\n<p dir=\"RTL\">در این فهرست شاهد هستیم که گوشی <span dir=\"LTR\">H8526</span> سونی توانسته است در آزمون‌های تک هسته‌ای و چند هسته‌ای به ترتیب امتیازهای 3033 و 10992 را کسب کند. این گوشی مرموز توانسته است امتیازهای جالب توجه مذکور را به کمک پردازنده کوالکام اسنپ‌دراگون 855 و 8 گیگابایت رم کسب کند. درواقع این گوشی ظاهرا اولین گوشی از برند سونی است که به 8 گیگابایت حافظه رم مجهز می‌شود. این گوشی همچنین به طور پیش فرض از سیستم عامل اندروید 9.0 بهره می‌برد.</p>","گزارشی از گوشی Sony Xperia XZ3","","inherit","closed","closed","","289-revision-v1","","","2018-09-02 18:17:45","2018-09-02 13:47:45","","289","http://islamic.demo-qaleb.ir/289-revision-v1/","0","revision","","0"),
("292","2","2018-09-02 18:22:30","2018-09-02 13:52:30","به گزارش \"ورزش سه\"، امیرقلعه نویی در کنفرانس خبری پیش از دیدار برابر پارس جنوبی جم گفته بود که ترجیح می دهد تساوی 2 بر 2 در بازی ببیند تا بدون گل. در بازی های گذشته نیز نمایش سپاهانی ها علاقمندان به فوتبال را از تماشای یک فوتبال زیبا سیراب کرده بود، اما در مقابل پارس جنوبی جم و شاگردان مهدی تارتار شرایط برای این تیم بسیار سخت تر از دیدارهای گذشته شد\r\n\r\n&nbsp;\r\n\r\n[gallery size=\"medium\" ids=\"294,295,296,297,298,293\"]","دیدار تیم های پارس جنوبی و سپاهان","","publish","open","closed","","%d8%af%db%8c%d8%af%d8%a7%d8%b1-%d8%aa%db%8c%d9%85-%d9%87%d8%a7%db%8c-%d9%be%d8%a7%d8%b1%d8%b3-%d8%ac%d9%86%d9%88%d8%a8%db%8c-%d9%88-%d8%b3%d9%be%d8%a7%d9%87%d8%a7%d9%86","","","2018-09-02 18:22:30","2018-09-02 13:52:30","","0","http://islamic.demo-qaleb.ir/?post_type=gallery&#038;p=292","0","gallery","","0"),
("293","2","2018-09-02 18:21:50","2018-09-02 13:51:50","","1397060911243894815212694","","inherit","open","closed","","1397060911243894815212694","","","2018-09-02 18:21:50","2018-09-02 13:51:50","","292","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/1397060911243894815212694.jpg","0","attachment","image/jpeg","0"),
("294","2","2018-09-02 18:22:04","2018-09-02 13:52:04","","1397060911243880715212694","","inherit","open","closed","","1397060911243880715212694","","","2018-09-02 18:22:04","2018-09-02 13:52:04","","292","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/1397060911243880715212694.jpg","0","attachment","image/jpeg","0"),
("295","2","2018-09-02 18:22:08","2018-09-02 13:52:08","","1397060911243922915212694","","inherit","open","closed","","1397060911243922915212694","","","2018-09-02 18:22:08","2018-09-02 13:52:08","","292","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/1397060911243922915212694.jpg","0","attachment","image/jpeg","0"),
("296","2","2018-09-02 18:22:12","2018-09-02 13:52:12","","1397060911243947915212694","","inherit","open","closed","","1397060911243947915212694","","","2018-09-02 18:22:12","2018-09-02 13:52:12","","292","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/1397060911243947915212694.jpg","0","attachment","image/jpeg","0"),
("297","2","2018-09-02 18:22:15","2018-09-02 13:52:15","","1397060911243960415212694","","inherit","open","closed","","1397060911243960415212694","","","2018-09-02 18:22:15","2018-09-02 13:52:15","","292","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/1397060911243960415212694.jpg","0","attachment","image/jpeg","0"),
("298","2","2018-09-02 18:22:19","2018-09-02 13:52:19","","139706091124398915212694","","inherit","open","closed","","139706091124398915212694","","","2018-09-02 18:22:19","2018-09-02 13:52:19","","292","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/139706091124398915212694.jpg","0","attachment","image/jpeg","0"),
("299","2","2018-09-02 18:22:30","2018-09-02 13:52:30","به گزارش \"ورزش سه\"، امیرقلعه نویی در کنفرانس خبری پیش از دیدار برابر پارس جنوبی جم گفته بود که ترجیح می دهد تساوی 2 بر 2 در بازی ببیند تا بدون گل. در بازی های گذشته نیز نمایش سپاهانی ها علاقمندان به فوتبال را از تماشای یک فوتبال زیبا سیراب کرده بود، اما در مقابل پارس جنوبی جم و شاگردان مهدی تارتار شرایط برای این تیم بسیار سخت تر از دیدارهای گذشته شد\r\n\r\n&nbsp;\r\n\r\n[gallery size=\"medium\" ids=\"294,295,296,297,298,293\"]","دیدار تیم های پارس جنوبی و سپاهان","","inherit","closed","closed","","292-revision-v1","","","2018-09-02 18:22:30","2018-09-02 13:52:30","","292","http://islamic.demo-qaleb.ir/292-revision-v1/","0","revision","","0"),
("300","2","2018-09-02 18:27:16","2018-09-02 13:57:16","مراسم بزرگداشت روز حقوق بشر اسلامی و کرامت انسانی و اعطای چهارمین جایزه حقوق بشر اسلامی امروز ۱۴ مرداد با حضور آیت‌الله آملی لاریجانی رئیس قوه قضاییه و محمد جواد لاریجانی دبیر ستاد حقوق بشر درمجتمع فرهنگی شهید بهشتی برگزار شد.\r\n\r\n[gallery size=\"medium\" ids=\"301,302,303,304,305,306\"]","مراسم بزرگداشت روز حقوق بشر اسلامی و کرامت انسانی","","publish","open","closed","","%d9%85%d8%b1%d8%a7%d8%b3%d9%85-%d8%a8%d8%b2%d8%b1%da%af%d8%af%d8%a7%d8%b4%d8%aa-%d8%b1%d9%88%d8%b2-%d8%ad%d9%82%d9%88%d9%82-%d8%a8%d8%b4%d8%b1-%d8%a7%d8%b3%d9%84%d8%a7%d9%85%db%8c-%d9%88-%da%a9%d8%b1","","","2018-09-02 18:27:16","2018-09-02 13:57:16","","0","http://islamic.demo-qaleb.ir/?post_type=gallery&#038;p=300","0","gallery","","0"),
("301","2","2018-09-02 18:26:46","2018-09-02 13:56:46","","1397051414445958214943494","","inherit","open","closed","","1397051414445958214943494","","","2018-09-02 18:26:46","2018-09-02 13:56:46","","300","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/1397051414445958214943494.jpg","0","attachment","image/jpeg","0"),
("302","2","2018-09-02 18:26:47","2018-09-02 13:56:47","","1397051414445969214943494","","inherit","open","closed","","1397051414445969214943494","","","2018-09-02 18:26:47","2018-09-02 13:56:47","","300","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/1397051414445969214943494.jpg","0","attachment","image/jpeg","0"),
("303","2","2018-09-02 18:26:49","2018-09-02 13:56:49","","1397051414445977014943494","","inherit","open","closed","","1397051414445977014943494","","","2018-09-02 18:26:49","2018-09-02 13:56:49","","300","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/1397051414445977014943494.jpg","0","attachment","image/jpeg","0"),
("304","2","2018-09-02 18:26:50","2018-09-02 13:56:50","","1397051414450039514943494","","inherit","open","closed","","1397051414450039514943494","","","2018-09-02 18:26:50","2018-09-02 13:56:50","","300","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/1397051414450039514943494.jpg","0","attachment","image/jpeg","0"),
("305","2","2018-09-02 18:26:52","2018-09-02 13:56:52","","1397051414450062914943494","","inherit","open","closed","","1397051414450062914943494","","","2018-09-02 18:26:52","2018-09-02 13:56:52","","300","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/1397051414450062914943494.jpg","0","attachment","image/jpeg","0"),
("306","2","2018-09-02 18:26:53","2018-09-02 13:56:53","","1397051414450087914943494","","inherit","open","closed","","1397051414450087914943494","","","2018-09-02 18:26:53","2018-09-02 13:56:53","","300","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/1397051414450087914943494.jpg","0","attachment","image/jpeg","0"),
("307","2","2018-09-02 18:27:16","2018-09-02 13:57:16","مراسم بزرگداشت روز حقوق بشر اسلامی و کرامت انسانی و اعطای چهارمین جایزه حقوق بشر اسلامی امروز ۱۴ مرداد با حضور آیت‌الله آملی لاریجانی رئیس قوه قضاییه و محمد جواد لاریجانی دبیر ستاد حقوق بشر درمجتمع فرهنگی شهید بهشتی برگزار شد.\r\n\r\n[gallery size=\"medium\" ids=\"301,302,303,304,305,306\"]","مراسم بزرگداشت روز حقوق بشر اسلامی و کرامت انسانی","","inherit","closed","closed","","300-revision-v1","","","2018-09-02 18:27:16","2018-09-02 13:57:16","","300","http://islamic.demo-qaleb.ir/300-revision-v1/","0","revision","","0"),
("309","2","2018-09-02 18:30:45","2018-09-02 14:00:45","","1397052820470746015081294","","inherit","open","closed","","1397052820470746015081294","","","2018-09-02 18:30:45","2018-09-02 14:00:45","","308","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/09/1397052820470746015081294.jpg","0","attachment","image/jpeg","0"),
("310","2","2018-09-02 18:30:49","2018-09-02 14:00:49","متن پیام به این شرح است:\r\n\r\nباسمه تعالی\r\n\r\nمدال‌آوران عزیز کاروان ورزشی:\r\n\r\nبه همه شما تبریک می‌گویم و از همه شما تشکر می‌کنم.\r\nملت ایران را شاد کردید و پرچم سرافراز ما را عزت بخشیدید.\r\n\r\nسید علی خامنه‌ای\r\n11 شهریور 1397\r\n\r\nانتهای پیام/*","پیام امام خامنه‌ای به مدال‌آوران بازی‌های آسیایی؛ ملت ایران را شاد کردید","","inherit","closed","closed","","308-revision-v1","","","2018-09-02 18:30:49","2018-09-02 14:00:49","","308","http://islamic.demo-qaleb.ir/308-revision-v1/","0","revision","","0"),
("311","2","2018-09-05 14:05:16","2018-09-05 09:35:16","متن پیام به این شرح است:\r\n\r\nباسمه تعالی\r\n\r\nمدال‌آوران عزیز کاروان ورزشی:\r\n\r\nبه همه شما تبریک می‌گویم و از همه شما تشکر می‌کنم.\r\nملت ایران را شاد کردید و پرچم سرافراز ما را عزت بخشیدید.\r\n\r\nسید علی خامنه‌ای\r\n11 شهریور 1397\r\n\r\nانتهای پیام/*","پیام امام خامنه‌ای به مدال‌آوران آسیایی؛ ملت ایران را شاد کردید","","inherit","closed","closed","","308-revision-v1","","","2018-09-05 14:05:16","2018-09-05 09:35:16","","308","http://islamic.demo-qaleb.ir/308-revision-v1/","0","revision","","0"),
("314","2","2018-09-11 12:14:11","2018-09-11 07:44:11","«اعوذ بالله من الشیطان الرجیم»\r\n\r\nبسم الله الرحمن الرحیم\r\n\r\nوَ قالَ مُوسى‏ لِأَخیهِ هارُونَ اخْلُفْنی‏ فی‏ قَوْمی‏ وَ أَصْلِحْ وَ لاتَتَّبِعْ سَبیلَ الْمُفْسِدینَ\r\n\r\nدر گذر بیش از سه دهه از عمر پربرکت نظام مقدس جمهوری اسلامی ایران، اقدامات فراوان و مؤثری در خصوص مقابله با فساد اداری صورت گرفته است. لیکن فرمان هشت ماده‌ای مقام معظم رهبری (مد ظله العالی) خطاب به سران قوای سه‌گانه کشور که در آن نقشه راه و خط‌مشی مبارزه با فساد، ترسیم شده، به‌عنوان منشور مبارزه با فساد اقتصادی و مالی و چراغ راه مسئولین نظام شناخته می‌شود.\r\nبانک مرکزی نیز به‌عنوان یکی از اجزای نظام مقدس جمهوری اسلامی ایران و سیاست‌گذار اصلی نظام پولی کشور که مسئولیت برقراری ثبات مالی، رشد اقتصادی مستمر و حفظ نظم و انضباط در بازار پول را بره‌عهده دارد، در راستای منویات مقام معظم رهبری از یک سو و حرکت در جهت دستیابی به نظام بانکی مبتنی بر استانداردهای بین المللی از سوی دیگر، مصمم است با تلاش هدفمند، گامهایی مؤثر در جهت شفاف سازی و سالم سازی اقتصاد، جلوگیری از اقدامات، فعالیت‌ها و زمینه‌های فسادزا به‌خصوص در حوزه پولی و ارزی بردارد.\r\n\r\nاین بانک با اعتقاد به این حقیقت که امروزه فساد در صور گوناگون آن نظیر رشوه، پول‌شویی، تقلب، اختلاس، تبانی و کسب امتیازات خاص، به‌صورت سیستمی در حال شکل‌گیری است، با ملحوظ نظر داشتن چهار حوزه اصلی تأثیرگذار در ایجاد و گسترش فساد در نظام بانکی کشور شامل «عدم شفافیت در مراودات مالی و تبادلات بانکی»، «نظارت بانکی و چالش‌های آن»، «چالش‌های پیش‌روی بازار غیرمتشکل پولی» و «ناکارآمدی سیستم‌های اطلاعاتی بین دستگاه‌ها»، با به‌کارگیری فناوری‌های نوین و توسعه زیرساخت‌های اطلاعاتی و نظارتی در راستای نظارت دقیق و همه‌جانبه بر عملیات بانکی، حصول اطمینان از رعایت استانداردها و ضوابط، تطبیق عملیات بانک‌داری با ضوابط مبارزه با پول‌شویی و پرهیز از اقدامات بازارشکنانه، اهتمام ویژه‌ای در مبارزه با عوامل مؤثر در مفاسد اقتصادی در حوزه پولی و مالی داشته است که موفقیت در این مسئولیت خطیر، تلاش بی‌شائبه و همه‌جانبه‌ای را برای ایجاد اشراف و حاکمیت مناسب در بانک مرکزی، ایجاب می‌نماید.\r\nدر راستای تحقق این مهم، راهبرد بانک مرکزی جمهوری اسلامی ایران در حوزه ارتقای سلامت اداری و مبارزه با پول‌شویی را می‌توان در سه رکن اساسی ساختار، روش‌ها و فناوری طبقه بندی نمود:\r\nدر رکن ساختار، بانک مرکزی نیازمند حصول اطمینان از بهره‌مندی از سازوکاری سازمانی است که بتواند این بانک را از نظر عملیات، ساختار مالی و رعایت قوانین و مقررات، مورد پایش و کنترل قرار داده و با آگاهی به‌موقع مقامات ارشد از تنگناها و مشکلات، یاری رسان آنان در بهبود عملکرد سازمان باشند که این مهم به حوزه بازرسی، پی‌گیری ویژه و نظارت بر امور اجرایی ــ با محوریت حسابرسی داخلی، ارزیابی عملکرد و پاسخگویی و رسیدگی به شکایات، محول شده است.\r\nدر رکن روش‌ها و فرآیندها، بانک مرکزی تحولات شگرف محیطی و شیوه‌های انجام کار را مد نظر قرار داده است. یکی از چالش‌های مهم نظام پولی و بانکی کشور، بروز شکاف و فاصله میان واقعیت روزمره در حال تحول و روش‌های اجرایی ناظر بر ممیزی، حسابرسی و کنترل بر روندهای کاری است که همچنان بر مدار روابط سنتی پیشین می‌چرخد.\r\nدر سال‌های گذشته ورود همه‌جانبه فناوری به حیطه فعالیت‌های بانکی، مجموعه نظارتی بانک مرکزی را با چالش‌های مربوط به افزایش سرعت عملیات و نیز حجم انبوه داده‌ها، مواجه نموده است. لذا بازنگری در روش‌های کنترلی و نظارتی و تمرکز بر نوسازی فرایندهای انجام کار و لحاظ نقاط رسیدگی و بازبینی به‌صورت سیستمی یکی از الزامات مهم است. از این رو بانک مرکزی جمهوری اسلامی ایران با آغاز دو طرح هم‌راستای بانک مرکزی ۱۴۰۰ و نیز نقشه راه و نوسازی نظام بانکی در صدد است تا با تعریف مجدد و روزآمد نمودن فرآیندها و روش‌های عملیاتی در نظام بانکی و بازتعریف نقش‌های نظارتی بانک مرکزی و واحدهای بازرسی و نظارتی در بانک‌ها، همگامی با تحولات محیطی را طراحی نماید.\r\nساختار مناسب و روش‌های انجام کار در زمینه تحول نگرش به داده‌ها و اطلاعات، توسط بانک مرکزی و نظام بانکی صورت می‌پذیرد. نظام بانکی کشور در این حوزه، از دو دهه گذشته، پیشگام و فعال بوده و تقریباً تمامی فعالیت‌های خود را با تکیه بر فناوری راهبری می‌کند. تکیه بر فناوری‌های جدید، گرچه مزایای غیرقابل انکاری برای نظام پولی و مردم داشته، اما حجم انبوهی از داده‌ها و اطلاعات را در پایگاه‌های داده مختلف، انباشته کرده که با توجه به افزایش چشمگیر حجم مبادلات، پردازش و تحلیل آنها به‌عنوان یک چالش مهم مقابل نظام بانکی قرار گرفته است. اقدامات بانک مرکزی در حوزه فناوری در سه شاخه به هم پیوسته دنبال می‌شود، اولاً، جامعیت و پیوستگی سامانه‌های الکترونیکی پردازش بانکی ،باید در تمامی انواع ابزارها و خدمات حاصل شود، ثانیاً، ماهیت داده‌ها و اطلاعات، باید به‌صورت استاندارد تعریف، پردازش و نگه‌داری شود و ثالثاً، سازوکارهای پردازش انبوه اطلاعات به‌منظور حصول اطمینان از اجرای قوانین و مقررات، کشف سریع و دقیق تخلفات و موارد مشکوک و اتخاذ اقدامات اصلاحی و تأمینی در زمان مناسب ایجاد شود.\r\nپیوستگی میان ساختار، فرایند و فناوری در بانک مرکزی جمهوری اسلامی ایران، در قالب سامانه‌هایی برنامه‌ریزی شده است که هریک به‌صورت نظام‌مند و همزمان، ابعاد کارکردی مبارزه با فساد در نظام پولی را مورد هدف قرار می‌دهد که شایسته است با توجه به ضیق وقت در اینجا به‌صورت خلاصه به برخی از این سامانه‌ها، اشاره کنم:\r\n۱٫ نسیم، Core banking یا بانک‌داری متمرکز الکترونیکی بانک مرکزی سامانه‌ای است که به‌منظور همگامی این بانک با تحولات فناوری و پوشش وظایف ذاتی آن در قانون پولی و بانکی کشور به‌عنوان بانک‌دار دولت پیاده سازی شده است که با استفاده از امکانات آن می‌توان تمامی عملیات مربوط به مدیریت حساب‌های دولتی را که بنا به دلایل متعددی از جمله نبود زیرساخت‌های لازم در زمینه بانک‌داری الکترونیک و سامانه‌های نوین بانک‌داری، به بانک‌های تجاری واگذار شده بود، مجدداً به بانک مرکزی بازگرداند. لازم به ذکر است که بیش از دویست هزار حساب در شبکه بانکی متعلق به وجوه دولت بوده و نظارت لازم و کافی بر آنها وجود نداشته است.\r\nهمان‌گونه که در تصویر مشاهده می‌فرمایید، ایجاد تمرکز و یک‌پارچگی در حساب‌های دولتی و امکان رصد و پایش دقیق منابع و مصارف دولت و به‌دنبال آن احصای صحیح و به‌هنگام درآمدهای دولت از جمله مزایایی است که با راه‌اندازی این سامانه از آن بهره‌مند خواهیم شد.\r\n۲٫ سامانه پیام‌رسانی مالی الکترونیکی یا «سپام»\r\nزیرساختی است که تمامی مراودات بین بانک‌ها را از طریق پروتکل‌های استاندارد مبادلات مالی، تحت پوشش قرار می‌دهد. با استفاده از این زیرساخت، تمامی مراودات مالی عمده بانک‌ها از قبیل اعتبارات اسنادی و ضمانت‌نامه‌های ارزی و ریالی و حوالجات ارزی از طریق یک شبکه واحد پیام‌رسانی قابل انجام بوده و ابزارهای نظارتی بانک مرکزی به‌منظور رصد و پایش این مراودات، روی آن قابل پیاده‌سازی است. شایان ذکر است که طرح پایلوت سامانه پیش‌گفت از ۱۳۹۳/۰۹/۲۰ در سراسر کشور راه‌اندازی می‌شود و امید است از بهمن ماه سال جاری به‌صورت رسمی آغاز به کار نماید.\r\n۳٫ فرآیند اجرایی و پردازشی فعلی چک، منجر به ایجاد اوضاع نابسامان تبادل چک اشخاص با ارقام برگشتی با مبالغ بالا و تعداد چشمگیر آن ( چیزی در حدود ۲۶میلیون قطعه طی سالهای۹۳-۸۹ )، گردش طولانی و غیر نظام‌مند و غیر ضرور فیزیک چک، صدور دسته‌چک‌های متنوع با ابعاد و محتوای متفاوت چک‌ها در بانک‌های مختلف، محدودیت در پایش و نیز کندی پردازش آن‌ها و در نهایت بی‌اعتمادی عامه مردم و بازارهای مبادله به این ابزار موثر پرداخت در بازار سنتی شده است.\r\nسامانه مدیریت الکترونیکی چک ( چکاوک) که با هدف حذف گردش فیزیکی چک‌ها بین شعب و واحد‌های بانکی و اعمال نظارت متمرکز بر جریان گردش وجوه و اعمال کنترل‌های قانونی و مقرراتی؛ براساس‌ مصوبه شورای پول و اعتبار، مراحل اجرایی خود را طی می کند، اعتماد را به چک بازگردانده و با امکان برخورداری ذینفع به حداقل اطلاعات واگذارنده چک،‌اطمینان نسبی را برای ایفای تعهد ایجاد می کند.\r\nاین سامانه مطابق با برنامه‌ریزی‌های به عمل آمده تا کنون در استانهای قم، قزوین، زنجان، سمنان، کرمانشاه، همدان، مرکزی، ایلام، البرز، کردستان، لرستان و گلستان عملیاتی شده و نهایتاً تا اسفند ماه سال جاری به طور کامل در سراسر کشور به اجرا درخواهد آمد.\r\n۴٫ پورتال ارزی اَبَرسامانه‌ای است که سامانه‌های ثبتارش (بازرگانی)، آسیکودا (گمرک) و ارزی (بانک مرکزی) را به یکدیگر متصل نموده فرآیندهای بین‌دستگاهی را میان این سامانه‌ها مدیریت می‌کند و از طریق شفاف‌سازی، یک‌پارچگی و نظارت دقیق و همه‌جانبه بر عملیات مرتبط با واردات و صادرات، فرصت هرگونه تبانی در جهت ارزان نمایی و گران نمایی کالا، خروج ارز از کشور از طریق جعل مدارک، اسناد گمرکی و پیمان‌نامه‌های ارزی و گریز از حقوق گمرکی را به حداقل می‌رساند.\r\n\r\n۵٫ فناوری اطلاعات در سال‌های گذشته با تعمیق نفوذ خود، تحولات عظیمی را در حوزه ارتباطات بین افراد و سازمان‌ها ایجاد و علاوه بر ایجاد اسناد الکترونیکی، با تحول در فرایندهای سنتی، موجبات تسریع، تدقیق و ردیابی مراودات با ابزارهای متنوع و سهل‌الوصول را فراهم کرده است.\r\nبا توجه به پیشرفت‌های حاصل شده در حوزه خدمت‌رسانی به مشتریان، اینک قوه قضائیه و بانک مرکزی جمهوری اسلامی ایران در صددند تا مراودات و مکاتبات فی‌مابین را نیز از مواهب پیشرفت‌های فناوری برخوردار سازند.\r\nاز این رو به‌منظور برقراری ارتباط الکترونیکی بین نظام بانکی کشور و قوه قضائیه که یکی از حساس‌ترین و مهمترین ارتباطات بین دستگاهی است، بستری مناسب به‌لحاظ اجرایی و مدیریتی با در نظر گرفتن ملاحظات ویژه (با عنایت به ماهیت اسناد و مکاتبات)، برقراری اطمینان از محرمانگی، انکار ناپذیری و اصالت مکاتبات و داده‌های تبادل شده ایجاد گردیده است.\r\n۶٫ مرکز امنیتی، تخصصی «کاشف» با نظارت بانک مرکزی جمهوری اسلامی ایران به‌منظور تأمین امنیت اطلاعات بانکی کشور از طریق تدوین الزامات و ایجاد چارچوب‌های امنیتی، مدیریت متمرکز امنیت، مدیریت رخدادهای امنیتی و به اشتراک گذاری اطلاعات و تجارب امنیتی بانک‌ها و مؤسسات مالی و اعتباری پیاده‌سازی شده است. این مرکز به‌عنوان نقطه تماس واحد، در تعامل با سایر نهادهای انتظامی، امنیتی و قضایی کشور، وظیفه جمع‌آوری و اشتراک‌گذاری اطلاعات و هماهنگی بین بانک‌ها در مواقع بروز رخدادهای امنیتی و بحران‌های سایبری را عهده‌دار است.\r\n۷٫ نظارت الکترونیکی بانک‌ها (سناب) سامانه‌ای است که استانداردسازی، یک‌پارچه کردن داده‌ها و اطلاعات بانکی و ایجاد یک ساختار منسجم گزارش‌گیری برخط، امکان نظارت الکترونیکی به‌هنگام و جامع بر عملیات بانک‌ها، ایجاد بانک اطلاعاتی یک‌پارچه از داده‌های پالایش شده بانکی، پایش و مانیتورینگ سیستم بانکی به‌لحاظ شناسایی تخلفات و سوء‌استفاده‌های مالی و … را مهیا می‌کند.\r\n۸٫ پس از گذشت حدود یک دهه از تصویب راهبرد نظام جامع پرداخت و با توجه به نظام‌های جدید پرداخت و تسویه و ابزارها و فناوری‌های نوین به‌وجود‌ آمده در جهان، بانک مرکزی جمهوری اسلامی ایران بر‌ آن شد تا نقشه راه ده سال آینده شبکه بانکی کشور را با کمک مشاوران خبره تدوین نماید. در این نقشه زیرساخت‌های اطلاعاتی مورد نیاز در حوزه‌های مختلف مأموریتی بانک مرکزی که طی ده سال آینده به‌طور تدریجی تکمیل و یا مستقر خواهند شد، شناسایی می‌شوند.\r\nاهداف اصلی نقشه راه ۱۴۰۰ بانک مرکزی، شامل تجزیه و تحلیل وضعیت موجود و رفع موانع، جهت نیل به یک نظام بانکی نوین بر پایه استانداردهای جهانی،‌ تعیین مسیرهای آتی نظام بانکی کشور، شناسایی و تعریف اهداف بلندمدت و استراتژیک، به‌کارگیری فناوری‌های نوین بانکی براساس استانداردهای جهانی، شناسایی ریسک‌های متفاوت و تدوین مدیریت ریسک است.\r\nنگاه بانک مرکزی به مبارزه با فساد، رویکردی راهبردی و بلندمدت است؛ باید توجه داشت که بروز فساد بیش از هرچیز ناشی از ضعف در ساختارها، فرایندها و مناسباتی است که طی زمان شکل گرفته و حفره‌های مقرراتی و زمینه‌های فساد در آن برای کسانی که در صدد سوء‌استفاده هستند روشن شده است. از این رو مبارزه جدی با فساد نیازمند تحول در حوزه‌های ساختاری و بنیادین است. فناوری و امکانات آن، فرصت مناسبی را برای بازنگری در این مناسبات و کشف نقاط آسیب‌پذیر و پوشش آنها فراهم کرده است و بانک مرکزی جمهوری اسلامی ایران در صدد است با اتخاذ راهبرد یادشده و بهره‌گیری کامل از امکانات فناوری، تحولی جدی در مقوله مبارزه با فساد را آغاز کند و به‌فضل الهی به انجام برساند.\r\nدر کوتاه‌مدت نیز ساماندهی بازار غیرمتشکل که فعالیت نهادهای پولی و بانکی بدون مجوز را شامل می‌شود، به‌صورت ویژه در دستور کار این بانک قرار دارد.\r\nمؤسسات پیش‌گفت قبلاً با داشتن سهمی تقریباً ۳۰درصدی از بازار پولی کشور، بدون نظارت بانک مرکزی سهم قابل توجهی در نوسانات ناخوشایند بازارهای مختلف ایفا ‌نموده و با ورود به فعالیت‌های سوداگرانه نظیر خرید و فروش مسکن، ارز، طلا و حتی احتکار ارزاق عمومی مردم و … کنار سایر عوامل، این بازارها را با تلاطم مواجه می‌ساختند.\r\nخوشبختانه با پیگیری‌های مستمر بانک مرکزی در جهت اجرای قانون تنظیم بازار غیرمتشکل پولی و قانون برنامه پنجم توسعه، علی‌رغم چالش‌های متعدد، بخشی از این مؤسسات فاقد مجوز؛ ساماندهی و منابع این مؤسسات در راستای اهداف نظام بانکی کشور هدایت گردیده است و در ادامه ضمناً انتظام بخشی سایر مؤسسات عمده بازار مزبور، در دستور کار قرار دارد و مراحل اجرایی را طی می‌کند.\r\nامید است به‌یاری حضرت حق و مساعدت کلیه دستگاه‌های اجرایی و نظارتی، شاهد مبارزه‌ای فراگیر و سیستمی با فساد باشیم. بدیهی است که طی این راه طولانی و توفیق در این مهم و ریشه‌کن کردن فساد و تحقق اراده مقام عظمای ولایت و مطالبات ملت در برخورد با مفسدین اقتصادی و سوءاستفاده گران، تعامل، همفکری، همراهی و همکاری همه‌جانبه دست اندر کاران نظام مقدس جمهوری اسلامی ایران را می‌طلبد.\r\n\r\nهمتم بدرقه راه کن ای طایر قدس ‌ که دراز است ره مقصد و من نوسفرم","امروز اختلاس، تبانی  به‌ صورت سیستمی در حال شکل‌گیری است","","inherit","closed","closed","","63-revision-v1","","","2018-09-11 12:14:11","2018-09-11 07:44:11","","63","http://islamic.demo-qaleb.ir/63-revision-v1/","0","revision","","0"),
("316","2","2018-09-11 12:15:03","2018-09-11 07:45:03","<div class=\"story\">\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nظریف همراه با معاون پارلمانی خود حسن قشقاوی وارد مجلس شد.\r\n\r\nهمزمان با ورود وزیر امور خارجه حجت‌الاسلام علیرضا سلیمی نماینده محلات و دلیجان در نطق میان د‌ستورش صحبت‌های خود را درباره تحریم و محدودیت ویزا توسط دولت آمریکا علیه ایران ایراد کرد.\r\n\r\nقبل از صحبت‌های وزیر امور خارجه نطق میان‌دستور نمایندگان تحت تأثیر ورود ظریف به مجلس قرار گرفت و توجهات نمایندگان به سمت وزیر امور خارجه رفت.\r\n\r\nدر صحن علنی مجلس نماهنگی از صحبت‌های مقام معظم رهبری  در جمع مسئولان وزارت خارجه و رئیس جمهور برای هماهنگی بیشتر این وزارتخانه با سیاستهای اقتصاد مقاومتی پخش شد.\r\n\r\nظریف در بخشی از سخنان خود ضمن توهین به نمایندگان مجلس گفت: من اجازه سوال از معاونین خود را به نمایندگان مجلس نمی‌دهم.\r\n\r\nاین سخن ظریف با واکنش نمایندگان مجلس مواجه شد و جمعی از آنها در واکنش خطاب به وی تأکید کردند که شأن مجلس پایین بیاید.\r\n\r\nعبدالله سامری نماینده خرمشهر و جواد کریمی قدوسی از نمایندگان معترض به سخنان وزیر امور خارجه بودند. عبدالله سامری گفت: مگر توهین به نمایندگان چگونه است؟\r\n\r\nعلی مطهری که ریاست مجلس را به‌عهده داشت، خطاب به وزیر امور خارجه گفت: صحبت‌های وزیر امور خارجه در صحن علنی شاید تحقیر مجلس و نمایندگان تلقی شود بنابراین کلماتی نباید گفته شود که از اقتدار مجلس بکاهد.\r\n\r\nوزیر خارجه با دادن نامه‌ای به ریاست مجلس از نمایندگان عذرخواهی کرد و گفت: اگر به عرایض بنده توجه کنید، متوجه می‌شوید که من قصد توهین به نمایندگان را نداشتم.\r\n\r\nعلی مطهری درباره سوال نمایندگان از وزرا تصریح کرد: نمایندگان آزادند، در مورد همه مسائل کشور سوال کنند اما نباید طوری بپرسند که تلقی داشتن نیات سیاسی شود.\r\n<div class=\"story\">\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nظریف همراه با معاون پارلمانی خود حسن قشقاوی وارد مجلس شد.\r\n\r\nهمزمان با ورود وزیر امور خارجه حجت‌الاسلام علیرضا سلیمی نماینده محلات و دلیجان در نطق میان د‌ستورش صحبت‌های خود را درباره تحریم و محدودیت ویزا توسط دولت آمریکا علیه ایران ایراد کرد.\r\n\r\nقبل از صحبت‌های وزیر امور خارجه نطق میان‌دستور نمایندگان تحت تأثیر ورود ظریف به مجلس قرار گرفت و توجهات نمایندگان به سمت وزیر امور خارجه رفت.\r\n\r\nدر صحن علنی مجلس نماهنگی از صحبت‌های مقام معظم رهبری  در جمع مسئولان وزارت خارجه و رئیس جمهور برای هماهنگی بیشتر این وزارتخانه با سیاستهای اقتصاد مقاومتی پخش شد.\r\n\r\nظریف در بخشی از سخنان خود ضمن توهین به نمایندگان مجلس گفت: من اجازه سوال از معاونین خود را به نمایندگان مجلس نمی‌دهم.\r\n\r\nاین سخن ظریف با واکنش نمایندگان مجلس مواجه شد و جمعی از آنها در واکنش خطاب به وی تأکید کردند که شأن مجلس پایین بیاید.\r\n\r\nعبدالله سامری نماینده خرمشهر و جواد کریمی قدوسی از نمایندگان معترض به سخنان وزیر امور خارجه بودند. عبدالله سامری گفت: مگر توهین به نمایندگان چگونه است؟\r\n\r\nعلی مطهری که ریاست مجلس را به‌عهده داشت، خطاب به وزیر امور خارجه گفت: صحبت‌های وزیر امور خارجه در صحن علنی شاید تحقیر مجلس و نمایندگان تلقی شود بنابراین کلماتی نباید گفته شود که از اقتدار مجلس بکاهد.\r\n\r\nوزیر خارجه با دادن نامه‌ای به ریاست مجلس از نمایندگان عذرخواهی کرد و گفت: اگر به عرایض بنده توجه کنید، متوجه می‌شوید که من قصد توهین به نمایندگان را نداشتم.\r\n\r\nعلی مطهری درباره سوال نمایندگان از وزرا تصریح کرد: نمایندگان آزادند، در مورد همه مسائل کشور سوال کنند اما نباید طوری بپرسند که تلقی داشتن نیات سیاسی شود.\r\n<div class=\"story\">\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nظریف همراه با معاون پارلمانی خود حسن قشقاوی وارد مجلس شد.\r\n\r\nهمزمان با ورود وزیر امور خارجه حجت‌الاسلام علیرضا سلیمی نماینده محلات و دلیجان در نطق میان د‌ستورش صحبت‌های خود را درباره تحریم و محدودیت ویزا توسط دولت آمریکا علیه ایران ایراد کرد.\r\n\r\nقبل از صحبت‌های وزیر امور خارجه نطق میان‌دستور نمایندگان تحت تأثیر ورود ظریف به مجلس قرار گرفت و توجهات نمایندگان به سمت وزیر امور خارجه رفت.\r\n\r\nدر صحن علنی مجلس نماهنگی از صحبت‌های مقام معظم رهبری  در جمع مسئولان وزارت خارجه و رئیس جمهور برای هماهنگی بیشتر این وزارتخانه با سیاستهای اقتصاد مقاومتی پخش شد.\r\n\r\nظریف در بخشی از سخنان خود ضمن توهین به نمایندگان مجلس گفت: من اجازه سوال از معاونین خود را به نمایندگان مجلس نمی‌دهم.\r\n\r\nاین سخن ظریف با واکنش نمایندگان مجلس مواجه شد و جمعی از آنها در واکنش خطاب به وی تأکید کردند که شأن مجلس پایین بیاید.\r\n\r\nعبدالله سامری نماینده خرمشهر و جواد کریمی قدوسی از نمایندگان معترض به سخنان وزیر امور خارجه بودند. عبدالله سامری گفت: مگر توهین به نمایندگان چگونه است؟\r\n\r\nعلی مطهری که ریاست مجلس را به‌عهده داشت، خطاب به وزیر امور خارجه گفت: صحبت‌های وزیر امور خارجه در صحن علنی شاید تحقیر مجلس و نمایندگان تلقی شود بنابراین کلماتی نباید گفته شود که از اقتدار مجلس بکاهد.\r\n\r\nوزیر خارجه با دادن نامه‌ای به ریاست مجلس از نمایندگان عذرخواهی کرد و گفت: اگر به عرایض بنده توجه کنید، متوجه می‌شوید که من قصد توهین به نمایندگان را نداشتم.\r\n\r\nعلی مطهری درباره سوال نمایندگان از وزرا تصریح کرد: نمایندگان آزادند، در مورد همه مسائل کشور سوال کنند اما نباید طوری بپرسند که تلقی داشتن نیات سیاسی شود.\r\n\r\nانتهای پیام/\r\n\r\n</div>\r\n</div>\r\n</div>","وزیر امور خارجه کشود: قصد توهین نداشتم؛عذرخواهی می‌کنم","","inherit","closed","closed","","51-revision-v1","","","2018-09-11 12:15:03","2018-09-11 07:45:03","","51","http://islamic.demo-qaleb.ir/51-revision-v1/","0","revision","","0"),
("317","2","2018-09-11 12:15:26","2018-09-11 07:45:26","<div class=\"story\">\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nظریف همراه با معاون پارلمانی خود حسن قشقاوی وارد مجلس شد.\r\n\r\nهمزمان با ورود وزیر امور خارجه حجت‌الاسلام علیرضا سلیمی نماینده محلات و دلیجان در نطق میان د‌ستورش صحبت‌های خود را درباره تحریم و محدودیت ویزا توسط دولت آمریکا علیه ایران ایراد کرد.\r\n\r\nقبل از صحبت‌های وزیر امور خارجه نطق میان‌دستور نمایندگان تحت تأثیر ورود ظریف به مجلس قرار گرفت و توجهات نمایندگان به سمت وزیر امور خارجه رفت.\r\n\r\nدر صحن علنی مجلس نماهنگی از صحبت‌های مقام معظم رهبری  در جمع مسئولان وزارت خارجه و رئیس جمهور برای هماهنگی بیشتر این وزارتخانه با سیاستهای اقتصاد مقاومتی پخش شد.\r\n\r\nظریف در بخشی از سخنان خود ضمن توهین به نمایندگان مجلس گفت: من اجازه سوال از معاونین خود را به نمایندگان مجلس نمی‌دهم.\r\n\r\nاین سخن ظریف با واکنش نمایندگان مجلس مواجه شد و جمعی از آنها در واکنش خطاب به وی تأکید کردند که شأن مجلس پایین بیاید.\r\n\r\nعبدالله سامری نماینده خرمشهر و جواد کریمی قدوسی از نمایندگان معترض به سخنان وزیر امور خارجه بودند. عبدالله سامری گفت: مگر توهین به نمایندگان چگونه است؟\r\n\r\nعلی مطهری که ریاست مجلس را به‌عهده داشت، خطاب به وزیر امور خارجه گفت: صحبت‌های وزیر امور خارجه در صحن علنی شاید تحقیر مجلس و نمایندگان تلقی شود بنابراین کلماتی نباید گفته شود که از اقتدار مجلس بکاهد.\r\n\r\nوزیر خارجه با دادن نامه‌ای به ریاست مجلس از نمایندگان عذرخواهی کرد و گفت: اگر به عرایض بنده توجه کنید، متوجه می‌شوید که من قصد توهین به نمایندگان را نداشتم.\r\n\r\nعلی مطهری درباره سوال نمایندگان از وزرا تصریح کرد: نمایندگان آزادند، در مورد همه مسائل کشور سوال کنند اما نباید طوری بپرسند که تلقی داشتن نیات سیاسی شود.\r\n<div class=\"story\">\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nظریف همراه با معاون پارلمانی خود حسن قشقاوی وارد مجلس شد.\r\n\r\nهمزمان با ورود وزیر امور خارجه حجت‌الاسلام علیرضا سلیمی نماینده محلات و دلیجان در نطق میان د‌ستورش صحبت‌های خود را درباره تحریم و محدودیت ویزا توسط دولت آمریکا علیه ایران ایراد کرد.\r\n\r\nقبل از صحبت‌های وزیر امور خارجه نطق میان‌دستور نمایندگان تحت تأثیر ورود ظریف به مجلس قرار گرفت و توجهات نمایندگان به سمت وزیر امور خارجه رفت.\r\n\r\nدر صحن علنی مجلس نماهنگی از صحبت‌های مقام معظم رهبری  در جمع مسئولان وزارت خارجه و رئیس جمهور برای هماهنگی بیشتر این وزارتخانه با سیاستهای اقتصاد مقاومتی پخش شد.\r\n\r\nظریف در بخشی از سخنان خود ضمن توهین به نمایندگان مجلس گفت: من اجازه سوال از معاونین خود را به نمایندگان مجلس نمی‌دهم.\r\n\r\nاین سخن ظریف با واکنش نمایندگان مجلس مواجه شد و جمعی از آنها در واکنش خطاب به وی تأکید کردند که شأن مجلس پایین بیاید.\r\n\r\nعبدالله سامری نماینده خرمشهر و جواد کریمی قدوسی از نمایندگان معترض به سخنان وزیر امور خارجه بودند. عبدالله سامری گفت: مگر توهین به نمایندگان چگونه است؟\r\n\r\nعلی مطهری که ریاست مجلس را به‌عهده داشت، خطاب به وزیر امور خارجه گفت: صحبت‌های وزیر امور خارجه در صحن علنی شاید تحقیر مجلس و نمایندگان تلقی شود بنابراین کلماتی نباید گفته شود که از اقتدار مجلس بکاهد.\r\n\r\nوزیر خارجه با دادن نامه‌ای به ریاست مجلس از نمایندگان عذرخواهی کرد و گفت: اگر به عرایض بنده توجه کنید، متوجه می‌شوید که من قصد توهین به نمایندگان را نداشتم.\r\n\r\nعلی مطهری درباره سوال نمایندگان از وزرا تصریح کرد: نمایندگان آزادند، در مورد همه مسائل کشور سوال کنند اما نباید طوری بپرسند که تلقی داشتن نیات سیاسی شود.\r\n<div class=\"story\">\r\n\r\nبه گزارش خبرنگار پارلمانی باشگاه خبرنگاران تسنیم <strong>«پویا»</strong>، محمدجواد ظریف وزیر امور خارجه کشورمان صبح امروز برای پاسخ به سوالات دو تن از نمایندگان مجلس در صحن علنی مجلس شورای اسلامی حضور یافت که حضور وی در مجلس با حاشیه‌هایی همراه بود.\r\n\r\nبیشتر استقبال کنندگان از ظریف در بدو ورودش نمایندگان اصلاح‌طلب بودند.\r\n\r\nظریف همراه با معاون پارلمانی خود حسن قشقاوی وارد مجلس شد.\r\n\r\nهمزمان با ورود وزیر امور خارجه حجت‌الاسلام علیرضا سلیمی نماینده محلات و دلیجان در نطق میان د‌ستورش صحبت‌های خود را درباره تحریم و محدودیت ویزا توسط دولت آمریکا علیه ایران ایراد کرد.\r\n\r\nقبل از صحبت‌های وزیر امور خارجه نطق میان‌دستور نمایندگان تحت تأثیر ورود ظریف به مجلس قرار گرفت و توجهات نمایندگان به سمت وزیر امور خارجه رفت.\r\n\r\nدر صحن علنی مجلس نماهنگی از صحبت‌های مقام معظم رهبری  در جمع مسئولان وزارت خارجه و رئیس جمهور برای هماهنگی بیشتر این وزارتخانه با سیاستهای اقتصاد مقاومتی پخش شد.\r\n\r\nظریف در بخشی از سخنان خود ضمن توهین به نمایندگان مجلس گفت: من اجازه سوال از معاونین خود را به نمایندگان مجلس نمی‌دهم.\r\n\r\nاین سخن ظریف با واکنش نمایندگان مجلس مواجه شد و جمعی از آنها در واکنش خطاب به وی تأکید کردند که شأن مجلس پایین بیاید.\r\n\r\nعبدالله سامری نماینده خرمشهر و جواد کریمی قدوسی از نمایندگان معترض به سخنان وزیر امور خارجه بودند. عبدالله سامری گفت: مگر توهین به نمایندگان چگونه است؟\r\n\r\nعلی مطهری که ریاست مجلس را به‌عهده داشت، خطاب به وزیر امور خارجه گفت: صحبت‌های وزیر امور خارجه در صحن علنی شاید تحقیر مجلس و نمایندگان تلقی شود بنابراین کلماتی نباید گفته شود که از اقتدار مجلس بکاهد.\r\n\r\nوزیر خارجه با دادن نامه‌ای به ریاست مجلس از نمایندگان عذرخواهی کرد و گفت: اگر به عرایض بنده توجه کنید، متوجه می‌شوید که من قصد توهین به نمایندگان را نداشتم.\r\n\r\nعلی مطهری درباره سوال نمایندگان از وزرا تصریح کرد: نمایندگان آزادند، در مورد همه مسائل کشور سوال کنند اما نباید طوری بپرسند که تلقی داشتن نیات سیاسی شود.\r\n\r\nانتهای پیام/\r\n\r\n</div>\r\n</div>\r\n</div>","وزیر امور خارجه کشور: قصد توهین نداشتم؛عذرخواهی می‌کنم","","inherit","closed","closed","","51-revision-v1","","","2018-09-11 12:15:26","2018-09-11 07:45:26","","51","http://islamic.demo-qaleb.ir/51-revision-v1/","0","revision","","0"),
("318","2","2018-09-11 12:18:24","2018-09-11 07:48:24","علی خسروی داور بین المللی فوتبال، مدرس دانشگاه و کارشناس برنامه های ورزشی صدا وسیما با انتقداد از بازی های المپیک در اینستاگرام خود نوشت:\r\n<div align=\"center\">فعلا كه فقط اين سه سوپر داور ايراني در المپيك ميدرخشند و كاروان ما در ريو كماكان در حسرت مدال المپيك ميباشند؟؟؟؟؟؟!!!!! بازي برزيل و دانمارك هم امروز صبح بدون اشتباه توسط فغاني سخندان و منصوري قضاوت شد و حالا منتظريم قضاوت يك چهارم نهايي نيمه نهايي وانشالله فينال به اين گروه و تيم سرافراز ايراني ابلاغ گردد. به احترامشان بپا خاسته و احترام نظامي ميگذاريم</div>\r\nاین مطالب در حالی در اینستاگرام علی خسروی منتشر می شود که روز پنجم سی و یکمین دوره مسابقات المپیک ۲۰۱۶ ریو در  به پایان رسید که چینی‌ها با کسب مدال طلا در تنیس روی میز بانوان تعداد مدال‌های طلای خود را با آمریکا برابر کردند، اما به دلیل پایین بودن مدال‌های نقره و برنز در همان مکان دوم باقی ماندند.\r\n\r\nقزاقستان با کسب دو طلای شنا و وزنه برداری در این روز به رتبه یازدهم صعود کرد و اسپانیا نیز نخستین طلای خود را امروز در رشته شنا کسب کرد.\r\nدر جدول رده بندی مدالی تاکنون بیش از ۵۰ کشور کسب مدال کرده‌اند و ایران هم در شمشیربازی می‌توانست صاحب نخستین مدال خود شود که با بدشانسی این اتفاق نیفتاد. مدال نماینده کویت هم به دلیل تعلیق بودن این کشور به نامش ثبت نشد و با پرچم کمیته بین المللی المپیک بود.\r\n\r\nدر جدول رده بندی آمریکا با ۱۰ طلا، ۱۱ نقره و ۱۰ برنز و مجموع ۳۱ در رده اول قرار دارد، چین با ۱۰ طلا، ۵ نقره و ۸ برنز و مجموع ۲۳ در رده دوم و ژاپن با ۶ طلا، یک نقره و ۱۱ برنز در مکان سوم جدول توزیع مدال‌ها قرار دارند.\r\n\r\nبرابر آخرین جدولی که در زیر آمده ایران تا کنون مدالی به دست نیاورده است.","انتقاد خسروی داور و کارشناس از بازی های المپیک ریو","","inherit","closed","closed","","94-revision-v1","","","2018-09-11 12:18:24","2018-09-11 07:48:24","","94","http://islamic.demo-qaleb.ir/94-revision-v1/","0","revision","","0"),
("319","2","2018-09-16 15:04:40","2018-09-16 10:34:40","وی به هفته دولت و سالروز شهادت شهیدان رجایی و باهنر اشاره کرد و اظهارداشت: این شهیدان، دولتمردانی مخلص، مردمی، ولایتی و ولایتمدار بودند، شهید رجایی هویت خویش را در مجلس با این جمله که \"من مقلد امام هستم\"، نشان داد.\r\n\r\nخطیب نماز جمعه این هفته تهران با اشاره به دیدار اخیر اعضای هیئت دولت با مقام معظم رهبری، افزود: سیره امام(ره) و مقام معظّم رهبری این بوده و هست که از دولت‌های پس پیروزی انقلاب حمایت کرد‌ه‌اند، این حمایت، پشتوانه منطقی و برهانی دارد؛  دولت، منتخب مردم است و حمایت از آنها احترام به مردم است.\r\n\r\nآیت‌الله خاتمی وجه دیگر حمایت رهبر انقلاب از دولت‌های پس از انقلاب را در این دانست که اداره کشور 80 میلیونی کار آسانی نیست و همه باید کمک کنند تا دولتمردان که در وسط میدان هستند، گره کار مردم را باز کنند.\r\n<blockquote><strong>بیشتر بخوانید:</strong>\r\n\r\n<strong>سؤال از رئیس‌جمهور| فرهنگی: تورم کنونی بی‌سابقه است</strong></blockquote>\r\nوی با بیان اینکه یکی از راه‌های حمایت از دولت را حمایت ناصحانه است، گفت: دیدن خوبی‌ها و تکریم و تشویق آنها از یک طرف و اینکه اگر نارسایی و نقاط ضعف دیده شد، نقد منصفانه داشته باشیم و اگر طرحی برای حل مشکلات وجود دارد نیز عرضه کنیم و از طرفی دیگر این راهکارها به‌کار گرفته شود، شامل حمایت ناصحانه است.\r\n\r\nخطیب نماز جمعه این هفته تهران اضافه کرد: دولتمردان بایستی در تراز انقلاب اسلامی عمل کنند. یکی از ویژگی‌های دولتمردان تراز انقلاب اسلامی این است که  مسئولیت را امانت و نه لقمه چرب می‌دانند؛ چنین کسی، اختلاس و حقوق نجومی و پارتی‌بازی در کارش نیست، اگر آنها خوب و یا بد عمل کنند، پای سبد نظام ریخته می‌شود.\r\n\r\n<strong>آیت‌الله خاتمی</strong> یکی دیگر از ویژگی‌های دولتمردان تراز انقلاب اسلامی در این دانست که خود را خادم و مردم را مخدوم می‌دانند و اظهار داشت: دولتمرد اسلامی، دغدغه گسترش دین دارد و اصلاً مأموریت حکومت دینی، صاف کردن جاده دین و ارزش‌های دینی است.\r\n\r\nوی با بیان اینکه دولتمرد تراز انقلاب اسلامی، دغدغه تحقق عدالت اجتماعی را دارد، گفت: دولتمرد نظام اسلامی، قانونمدارانه عمل می‌کند و خودش در خط مقدم عمل به قانون است؛ چنین فردی، شایسته‌سالار و نه قبیله‌سالار، فرزندسالار، حزب‌سالار و باندسالار است، در نزد او هر کسی که شایسته است، جایگاه دارد.\r\n\r\nخطیب نماز جمعه این هفته تهران یکی دیگر از ویژگی‌های دولتمرد تراز انقلاب اسلامی در این عنوان کرد که زندگی‌اش همسان محرومین است.\r\n\r\nبه گزارش تسنیم، آیت‌اللعه خاتمی با اشاره به جلسه مجلس برای طرح سؤال از رئیس‌جمهور که سه‌شنبه گذشته برگزار شد، اظهار داشت: این جلسه، نمایش زیبای مردمسالاری بود، آنچه در مجلس رخ داد، جدی و نه نمایشی بود، نمایندگان واقعا سؤال کردند و رئیس جمهور هم جدی وارد صحنه شد و پاسخ داد و متانت در گفتار و رفتار نمایندگان و رئیس‌جمهور بود.\r\n\r\nوی با بیان اینکه جلسه مجلس برای سؤال از رئیس‌جمهور نشان داد که مشکل واقعی مردم، مشکل معیشتی است، تصریح کرد: این مسئله، اصلی است، نباید حاشیه‌سازی‌ها، این مسئله اصلی را تحت‌الشعاع قرار دهد.\r\n\r\nخطیب نماز جمعه این هفته تهران ادامه داد: دشمن به دنبال دعوا در نشست سؤال از رئیس‌‌جمهور در مجلس بود و می‌خواست روز سه‌شنبه، دعوای نمایندگان را ببیند، اما رفتار متین نمایندگان و رئیس‌جمهور آنها را ناکام گذاشت.\r\n\r\nآیت‌الله خاتمی با اشاره به قانع نشدن نمایندگان از 4 سؤال از میان 5 سؤال از رئیس‌جمهور، گفت: از این جهت معلوم می‌شود که بین انتظارات نمایندگان و واقعیت‌های موجود، خلاء وجود دارد و دولت باید با تلاش شبانه‌روزی این خلاء را پُر کند.\r\n\r\nوی در بخش دیگری از سخنانش با اشاره به تأکیدات مکرر رهبر معظم انقلاب مبنی بر اینکه در هیچ سطحی با آمریکا مذاکر نخواهیم کرد، گفت: دولت آمریکا، عهدشکن است و ارزش‌های اخلاقی برای او معنایی ندارد.\r\n\r\nخطیب نماز جمعه این هفته تهران تصریح کرد: آمریکا و اتحادیه اروپا و همه دنیا بداند، نظام اسلامی از خطوط قرمزش که از جمله اقتدار موشکی است، سر سوزنی عقب‌نشینی نخواهد کرد.\r\n\r\nآیت‌الله خاتمی با اشاره به بخشی از سخنان رهبر انقلاب در دیدار اعضای هیئت دولت مبنی بر بلامانع بودن مذاکره با اروپا، گفت: اقتصاد و مسائل سیاسی خود را به آنها گره نمی‌زنیم، بلکه اعتماد ما، به خدا و ظرفیت‌های فراوان این مردم است.\r\n\r\nوی همچنین به تأکیدات مقام معظم رهبری مبنی بر مبارزه با فساد اشاره و تصریح کرد: قوه‌قضائیه که به این خوبی وارد میدان شده، با قاطعیت و عدالت تا آخر خط در صحنه باشد، راه‌حل برون‌رفت از این مشکلات، اقتصاد مقاومتی است.\r\n\r\nخطیب نماز جمعه این هفته تهران تأکید کرد: سیاست ما این است که با همسایگان، برادرانه رفتار کنیم، اما «چه خوش بی که محبت هر دو سر بی»؛ اگر آنها برادرانه رفتار کنند، مطمئن باشند که بهترین رفتار برادرانه را خواهند دید.\r\n\r\nآیت‌‌الله خاتمی در پایان خطاب به نمازگزاران، خاطرنشان کرد: ولایت فقیه ما، قطره‌ای از دریای ناپیداکرانه غدیر است که بحمدلله پشیبان آن بودید، هستید و خواهید بود و به بیان امام(ره) کشورتان آسیبی نخواهد دید.","جلسه سؤال از رئیس‌جمهور نشان داد که مشکل واقعی مردم معیشت است","","inherit","closed","closed","","278-revision-v1","","","2018-09-16 15:04:40","2018-09-16 10:34:40","","278","http://islamic.demo-qaleb.ir/278-revision-v1/","0","revision","","0");

INSERT INTO `wp_posts` VALUES 
("327","2","2018-12-10 13:59:47","2018-12-10 10:29:47","متن پیام به این شرح است:\r\n\r\nباسمه تعالی\r\n\r\nمدال‌آوران عزیز کاروان ورزشی:\r\n\r\nبه همه شما تبریک <span style=\"color: #ff0000;\">می‌گویم</span> و از همه شما تشکر می‌کنم.\r\nملت ایران را شاد کردید و پرچم سرافراز ما را عزت بخشیدید.\r\n\r\nسید علی خامنه‌ای\r\n11 شهریور 1397\r\n\r\nانتهای پیام/*","پیام امام خامنه‌ای به مدال‌آوران آسیایی؛ ملت ایران را شاد کردید","","inherit","closed","closed","","308-revision-v1","","","2018-12-10 13:59:47","2018-12-10 10:29:47","","308","http://islamic.demo-qaleb.ir/308-revision-v1/","0","revision","","0"),
("332","2","2019-01-26 21:39:45","2019-01-26 18:09:45","","Placko-new-building-plan-03","","inherit","open","closed","","placko-new-building-plan-03","","","2019-01-26 21:39:45","2019-01-26 18:09:45","","57","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/Placko-new-building-plan-03.jpg","0","attachment","image/jpeg","0"),
("333","2","2019-01-26 21:40:28","2019-01-26 18:10:28","<p class=\"rtejustify\">به گزارش خبرنگار اقتصادی وزیر راه و شهرسازی و فرمانده قرارگاه خاتم‌الانبیاء امروز پس از بازدید از آزادراه کنارگذر جنوبی تهران از عملیات اجرایی پیشرفت پروژه راه‌آهن سریع‌السیر تهران-قم-اصفهان بازدید کردند.</p>\n<p class=\"rtejustify\">این پروژه که برای اولین بار در کشور اجرا می‌شود به پیمانکاری قرارگاه خاتم‌الانبیاء و کارفرمایی دولت اجرا می‌شود.</p>\n<p class=\"rtejustify\">بنابراین گزارش، سردار عبادالله عبداللهی در حاشیه بازدید از عملیات اجرایی این پروژه بیان کرد: پروژه راه‌آهن سریع السیر تهران-قم-اصفهان به عنوان یک ابرپروژه مطرح است و باید به عنوان یک ابرپروژه باشد اما ما از روند این پروژه، مطالعات و همه موارد آن فعلاً رضایت خاصی نداریم.</p>\n<p class=\"rtejustify\">سردار عبداللهی افزود: این پروژه در دو قطعه تهران تا قم و قم تا اصفهان اجرا خواهد شد که روسازی قم تا اصفهان ۷۵ درصد پیشرفت فیزیکی دارد.</p>\n<p class=\"rtejustify\">بنابراین گزارش مدیرعامل شرکت ساخت و توسعه زیربناهای کشور در حاشیه این بازدید درباره راه‌آهن سریع‌السیر تهران – قم – اصفهان بیان کرد: اعتبارات اسنادی راه‌آ‌هن تهران- قم- اصفهان گشایش یافت و هم‌اکنون این پروژه در ۲ فاز تهران – قم – اصفهان فعال است.</p>\n<img class=\"size-medium aligncenter\" src=\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/Placko-new-building-plan-03.jpg\" width=\"1200\" height=\"646\" />\n<p class=\"rtejustify\">وی با بیان اینکه این پروژه اولین پروژه قطار سریع‌السیر در کشور است، گفت: پیمانکار در محل اجرا مستقر شده است.</p>\n<p class=\"rtejustify\">معاون وزیر راه و شهرسازی افزود: قرارگاه سازندگی خاتم‌الانبیاء به عنوان پیمانکار این پروژه با جونیت چینی که LC را آورده است در این پروژه فعال هستند.</p>\n<p class=\"rtejustify\">وی ادامه داد: در بخش قم تا اصفهان زیرسازی ۷۰ درصد پیشرفت فیزیکی دارد و در بخش تهران تا قم در مرحله فاز صفر مطالعاتی است.</p>\n<p class=\"rtejustify\">نورزاد با بیان اینکه شرکت آزمایشگاه‌ها در این پروژه مستقر شده است، بیان کرد: برنامه‌ریزی می‌کنیم که در فرودگاه امام خمینی (ره) ایستگاه قطار وجود داشته باشد.</p>\n<p class=\"rtejustify\">وی بیان کرد: در بخشی از این مسیر از کیلومتر ۲۰۹ به بعد در ۳۵ کیلومتر مشکل تملک اراضی در منطقه اصفهان داریم که ۹ کیلومتر آن منابع طبیعی است.</p>\n<p class=\"rtejustify\">معاون وزیر راه و شهرسازی گفت:‌در تعیین موقعیت ایستگاه اصفهان و عبور به سمت شیراز مطالعاتی قبلاً در شرکت ساخت و توسعه زیربناهای حمل‌ونقل انجام شده بود.</p>","بررسی جزئیات اجرای راه‌آهن سریع‌السیر تهران-قم-اصفهان","","inherit","closed","closed","","57-autosave-v1","","","2019-01-26 21:40:28","2019-01-26 18:10:28","","57","http://islamic.demo-qaleb.ir/57-autosave-v1/","0","revision","","0"),
("338","2","2019-08-03 13:14:06","2019-08-03 08:44:06","<p dir=\"RTL\">جمعی از دانشجویان عصر امروز با حضور در حسینیه امام خمینی (ره) با رهبر معظم انقلاب دیدار کردند.</p>\n<p dir=\"RTL\">علیرضا شریفی، از دانشجویان بسیجی به نمایندگی از بسیج دانشجویی در این نشست سخنانی را مطرح کرد.</p>\n<p dir=\"RTL\">وی در بخشی از سخنان خود اظهار داشت: امروز که در پنجمین دهه از عمر پر برکت انقلاب اسلامی به مدد حضرت ولی عصر (عج) و هدایت حکیمانه امام(ره) و رهبری مدبرانه حضرتعالی گام اول انقلاب که ترجمان جامع «ما می‌توانیم» بود، محقق شد، لیکن وجود مواردی اعم از نفوذ خوی اشرافیت و کاخ نشینی، نبود شفافیت و پاسخگویی در عملکرد‌ها، مرعوبیت و عدم مرزبندی برخی از مسئولان در برابر دشمن، در برهه‌هایی از این زمان چهل ساله باعث تلخی کام مردم عزیز ایران اسلامی شد.\n\nاین فعال دانشجویی با بیان اینکه اعتقاد ما این است که در طول این سال‌ها اگر قصوری دیده شد، به علت دوری و فاصله گرفتن کارگزاران نظام از آرمان‌های انقلاب بود و هر کجا که شاهد رشد، پیشرفت و اعتلای نظام و مردم بوده ایم، آن زمانی بوده است که مسئولین کشور با روحیه جهادی و انقلابی عامل به ارزش ها، اصول، آرمان‌ها و منویات امام و رهبری عزیز بودند، تصریح کرد: حال در ابتدای گام دوم انقلاب به عنوان افسران جوان جنگ نرم برآن شدیم نکاتی را با امام و ولی زمانمان در میان گذاریم تا ضمن بهره مندی از رهنمود‌های حکیمانه و هدایتگرانه شما، بتوانیم نقش و جایگاه خود را در مسیر رسیدن به تمدن نوین اسلامی بیش از پیش فهم کنیم.</p>\nشریفی افزود: در گام اول انقلاب که گام طراحی و ایجاد بستر‌های حکمرانی اسلامی بود، دانشگاه و دانشجو، به عنوان مبدا و محور تحولات در جامعه به ایفای نقش پرداختند.اکنون و در گام دوم و با توجه به پر رنگ بودن جایگاه نسل جوان در این مرحله، فرزندان بسیجی رهبر انقلاب در دانشگاه‌های سراسر کشور به عنوان مروجان حقیقت «نظام انقلابی» همت بر آن شده و دارند که با نگاهی تحولی و رویکردی مساله محور، مبتنی بر آرمان‌ها و واقعیت ها، نیاز‌های روز جامعه را از دریچه نگاه مردم دنبال و مطالبه کنند. از همین رو فرزندانتان، آمادگی کامل خود را جهت نظریه پردازی، طراحی الگو‌های ایجابی و تربیت نیرو‌های ملتزم در مسیر جوان سازی و مردمی سازی حکمرانی اعلام می‌دارند.\n\nنماینده بسیج دانشجوی با بیان اینکه در شرایط جنگ اقتصادی، تبیین و به کارگیری نظریه مقاومت در حوزه اقتصاد، ضرورتی اجتناب ناپذیر است، ادامه داد: اما امروز و در این جنگ اقتصادی آرایش جنگی متناسب از دولت مردان دیده نمی‌شود، چرا که عدم توانمندی در کنترل بازار، وجود احتکار، فعالیت شبکه خزنده اخلال گران اقتصادی و گرانی‌های افسار گسیخته موجب شده معیشت مردم به گروگان ناکارآمدی مسئولین درآید.\n\nوی تاکید کرد: در شرایطی که با برخی اقدامات مشخص مانند رشد صادرات فرآورده‌های نفتی و محصولات غیر نفتی، اتکای بودجه داخلی به مالیات و انجام طرح‌های معطل مانده نظیر مالیات بر عایدی سرمایه، مالیات بر مسکن خالی، مالیات برخی اقشار نظیر پزشکان و وکلا و یا با برقراری سامانه‌های مولد شفافیت، می‌توان با بسیاری از ناکارآمدی‌ها و سرچشمه‌های فساد مبارزه کرد. البته در این کشاکش صدایی از بهارستان به گوش نمی‌رسد. به نظر می‌آید نمایندگان نیز در حال گرفتن آرایش جنگی اند؛ اما خدا می‌داند انتخاباتی یا اقتصادی؟!\n\nاین دانشجوی بسیجی به نقش قوه قضائیه نیز در این بین اشاره کرد و گفت: از طرفی نقش قوه قضاییه به عنوان نظام قضایی که باید انقلابی باشد، در مسیر رسیدن به تمدن نوین اسلامی بسیار برجسته است. قوه عدلیه به عنوان نماد کارآمدی نظام اسلامی در برقراری عدالت و احقاق حقوق عامه در کنار برخورد قاطع با اهمال کاران و زالو صفتان اقتصادی بیشتر از قبل باید به مقوله ایجادِ ساز و کار‌های پیشگیری از جرائم و مفاسد کلان بپردازد.\n\nوی اضافه کرد: اینکه قوه محترم، دادگاه‌های علنی برپا دارد و با مجرمین با شدت برخورد کند خوب است، اما آنچه بهتر است حضور فعال دستگاه قضا در عرصه ایجاد نرم افزار‌های قدرتمند نظارت و پیشگیری است که بسیاری از مفاسد اقتصادی و اداری فعلی می توانند قبل از اینکه در رسانه‌ها و دادگاه‌ها آینه دق شوند و در مقابل چشمان مردم قرار بگیرند، پشت سدی از ساز و کار‌های دقیق بمانند و اساسا مبادی فساد زایی وجود نداشته باشد که محل سواستفاده فرصت طلبان شود.\n\nاین فعال دانشجویی با اشاره به اینکه امروز با نگاه کلان نسبت به معضلات نظام در می‌یابیم عمده آن‌ها ناشی از عدم انطباق قوانین و مصوبات با سیاست‌های کلی نظام است، یادآور شد:  نمونه‌های مختلفی نظیر قانون مدیریت خدمات کشوری، CFT و پالرمو نشان از عدم تطبیق قوانین مصوب مجلس با سیاست‌های کلی نظام دارد. با تدبیر حضرتعالی هیئت عالی نظارت مجمع تشخیص مصلحت برای رفع این معضل شکل گرفت، اما بعضی کج‌اندیشان درتلاشند این هیئت را غیرقانونی و صرفا مشورتی جلوه دهند، در حالیکه نظارت بر حسن اجرای سیاست‌های کلی نظام جزئی از اختیارات مصرح رهبری در اصل110  قانون اساسی است که به این هیئت تفویض شده است. از این رو از حضرتعالی درخواست می‌کنیم با عنایت به اختیارات قانونیتان در قانون اساسی، در صورت صلاحدید به عنوان فصل الخطاب به این مسئله بپردازید تا یکبار برای همیشه، تکلیف همگان در این زمینه روشن گردد.\n\nنماینده بسیج دانشجویی به لزوم تفکیک ریاست دو شورای عالی فضای مجازی و انقلاب فرهنگی از ریاست جمهوری اشاره کرد و گفت: حضرت آقا؛ در عرصه مقابله با جنگ نرم دشمن و تهاجم فرهنگی غرب بنظر می‌رسد بخشی از ناکارآمدی‌ها و عقب‌ماندگی‌های موجود، ناشی از ضعف ساختار اداره دو شورای عالی فضای مجازی و انقلاب فرهنگی است.\n\nوی تصریح کرد: چنانچه تفکیک ریاست مجمع تشخیص مصلحت نظام از جایگاه ریاست جمهوری سبب کارآمدی و ارتقاء جایگاه مجمع تشخیص شد، حال این پیشنهاد قابل بررسی است که به دلیل مشغله رؤسای دولت‌ها به امر مدیریت اجرایی که به کاهش کمی و کیفی جلسات این دو شورا انجامیده و هم‌چنین نیاز به سیاست‌گذاری یکپارچه و غیرجناحی نظام در مسائل فرهنگی و جنگ رسانه‌ای، تفکیک ریاست این دو شورای عالی از جایگاه ریاست جمهوری و انتصاب رؤسای مستقل از رؤسای قوا می‌تواند یک اقدام مؤثر برای نزدیک شدن خروجی سیاست‌گذاری این دو شورا به اهداف عالیه آن‌ها گردد؛ البته حضور مستمر رؤسای قوا و مسئولین اجرایی و تقنینی برای ضمانت هماهنگی اجرایی امور قطعا مورد تأکید است.\n\nشریفی در ادامه سخنان خود خطاب به رهبر انقلاب اظهار داشت: موارد فوق به این سوال مشخص منتهی می‌شود که چه میزان از مشکلات و مسائل کشور ناظر بر کارگزاران و مسئولین است و چه مقدار منتهی به ناکارآمدی برخی ساز و کار‌ها و ساختار‌ها؟! خوشحال می‌شویم که بدانیم در نگاه معظم له اشکالات امروز کشور و خاصتاً نظام سیاسی، اداری و اقتصادی را ناظر بر کارگزار می‌دانید و یا ساختار؟!","لزوم تفکیک ریاست شورای فضای مجازی و شورای انقلاب فرهنگی","","inherit","closed","closed","","1-autosave-v1","","","2019-08-03 13:14:06","2019-08-03 08:44:06","","1","http://islamic.demo-qaleb.ir/1-autosave-v1/","0","revision","","0"),
("334","2","2019-01-26 21:40:45","2019-01-26 18:10:45","<p class=\"rtejustify\">به گزارش خبرنگار اقتصادی وزیر راه و شهرسازی و فرمانده قرارگاه خاتم‌الانبیاء امروز پس از بازدید از آزادراه کنارگذر جنوبی تهران از عملیات اجرایی پیشرفت پروژه راه‌آهن سریع‌السیر تهران-قم-اصفهان بازدید کردند.</p>\r\n<p class=\"rtejustify\">این پروژه که برای اولین بار در کشور اجرا می‌شود به پیمانکاری قرارگاه خاتم‌الانبیاء و کارفرمایی دولت اجرا می‌شود.</p>\r\n<p class=\"rtejustify\">بنابراین گزارش، سردار عبادالله عبداللهی در حاشیه بازدید از عملیات اجرایی این پروژه بیان کرد: پروژه راه‌آهن سریع السیر تهران-قم-اصفهان به عنوان یک ابرپروژه مطرح است و باید به عنوان یک ابرپروژه باشد اما ما از روند این پروژه، مطالعات و همه موارد آن فعلاً رضایت خاصی نداریم.</p>\r\n<p class=\"rtejustify\">سردار عبداللهی افزود: این پروژه در دو قطعه تهران تا قم و قم تا اصفهان اجرا خواهد شد که روسازی قم تا اصفهان ۷۵ درصد پیشرفت فیزیکی دارد.</p>\r\n<p class=\"rtejustify\">بنابراین گزارش مدیرعامل شرکت ساخت و توسعه زیربناهای کشور در حاشیه این بازدید درباره راه‌آهن سریع‌السیر تهران – قم – اصفهان بیان کرد: اعتبارات اسنادی راه‌آ‌هن تهران- قم- اصفهان گشایش یافت و هم‌اکنون این پروژه در ۲ فاز تهران – قم – اصفهان فعال است.</p>\r\n<img class=\"size-medium aligncenter\" src=\"http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/Placko-new-building-plan-03.jpg\" width=\"1200\" height=\"646\" />\r\n<p class=\"rtejustify\">وی با بیان اینکه این پروژه اولین پروژه قطار سریع‌السیر در کشور است، گفت: پیمانکار در محل اجرا مستقر شده است.</p>\r\n<p class=\"rtejustify\">معاون وزیر راه و شهرسازی افزود: قرارگاه سازندگی خاتم‌الانبیاء به عنوان پیمانکار این پروژه با جونیت چینی که LC را آورده است در این پروژه فعال هستند.</p>\r\n<p class=\"rtejustify\">وی ادامه داد: در بخش قم تا اصفهان زیرسازی ۷۰ درصد پیشرفت فیزیکی دارد و در بخش تهران تا قم در مرحله فاز صفر مطالعاتی است.</p>\r\n<p class=\"rtejustify\">نورزاد با بیان اینکه شرکت آزمایشگاه‌ها در این پروژه مستقر شده است، بیان کرد: برنامه‌ریزی می‌کنیم که در فرودگاه امام خمینی (ره) ایستگاه قطار وجود داشته باشد.</p>\r\n<p class=\"rtejustify\">وی بیان کرد: در بخشی از این مسیر از کیلومتر ۲۰۹ به بعد در ۳۵ کیلومتر مشکل تملک اراضی در منطقه اصفهان داریم که ۹ کیلومتر آن منابع طبیعی است.</p>\r\n<p class=\"rtejustify\">معاون وزیر راه و شهرسازی گفت:‌در تعیین موقعیت ایستگاه اصفهان و عبور به سمت شیراز مطالعاتی قبلاً در شرکت ساخت و توسعه زیربناهای حمل‌ونقل انجام شده بود.</p>","بررسی جزئیات اجرای راه‌آهن سریع‌السیر تهران-قم-اصفهان","","inherit","closed","closed","","57-revision-v1","","","2019-01-26 21:40:45","2019-01-26 18:10:45","","57","http://islamic.demo-qaleb.ir/57-revision-v1/","0","revision","","0"),
("344","2","2019-08-03 13:28:58","2019-08-03 08:58:58","","دیدار اساتید دانشگاه","دیدار اساتید دانشگاه","inherit","open","closed","","%d8%af%db%8c%d8%af%d8%a7%d8%b1-%d8%a7%d8%b3%d8%a7%d8%aa%db%8c%d8%af-%d8%af%d8%a7%d9%86%d8%b4%da%af%d8%a7%d9%87","","","2019-08-03 13:28:58","2019-08-03 08:58:58","","1","http://islamic.demo-qaleb.ir/wp-content/uploads/2018/03/6.jpg","0","attachment","image/jpeg","0"),
("340","2","2019-08-03 13:23:53","2019-08-03 08:53:53","<p dir=\"RTL\">جمعی از دانشجویان عصر امروز با حضور در حسینیه امام خمینی (ره) با رهبر معظم انقلاب دیدار کردند.</p>\r\n<p dir=\"RTL\">علیرضا شریفی، از دانشجویان بسیجی به نمایندگی از بسیج دانشجویی در این نشست سخنانی را مطرح کرد.</p>\r\n<p dir=\"RTL\">وی در بخشی از سخنان خود اظهار داشت: امروز که در پنجمین دهه از عمر پر برکت انقلاب اسلامی به مدد حضرت ولی عصر (عج) و هدایت حکیمانه امام(ره) و رهبری مدبرانه حضرتعالی گام اول انقلاب که ترجمان جامع «ما می‌توانیم» بود، محقق شد، لیکن وجود مواردی اعم از نفوذ خوی اشرافیت و کاخ نشینی، نبود شفافیت و پاسخگویی در عملکرد‌ها، مرعوبیت و عدم مرزبندی برخی از مسئولان در برابر دشمن، در برهه‌هایی از این زمان چهل ساله باعث تلخی کام مردم عزیز ایران اسلامی شد.\r\n\r\nاین فعال دانشجویی با بیان اینکه اعتقاد ما این است که در طول این سال‌ها اگر قصوری دیده شد، به علت دوری و فاصله گرفتن کارگزاران نظام از آرمان‌های انقلاب بود و هر کجا که شاهد رشد، پیشرفت و اعتلای نظام و مردم بوده ایم، آن زمانی بوده است که مسئولین کشور با روحیه جهادی و انقلابی عامل به ارزش ها، اصول، آرمان‌ها و منویات امام و رهبری عزیز بودند، تصریح کرد: حال در ابتدای گام دوم انقلاب به عنوان افسران جوان جنگ نرم برآن شدیم نکاتی را با امام و ولی زمانمان در میان گذاریم تا ضمن بهره مندی از رهنمود‌های حکیمانه و هدایتگرانه شما، بتوانیم نقش و جایگاه خود را در مسیر رسیدن به تمدن نوین اسلامی بیش از پیش فهم کنیم.</p>\r\nشریفی افزود: در گام اول انقلاب که گام طراحی و ایجاد بستر‌های حکمرانی اسلامی بود، دانشگاه و دانشجو، به عنوان مبدا و محور تحولات در جامعه به ایفای نقش پرداختند.اکنون و در گام دوم و با توجه به پر رنگ بودن جایگاه نسل جوان در این مرحله، فرزندان بسیجی رهبر انقلاب در دانشگاه‌های سراسر کشور به عنوان مروجان حقیقت «نظام انقلابی» همت بر آن شده و دارند که با نگاهی تحولی و رویکردی مساله محور، مبتنی بر آرمان‌ها و واقعیت ها، نیاز‌های روز جامعه را از دریچه نگاه مردم دنبال و مطالبه کنند. از همین رو فرزندانتان، آمادگی کامل خود را جهت نظریه پردازی، طراحی الگو‌های ایجابی و تربیت نیرو‌های ملتزم در مسیر جوان سازی و مردمی سازی حکمرانی اعلام می‌دارند.\r\n\r\nنماینده بسیج دانشجوی با بیان اینکه در شرایط جنگ اقتصادی، تبیین و به کارگیری نظریه مقاومت در حوزه اقتصاد، ضرورتی اجتناب ناپذیر است، ادامه داد: اما امروز و در این جنگ اقتصادی آرایش جنگی متناسب از دولت مردان دیده نمی‌شود، چرا که عدم توانمندی در کنترل بازار، وجود احتکار، فعالیت شبکه خزنده اخلال گران اقتصادی و گرانی‌های افسار گسیخته موجب شده معیشت مردم به گروگان ناکارآمدی مسئولین درآید.\r\n\r\nوی تاکید کرد: در شرایطی که با برخی اقدامات مشخص مانند رشد صادرات فرآورده‌های نفتی و محصولات غیر نفتی، اتکای بودجه داخلی به مالیات و انجام طرح‌های معطل مانده نظیر مالیات بر عایدی سرمایه، مالیات بر مسکن خالی، مالیات برخی اقشار نظیر پزشکان و وکلا و یا با برقراری سامانه‌های مولد شفافیت، می‌توان با بسیاری از ناکارآمدی‌ها و سرچشمه‌های فساد مبارزه کرد. البته در این کشاکش صدایی از بهارستان به گوش نمی‌رسد. به نظر می‌آید نمایندگان نیز در حال گرفتن آرایش جنگی اند؛ اما خدا می‌داند انتخاباتی یا اقتصادی؟!\r\n\r\nاین دانشجوی بسیجی به نقش قوه قضائیه نیز در این بین اشاره کرد و گفت: از طرفی نقش قوه قضاییه به عنوان نظام قضایی که باید انقلابی باشد، در مسیر رسیدن به تمدن نوین اسلامی بسیار برجسته است. قوه عدلیه به عنوان نماد کارآمدی نظام اسلامی در برقراری عدالت و احقاق حقوق عامه در کنار برخورد قاطع با اهمال کاران و زالو صفتان اقتصادی بیشتر از قبل باید به مقوله ایجادِ ساز و کار‌های پیشگیری از جرائم و مفاسد کلان بپردازد.\r\n\r\nوی اضافه کرد: اینکه قوه محترم، دادگاه‌های علنی برپا دارد و با مجرمین با شدت برخورد کند خوب است، اما آنچه بهتر است حضور فعال دستگاه قضا در عرصه ایجاد نرم افزار‌های قدرتمند نظارت و پیشگیری است که بسیاری از مفاسد اقتصادی و اداری فعلی می توانند قبل از اینکه در رسانه‌ها و دادگاه‌ها آینه دق شوند و در مقابل چشمان مردم قرار بگیرند، پشت سدی از ساز و کار‌های دقیق بمانند و اساسا مبادی فساد زایی وجود نداشته باشد که محل سواستفاده فرصت طلبان شود.\r\n\r\nاین فعال دانشجویی با اشاره به اینکه امروز با نگاه کلان نسبت به معضلات نظام در می‌یابیم عمده آن‌ها ناشی از عدم انطباق قوانین و مصوبات با سیاست‌های کلی نظام است، یادآور شد:  نمونه‌های مختلفی نظیر قانون مدیریت خدمات کشوری، CFT و پالرمو نشان از عدم تطبیق قوانین مصوب مجلس با سیاست‌های کلی نظام دارد. با تدبیر حضرتعالی هیئت عالی نظارت مجمع تشخیص مصلحت برای رفع این معضل شکل گرفت، اما بعضی کج‌اندیشان درتلاشند این هیئت را غیرقانونی و صرفا مشورتی جلوه دهند، در حالیکه نظارت بر حسن اجرای سیاست‌های کلی نظام جزئی از اختیارات مصرح رهبری در اصل110  قانون اساسی است که به این هیئت تفویض شده است. از این رو از حضرتعالی درخواست می‌کنیم با عنایت به اختیارات قانونیتان در قانون اساسی، در صورت صلاحدید به عنوان فصل الخطاب به این مسئله بپردازید تا یکبار برای همیشه، تکلیف همگان در این زمینه روشن گردد.\r\n\r\nنماینده بسیج دانشجویی به لزوم تفکیک ریاست دو شورای عالی فضای مجازی و انقلاب فرهنگی از ریاست جمهوری اشاره کرد و گفت: حضرت آقا؛ در عرصه مقابله با جنگ نرم دشمن و تهاجم فرهنگی غرب بنظر می‌رسد بخشی از ناکارآمدی‌ها و عقب‌ماندگی‌های موجود، ناشی از ضعف ساختار اداره دو شورای عالی فضای مجازی و انقلاب فرهنگی است.\r\n\r\nوی تصریح کرد: چنانچه تفکیک ریاست مجمع تشخیص مصلحت نظام از جایگاه ریاست جمهوری سبب کارآمدی و ارتقاء جایگاه مجمع تشخیص شد، حال این پیشنهاد قابل بررسی است که به دلیل مشغله رؤسای دولت‌ها به امر مدیریت اجرایی که به کاهش کمی و کیفی جلسات این دو شورا انجامیده و هم‌چنین نیاز به سیاست‌گذاری یکپارچه و غیرجناحی نظام در مسائل فرهنگی و جنگ رسانه‌ای، تفکیک ریاست این دو شورای عالی از جایگاه ریاست جمهوری و انتصاب رؤسای مستقل از رؤسای قوا می‌تواند یک اقدام مؤثر برای نزدیک شدن خروجی سیاست‌گذاری این دو شورا به اهداف عالیه آن‌ها گردد؛ البته حضور مستمر رؤسای قوا و مسئولین اجرایی و تقنینی برای ضمانت هماهنگی اجرایی امور قطعا مورد تأکید است.\r\n\r\nشریفی در ادامه سخنان خود خطاب به رهبر انقلاب اظهار داشت: موارد فوق به این سوال مشخص منتهی می‌شود که چه میزان از مشکلات و مسائل کشور ناظر بر کارگزاران و مسئولین است و چه مقدار منتهی به ناکارآمدی برخی ساز و کار‌ها و ساختار‌ها؟! خوشحال می‌شویم که بدانیم در نگاه معظم له اشکالات امروز کشور و خاصتاً نظام سیاسی، اداری و اقتصادی را ناظر بر کارگزار می‌دانید و یا ساختار؟!","لزوم تفکیک ریاست شورای فضای مجازی و شورای انقلاب فرهنگی","","inherit","closed","closed","","1-revision-v1","","","2019-08-03 13:23:53","2019-08-03 08:53:53","","1","http://islamic.demo-qaleb.ir/1-revision-v1/","0","revision","","0"),
("342","2","2019-08-03 13:24:48","2019-08-03 08:54:48","<p dir=\"RTL\">جمعی از دانشجویان عصر امروز با حضور در حسینیه امام خمینی (ره) با رهبر معظم انقلاب دیدار کردند.</p>\r\n<p dir=\"RTL\">علیرضا شریفی، از دانشجویان بسیجی به نمایندگی از بسیج دانشجویی در این نشست سخنانی را مطرح کرد.</p>\r\n<p dir=\"RTL\">وی در بخشی از سخنان خود اظهار داشت: امروز که در پنجمین دهه از عمر پر برکت انقلاب اسلامی به مدد حضرت ولی عصر (عج) و هدایت حکیمانه امام(ره) و رهبری مدبرانه حضرتعالی گام اول انقلاب که ترجمان جامع «ما می‌توانیم» بود، محقق شد، لیکن وجود مواردی اعم از نفوذ خوی اشرافیت و کاخ نشینی، نبود شفافیت و پاسخگویی در عملکرد‌ها، مرعوبیت و عدم مرزبندی برخی از مسئولان در برابر دشمن، در برهه‌هایی از این زمان چهل ساله باعث تلخی کام مردم عزیز ایران اسلامی شد.</p>\r\nاین فعال دانشجویی با بیان اینکه اعتقاد ما این است که در طول این سال‌ها اگر قصوری دیده شد، به علت دوری و فاصله گرفتن کارگزاران نظام از آرمان‌های انقلاب بود و هر کجا که شاهد رشد، پیشرفت و اعتلای نظام و مردم بوده ایم، آن زمانی بوده است که مسئولین کشور با روحیه جهادی و انقلابی عامل به ارزش ها، اصول، آرمان‌ها و منویات امام و رهبری عزیز بودند، تصریح کرد: حال در ابتدای گام دوم انقلاب به عنوان افسران جوان جنگ نرم برآن شدیم نکاتی را با امام و ولی زمانمان در میان گذاریم تا ضمن بهره مندی از رهنمود‌های حکیمانه و هدایتگرانه شما، بتوانیم نقش و جایگاه خود را در مسیر رسیدن به تمدن نوین اسلامی بیش از پیش فهم کنیم.\r\n\r\nشریفی افزود: در گام اول انقلاب که گام طراحی و ایجاد بستر‌های حکمرانی اسلامی بود، دانشگاه و دانشجو، به عنوان مبدا و محور تحولات در جامعه به ایفای نقش پرداختند.اکنون و در گام دوم و با توجه به پر رنگ بودن جایگاه نسل جوان در این مرحله، فرزندان بسیجی رهبر انقلاب در دانشگاه‌های سراسر کشور به عنوان مروجان حقیقت «نظام انقلابی» همت بر آن شده و دارند که با نگاهی تحولی و رویکردی مساله محور، مبتنی بر آرمان‌ها و واقعیت ها، نیاز‌های روز جامعه را از دریچه نگاه مردم دنبال و مطالبه کنند. از همین رو فرزندانتان، آمادگی کامل خود را جهت نظریه پردازی، طراحی الگو‌های ایجابی و تربیت نیرو‌های ملتزم در مسیر جوان سازی و مردمی سازی حکمرانی اعلام می‌دارند.\r\n\r\nنماینده بسیج دانشجوی با بیان اینکه در شرایط جنگ اقتصادی، تبیین و به کارگیری نظریه مقاومت در حوزه اقتصاد، ضرورتی اجتناب ناپذیر است، ادامه داد: اما امروز و در این جنگ اقتصادی آرایش جنگی متناسب از دولت مردان دیده نمی‌شود، چرا که عدم توانمندی در کنترل بازار، وجود احتکار، فعالیت شبکه خزنده اخلال گران اقتصادی و گرانی‌های افسار گسیخته موجب شده معیشت مردم به گروگان ناکارآمدی مسئولین درآید.\r\n\r\nوی تاکید کرد: در شرایطی که با برخی اقدامات مشخص مانند رشد صادرات فرآورده‌های نفتی و محصولات غیر نفتی، اتکای بودجه داخلی به مالیات و انجام طرح‌های معطل مانده نظیر مالیات بر عایدی سرمایه، مالیات بر مسکن خالی، مالیات برخی اقشار نظیر پزشکان و وکلا و یا با برقراری سامانه‌های مولد شفافیت، می‌توان با بسیاری از ناکارآمدی‌ها و سرچشمه‌های فساد مبارزه کرد. البته در این کشاکش صدایی از بهارستان به گوش نمی‌رسد. به نظر می‌آید نمایندگان نیز در حال گرفتن آرایش جنگی اند؛ اما خدا می‌داند انتخاباتی یا اقتصادی؟!\r\n\r\nاین دانشجوی بسیجی به نقش قوه قضائیه نیز در این بین اشاره کرد و گفت: از طرفی نقش قوه قضاییه به عنوان نظام قضایی که باید انقلابی باشد، در مسیر رسیدن به تمدن نوین اسلامی بسیار برجسته است. قوه عدلیه به عنوان نماد کارآمدی نظام اسلامی در برقراری عدالت و احقاق حقوق عامه در کنار برخورد قاطع با اهمال کاران و زالو صفتان اقتصادی بیشتر از قبل باید به مقوله ایجادِ ساز و کار‌های پیشگیری از جرائم و مفاسد کلان بپردازد.\r\n\r\nوی اضافه کرد: اینکه قوه محترم، دادگاه‌های علنی برپا دارد و با مجرمین با شدت برخورد کند خوب است، اما آنچه بهتر است حضور فعال دستگاه قضا در عرصه ایجاد نرم افزار‌های قدرتمند نظارت و پیشگیری است که بسیاری از مفاسد اقتصادی و اداری فعلی می توانند قبل از اینکه در رسانه‌ها و دادگاه‌ها آینه دق شوند و در مقابل چشمان مردم قرار بگیرند، پشت سدی از ساز و کار‌های دقیق بمانند و اساسا مبادی فساد زایی وجود نداشته باشد که محل سواستفاده فرصت طلبان شود.\r\n\r\nاین فعال دانشجویی با اشاره به اینکه امروز با نگاه کلان نسبت به معضلات نظام در می‌یابیم عمده آن‌ها ناشی از عدم انطباق قوانین و مصوبات با سیاست‌های کلی نظام است، یادآور شد:  نمونه‌های مختلفی نظیر قانون مدیریت خدمات کشوری، CFT و پالرمو نشان از عدم تطبیق قوانین مصوب مجلس با سیاست‌های کلی نظام دارد. با تدبیر حضرتعالی هیئت عالی نظارت مجمع تشخیص مصلحت برای رفع این معضل شکل گرفت، اما بعضی کج‌اندیشان درتلاشند این هیئت را غیرقانونی و صرفا مشورتی جلوه دهند، در حالیکه نظارت بر حسن اجرای سیاست‌های کلی نظام جزئی از اختیارات مصرح رهبری در اصل110  قانون اساسی است که به این هیئت تفویض شده است. از این رو از حضرتعالی درخواست می‌کنیم با عنایت به اختیارات قانونیتان در قانون اساسی، در صورت صلاحدید به عنوان فصل الخطاب به این مسئله بپردازید تا یکبار برای همیشه، تکلیف همگان در این زمینه روشن گردد.\r\n\r\nنماینده بسیج دانشجویی به لزوم تفکیک ریاست دو شورای عالی فضای مجازی و انقلاب فرهنگی از ریاست جمهوری اشاره کرد و گفت: حضرت آقا؛ در عرصه مقابله با جنگ نرم دشمن و تهاجم فرهنگی غرب بنظر می‌رسد بخشی از ناکارآمدی‌ها و عقب‌ماندگی‌های موجود، ناشی از ضعف ساختار اداره دو شورای عالی فضای مجازی و انقلاب فرهنگی است.\r\n\r\nوی تصریح کرد: چنانچه تفکیک ریاست مجمع تشخیص مصلحت نظام از جایگاه ریاست جمهوری سبب کارآمدی و ارتقاء جایگاه مجمع تشخیص شد، حال این پیشنهاد قابل بررسی است که به دلیل مشغله رؤسای دولت‌ها به امر مدیریت اجرایی که به کاهش کمی و کیفی جلسات این دو شورا انجامیده و هم‌چنین نیاز به سیاست‌گذاری یکپارچه و غیرجناحی نظام در مسائل فرهنگی و جنگ رسانه‌ای، تفکیک ریاست این دو شورای عالی از جایگاه ریاست جمهوری و انتصاب رؤسای مستقل از رؤسای قوا می‌تواند یک اقدام مؤثر برای نزدیک شدن خروجی سیاست‌گذاری این دو شورا به اهداف عالیه آن‌ها گردد؛ البته حضور مستمر رؤسای قوا و مسئولین اجرایی و تقنینی برای ضمانت هماهنگی اجرایی امور قطعا مورد تأکید است.\r\n\r\nشریفی در ادامه سخنان خود خطاب به رهبر انقلاب اظهار داشت: موارد فوق به این سوال مشخص منتهی می‌شود که چه میزان از مشکلات و مسائل کشور ناظر بر کارگزاران و مسئولین است و چه مقدار منتهی به ناکارآمدی برخی ساز و کار‌ها و ساختار‌ها؟! خوشحال می‌شویم که بدانیم در نگاه معظم له اشکالات امروز کشور و خاصتاً نظام سیاسی، اداری و اقتصادی را ناظر بر کارگزار می‌دانید و یا ساختار؟!","لزوم تفکیک ریاست شورای فضای مجازی و شورای انقلاب فرهنگی","","inherit","closed","closed","","1-revision-v1","","","2019-08-03 13:24:48","2019-08-03 08:54:48","","1","http://islamic.demo-qaleb.ir/1-revision-v1/","0","revision","","0"),
("345","2","2019-08-03 15:09:25","2019-08-03 10:39:25","","logo2","","inherit","open","closed","","logo2","","","2019-08-03 15:09:25","2019-08-03 10:39:25","","0","http://islamic.demo-qaleb.ir/wp-content/uploads/2019/08/logo2.png","0","attachment","image/png","0"),
("350","2","2019-08-03 15:27:39","2019-08-03 10:57:39","","صفحه نخست 2","","publish","closed","closed","","%d8%b5%d9%81%d8%ad%d9%87-%d9%86%d8%ae%d8%b3%d8%aa-2","","","2019-08-03 15:39:39","2019-08-03 11:09:39","","0","http://islamic.demo-qaleb.ir/?p=350","3","nav_menu_item","","0"),
("367","2","2019-09-28 15:43:45","2019-09-28 12:13:45","این یک برگه‌ی نمونه است که با یک نوشته در وبلاگ تفاوت دارد زیرا برگه‌ها در یک مکان ثابت می‌مانند و معمولاً در فهرست پیوندهای درونی سایت شما نمایش داده می‌شوند (در بیشتر پوسته‌ها). بیشتر افراد کار کردن با برگه‌ها را از یک برگه‌ی «درباره من» که آن‌ها را به خوانندگان سایت معرفی می‌کند، شروع می‌کنند. برای مثال این‌چنین می‌گویند:\r\n<blockquote>سلام دوستان، من روزها یک کارمند اداری هستم و شب‌ها یک راننده تاکسی، این وبلاگ من است. من در اهواز زندگی می‌کنم که شهری در جنوب غربی ایران است.</blockquote>\r\nیا چیزی شبیه این:\r\n<blockquote>شرکت XYZ در سال ۱۳۶۵ تاسیس شد و ارائه‌دهنده محصولات صنعتی است. این شرکت ۲۰۰۰ کارگر و کارمند دارد. امیدواریم از محصولات ما راضی باشید.</blockquote>\r\nبه‌عنوان یک کاربر تازه‌ی وردپرس فارسی شما برای پاک کردن این برگه و ساختن برگه‌های تازه می‌توانید به پیشخوان خود مراجعه کنید. موفق باشید","درباره ما","","inherit","closed","closed","","170-revision-v1","","","2019-09-28 15:43:45","2019-09-28 12:13:45","","170","http://islamic.demo-qaleb.ir/170-revision-v1/","0","revision","","0"),
("362","2","2019-09-28 15:28:33","2019-09-28 11:58:33","این یک برگه‌ی نمونه است که با یک نوشته در وبلاگ تفاوت دارد زیرا برگه‌ها در یک مکان ثابت می‌مانند و معمولاً در فهرست پیوندهای درونی سایت شما نمایش داده می‌شوند (در بیشتر پوسته‌ها). بیشتر افراد کار کردن با برگه‌ها را از یک برگه‌ی «درباره من» که آن‌ها را به خوانندگان سایت معرفی می‌کند، شروع می‌کنند. برای مثال این‌چنین می‌گویند:\r\n<blockquote>سلام دوستان، من روزها یک کارمند اداری هستم و شب‌ها یک راننده تاکسی، این وبلاگ من است. من در اهواز زندگی می‌کنم که شهری در جنوب غربی ایران است.</blockquote>\r\nیا چیزی شبیه این:\r\n<blockquote>شرکت XYZ در سال ۱۳۶۵ تاسیس شد و ارائه‌دهنده محصولات صنعتی است. این شرکت ۲۰۰۰ کارگر و کارمند دارد. امیدواریم از محصولات ما راضی باشید.</blockquote>\r\nبه‌عنوان یک کاربر تازه‌ی وردپرس فارسی شما برای پاک کردن این برگه و ساختن برگه‌های تازه می‌توانید به پیشخوان خود مراجعه کنید. موفق باشید!\r\n\r\n&nbsp;\r\n\r\n[su_tabs active=\"2\" vertical=\"yes\"][su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab] [su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab] [su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab][/su_tabs]","درباره ما","","inherit","closed","closed","","170-revision-v1","","","2019-09-28 15:28:33","2019-09-28 11:58:33","","170","http://islamic.demo-qaleb.ir/170-revision-v1/","0","revision","","0"),
("363","2","2019-09-28 15:29:25","2019-09-28 11:59:25","این یک برگه‌ی نمونه است که با یک نوشته در وبلاگ تفاوت دارد زیرا برگه‌ها در یک مکان ثابت می‌مانند و معمولاً در فهرست پیوندهای درونی سایت شما نمایش داده می‌شوند (در بیشتر پوسته‌ها). بیشتر افراد کار کردن با برگه‌ها را از یک برگه‌ی «درباره من» که آن‌ها را به خوانندگان سایت معرفی می‌کند، شروع می‌کنند. برای مثال این‌چنین می‌گویند:\r\n<blockquote>سلام دوستان، من روزها یک کارمند اداری هستم و شب‌ها یک راننده تاکسی، این وبلاگ من است. من در اهواز زندگی می‌کنم که شهری در جنوب غربی ایران است.</blockquote>\r\nیا چیزی شبیه این:\r\n<blockquote>شرکت XYZ در سال ۱۳۶۵ تاسیس شد و ارائه‌دهنده محصولات صنعتی است. این شرکت ۲۰۰۰ کارگر و کارمند دارد. امیدواریم از محصولات ما راضی باشید.</blockquote>\r\nبه‌عنوان یک کاربر تازه‌ی وردپرس فارسی شما برای پاک کردن این برگه و ساختن برگه‌های تازه می‌توانید به پیشخوان خود مراجعه کنید. موفق باشید!\r\n\r\n[su_tabs active=\"2\" vertical=\"yes\"][su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab] [su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab] [su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab][/su_tabs]","درباره ما","","inherit","closed","closed","","170-revision-v1","","","2019-09-28 15:29:25","2019-09-28 11:59:25","","170","http://islamic.demo-qaleb.ir/170-revision-v1/","0","revision","","0"),
("366","2","2019-09-28 15:33:50","2019-09-28 12:03:50","این یک برگه‌ی نمونه است که با یک نوشته در وبلاگ تفاوت دارد زیرا برگه‌ها در یک مکان ثابت می‌مانند و معمولاً در فهرست پیوندهای درونی سایت شما نمایش داده می‌شوند (در بیشتر پوسته‌ها). بیشتر افراد کار کردن با برگه‌ها را از یک برگه‌ی «درباره من» که آن‌ها را به خوانندگان سایت معرفی می‌کند، شروع می‌کنند. برای مثال این‌چنین می‌گویند:\r\n<blockquote>سلام دوستان، من روزها یک کارمند اداری هستم و شب‌ها یک راننده تاکسی، این وبلاگ من است. من در اهواز زندگی می‌کنم که شهری در جنوب غربی ایران است.</blockquote>\r\nیا چیزی شبیه این:\r\n<blockquote>شرکت XYZ در سال ۱۳۶۵ تاسیس شد و ارائه‌دهنده محصولات صنعتی است. این شرکت ۲۰۰۰ کارگر و کارمند دارد. امیدواریم از محصولات ما راضی باشید.</blockquote>\r\nبه‌عنوان یک کاربر تازه‌ی وردپرس فارسی شما برای پاک کردن این برگه و ساختن برگه‌های تازه می‌توانید به پیشخوان خود مراجعه کنید. موفق باشید!\r\n\r\n[su_tabs active=\"2\" vertical=\"yes\"][su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab] [su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab] [su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab][/su_tabs]","درباره ما","","inherit","closed","closed","","170-revision-v1","","","2019-09-28 15:33:50","2019-09-28 12:03:50","","170","http://islamic.demo-qaleb.ir/170-revision-v1/","0","revision","","0"),
("365","2","2019-09-28 15:33:32","2019-09-28 12:03:32","[tabs]\r\n[tab title=\"Tab 1 Title\"]\r\nTab 1 text goes here.\r\n[/tab]\r\n[tab title=\"Tab 2 Title\"]\r\nTab 2 text goes here.\r\n[/tab]\r\n[tab title=\"Tab 3 Title\"]\r\nTab 3 text goes here.\r\n[/tab]\r\n[/tabs]\r\n\r\n&nbsp;\r\n\r\nاین یک برگه‌ی نمونه است که با یک نوشته در وبلاگ تفاوت دارد زیرا برگه‌ها در یک مکان ثابت می‌مانند و معمولاً در فهرست پیوندهای درونی سایت شما نمایش داده می‌شوند (در بیشتر پوسته‌ها). بیشتر افراد کار کردن با برگه‌ها را از یک برگه‌ی «درباره من» که آن‌ها را به خوانندگان سایت معرفی می‌کند، شروع می‌کنند. برای مثال این‌چنین می‌گویند:\r\n<blockquote>سلام دوستان، من روزها یک کارمند اداری هستم و شب‌ها یک راننده تاکسی، این وبلاگ من است. من در اهواز زندگی می‌کنم که شهری در جنوب غربی ایران است.</blockquote>\r\nیا چیزی شبیه این:\r\n<blockquote>شرکت XYZ در سال ۱۳۶۵ تاسیس شد و ارائه‌دهنده محصولات صنعتی است. این شرکت ۲۰۰۰ کارگر و کارمند دارد. امیدواریم از محصولات ما راضی باشید.</blockquote>\r\nبه‌عنوان یک کاربر تازه‌ی وردپرس فارسی شما برای پاک کردن این برگه و ساختن برگه‌های تازه می‌توانید به پیشخوان خود مراجعه کنید. موفق باشید!\r\n\r\n[su_tabs active=\"2\" vertical=\"yes\"][su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab] [su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab] [su_tab title=\"Tab name\" disabled=\"no\" anchor=\"\" url=\"\" target=\"blank\" class=\"\"]Tab content[/su_tab][/su_tabs]","درباره ما","","inherit","closed","closed","","170-revision-v1","","","2019-09-28 15:33:32","2019-09-28 12:03:32","","170","http://islamic.demo-qaleb.ir/170-revision-v1/","0","revision","","0"),
("370","2","2020-06-22 16:42:31","2020-06-22 12:12:31","<a href=\"http://islamic.demo-qaleb.ir/\">محمد عجمی مشاور</a> استاندار و مدیرکل امور اتباع و مهاجرین خارجی استان خراسان رضوی در گفت و گو با خبرنگار مهر اعلام کرد: بر اساس این بند که در سال 1396 مصوب شده به اتباع خارجی که دارای کارت آمایش معتبر هستند طبق ضوابطی گواهینامه راهنمایی و رانندگی اعطا می شود.\r\n<div class=\"full-text\">\r\n\r\nوی افزود: در حال حاضر دستورالعمل اجرایی که این امر چگونه و با چه کم و کیف و به چه گروه‌هایی ارائه شود هنوز ابلاغ نشده و به محض ابلاغ آن بلافاصله اطلاع‌رسانی خواهد شد تا اتباع خارجی که با کارت آمایش معتبر مقیم ایران هستند بتوانند برای اخذ گواهینامه رانندگی اقدام کرده و تشکیل پرونده بدهند.\r\n\r\nعجمی گفت: موضوع اعطای گواهینامه رانندگی به اتباع خارجی دارای کارت آمایش معتبر در سال 1397 همچون سال گذشته توسط اداره کل اتباع وزارت کشور پیگیری خواهد شد و امیدواریم که در سال جاری نوید بخش اجرایی شدن این موضوع باشیم.\r\n\r\nمشاور استاندار خراسان رضوی خاطرنشان کرد: خروج و مراجعت اتباع خارجی دارای کارت آمایش در اواخر سال 1396 به تصویب رسیده و به دلیل پایان سال و تعطیلات نوروزی دستورالعمل اجرایی آن اعلام نشد و به محض ابلاغ جزئیات اجرای آن به استان‌ها اطلاع‌رسانی خواهد شد.\r\n\r\nمدیرکل امور اتباع خارجی خراسان رضوی در ادامه گفت: ما نیز مشتاق هستیم تا خروج و مراجعت اتباع خارجی دارای کارت آمایش در چارچوب ضوابط و مقرراتی که اعلام خواهد شد عملیاتی شود.\r\n\r\nوی تأکید کرد: موضوعات مرتبط با مهاجرین افغانستانی مقیم ایران همواره در جلسات مقامات و دیپلمات‌های دو کشور مورد بحث و تبادل نظر قرار می‌گیرد.\r\n\r\nعجمی خاطرنشان کرد: چنانچه در مذاکرات مقامات جمهوری اسلامی ایران و جمهوری اسلامی افغانستان توافقاتی انجام پذیرد توافقات به اداره کل اتباع وزارت کشور اعلام می‌شود.\r\n\r\n</div>","اعطای گواهینامه رانندگی به اتباع خارجی دارای کارت آمایش","","inherit","closed","closed","","33-revision-v1","","","2020-06-22 16:42:31","2020-06-22 12:12:31","","33","http://islamic.demo-qaleb.ir/33-revision-v1/","0","revision","","0"),
("371","2","2020-06-22 16:42:59","2020-06-22 12:12:59","<a href=\"http://islamic.demo-qaleb.ir/\"><span style=\"color: #ff0000;\">محمد عجمی مشاور</span></a> استاندار و مدیرکل امور اتباع و مهاجرین خارجی استان خراسان رضوی در گفت و گو با خبرنگار مهر اعلام کرد: بر اساس این بند که در سال 1396 مصوب شده به اتباع خارجی که دارای کارت آمایش معتبر هستند طبق ضوابطی گواهینامه راهنمایی و رانندگی اعطا می شود.\r\n<div class=\"full-text\">\r\n\r\nوی افزود: در حال حاضر دستورالعمل اجرایی که این امر چگونه و با چه کم و کیف و به چه گروه‌هایی ارائه شود هنوز ابلاغ نشده و به محض ابلاغ آن بلافاصله اطلاع‌رسانی خواهد شد تا اتباع خارجی که با کارت آمایش معتبر مقیم ایران هستند بتوانند برای اخذ گواهینامه رانندگی اقدام کرده و تشکیل پرونده بدهند.\r\n\r\nعجمی گفت: موضوع اعطای گواهینامه رانندگی به اتباع خارجی دارای کارت آمایش معتبر در سال 1397 همچون سال گذشته توسط اداره کل اتباع وزارت کشور پیگیری خواهد شد و امیدواریم که در سال جاری نوید بخش اجرایی شدن این موضوع باشیم.\r\n\r\nمشاور استاندار خراسان رضوی خاطرنشان کرد: خروج و مراجعت اتباع خارجی دارای کارت آمایش در اواخر سال 1396 به تصویب رسیده و به دلیل پایان سال و تعطیلات نوروزی دستورالعمل اجرایی آن اعلام نشد و به محض ابلاغ جزئیات اجرای آن به استان‌ها اطلاع‌رسانی خواهد شد.\r\n\r\nمدیرکل امور اتباع خارجی خراسان رضوی در ادامه گفت: ما نیز مشتاق هستیم تا خروج و مراجعت اتباع خارجی دارای کارت آمایش در چارچوب ضوابط و مقرراتی که اعلام خواهد شد عملیاتی شود.\r\n\r\nوی تأکید کرد: موضوعات مرتبط با مهاجرین افغانستانی مقیم ایران همواره در جلسات مقامات و دیپلمات‌های دو کشور مورد بحث و تبادل نظر قرار می‌گیرد.\r\n\r\nعجمی خاطرنشان کرد: چنانچه در مذاکرات مقامات جمهوری اسلامی ایران و جمهوری اسلامی افغانستان توافقاتی انجام پذیرد توافقات به اداره کل اتباع وزارت کشور اعلام می‌شود.\r\n\r\n</div>","اعطای گواهینامه رانندگی به اتباع خارجی دارای کارت آمایش","","inherit","closed","closed","","33-revision-v1","","","2020-06-22 16:42:59","2020-06-22 12:12:59","","33","http://islamic.demo-qaleb.ir/33-revision-v1/","0","revision","","0"),
("377","2","2021-08-10 13:55:03","2021-08-10 09:25:03","<label> Your name\n    [text* your-name] </label>\n\n<label> Your email\n    [email* your-email] </label>\n\n<label> موضوع\n    [text* your-subject] </label>\n\n<label> Your message (optional)\n    [textarea your-message] </label>\n\n[submit \"Submit\"]\n[_site_title] \"[your-subject]\"\n[_site_title] <wordpress@islamic.demo-qaleb.ir>\nاز : [your-name] <[your-email]>\nموضوع: [your-subject]\n\nمحتوای پیام :\n[your-message]\n\n-- \nاین ایمیل از فرم تماس در [_site_title] ([_site_url]) ارسال شده است.\n[_site_admin_email]\nReply-To: [your-email]\n\n0\n0\n\n[_site_title] \"[your-subject]\"\n[_site_title] <wordpress@islamic.demo-qaleb.ir>\nمحتوای پیام :\n[your-message]\n\n-- \nاین ایمیل از فرم تماس در [_site_title] ([_site_url]) ارسال شده است.\n[your-email]\nReply-To: [_site_admin_email]\n\n0\n0\nاز پیام شما متشکریم، پیام شما با موفقیت ارسال شد.\nمشکلی در ارسال پیام شما بوجود آمده است، لطفا دوباره تلاش کنید.\nیک یا چند تا از مقادیر وارد شده مشکل دارد، لطفا پس از بررسی دوباره تلاش کنید.\nمشکلی در ارسال پیام شما بوجود آمده است، لطفا دوباره تلاش کنید.\nشما باید با شرایط و قوانین موافقت کنید تا قادر به ارسال پیام باشید.\nپر کردن این قسمت اجباری است.\nمقدار وارد شده طولانی است.\nمقدار وارد شده کوتاه است.\nمشکلی در آپلود فایل شما رخ داده است.\nشما اجازه ندارید از این نوع فایل آپلود کنید.\nحجم فایل شما بسیار زیاد است.\nمشکلی در آپلود فایل شما رخ داده است.","فرم تماس 1","","publish","closed","closed","","%d9%81%d8%b1%d9%85-%d8%aa%d9%85%d8%a7%d8%b3-1","","","2021-08-10 13:55:03","2021-08-10 09:25:03","","0","http://islamic.demo-qaleb.ir/?post_type=wpcf7_contact_form&p=377","0","wpcf7_contact_form","","0");


/* INSERT TABLE DATA: wp_term_relationships */
INSERT INTO `wp_term_relationships` VALUES 
("9","11","0"),
("10","11","0"),
("11","11","0"),
("12","11","0"),
("13","11","0"),
("14","11","0"),
("16","11","0"),
("17","11","0"),
("358","11","0"),
("15","11","0"),
("1","58","0"),
("1","12","0"),
("1","15","0"),
("1","16","0"),
("1","60","0"),
("27","1","0"),
("27","7","0"),
("27","17","0"),
("27","12","0"),
("27","14","0"),
("27","13","0"),
("27","15","0"),
("30","1","0"),
("30","18","0"),
("30","19","0"),
("30","20","0"),
("30","10","0"),
("30","17","0"),
("30","6","0"),
("33","1","0"),
("33","6","0"),
("33","10","0"),
("33","9","0"),
("36","1","0"),
("36","8","0"),
("36","2","0"),
("36","9","0"),
("36","21","0"),
("36","12","0"),
("36","22","0"),
("39","1","0"),
("39","6","0"),
("39","8","0"),
("39","2","0"),
("39","19","0"),
("39","22","0"),
("39","12","0"),
("39","16","0"),
("42","1","0"),
("42","5","0"),
("42","10","0"),
("42","2","0"),
("42","17","0"),
("42","9","0"),
("42","20","0"),
("42","19","0"),
("42","15","0"),
("42","16","0"),
("42","23","0"),
("45","1","0"),
("45","5","0"),
("45","8","0"),
("45","2","0"),
("45","24","0"),
("45","23","0"),
("45","19","0"),
("45","12","0"),
("45","22","0"),
("48","1","0"),
("48","4","0"),
("48","8","0"),
("48","2","0"),
("48","17","0"),
("48","19","0"),
("48","23","0"),
("48","20","0"),
("48","25","0"),
("51","1","0"),
("51","4","0"),
("51","10","0"),
("51","2","0"),
("51","3","0"),
("51","17","0"),
("51","12","0"),
("51","23","0"),
("51","19","0"),
("51","15","0"),
("51","26","0"),
("54","1","0"),
("54","26","0"),
("54","16","0"),
("54","19","0"),
("54","23","0"),
("54","15","0"),
("54","22","0"),
("57","1","0"),
("57","5","0"),
("57","2","0"),
("57","24","0"),
("57","21","0"),
("57","15","0"),
("57","12","0"),
("60","1","0"),
("60","5","0"),
("60","10","0"),
("60","27","0"),
("60","28","0"),
("60","29","0"),
("60","19","0"),
("60","12","0"),
("63","1","0"),
("63","5","0"),
("63","8","0"),
("63","10","0"),
("63","2","0"),
("63","9","0"),
("63","26","0"),
("63","16","0"),
("63","12","0"),
("63","22","0"),
("66","31","0"),
("66","30","0"),
("70","26","0"),
("70","30","0"),
("70","16","0"),
("73","30","0"),
("73","31","0"),
("73","32","0"),
("77","19","0"),
("77","30","0"),
("77","23","0"),
("77","32","0"),
("80","32","0"),
("80","30","0"),
("80","29","0"),
("80","31","0"),
("80","28","0"),
("84","34","0"),
("84","35","0"),
("84","33","0"),
("94","19","0"),
("94","6","0"),
("94","7","0"),
("94","2","0"),
("94","3","0"),
("94","9","0"),
("94","23","0"),
("94","25","0"),
("94","24","0"),
("94","13","0"),
("97","1","0"),
("97","6","0"),
("97","3","0"),
("97","26","0"),
("97","23","0"),
("97","16","0"),
("97","12","0"),
("97","19","0"),
("100","1","0"),
("100","6","0"),
("100","8","0"),
("100","2","0"),
("100","19","0"),
("100","16","0"),
("100","18","0"),
("100","21","0"),
("100","28","0"),
("106","1","0"),
("106","6","0"),
("106","2","0"),
("106","26","0"),
("106","23","0"),
("106","16","0"),
("106","12","0"),
("109","36","0"),
("112","1","0"),
("112","4","0"),
("112","3","0"),
("112","17","0"),
("116","35","0"),
("116","37","0"),
("116","38","0"),
("116","33","0"),
("113","39","0"),
("129","40","0"),
("129","41","0"),
("129","42","0"),
("129","43","0"),
("129","33","0"),
("137","44","0"),
("139","44","0"),
("138","44","0"),
("140","44","0"),
("142","44","0"),
("143","44","0"),
("144","44","0"),
("145","48","0"),
("145","39","0"),
("149","48","0"),
("149","39","0"),
("153","48","0"),
("153","36","0"),
("156","1","0"),
("156","19","0"),
("156","23","0"),
("156","26","0"),
("156","25","0"),
("159","41","0"),
("159","43","0"),
("159","34","0"),
("159","35","0"),
("159","45","0"),
("159","47","0"),
("165","49","0"),
("166","49","0"),
("167","49","0"),
("168","49","0"),
("172","44","0"),
("173","44","0"),
("174","11","0"),
("175","11","0"),
("176","11","0"),
("177","11","0"),
("178","11","0"),
("179","11","0"),
("180","11","0"),
("181","11","0"),
("182","11","0"),
("183","11","0"),
("184","11","0"),
("232","11","0"),
("231","11","0"),
("235","11","0"),
("234","11","0"),
("230","11","0"),
("233","11","0"),
("351","11","0"),
("349","11","0"),
("350","11","0"),
("353","11","0"),
("260","54","0"),
("260","55","0"),
("260","53","0"),
("268","54","0"),
("268","55","0"),
("268","53","0"),
("271","54","0"),
("271","55","0"),
("271","53","0"),
("272","54","0"),
("272","55","0"),
("272","53","0"),
("273","54","0"),
("273","55","0"),
("273","53","0"),
("270","54","0"),
("270","55","0"),
("270","53","0"),
("278","26","0"),
("278","4","0"),
("278","2","0"),
("278","15","0"),
("278","29","0"),
("278","25","0"),
("289","48","0"),
("289","39","0"),
("292","42","0"),
("292","35","0"),
("292","45","0"),
("292","47","0"),
("292","46","0"),
("300","42","0"),
("300","38","0"),
("300","40","0"),
("300","45","0"),
("300","47","0"),
("300","33","0"),
("308","56","0"),
("308","8","0"),
("308","7","0"),
("308","2","0"),
("308","57","0"),
("308","58","0"),
("308","4","0"),
("112","26","0"),
("112","23","0"),
("112","15","0"),
("112","12","0"),
("112","18","0"),
("1","59","0");


/* INSERT TABLE DATA: wp_term_taxonomy */
INSERT INTO `wp_term_taxonomy` VALUES 
("1","1","category","","0","18"),
("2","2","category","","0","13"),
("3","3","category","","0","4"),
("4","4","category","","1","5"),
("5","5","category","","1","5"),
("6","6","category","","1","7"),
("7","7","category","","1","3"),
("8","8","category","","1","7"),
("9","9","category","","0","5"),
("10","10","category","","0","6"),
("11","11","nav_menu","","0","31"),
("12","12","post_tag","","0","12"),
("13","13","post_tag","","0","2"),
("14","14","post_tag","","0","1"),
("15","15","post_tag","","0","8"),
("16","16","post_tag","","0","9"),
("17","17","category","","0","6"),
("18","18","post_tag","","0","3"),
("19","19","post_tag","","0","13"),
("20","20","post_tag","","0","3"),
("21","21","post_tag","","0","3"),
("22","22","post_tag","","0","5"),
("23","23","post_tag","","0","11"),
("24","24","post_tag","","0","3"),
("25","25","post_tag","","0","4"),
("26","26","post_tag","","0","9"),
("27","27","post_tag","","0","1"),
("28","28","post_tag","","0","3"),
("29","29","post_tag","","0","3"),
("30","30","category","","0","5"),
("31","31","post_tag","","0","3"),
("32","32","post_tag","","0","3"),
("33","33","gallery_category","","45","4"),
("34","34","gallery-tags","","0","2"),
("35","35","gallery-tags","","0","4"),
("36","36","media_category","","48","2"),
("37","37","gallery-tags","","0","1"),
("38","38","gallery-tags","","0","2"),
("39","39","media_category","","48","4"),
("40","40","gallery-tags","","0","2"),
("41","41","gallery-tags","","0","2"),
("42","42","gallery-tags","","0","3"),
("43","43","gallery-tags","","0","2"),
("44","44","nav_menu","","0","9"),
("45","45","gallery_category","","0","3"),
("46","46","gallery_category","","45","1"),
("47","47","gallery_category","","45","3"),
("48","48","media_category","","0","4"),
("49","49","nav_menu","","0","4"),
("50","50","post_tag","","0","0"),
("51","51","post_tag","","0","0"),
("55","55","newspaper_category","","0","6"),
("53","53","newspaper_category","","0","6"),
("54","54","newspaper_category","","0","6"),
("56","56","post_tag","","0","1"),
("57","57","post_tag","","0","1"),
("58","58","post_tag","","0","2"),
("59","59","category","","0","1"),
("60","60","post_tag","","0","1");


/* INSERT TABLE DATA: wp_terms */
INSERT INTO `wp_terms` VALUES 
("1","آخرین اخبار","news","0"),
("2","ایران","%d8%a7%db%8c%d8%b1%d8%a7%d9%86","0"),
("3","بین الملل","%d8%a8%db%8c%d9%86-%d8%a7%d9%84%d9%85%d9%84%d9%84","0"),
("4","سیاسی","%d8%b3%db%8c%d8%a7%d8%b3%db%8c","0"),
("5","اقتصادی","%d8%a7%d9%82%d8%aa%d8%b5%d8%a7%d8%af%db%8c","0"),
("6","اجتماعی","%d8%a7%d8%ac%d8%aa%d9%85%d8%a7%d8%b9%db%8c","0"),
("7","ورزشی","%d9%88%d8%b1%d8%b2%d8%b4%db%8c","0"),
("8","فرهنگی","%d9%81%d8%b1%d9%87%d9%86%da%af%db%8c","0"),
("9","یادداشت","%db%8c%d8%a7%d8%af%d8%af%d8%a7%d8%b4%d8%aa","0"),
("10","استان ها","%d8%a7%d8%b3%d8%aa%d8%a7%d9%86-%d9%87%d8%a7","0"),
("11","فهرست اصلی","%d9%81%d9%87%d8%b1%d8%b3%d8%aa-%d8%a7%d8%b5%d9%84%db%8c","0"),
("12","خبر","%d8%ae%d8%a8%d8%b1","0"),
("13","ورزشی","%d9%88%d8%b1%d8%b2%d8%b4%db%8c","0"),
("14","فوتبال","%d9%81%d9%88%d8%aa%d8%a8%d8%a7%d9%84","0"),
("15","ایران","%d8%a7%db%8c%d8%b1%d8%a7%d9%86","0"),
("16","جهان","%d8%ac%d9%87%d8%a7%d9%86","0"),
("17","ویژه","%d9%88%db%8c%da%98%d9%87","0"),
("18","سرقت","%d8%b3%d8%b1%d9%82%d8%aa","0"),
("19","اجتماعی","%d8%a7%d8%ac%d8%aa%d9%85%d8%a7%d8%b9%db%8c","0"),
("20","فرماندهی","%d9%81%d8%b1%d9%85%d8%a7%d9%86%d8%af%d9%87%db%8c","0"),
("21","وزیر علوم","%d9%88%d8%b2%db%8c%d8%b1-%d8%b9%d9%84%d9%88%d9%85","0"),
("22","یادداشت","%db%8c%d8%a7%d8%af%d8%af%d8%a7%d8%b4%d8%aa","0"),
("23","اقتصاد","%d8%a7%d9%82%d8%aa%d8%b5%d8%a7%d8%af","0"),
("24","قم","%d9%82%d9%85","0"),
("25","رهبری","%d8%b1%d9%87%d8%a8%d8%b1%db%8c","0"),
("26","بین الملل","%d8%a8%db%8c%d9%86-%d8%a7%d9%84%d9%85%d9%84%d9%84","0"),
("27","ربیعی","%d8%b1%d8%a8%db%8c%d8%b9%db%8c","0"),
("28","کار","%da%a9%d8%a7%d8%b1","0"),
("29","خبری","%d8%ae%d8%a8%d8%b1%db%8c","0"),
("30","کاریکاتور","%da%a9%d8%a7%d8%b1%db%8c%da%a9%d8%a7%d8%aa%d9%88%d8%b1","0"),
("31","کاریکاتور","%da%a9%d8%a7%d8%b1%db%8c%da%a9%d8%a7%d8%aa%d9%88%d8%b1","0"),
("32","گرافیک","%da%af%d8%b1%d8%a7%d9%81%db%8c%da%a9","0"),
("33","مذهبی","%d9%85%d8%b0%d9%87%d8%a8%db%8c","0"),
("34","مشهد","%d9%85%d8%b4%d9%87%d8%af","0"),
("35","عکس خبری","%d8%b9%da%a9%d8%b3-%d8%ae%d8%a8%d8%b1%db%8c","0"),
("36","مذهبی","%d9%85%d8%b0%d9%87%d8%a8%db%8c","0"),
("37","رهبر","%d8%b1%d9%87%d8%a8%d8%b1","0"),
("38","مداحان","%d9%85%d8%af%d8%a7%d8%ad%d8%a7%d9%86","0"),
("39","علمی","%d8%b9%d9%84%d9%85%db%8c","0"),
("40","قدر","%d9%82%d8%af%d8%b1","0"),
("41","خبر","%d8%ae%d8%a8%d8%b1","0"),
("42","عکس","%d8%b9%da%a9%d8%b3","0"),
("43","مذهبی","%d9%85%d8%b0%d9%87%d8%a8%db%8c","0"),
("44","فهرست بالا","%d9%81%d9%87%d8%b1%d8%b3%d8%aa-%d8%a8%d8%a7%d9%84%d8%a7","0"),
("45","عکس","%d8%b9%da%a9%d8%b3","0"),
("46","ورزشی","%d9%88%d8%b1%d8%b2%d8%b4%db%8c","0"),
("47","سیاسی","%d8%b3%db%8c%d8%a7%d8%b3%db%8c","0"),
("48","فیلم","%d9%81%db%8c%d9%84%d9%85","0"),
("49","بالا و فوتر","%d8%a8%d8%a7%d9%84%d8%a7-%d9%88-%d9%81%d9%88%d8%aa%d8%b1","0"),
("50","آل سعود","%d8%a2%d9%84-%d8%b3%d8%b9%d9%88%d8%af","0"),
("51","آمریکا","%d8%a2%d9%85%d8%b1%db%8c%da%a9%d8%a7","0"),
("55","ماه نامه","%d9%85%d8%a7%d9%87-%d9%86%d8%a7%d9%85%d9%87","0"),
("53","هفته نامه","%d9%87%d9%81%d8%aa%d9%87-%d9%86%d8%a7%d9%85%d9%87","0"),
("54","روزنامه","%d8%b1%d9%88%d8%b2%d9%86%d8%a7%d9%85%d9%87","0"),
("56","مدال","%d9%85%d8%af%d8%a7%d9%84","0"),
("57","ورزش","%d9%88%d8%b1%d8%b2%d8%b4","0"),
("58","رهبر","%d8%b1%d9%87%d8%a8%d8%b1","0"),
("59","اسلایدر بزرگ","%d8%a7%d8%b3%d9%84%d8%a7%db%8c%d8%af%d8%b1-%d8%a8%d8%b2%d8%b1%da%af","0"),
("60","امام خامنه ای","%d8%a7%d9%85%d8%a7%d9%85-%d8%ae%d8%a7%d9%85%d9%86%d9%87-%d8%a7%db%8c","0");


/* INSERT TABLE DATA: wp_usermeta */
INSERT INTO `wp_usermeta` VALUES 
("1","1","nickname","آفتاب"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","comment_shortcuts","false"),
("7","1","admin_color","fresh"),
("8","1","use_ssl","0"),
("9","1","show_admin_bar_front","false"),
("10","1","locale",""),
("11","1","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("12","1","wp_user_level","10"),
("13","1","dismissed_wp_pointers","text_widget_paste_html,theme_editor_notice,text_widget_custom_html,wp496_privacy"),
("14","1","show_welcome_panel","1"),
("15","1","session_tokens","a:1:{s:64:\"a2f3b04028107096b8bf1b69310b92f7e482ca768b28ca7cf8c2d62e869d2450\";a:4:{s:10:\"expiration\";i:1528192757;s:2:\"ip\";s:12:\"192.15.46.68\";s:2:\"ua\";s:77:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:60.0) Gecko/20100101 Firefox/60.0\";s:5:\"login\";i:1528019957;}}"),
("16","1","wp_dashboard_quick_press_last_post_id","255"),
("17","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"192.15.46.0\";}"),
("18","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("19","1","metaboxhidden_nav-menus","a:2:{i:0;s:12:\"add-post_tag\";i:1;s:16:\"add-gallery-tags\";}"),
("21","1","wp_user-settings","libraryContent=browse&hidetb=1&editor=html"),
("22","1","wp_user-settings-time","1524563080"),
("20","1","closedpostboxes_nav-menus","a:0:{}"),
("23","1","closedpostboxes_post","a:0:{}"),
("24","1","metaboxhidden_post","a:6:{i:0;s:11:\"postexcerpt\";i:1;s:13:\"trackbacksdiv\";i:2;s:10:\"postcustom\";i:3;s:16:\"commentstatusdiv\";i:4;s:7:\"slugdiv\";i:5;s:9:\"authordiv\";}"),
("25","1","meta-box-order_post","a:3:{s:4:\"side\";s:94:\"submitdiv,postimagediv,prfx2_meta,prfx4_meta,prfx3_meta,post-info,categorydiv,tagsdiv-post_tag\";s:6:\"normal\";s:83:\"postexcerpt,trackbacksdiv,postcustom,commentstatusdiv,slugdiv,authordiv,commentsdiv\";s:8:\"advanced\";s:0:\"\";}"),
("26","1","screen_layout_post","2"),
("27","1","nav_menu_recently_edited","11"),
("28","1","syntax_highlighting","true"),
("29","2","wp_capabilities","a:1:{s:13:\"administrator\";s:1:\"1\";}"),
("30","2","wp_user_level","10"),
("31","2","rich_editing","true"),
("32","2","admin_color","midnight"),
("33","2","nickname","جمهوری"),
("53","2","session_tokens","a:1:{s:64:\"6f8c0144f2b6f4fb6471769a237decd9976bc4cdba8d933e55557f095e79a17e\";a:4:{s:10:\"expiration\";i:1628746650;s:2:\"ip\";s:12:\"86.57.96.100\";s:2:\"ua\";s:78:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:90.0) Gecko/20100101 Firefox/90.0\";s:5:\"login\";i:1628573850;}}"),
("35","2","wp_user-settings","libraryContent=browse&hidetb=1&editor=tinymce"),
("36","2","wp_user-settings-time","1569671909"),
("37","2","nav_menu_recently_edited","11"),
("38","2","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("39","2","metaboxhidden_nav-menus","a:5:{i:0;s:21:\"add-post-type-gallery\";i:1;s:19:\"add-post-type-media\";i:2;s:23:\"add-post-type-newspaper\";i:3;s:12:\"add-post_tag\";i:4;s:16:\"add-gallery-tags\";}"),
("57","2","closedpostboxes_dashboard","a:0:{}"),
("40","2","_new_email","a:2:{s:4:\"hash\";s:32:\"5c2a0899c9e218bd6c110b0402e85cde\";s:8:\"newemail\";s:21:\"maerefat.67@gmail.com\";}"),
("41","2","first_name",""),
("42","2","last_name",""),
("43","2","description",""),
("44","2","syntax_highlighting","true"),
("45","2","comment_shortcuts","false"),
("46","2","use_ssl","0"),
("47","2","show_admin_bar_front","false"),
("48","2","locale",""),
("54","2","show_try_gutenberg_panel","0"),
("58","2","metaboxhidden_dashboard","a:4:{i:0;s:19:\"dashboard_right_now\";i:1;s:18:\"dashboard_activity\";i:2;s:21:\"dashboard_quick_press\";i:3;s:17:\"dashboard_primary\";}"),
("49","2","wp_dashboard_quick_press_last_post_id","374"),
("50","2","community-events-location","a:1:{s:2:\"ip\";s:10:\"86.57.95.0\";}"),
("51","2","dismissed_wp_pointers","wp496_privacy,thsp_settings_pointer,theme_editor_notice,text_widget_custom_html"),
("55","2","wp_r_tru_u_x","a:2:{s:2:\"id\";i:0;s:7:\"expires\";i:1551338039;}"),
("56","2","closedpostboxes_nav-menus","a:0:{}"),
("59","2","duplicator_pro_created_format","1");


/* INSERT TABLE DATA: wp_users */
INSERT INTO `wp_users` VALUES 
("2","islamic","$P$B4ogtPGqyaH/1dGPiyw9UccnF59Lua.","islamic","maerefat.67@gmail.com","","2018-08-31 10:11:20","1578533205:$P$BFnRLa6dAER.UOlICCdN8pgCRC20eY0","0","جمهوری");


 /* SQL Chunk Footer Index 1 */ 

SET FOREIGN_KEY_CHECKS = 1; 

/* Duplicator WordPress Timestamp: 2021-08-10 09:26:39*/
/* DUPLICATOR_PRO_MYSQLDUMP_EOF */
