<?php

function qaleb_custom_post_type1() {

	$labels = array(
		'name'                => _x( 'عکس', 'Post Type General Name', 'qaleb_domain' ),
		'singular_name'       => _x( 'gallery', 'Post Type Singular Name', 'qaleb_domain' ),
		'menu_name'           => __( 'گالری عکس', 'qaleb_domain' ),
		'name_admin_bar'      => __( 'عکس', 'qaleb_domain' ),
		'parent_item_colon'   => __( 'گزینه مادر', 'qaleb_domain' ),
		'all_items'           => __( 'همه عکس ها', 'qaleb_domain' ),
		'add_new_item'        => __( 'افزودن مورد جدید', 'qaleb_domain' ),
		'add_new'             => __( 'افزودن جدید', 'qaleb_domain' ),
		'new_item'            => __( 'گزینه جدید', 'qaleb_domain' ),
		'edit_item'           => __( 'ویرایش', 'qaleb_domain' ),
		'update_item'         => __( 'به روز رسانی', 'qaleb_domain' ),
		'view_item'           => __( 'نمایش', 'qaleb_domain' ),
		'search_items'        => __( 'جستجو', 'qaleb_domain' ),
		'not_found'           => __( 'چیزی پیدا نشد', 'qaleb_domain' ),
		'not_found_in_trash'  => __( 'موردی در سطل زباله پیدا نشد', 'qaleb_domain' ),
	);
	$args = array(
		'label'               => __( 'gallery', 'qaleb_domain' ),
		'description'         => __( 'عکس', 'qaleb_domain' ),
		'labels'              => $labels,
        'supports' => array('title', 'editor', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
		'taxonomies'          => array('gallery-tags'),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'menu_position'       => 5,
		'show_in_admin_bar'   => true,
		'show_in_nav_menus'   => true,
		'can_export'          => true,
		'has_archive'         => true,		
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
		'menu_icon'           => 'dashicons-format-image',
	);
	register_post_type( 'gallery', $args );
}

function my_taxonomies_gallery() {
    $labels = array(
        'name'              => _x( 'دسته بندی عکس', 'taxonomy general name' ),
        'singular_name'     => _x( 'دسته بندی عکس', 'taxonomy singular name' ),
        'search_items'      => __( 'جست و جوی دسته بندی' ),
        'all_items'         => __( 'همه دسته بندی ها' ),
        'parent_item'       => __( 'دسته بندی جدید' ),
        'parent_item_colon' => __( 'دسته بندی جدید:' ),
        'edit_item'         => __( 'ویرایش دسته بندی' ), 
        'update_item'       => __( 'تغییر دسته بندی' ),
        'add_new_item'      => __( 'افزودن دسته بندی جدید' ),
        'new_item_name'     => __( 'دسته بندی جدید' ),
        'menu_name'         => __( 'دسته ها' ),
    );
    $args = array(
        'labels' => $labels,
        'hierarchical' => true,
		
    );
    register_taxonomy( 'gallery_category', 'gallery', $args );
}
add_action( 'init', 'my_taxonomies_gallery', 0 );
add_action( 'init', 'qaleb_custom_post_type1', 0 );



// Register Media Custom Post Type
function qaleb_custom_post_type3() {

	$labels = array(
		'name'                => _x( 'فیلم', 'Post Type General Name', 'qaleb_domain' ),
		'singular_name'       => _x( 'media', 'Post Type Singular Name', 'qaleb_domain' ),
		'menu_name'           => __( 'گالری فیلم', 'qaleb_domain' ),
		'name_admin_bar'      => __( 'فیلم', 'qaleb_domain' ),
		'parent_item_colon'   => __( 'گزینه مادر', 'qaleb_domain' ),
		'all_items'           => __( 'همه فیلم ها', 'qaleb_domain' ),
		'add_new_item'        => __( 'افزودن مورد جدید', 'qaleb_domain' ),
		'add_new'             => __( 'افزودن جدید', 'qaleb_domain' ),
		'new_item'            => __( 'گزینه جدید', 'qaleb_domain' ),
		'edit_item'           => __( 'ویرایش', 'qaleb_domain' ),
		'update_item'         => __( 'به روز رسانی', 'qaleb_domain' ),
		'view_item'           => __( 'نمایش', 'qaleb_domain' ),
		'search_items'        => __( 'جستجو', 'qaleb_domain' ),
		'not_found'           => __( 'چیزی پیدا نشد', 'qaleb_domain' ),
		'not_found_in_trash'  => __( 'موردی در سطل زباله پیدا نشد', 'qaleb_domain' ),
	);
	$args = array(
		'label'               => __( 'media', 'qaleb_domain' ),
		'description'         => __( 'فیلم', 'qaleb_domain' ),
		'labels'              => $labels,
        'supports' => array('title', 'editor', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
		'taxonomies'          => array('media-tags'),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'menu_position'       => 5,
		'show_in_admin_bar'   => true,
		'show_in_nav_menus'   => true,
		'can_export'          => true,
		'has_archive'         => true,		
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
		'menu_icon'           => 'dashicons-format-video',
	);
	register_post_type( 'media', $args );
}

function my_taxonomies_media() {
    $labels = array(
        'name'              => _x( 'دسته بندی فیلم', 'taxonomy general name' ),
        'singular_name'     => _x( 'دسته بندی فیلم', 'taxonomy singular name' ),
        'search_items'      => __( 'جست و جوی دسته بندی' ),
        'all_items'         => __( 'همه دسته بندی ها' ),
        'parent_item'       => __( 'دسته بندی جدید' ),
        'parent_item_colon' => __( 'دسته بندی جدید:' ),
        'edit_item'         => __( 'ویرایش دسته بندی' ), 
        'update_item'       => __( 'تغییر دسته بندی' ),
        'add_new_item'      => __( 'افزودن دسته بندی جدید' ),
        'new_item_name'     => __( 'دسته بندی جدید' ),
        'menu_name'         => __( 'دسته ها' ),
    );
    $args = array(
        'labels' => $labels,
        'hierarchical' => true,
		
    );
    register_taxonomy( 'media_category', 'media', $args );
}
add_action( 'init', 'my_taxonomies_media', 0 );
add_action( 'init', 'qaleb_custom_post_type3', 0 );





// Adding Newspaper Post Type

function qaleb_custom_post_type2() {

	$labels = array(
		'name'                => _x( 'روزنامه', 'Post Type General Name', 'qaleb_domain' ),
		'singular_name'       => _x( 'newspaper', 'Post Type Singular Name', 'qaleb_domain' ),
		'menu_name'           => __( 'گیشه روزنامه', 'qaleb_domain' ),
		'name_admin_bar'      => __( 'روزنامه', 'qaleb_domain' ),
		'parent_item_colon'   => __( 'گزینه مادر', 'qaleb_domain' ),
		'all_items'           => __( 'همه روزنامه ها', 'qaleb_domain' ),
		'add_new_item'        => __( 'افزودن مورد جدید', 'qaleb_domain' ),
		'add_new'             => __( 'افزودن جدید', 'qaleb_domain' ),
		'new_item'            => __( 'گزینه جدید', 'qaleb_domain' ),
		'edit_item'           => __( 'ویرایش', 'qaleb_domain' ),
		'update_item'         => __( 'به روز رسانی', 'qaleb_domain' ),
		'view_item'           => __( 'نمایش', 'qaleb_domain' ),
		'search_items'        => __( 'جستجو', 'qaleb_domain' ),
		'not_found'           => __( 'چیزی پیدا نشد', 'qaleb_domain' ),
		'not_found_in_trash'  => __( 'موردی در سطل زباله پیدا نشد', 'qaleb_domain' ),
	);
	$args = array(
		'label'               => __( 'newspaper', 'qaleb_domain' ),
		'description'         => __( 'روزنامه', 'qaleb_domain' ),
		'labels'              => $labels,
        'supports' => array('title', 'editor', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
		'taxonomies'          => array('newspaper-tags'),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'menu_position'       => 5,
		'show_in_admin_bar'   => true,
		'show_in_nav_menus'   => true,
		'can_export'          => true,
		'has_archive'         => true,		
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
		'menu_icon'           => 'dashicons-welcome-widgets-menus',
	);
	register_post_type( 'newspaper', $args );
}

function my_taxonomies_newspaper() {
    $labels = array(
        'name'              => _x( 'دسته بندی روزنامه', 'taxonomy general name' ),
        'singular_name'     => _x( 'دسته بندی روزنامه', 'taxonomy singular name' ),
        'search_items'      => __( 'جست و جوی دسته بندی' ),
        'all_items'         => __( 'همه دسته بندی ها' ),
        'parent_item'       => __( 'دسته بندی جدید' ),
        'parent_item_colon' => __( 'دسته بندی جدید:' ),
        'edit_item'         => __( 'ویرایش دسته بندی' ), 
        'update_item'       => __( 'تغییر دسته بندی' ),
        'add_new_item'      => __( 'افزودن دسته بندی جدید' ),
        'new_item_name'     => __( 'دسته بندی جدید' ),
        'menu_name'         => __( 'دسته ها' ),
    );
    $args = array(
        'labels' => $labels,
        'hierarchical' => true,
		
    );
    register_taxonomy( 'newspaper_category', 'newspaper', $args );
}
add_action( 'init', 'my_taxonomies_newspaper', 0 );
add_action( 'init', 'qaleb_custom_post_type2', 0 );



// Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
        'name'              => _x( 'برچسب ها', 'taxonomy general name' ),
        'singular_name'     => _x( 'برچسب ها', 'taxonomy singular name' ),
        'search_items'      => __( 'نوع جستجو' ),
        'all_items'         => __( 'همه برچسب ها' ),
        'parent_item'       => __( 'برچسب های مادر' ),
        'parent_item_colon' => __( 'برچسب های مادر:' ),
        'edit_item'         => __( 'ویرایش برچسب' ),
        'update_item'       => __( 'به روز رسانی برچسب' ),
        'add_new_item'      => __( 'افزودن تگ جدید' ),
        'new_item_name'     => __( 'عنوان تگ جدید' ),
        'menu_name'         => __( 'برچسب ها' ),
    );

    $args = array(
        'hierarchical'      => false,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'Tags' ),
    );
    register_taxonomy( 'gallery-tags', array( 'gallery' ) );


?>
