<?php
/*
* newspaper
*
* @since News
*/
class last_post_newspaper extends WP_Widget {

public function __construct(){
$widget_ops = array(
'classname' => 'last_post_newspaper',
'description' => 'برای سایدبار سمت راست',
);
parent::__construct( 'last_post_newspaper', 'News - گیشه روزنامه', $widget_ops );
}

function widget( $args, $instance ) {
$widget_title = apply_filters( 'widget_title', $instance['widget_title'] );
$post_num = apply_filters( 'post_num', $instance['post_num'] );
$post_cat = apply_filters( 'post_cat', $instance['post_cat'] );
$limit_title = apply_filters( 'limit_title', $instance['limit_title'] );
echo $args['before_widget'];
if( !empty($widget_title) ) {
echo $args['before_title'];
echo $widget_title;
echo $args['after_title'];
}
?>
<div id="daily_photo" class="widget daily-pic">
<div id="daily-photo" class="content">
<div data-u="loading" class="loading"></div>
<div data-u="slides" class="slides">
<?php
$wp_query = new WP_Query(array('post_type' => 'newspaper','posts_per_page'=> '4' ));
while ($wp_query->have_posts()) : $wp_query->the_post();
?>
<div class="img-f img-b">
<?php if(has_post_thumbnail()){?>
<a href="<?php the_permalink(); ?>"><?php $ata = get_the_title(); if ( has_post_thumbnail()) the_post_thumbnail('gallery', array('title' => esc_attr( $post->post_title ) , 'alt' => $ata ) ); ?></a>
<?php }else{ ?>
<img src="<?php bloginfo("template_url"); ?>/img/none.png">
<?php } ?>
<span class="daily-cat"><?php the_title(); ?></span>
</div>
<?php
endwhile;
wp_reset_query();
?>
</div>
<div data-u="navigator" class="navigator">
<div data-u="prototype"></div>
</div>
</div>
</div>
<script type="text/javascript">
jQuery(document).ready(function() {
jssor_dailypic_starter('daily-photo');
});
</script>
<?php
echo $args['after_widget'];
}

function update( $new_instance, $old_instance ) {
$instance = array();
$instance['widget_title'] = ( ! empty( $new_instance['widget_title'] ) ) ? strip_tags( $new_instance['widget_title'] ) : '';
$instance['post_num'] = ( ! empty( $new_instance['post_num'] ) ) ? strip_tags( $new_instance['post_num'] ) : '';
$instance['post_cat'] = ( ! empty( $new_instance['post_cat'] ) ) ? strip_tags( $new_instance['post_cat'] ) : '';
$instance['limit_title'] = ( ! empty( $new_instance['limit_title'] ) ) ? $new_instance['limit_title'] : '';
return $instance;
}

function form( $instance ) {
if ( isset( $instance[ 'widget_title' ] ) ) {
$widget_title = $instance[ 'widget_title' ];
} else {
$widget_title = 'گیشه روز نامه';
}

if ( isset( $instance[ 'post_num' ] ) ) {
$post_num = $instance[ 'post_num' ];
} else {
$post_num = '1';
}

if ( isset( $instance[ 'limit_title' ] ) ) {
$limit_title = $instance[ 'limit_title' ];
}
?>
<p>
<label for="<?php echo $this->get_field_id( 'widget_title' ); ?>">نام:</label>
<input name="<?php echo $this->get_field_name( 'widget_title' ); ?>" type="text" value="<?php echo esc_attr( $widget_title ); ?>" id="<?php echo $this->get_field_id( 'widget_title' ); ?>" class="widefat">
</p>
<?php
}
}

function qaleb_last_post_newspaper_widget() {
register_widget( 'last_post_newspaper' );
}

add_action( 'widgets_init', 'qaleb_last_post_newspaper_widget' );
?>